# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerServiceLinuxProfile(Model):
    """Profile for Linux VMs in the container service cluster.

    :param admin_username: The administrator username to use for Linux VMs.
    :type admin_username: str
    :param ssh: The ssh key configuration for Linux VMs.
    :type ssh: :class:`ContainerServiceSshConfiguration
     <azure.mgmt.containerservice.models.ContainerServiceSshConfiguration>`
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[a-z][a-z0-9_-]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(self, admin_username, ssh):
        self.admin_username = admin_username
        self.ssh = ssh
