# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LoggerUpdateContract(Model):
    """Logger update contract.

    :param logger_type: Logger type. Possible values include: 'azureEventHub',
     'applicationInsights'
    :type logger_type: str or ~azure.mgmt.apimanagement.models.LoggerType
    :param description: Logger description.
    :type description: str
    :param credentials: Logger credentials.
    :type credentials: dict[str, str]
    :param is_buffered: Whether records are buffered in the logger before
     publishing. Default is assumed to be true.
    :type is_buffered: bool
    """

    _attribute_map = {
        'logger_type': {'key': 'properties.loggerType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': '{str}'},
        'is_buffered': {'key': 'properties.isBuffered', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(LoggerUpdateContract, self).__init__(**kwargs)
        self.logger_type = kwargs.get('logger_type', None)
        self.description = kwargs.get('description', None)
        self.credentials = kwargs.get('credentials', None)
        self.is_buffered = kwargs.get('is_buffered', None)
