% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionset-helpers.r
\name{ExpressionSet helper methods}
\alias{ExpressionSet helper methods}
\alias{as.ExpressionSet}
\alias{as.ExpressionSet,data.frame-method}
\alias{read.ExpressionSet}
\title{Convert object to \link[Biobase:class.ExpressionSet]{ExpressionSet} or read it from a file}
\usage{
as.ExpressionSet(x, ...)

\S4method{as.ExpressionSet}{data.frame}(x, annotation_cols = !sapply(x, is.double))

read.ExpressionSet(file, header = TRUE, ...)
}
\arguments{
\item{x}{\link[base]{data.frame} to convert to an \link[Biobase:class.ExpressionSet]{ExpressionSet}.}

\item{...}{Additional parameters to \link[utils]{read.table}}

\item{annotation_cols}{The data.frame columns used as annotations. All others are used as expressions. (Logical, character or numerical index array)}

\item{file}{File path to read ASCII data from}

\item{header}{Specifies if the file has a header row.}
}
\value{
an \link[Biobase:class.ExpressionSet]{ExpressionSet} object
}
\description{
These functions present quick way to create \link[Biobase:class.ExpressionSet]{ExpressionSet} objects.
}
\details{
They work by using all continuous (double) columns as expression data, and all others as observation annotations.
}
\examples{
library(Biobase)
df <- data.frame(Time  = seq_len(3), #integer column
                 Actb  = c(0.05, 0.3, 0.8),
                 Gapdh = c(0.2, 0.03, 0.1))
set <- as.ExpressionSet(df)
rownames(exprs(set)) == c('Actb', 'Gapdh')
phenoData(set)$Time == 1:3

}
\seealso{
\link[utils]{read.table} on which \code{read.ExpressionSet} is based, and \link[Biobase:class.ExpressionSet]{ExpressionSet}.
}
