% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{coerce_to}
\alias{coerce_to}
\title{Coerce variable to a different class}
\usage{
coerce_to(x, target_class, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to coerce.}

\item{target_class}{The desired class of x.  Multiple values allowed (see 
note).}

\item{.xname}{Not intended to be used directly.}
}
\value{
The input \code{x} after attempted coercion to the target class.
}
\description{
Coerce the input to a different class, with a warning.  More reliable then 
\code{\link[methods]{as}}, and supports coercion to multiple classes.
}
\note{
If x does not already have the target class, a warning is given
before coercion.  
The function will try and convert the \code{x} to each of the classes given
in \code{target_class}, in order, until it succeeds or runs out of classes
to try.  It will first try and convert \code{x} using a dedicated 
\code{as.target_class} function if that exists.  If it does not exist, or 
throws an error then \code{coerce_to} will try to use 
\code{as(x, target_class)}.
}
\examples{
# Numbers can be coerced to characters but not to calls.
dont_stop(coerce_to(1:5, c("call", "character")))
}
\seealso{
\code{\link[methods]{is}} and \code{\link[methods]{as}}.
}

