% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_column_wrap}
\alias{layout_column_wrap}
\title{Column-first uniform grid layouts}
\usage{
layout_column_wrap(
  ...,
  width = "200px",
  fixed_width = FALSE,
  heights_equal = c("all", "row"),
  fill = TRUE,
  fillable = TRUE,
  height = NULL,
  height_mobile = NULL,
  gap = NULL,
  class = NULL
)
}
\arguments{
\item{...}{Unnamed arguments should be UI elements (e.g., \code{\link[=card]{card()}}). Named
arguments become attributes on the containing \link[htmltools:builder]{htmltools::tag} element.}

\item{width}{The desired width of each card, which can be any of the
following:
\itemize{
\item A (unit-less) number between 0 and 1.
\itemize{
\item This should be specified as \code{1/num}, where \code{num} represents the number
of desired columns.
}
\item A \link[htmltools:validateCssUnit]{CSS length unit}
\itemize{
\item Either the minimum (when \code{fixed_width=FALSE}) or fixed width
(\code{fixed_width=TRUE}).
}
\item \code{NULL}
\itemize{
\item Allows power users to set the \code{grid-template-columns} CSS property
manually, either via a \code{style} attribute or a CSS stylesheet.
}
}}

\item{fixed_width}{When \code{width} is greater than 1 or is a CSS length unit,
e.g. \code{"200px"}, \code{fixed_width} indicates whether that \code{width} value
represents the absolute size of each column (\code{fixed_width=TRUE}) or the
minimum size of a column (\code{fixed_width=FALSE}). When \code{fixed_width=FALSE},
new columns are added to a row when \code{width} space is available and columns
will never exceed the container or viewport size. When \code{fixed_width=TRUE},
all columns will be exactly \code{width} wide, which may result in columns
overflowing the parent container.}

\item{heights_equal}{If \code{"all"} (the default), every card in every row of the
grid will have the same height. If \code{"row"}, then every card in \emph{each} row
of the grid will have the same height, but heights may vary between rows.}

\item{fill}{Whether or not to allow the layout to grow/shrink to fit a
fillable container with an opinionated height (e.g., \code{page_fillable()}).}

\item{fillable}{Whether or not each element is wrapped in a fillable container.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{height_mobile}{Any valid CSS unit to use for the height when on mobile
devices (or narrow windows).}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}. This argument is only applicable when \code{fillable = TRUE}}

\item{class}{Additional CSS classes for the returned UI element.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Wraps a 1d sequence of UI elements into a 2d grid. The number of columns (and
rows) in the grid dependent on the column \code{width} as well as the size of the
display. For more explanation and illustrative examples, see the \emph{References}
section below.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- card("A simple card")

# Always has 2 columns (on non-mobile)
layout_column_wrap(width = 1/2, x, x, x)

# Automatically lays out three cards into columns
# such that each column is at least 200px wide:
layout_column_wrap(x, x, x)

# To use larger column widths by default, set `width`.
# This example has 3 columns when the screen is at least 900px wide:
layout_column_wrap(width = "300px", x, x, x)
\dontshow{\}) # examplesIf}
}
\references{
The bslib website features \code{layout_column_wrap()} in two places:
\itemize{
\item \href{https://rstudio.github.io/bslib/articles/column-layout/index.html}{Column-based layouts}
\item \href{https://rstudio.github.io/bslib/articles/cards/index.html#multiple-cards}{Cards: Multiple cards}
}
}
\seealso{
Other Column layouts: 
\code{\link{layout_columns}()}
}
\concept{Column layouts}
