% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_test.R
\name{coef_test}
\alias{coef_test}
\title{Test all or selected regression coefficients in a fitted model}
\usage{
coef_test(
  obj,
  vcov,
  test = "Satterthwaite",
  coefs = "All",
  p_values = TRUE,
  ...
)
}
\arguments{
\item{obj}{Fitted model for which to calculate t-tests.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{test}{Character vector specifying which small-sample corrections to
calculate. \code{"z"} returns a z test (i.e., using a standard normal
reference distribution). \code{"naive-t"} returns a t test with \code{m -
1} degrees of freedom, where \code{m} is the number of unique clusters.
\code{"naive-tp"} returns a t test with \code{m - p} degrees of freedom,
where \code{p} is the number of regression coefficients in \code{obj}.
\code{"Satterthwaite"} returns a Satterthwaite correction.
\code{"saddlepoint"} returns a saddlepoint correction. Default is
\code{"Satterthwaite"}.}

\item{coefs}{Character, integer, or logical vector specifying which
coefficients should be tested. The default value \code{"All"} will test all
estimated coefficients.}

\item{p_values}{Logical indicating whether to report p-values. The default
value is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only
needed if \code{vcov} is a character string.}
}
\value{
A data frame containing estimated regression coefficients, standard
  errors, and test results. For the Satterthwaite approximation, degrees of
  freedom and a p-value are reported. For the saddlepoint approximation, the
  saddlepoint and a p-value are reported.
}
\description{
\code{coef_test} reports t-tests for each coefficient estimate in a fitted
linear regression model, using a sandwich estimator for the standard errors
and a small sample correction for the p-value. The small-sample correction is
based on a Satterthwaite approximation or a saddlepoint approximation.
}
\examples{

data("ChickWeight", package = "datasets")
lm_fit <- lm(weight ~ Diet  * Time, data = ChickWeight)
diet_index <- grepl("Diet.:Time", names(coef(lm_fit)))
coef_test(lm_fit, vcov = "CR2", cluster = ChickWeight$Chick, coefs = diet_index)

V_CR2 <- vcovCR(lm_fit, cluster = ChickWeight$Chick, type = "CR2")
coef_test(lm_fit, vcov = V_CR2, coefs = diet_index)

}
\seealso{
\code{\link{vcovCR}}
}
