% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_backbone.R, R/layouts.R
\name{layout_backbone}
\alias{layout_backbone}
\alias{layout_as_backbone}
\alias{layout_igraph_backbone}
\title{backbone graph layout}
\usage{
layout_as_backbone(g, keep = 0.2, backbone = TRUE)

layout_igraph_backbone(g, keep = 0.2, backbone = TRUE, circular)
}
\arguments{
\item{g}{igraph object}

\item{keep}{fraction of edges to keep during backbone calculation}

\item{backbone}{logical. Return edge ids of the backbone (Default: TRUE)}

\item{circular}{not used}
}
\value{
list of xy coordinates and vector of edge ids included in the backbone
}
\description{
emphasizes a hidden group structure if it exists in the graph. Calculates a layout for a sparsified network only including the most embedded edges. Deleted edges are added back after the layout is calculated.
}
\details{
The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
library(igraph)
\dontrun{
g <- sample_islands(9, 20, 0.4, 9)
g <- simplify(g)
V(g)$grp <- as.character(rep(1:9, each = 20))
bb <- layout_as_backbone(g, keep = 0.4)

# add backbone links as edge attribute
E(g)$col <- FALSE
E(g)$col[bb$backbone] <- TRUE
}
}
\references{
Nocaj, A., Ortmann, M., & Brandes, U. (2015). Untangling the hairballs of multi-centered, small-world online social media networks. Journal of Graph Algorithms and Applications: JGAA, 19(2), 595-618.
}
