% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stereo.R
\name{get.element.types}
\alias{get.element.types}
\title{Obtain the type of stereo element support for atom.}
\usage{
get.element.types(mol)
}
\arguments{
\item{mol}{A \code{jObjRef} representing an \code{IAtomContainer}}
}
\value{
A factor of length equal in length to the number of atoms, indicating the element type
}
\description{
Supported elements types are
\describe{
\item{Bicoordinate}{an central atom involved in a cumulated system (not yet supported)}
\item{Tricoordinate}{an atom at one end of a geometric (double-bond) stereo bond or cumulated system}
\item{Tetracoordinate}{a tetrahedral atom (could also be square planar in future)}
\item{None}{the atom is not a (supported) stereo element type}
}
}
\seealso{
\code{\link{get.stereocenters}}, \code{\link{get.stereo.types}}
}
\author{
Rajarshi Guha \email{rajarshi.guha@gmail.com}
}
