% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{SitemFit1}
\alias{SitemFit1}
\title{Compute the S fit statistic for 1 item}
\usage{
SitemFit1(
  grp,
  item,
  free = 0,
  ...,
  method = "pearson",
  log = TRUE,
  qwidth = 6,
  qpoints = 49L,
  alt = FALSE,
  omit = 0L,
  .twotier = TRUE
)
}
\arguments{
\item{grp}{a list containing the model and data. See the details section.}

\item{item}{the item of interest}

\item{free}{the number of free parameters involved in estimating the item (to adjust the df)}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{method}{whether to use a pearson or rms test}

\item{log}{whether to return p-values in log units}

\item{qwidth}{\lifecycle{deprecated}}

\item{qpoints}{\lifecycle{deprecated}}

\item{alt}{whether to include the item of interest in the denominator}

\item{omit}{number of items to omit or a character vector with the names of the items to omit when calculating the observed and expected sum-score tables}

\item{.twotier}{whether to enable the two-tier optimization}
}
\description{
Implements the Kang & Chen (2007) polytomous extension to
S statistic of Orlando & Thissen (2000). Rows with
missing data are ignored, but see the \code{omit} option.
}
\details{
This statistic is good at finding a small number of misfitting
items among a large number of well fitting items. However, be
aware that misfitting items can cause other items to misfit.

Observed tables cannot be computed when data is
missing. Therefore, you can optionally omit items with the
greatest number of responses missing relative to the item of
interest.

Pearson is slightly more powerful than RMS in most cases I
examined.

Setting \code{alt} to \code{TRUE} causes the tables to match
published articles. However, the default setting of \code{FALSE}
probably provides slightly more power when there are less than 10
items.

The name of the test, "S", probably stands for sum-score.
}
\section{Format of a group}{


A model, or group within a model, is represented as a named list.
\describe{
\item{spec}{list of response model objects}
\item{param}{numeric matrix of item parameters}
\item{free}{logical matrix of indicating which parameters are free (TRUE) or fixed (FALSE)}
\item{mean}{numeric vector giving the mean of the latent distribution}
\item{cov}{numeric matrix giving the covariance of the latent distribution}
\item{data}{data.frame containing observed item responses, and optionally,
weights and frequencies}
\item{score}{factors scores with response patterns in rows}
\item{weightColumn}{name of the data column containing the numeric row weights (optional)}
\item{freqColumn}{name of the data column containing the integral row frequencies (optional)}
\item{qwidth}{width of the quadrature expressed in Z units}
\item{qpoints}{number of quadrature points}
\item{minItemsPerScore}{minimum number of non-missing items when estimating factor scores}
}

The \code{param} matrix stores items parameters by column. If a
column has more rows than are required to fully specify a model
then the extra rows are ignored.  The order of the items in
\code{spec} and order of columns in \code{param} are assumed to
match. All items should have the same number of latent dimensions.
Loadings on latent dimensions are given in the first few rows and
can be named by setting rownames. Item names are assigned by
\code{param} colnames.

Currently only a multivariate normal distribution is available,
parameterized by the \code{mean} and \code{cov}. If \code{mean} and
\code{cov} are not specified then a standard normal distribution is
assumed. The quadrature consists of equally spaced points. For
example, \code{qwidth=2} and \code{qpoints=5} would produce points
-2, -1, 0, 1, and 2. The quadrature specification is part of the
group and not passed as extra arguments for the sake of
consistency. As currently implemented, OpenMx uses EAP scores to
estimate latent distribution parameters. By default, the exact same
EAP scores should be produced by \link{EAPscores}.
}

\references{
Kang, T. and Chen, T. T. (2007). An investigation of
the performance of the generalized S-Chisq item-fit index for
polytomous IRT models. ACT Research Report Series.

Orlando, M. and Thissen, D. (2000). Likelihood-Based
Item-Fit Indices for Dichotomous Item Response Theory Models.
\emph{Applied Psychological Measurement, 24}(1), 50-64.
}
\seealso{
Other diagnostic: 
\code{\link{ChenThissen1997}()},
\code{\link{SitemFit}()},
\code{\link{multinomialFit}()},
\code{\link{rpf.1dim.fit}()},
\code{\link{sumScoreEAPTest}()}
}
\concept{diagnostic}
