% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal-viridis.r
\name{viridis_pal}
\alias{viridis_pal}
\title{Viridis palette}
\usage{
viridis_pal(alpha = 1, begin = 0, end = 1, direction = 1,
  option = "D")
}
\arguments{
\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the viridis colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the viridis colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{option}{A character string indicating the colormap option to use. Four
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"),
and "viridis" (or "D", the default option).}
}
\description{
Viridis palette
}
\examples{
show_col(viridis_pal()(10))
show_col(viridis_pal(direction = -1)(6))
show_col(viridis_pal(begin = 0.2, end = 0.8)(4))
show_col(viridis_pal(option = "plasma")(6))
}
\references{
\url{https://bids.github.io/colormap/}
}
