% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-interact-opts.R
\name{hoverOpts}
\alias{hoverOpts}
\title{Create an object representing hover options}
\usage{
hoverOpts(id = NULL, delay = 300, delayType = c("debounce",
  "throttle"), clip = TRUE, nullOutside = TRUE)
}
\arguments{
\item{id}{Input value name. For example, if the value is \code{"plot_hover"},
then the hover coordinates will be available as \code{input$plot_hover}.}

\item{delay}{How long to delay (in milliseconds) when debouncing or
throttling, before sending the mouse location to the server.}

\item{delayType}{The type of algorithm for limiting the number of hover
events. Use \code{"throttle"} to limit the number of hover events to one
every \code{delay} milliseconds. Use \code{"debounce"} to suspend events
while the cursor is moving, and wait until the cursor has been at rest for
\code{delay} milliseconds before sending an event.}

\item{clip}{Should the hover area be clipped to the plotting area? If FALSE,
then the server will receive hover events even when the mouse is outside
the plotting area, as long as it is still inside the image.}

\item{nullOutside}{If \code{TRUE} (the default), the value will be set to
\code{NULL} when the mouse exits the plotting area. If \code{FALSE}, the
value will stop changing when the cursor exits the plotting area.}
}
\description{
This generates an object representing hovering options, to be passed as the
\code{hover} argument of \code{\link[=imageOutput]{imageOutput()}} or
\code{\link[=plotOutput]{plotOutput()}}.
}
