% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatools.R
\name{check.distribution}
\alias{check.distribution}
\title{Check for adequaty of distrubution.}
\usage{
check.distribution(
  .data,
  .do.norm = NA,
  .laplace = 1,
  .na.val = 0,
  .warn.zero = F,
  .warn.sum = T
)
}
\arguments{
\item{.data}{Numeric vector of values.}

\item{.do.norm}{One of the three values - NA, T or F. If NA than check for distrubution (sum(.data) == 1)
and normalise if needed with the given laplace correction value. if T then do normalisation and laplace
correction. If F than don't do normalisaton and laplace correction.}

\item{.laplace}{Value for laplace correction.}

\item{.na.val}{Replace all NAs with this value.}

\item{.warn.zero}{if T then the function checks if in the resulted vector (after normalisation)
are any zeros, and print a warning message if there are some.}

\item{.warn.sum}{if T then the function checks if the sum of resulted vector (after normalisation)
is equal to one, and print a warning message if not.}
}
\value{
Numeric vector.
}
\description{
Check if the given .data is a distribution and normalise it if necessary with optional laplace correction.
}
