% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inheritance.R
\name{class-expectations}
\alias{class-expectations}
\alias{expect_is_not}
\alias{expect_is_exactly}
\alias{expect_all_inherit}
\title{Class Expectations}
\usage{
expect_is_not(object, class, info = NULL, label = NULL)

expect_is_exactly(object, class, info = NULL, label = NULL)

expect_all_inherit(object, class, info = NULL, label = NULL)
}
\arguments{
\item{object}{the object in question.}

\item{class}{the expected class object is to be.}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\description{
These extend the \link[testthat:expect_is]{testthat::expect_is} to have finer grain tests.
}
\section{Functions}{
\itemize{
\item \code{expect_is_not}: test that an object does \strong{not} inherit from a class.

\item \code{expect_is_exactly}: test that an object is exactly a specific class
and not a child class.

\item \code{expect_all_inherit}: test that all elements of a list inherit a given class.
}}

\examples{

# Test to make sure an object is not of a class.
\dontrun{
# will return an error.
expect_is_not(1L, "numeric")
}

# but this is fine.
expect_is_not('a', "numeric")

expect_is_exactly('a', "character")
}
\seealso{
Other class: \code{\link{class-tests}}
}
\concept{class}
