% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.R
\name{alter}
\alias{alter}
\alias{trie_add}
\alias{trie_remove}
\title{Add or remove trie entries}
\usage{
trie_add(trie, keys, values)

trie_remove(trie, keys)
}
\arguments{
\item{trie}{a trie object created with \code{\link{trie}}}

\item{keys}{a character vector containing the keys of the entries to
add (or remove). Entries with NA keys will not be added.}

\item{values}{an atomic vector, matching the type of the trie, containing
the values of the entries to add. Entries with NA values will not be added.}
}
\value{
nothing; the trie is modified in-place
}
\description{
\code{trie_add} and \code{trie_remove} allow you to
add or remove entries from tries, respectively.
}
\examples{
trie <- trie("foo", "bar")
length(trie)

trie_add(trie, "baz", "qux")
length(trie)

trie_remove(trie, "baz")
length(trie)

}
\seealso{
\code{\link{trie}} for creating tries in the first place.
}

