/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

/*
 * testuser - test program to retrieve an entry from the user table
 */ 

static char sccsid[] =
"$Id: testuser.c,v 1.6 1999/06/23 23:40:44 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";


#include	<sys/types.h>
#include	<stdio.h>
#include	"radius.h"
#include	"users.h"
#include	<varargs.h>

char		*progname;
int		debug_flag;
int		radius_dbm;
char		*radius_dir;
char		*radius_log;

int		accept_zero = 0;
int		debug_mem = 0;

int
main(argc, argv)
int argc;
char * argv[];
{
	USER_DESC	*user_desc;
	VALUE_PAIR	*user_check;
	VALUE_PAIR	*user_reply;
	char		auth_name[AUTH_STRING_LEN + 2];
	char		*req_name;
	int		dict_init();
	int		i;
	void		dump_pair();
	void		log_version();
	void		pairfree();
	void		usage();

	debug_flag = 1;
	radius_dbm = 0;
	req_name = (char *)NULL;
	for (i=1; i<argc; i++) {
		if (*argv[i] == '-') {
			radius_dbm = 1;
		} else {
			req_name = argv[i];
		}
	}
	if (req_name == (char *)NULL) {
		usage();
	}
	progname = argv[0];
	radius_dir = "raddb";
	radius_log = "/dev/tty";

	log_version();

	if(dict_init() != 0) {
		printf("dict_init FAILED\n");
		exit(1);
	}

	/*
	 * Open the user table
	 */
	if((user_desc = user_open()) == (USER_DESC *)NULL) {
		return(-1);
	}

	for (;;) {
		if (user_find(	req_name,
				auth_name,
				&user_check,
				&user_reply,
				user_desc) != 0) {
			printf("user req_name <%s> NOT Found!\n", req_name);
			break;
		}
		printf("Found user req_name <%s> auth_name <%s>\n",
			req_name, auth_name);
		dump_pair(user_reply);
		pairfree(user_check,"main");
		pairfree(user_reply,"main");
	}
	user_close(user_desc);
	exit(0);
}

void
dump_pair(vp)
VALUE_PAIR * vp;
{
	while (vp) {
		if (vp->attribute == PW_PORT_MESSAGE) {
			printf(" from %s\n", vp->strvalue);
		}
		vp = vp->next;
	}
}

void
usage()
{
	printf("usage: testuser <username>\n");
	exit(1);
}

VALUE_PAIR	*
get_attribute(value_list, attribute)
VALUE_PAIR	*value_list;
int		attribute;
{
	while(value_list != (VALUE_PAIR *)NULL) {
		if(value_list->attribute == attribute) {
			return(value_list);
		}
		value_list = value_list->next;
	}
	return((VALUE_PAIR *)NULL);
}

void
rad_exit(rc)
int rc;
{
	exit(rc);
}
