// --- Generated by AidaCxxStub ---
#ifndef __RAPICORN_CLIENTAPI_HH_
#define __RAPICORN_CLIENTAPI_HH_

// includes:
#include <ui/utilities.hh>
namespace Rapicorn {
class WidgetImpl; // FIXME
class WindowImpl;
}

// --- ClientHH Boilerplate ---
#include <rapicorn-core.hh>

// --- Interfaces (class declarations) ---

namespace Rapicorn {

/// @cond GeneratedEnums
enum AdjustmentSourceType {
  ADJUSTMENT_SOURCE_NONE = 0,
  ADJUSTMENT_SOURCE_ANCESTRY_HORIZONTAL = 1,
  ADJUSTMENT_SOURCE_ANCESTRY_VERTICAL = 2,
  ADJUSTMENT_SOURCE_ANCESTRY_VALUE = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  AdjustmentSourceType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, AdjustmentSourceType &e) { e = AdjustmentSourceType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum AlignType {
  ALIGN_LEFT = 1,
  ALIGN_CENTER = 2,
  ALIGN_RIGHT = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  AlignType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, AlignType &e) { e = AlignType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum AnchorType {
  ANCHOR_NONE = 0,
  ANCHOR_CENTER = 1,
  ANCHOR_EAST = 2,
  ANCHOR_NORTH_EAST = 3,
  ANCHOR_NORTH = 4,
  ANCHOR_NORTH_WEST = 5,
  ANCHOR_WEST = 6,
  ANCHOR_SOUTH_WEST = 7,
  ANCHOR_SOUTH = 8,
  ANCHOR_SOUTH_EAST = 9,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  AnchorType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, AnchorType &e) { e = AnchorType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum ClickType {
  CLICK_ON_PRESS = 1,
  CLICK_ON_RELEASE = 2,
  CLICK_SLOW_REPEAT = 3,
  CLICK_FAST_REPEAT = 4,
  CLICK_KEY_REPEAT = 5,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  ClickType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, ClickType &e) { e = ClickType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum ColorType {
  COLOR_NONE = 0,
  COLOR_FOREGROUND = 1,
  COLOR_BACKGROUND = 2,
  COLOR_BACKGROUND_EVEN = 3,
  COLOR_BACKGROUND_ODD = 4,
  COLOR_DARK = 5,
  COLOR_DARK_SHADOW = 6,
  COLOR_DARK_GLINT = 7,
  COLOR_LIGHT = 8,
  COLOR_LIGHT_SHADOW = 9,
  COLOR_LIGHT_GLINT = 10,
  COLOR_FOCUS = 11,
  COLOR_BLACK = 12,
  COLOR_WHITE = 13,
  COLOR_RED = 14,
  COLOR_YELLOW = 15,
  COLOR_GREEN = 16,
  COLOR_CYAN = 17,
  COLOR_BLUE = 18,
  COLOR_MAGENTA = 19,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  ColorType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, ColorType &e) { e = ColorType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum ColorSchemeType {
  COLOR_INHERIT = 0,
  COLOR_NORMAL = 1,
  COLOR_SELECTED = 2,
  COLOR_BASE = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  ColorSchemeType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, ColorSchemeType &e) { e = ColorSchemeType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum DirType {
  DIR_NONE = 0,
  DIR_RIGHT = 1,
  DIR_UP = 2,
  DIR_LEFT = 3,
  DIR_DOWN = 4,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  DirType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, DirType &e) { e = DirType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum EllipsizeType {
  ELLIPSIZE_START = 1,
  ELLIPSIZE_MIDDLE = 2,
  ELLIPSIZE_END = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  EllipsizeType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, EllipsizeType &e) { e = EllipsizeType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum FocusDirType {
  FOCUS_NEXT = 1,
  FOCUS_PREV = 2,
  FOCUS_RIGHT = 3,
  FOCUS_UP = 4,
  FOCUS_LEFT = 5,
  FOCUS_DOWN = 6,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  FocusDirType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, FocusDirType &e) { e = FocusDirType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum FrameType {
  FRAME_NONE = 0,
  FRAME_BACKGROUND = 1,
  FRAME_IN = 2,
  FRAME_OUT = 3,
  FRAME_ETCHED_IN = 4,
  FRAME_ETCHED_OUT = 5,
  FRAME_FOCUS = 6,
  FRAME_ALERT_FOCUS = 7,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  FrameType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, FrameType &e) { e = FrameType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum LightingType {
  LIGHTING_NONE = 0,
  LIGHTING_UPPER_LEFT = 1,
  LIGHTING_UPPER_RIGHT = 2,
  LIGHTING_LOWER_LEFT = 3,
  LIGHTING_LOWER_RIGHT = 4,
  LIGHTING_CENTER = 5,
  LIGHTING_DIFFUSE = 6,
  LIGHTING_DARK_FLAG = 128,
  LIGHTING_DARK_UPPER_LEFT = 129,
  LIGHTING_DARK_UPPER_RIGHT = 130,
  LIGHTING_DARK_LOWER_LEFT = 131,
  LIGHTING_DARK_LOWER_RIGHT = 132,
  LIGHTING_DARK_CENTER = 133,
  LIGHTING_DARK_DIFFUSE = 134,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  LightingType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, LightingType &e) { e = LightingType (frr.pop_evalue()); }
inline LightingType  operator&  (LightingType  s1, LightingType s2) { return LightingType (s1 & Rapicorn::Aida::uint64 (s2)); }
inline LightingType& operator&= (LightingType &s1, LightingType s2) { s1 = s1 & s2; return s1; }
inline LightingType  operator|  (LightingType  s1, LightingType s2) { return LightingType (s1 | Rapicorn::Aida::uint64 (s2)); }
inline LightingType& operator|= (LightingType &s1, LightingType s2) { s1 = s1 | s2; return s1; }
/// @endcond

/// @cond GeneratedEnums
enum SelectionMode {
  SELECTION_NONE = 0,
  SELECTION_SINGLE = 1,
  SELECTION_BROWSE = 2,
  SELECTION_MULTIPLE = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  SelectionMode  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, SelectionMode &e) { e = SelectionMode (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum SizePolicyType {
  SIZE_POLICY_NORMAL = 0,
  SIZE_POLICY_WIDTH_FROM_HEIGHT = 1,
  SIZE_POLICY_HEIGHT_FROM_WIDTH = 2,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  SizePolicyType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, SizePolicyType &e) { e = SizePolicyType (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum StateType {
  STATE_NORMAL = 0,
  STATE_INSENSITIVE = 1,
  STATE_PRELIGHT = 2,
  STATE_IMPRESSED = 4,
  STATE_FOCUS = 8,
  STATE_DEFAULT = 16,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  StateType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, StateType &e) { e = StateType (frr.pop_evalue()); }
inline StateType  operator&  (StateType  s1, StateType s2) { return StateType (s1 & Rapicorn::Aida::uint64 (s2)); }
inline StateType& operator&= (StateType &s1, StateType s2) { s1 = s1 & s2; return s1; }
inline StateType  operator|  (StateType  s1, StateType s2) { return StateType (s1 | Rapicorn::Aida::uint64 (s2)); }
inline StateType& operator|= (StateType &s1, StateType s2) { s1 = s1 | s2; return s1; }
/// @endcond

/// @cond GeneratedEnums
enum TextMode {
  TEXT_MODE_WRAPPED = 1,
  TEXT_MODE_ELLIPSIZED = 2,
  TEXT_MODE_SINGLE_LINE = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  TextMode  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, TextMode &e) { e = TextMode (frr.pop_evalue()); }
/// @endcond

/// @cond GeneratedEnums
enum WindowType {
  WINDOW_TYPE_NORMAL = 0,
  WINDOW_TYPE_DESKTOP = 1,
  WINDOW_TYPE_DOCK = 2,
  WINDOW_TYPE_TOOLBAR = 3,
  WINDOW_TYPE_MENU = 4,
  WINDOW_TYPE_UTILITY = 5,
  WINDOW_TYPE_SPLASH = 6,
  WINDOW_TYPE_DIALOG = 7,
  WINDOW_TYPE_DROPDOWN_MENU = 8,
  WINDOW_TYPE_POPUP_MENU = 9,
  WINDOW_TYPE_TOOLTIP = 10,
  WINDOW_TYPE_NOTIFICATION = 11,
  WINDOW_TYPE_COMBO = 12,
  WINDOW_TYPE_DND = 13,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  WindowType  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, WindowType &e) { e = WindowType (frr.pop_evalue()); }
/// @endcond

struct BoolSeq : public std::vector<bool>
{
  typedef std::vector<bool> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::BoolSeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const BoolSeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, BoolSeq&);

struct StringSeq : public std::vector<std::string>
{
  typedef std::vector<std::string> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::StringSeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  // class_scope:StringSeq:
  explicit StringSeq () {}
  /*ctor*/ StringSeq (const std::vector<std::string> &strv) : Sequence (strv) {}
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const StringSeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, StringSeq&);

struct AnySeq : public std::vector<Rapicorn::Aida::Any>
{
  typedef std::vector<Rapicorn::Aida::Any> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::AnySeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const AnySeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, AnySeq&);

struct AnySeqSeq : public std::vector<AnySeq>
{
  typedef std::vector<AnySeq> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::AnySeqSeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const AnySeqSeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, AnySeqSeq&);

struct PixelSeq : public std::vector<int>
{
  typedef std::vector<int> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::PixelSeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const PixelSeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, PixelSeq&);

struct Pixbuf
{
  /// @cond GeneratedFields
  int                           row_length;
  PixelSeq                      pixels;
  StringSeq                     variables;
  /// @endcond
  inline                        Pixbuf () { row_length = 0; }
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::Pixbuf"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  bool                          operator==  (const Pixbuf &other) const;
  bool                          operator!=  (const Pixbuf &other) const { return !operator== (other); }
  void                          operator<<= (Rapicorn::Aida::Any &any);
  friend void                   operator<<= (Rapicorn::Aida::Any &any, const Pixbuf &rec);
  // class_scope:Pixbuf:
  /// Construct Pixbuf at given width and height.
  explicit        Pixbuf       (uint w, uint h) : row_length (0) { pixels.resize (w, h); }
  /// Reset width and height and resize pixel sequence.
  void            resize       (uint w, uint h) { row_length = w; pixels.resize (row_length * h); }
  /// Access row as endian dependant ARGB integers.
  uint32_t*       row          (uint y)         { return y < uint32_t (height()) ? (uint32_t*) &pixels[row_length * y] : NULL; }
  /// Access row as endian dependant ARGB integers.
  const uint32_t* row          (uint y) const   { return y < uint32_t (height()) ? (uint32_t*) &pixels[row_length * y] : NULL; }
  /// Width of the Pixbuf.
  int             width        () const         { return row_length; }
  /// Height of the Pixbuf.
  int             height       () const         { return row_length ? pixels.size() / row_length : 0; }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const Pixbuf&);
void operator>>= (Rapicorn::Aida::FieldReader&, Pixbuf&);

/// @cond GeneratedEnums
enum UpdateKind {
  UPDATE_READ = 1,
  UPDATE_CHANGE = 2,
  UPDATE_INSERTION = 3,
  UPDATE_DELETION = 4,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  UpdateKind  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, UpdateKind &e) { e = UpdateKind (frr.pop_evalue()); }
/// @endcond

struct UpdateSpan
{
  /// @cond GeneratedFields
  int                           start;
  int                           length;
  /// @endcond
  inline                        UpdateSpan () { start = 0; length = 0; }
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::UpdateSpan"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  bool                          operator==  (const UpdateSpan &other) const;
  bool                          operator!=  (const UpdateSpan &other) const { return !operator== (other); }
  void                          operator<<= (Rapicorn::Aida::Any &any);
  friend void                   operator<<= (Rapicorn::Aida::Any &any, const UpdateSpan &rec);
  // class_scope:UpdateSpan:
  explicit UpdateSpan (int _start, int _length) : start (_start), length (_length) {}
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const UpdateSpan&);
void operator>>= (Rapicorn::Aida::FieldReader&, UpdateSpan&);

struct UpdateRequest
{
  /// @cond GeneratedFields
  UpdateKind                    kind;
  UpdateSpan                    rowspan;
  UpdateSpan                    colspan;
  StringSeq                     variables;
  Rapicorn::Aida::Any           value;
  /// @endcond
  inline                        UpdateRequest () { kind = UpdateKind (0); }
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::UpdateRequest"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  bool                          operator==  (const UpdateRequest &other) const;
  bool                          operator!=  (const UpdateRequest &other) const { return !operator== (other); }
  void                          operator<<= (Rapicorn::Aida::Any &any);
  friend void                   operator<<= (Rapicorn::Aida::Any &any, const UpdateRequest &rec);
  // class_scope:UpdateRequest:
  explicit UpdateRequest (UpdateKind _kind, const UpdateSpan &rs, const UpdateSpan &cs = UpdateSpan()) :
    kind (_kind), rowspan (rs), colspan (cs) {}
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const UpdateRequest&);
void operator>>= (Rapicorn::Aida::FieldReader&, UpdateRequest&);

/** @interface ListModel
 * See also the corresponding C++ stub class ListModelHandle. */
/// See also the corresponding IDL class ListModel.
class ListModelHandle : public virtual Rapicorn::Aida::SmartHandle
{
  typedef Rapicorn::Aida::Connector<ListModelHandle, void (const UpdateRequest &urequest)> __Aida_Signal__updated;
  size_t __aida_connect__updated (size_t, const std::function<void (const UpdateRequest &urequest)>&);
  static ListModelHandle                 __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static ListModelHandle        down_cast (SmartHandle smh) { return smh == NULL ? ListModelHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      ListModelHandle ();
  __Aida_Signal__updated        sig_updated () { return __Aida_Signal__updated (*this, &ListModelHandle::__aida_connect__updated); }
  int                           count           ();
  Rapicorn::Aida::Any           row             (int index);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const ListModelHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, ListModelHandle&);
typedef ListModelHandle ListModelH; ///< Convenience alias for the IDL type ListModel.

/** @interface ListModelRelay
 * See also the corresponding C++ stub class ListModelRelayHandle. */
/// See also the corresponding IDL class ListModelRelay.
class ListModelRelayHandle : public virtual Rapicorn::Aida::SmartHandle
{
  typedef Rapicorn::Aida::Connector<ListModelRelayHandle, void (const UpdateRequest &urequest)> __Aida_Signal__refill;
  size_t __aida_connect__refill (size_t, const std::function<void (const UpdateRequest &urequest)>&);
  static ListModelRelayHandle            __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static ListModelRelayHandle   down_cast (SmartHandle smh) { return smh == NULL ? ListModelRelayHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      ListModelRelayHandle ();
  __Aida_Signal__refill         sig_refill () { return __Aida_Signal__refill (*this, &ListModelRelayHandle::__aida_connect__refill); }
  ListModelHandle               model                ();
  void                          fill                 (int first,
                                                      const AnySeq &asq);
  void                          update               (const UpdateRequest &urequest);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const ListModelRelayHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, ListModelRelayHandle&);
typedef ListModelRelayHandle ListModelRelayH; ///< Convenience alias for the IDL type ListModelRelay.

struct Requisition
{
  /// @cond GeneratedFields
  double                        width;
  double                        height;
  /// @endcond
  inline                        Requisition () { width = 0; height = 0; }
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::Requisition"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
  bool                          operator==  (const Requisition &other) const;
  bool                          operator!=  (const Requisition &other) const { return !operator== (other); }
  void                          operator<<= (Rapicorn::Aida::Any &any);
  friend void                   operator<<= (Rapicorn::Aida::Any &any, const Requisition &rec);
  // class_scope:Requisition:
  inline Requisition (double w, double h) : width (w), height (h) {}
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const Requisition&);
void operator>>= (Rapicorn::Aida::FieldReader&, Requisition&);

class WidgetHandle;

struct WidgetSeq : public std::vector<Rapicorn::Aida::SmartMember<WidgetHandle>>
{
  typedef std::vector<Rapicorn::Aida::SmartMember<WidgetHandle>> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::WidgetSeq"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const WidgetSeq&);
void operator>>= (Rapicorn::Aida::FieldReader&, WidgetSeq&);

/** @interface Widget
 * See also the corresponding C++ stub class WidgetHandle. */
/// See also the corresponding IDL class Widget.
class WidgetHandle : public virtual Rapicorn::Aida::SmartHandle
{
  static WidgetHandle                    __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static WidgetHandle           down_cast (SmartHandle smh) { return smh == NULL ? WidgetHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      WidgetHandle ();
  std::string                   name           () const;
  void                          name           (const std::string&);
  double                        width          () const;
  void                          width          (double);
  double                        height         () const;
  void                          height         (double);
  bool                          hexpand        () const;
  void                          hexpand        (bool);
  bool                          vexpand        () const;
  void                          vexpand        (bool);
  bool                          hspread        () const;
  void                          hspread        (bool);
  bool                          vspread        () const;
  void                          vspread        (bool);
  bool                          hshrink        () const;
  void                          hshrink        (bool);
  bool                          vshrink        () const;
  void                          vshrink        (bool);
  bool                          visible        () const;
  void                          visible        (bool);
  bool                          sensitive      () const;
  void                          sensitive      (bool);
  double                        hposition      () const;
  void                          hposition      (double);
  double                        hspan          () const;
  void                          hspan          (double);
  double                        vposition      () const;
  void                          vposition      (double);
  double                        vspan          () const;
  void                          vspan          (double);
  int                           left_spacing   () const;
  void                          left_spacing   (int);
  int                           right_spacing  () const;
  void                          right_spacing  (int);
  int                           bottom_spacing () const;
  void                          bottom_spacing (int);
  int                           top_spacing    () const;
  void                          top_spacing    (int);
  double                        hanchor        () const;
  void                          hanchor        (double);
  double                        vanchor        () const;
  void                          vanchor        (double);
  double                        halign         () const;
  void                          halign         (double);
  double                        hscale         () const;
  void                          hscale         (double);
  double                        valign         () const;
  void                          valign         (double);
  double                        vscale         () const;
  void                          vscale         (double);
  ColorSchemeType               color_scheme   () const;
  void                          color_scheme   (ColorSchemeType);
  bool                          match_selector        (const std::string &selector);
  WidgetHandle                  query_selector        (const std::string &selector);
  WidgetSeq                     query_selector_all    (const std::string &selector);
  WidgetHandle                  query_selector_unique (const std::string &selector);
  std::string                   test_dump             ();
  // class_scope:Widget:
  /// Carry out Widget::query_selector_unique() and Target::down_cast() in one step, for type safe access to a descendant.
  template<class Target> Target component (const std::string &selector) { return Target::down_cast (query_selector_unique (selector)); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const WidgetHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, WidgetHandle&);
typedef WidgetHandle WidgetH; ///< Convenience alias for the IDL type Widget.

/** @interface Container
 * See also the corresponding C++ stub class ContainerHandle. */
/// See also the corresponding IDL class Container.
class ContainerHandle : public WidgetHandle
{
  static ContainerHandle                 __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static ContainerHandle        down_cast (SmartHandle smh) { return smh == NULL ? ContainerHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      ContainerHandle ();
  WidgetHandle                  create_child    (const std::string &widget_identifier,
                                                 const StringSeq &args = StringSeq());
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const ContainerHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, ContainerHandle&);
typedef ContainerHandle ContainerH; ///< Convenience alias for the IDL type Container.

/** @interface ButtonArea
 * See also the corresponding C++ stub class ButtonAreaHandle. */
/// See also the corresponding IDL class ButtonArea.
class ButtonAreaHandle : public ContainerHandle
{
  static ButtonAreaHandle                __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static ButtonAreaHandle       down_cast (SmartHandle smh) { return smh == NULL ? ButtonAreaHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      ButtonAreaHandle ();
  std::string                   on_click  () const;
  void                          on_click  (const std::string&);
  std::string                   on_click2 () const;
  void                          on_click2 (const std::string&);
  std::string                   on_click3 () const;
  void                          on_click3 (const std::string&);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const ButtonAreaHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, ButtonAreaHandle&);
typedef ButtonAreaHandle ButtonAreaH; ///< Convenience alias for the IDL type ButtonArea.

/** @interface Drawable
 * See also the corresponding C++ stub class DrawableHandle. */
/// See also the corresponding IDL class Drawable.
class DrawableHandle : public WidgetHandle
{
  typedef Rapicorn::Aida::Connector<DrawableHandle, void (int x, int y, int w, int h)> __Aida_Signal__redraw;
  size_t __aida_connect__redraw (size_t, const std::function<void (int x, int y, int w, int h)>&);
  static DrawableHandle                  __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static DrawableHandle         down_cast (SmartHandle smh) { return smh == NULL ? DrawableHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      DrawableHandle ();
  __Aida_Signal__redraw         sig_redraw () { return __Aida_Signal__redraw (*this, &DrawableHandle::__aida_connect__redraw); }
  void                          draw_rect      (int x,
                                                int y,
                                                const Pixbuf &pixbuf);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const DrawableHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, DrawableHandle&);
typedef DrawableHandle DrawableH; ///< Convenience alias for the IDL type Drawable.

/** @interface WidgetList
 * See also the corresponding C++ stub class WidgetListHandle. */
/// See also the corresponding IDL class WidgetList.
class WidgetListHandle : public ContainerHandle
{
  static WidgetListHandle                __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static WidgetListHandle       down_cast (SmartHandle smh) { return smh == NULL ? WidgetListHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      WidgetListHandle ();
  std::string                   model          () const;
  void                          model          (const std::string&);
  SelectionMode                 selection_mode () const;
  void                          selection_mode (SelectionMode);
  void                          set_selection    (const BoolSeq &selection);
  BoolSeq                       get_selection    ();
  void                          select_range     (int first,
                                                  int length);
  void                          unselect_range   (int first,
                                                  int length);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const WidgetListHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, WidgetListHandle&);
typedef WidgetListHandle WidgetListH; ///< Convenience alias for the IDL type WidgetList.

/** @interface Window
 * See also the corresponding C++ stub class WindowHandle. */
/// See also the corresponding IDL class Window.
class WindowHandle : public ContainerHandle
{
  typedef Rapicorn::Aida::Connector<WindowHandle, bool (const std::string &cmdname, const StringSeq &args)> __Aida_Signal__commands;
  size_t __aida_connect__commands (size_t, const std::function<bool (const std::string &cmdname, const StringSeq &args)>&);
  typedef Rapicorn::Aida::Connector<WindowHandle, void ()> __Aida_Signal__displayed;
  size_t __aida_connect__displayed (size_t, const std::function<void ()>&);
  static WindowHandle                    __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static WindowHandle           down_cast (SmartHandle smh) { return smh == NULL ? WindowHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      WindowHandle ();
  std::string                   title      () const;
  void                          title      (const std::string&);
  bool                          auto_focus () const;
  void                          auto_focus (bool);
  __Aida_Signal__commands       sig_commands () { return __Aida_Signal__commands (*this, &WindowHandle::__aida_connect__commands); }
  __Aida_Signal__displayed      sig_displayed () { return __Aida_Signal__displayed (*this, &WindowHandle::__aida_connect__displayed); }
  bool                          viewable          ();
  void                          show              ();
  bool                          closed            ();
  void                          close             ();
  bool                          snapshot          (const std::string &pngname);
  bool                          synthesize_click  (WidgetHandle &widget,
                                                   int button,
                                                   double xalign = 0.5,
                                                   double yalign = 0.5);
  bool                          synthesize_enter  (double xalign = 0.5,
                                                   double yalign = 0.5);
  bool                          synthesize_leave  ();
  bool                          synthesize_delete ();
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const WindowHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, WindowHandle&);
typedef WindowHandle WindowH; ///< Convenience alias for the IDL type Window.

struct WindowList : public std::vector<Rapicorn::Aida::SmartMember<WindowHandle>>
{
  typedef std::vector<Rapicorn::Aida::SmartMember<WindowHandle>> Sequence;
  reference append_back(); ///< Append data at the end, returns write reference to data.
  std::string                   __aida_type_name__ () const	{ return "Rapicorn::WindowList"; }
  Rapicorn::Aida::TypeCode      __aida_type_code__ () const	{ return Rapicorn::Aida::TypeMap::lookup (__aida_type_name__()); }
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const WindowList&);
void operator>>= (Rapicorn::Aida::FieldReader&, WindowList&);

/** @interface Application
 * See also the corresponding C++ stub class ApplicationHandle. */
/// See also the corresponding IDL class Application.
class ApplicationHandle : public virtual Rapicorn::Aida::SmartHandle
{
  typedef Rapicorn::Aida::Connector<ApplicationHandle, void ()> __Aida_Signal__missing_primary;
  size_t __aida_connect__missing_primary (size_t, const std::function<void ()>&);
  static ApplicationHandle               __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  static Rapicorn::Aida::BaseConnection* __aida_connection__();
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static ApplicationHandle      down_cast (SmartHandle smh) { return smh == NULL ? ApplicationHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      ApplicationHandle ();
  __Aida_Signal__missing_primary sig_missing_primary () { return __Aida_Signal__missing_primary (*this, &ApplicationHandle::__aida_connect__missing_primary); }
  std::string                   auto_path               (const std::string &file_name,
                                                         const std::string &binary_path,
                                                         bool search_vpath = 1);
  StringSeq                     auto_load               (const std::string &defs_domain,
                                                         const std::string &file_name,
                                                         const std::string &binary_path,
                                                         const std::string &i18n_domain = "");
  bool                          factory_window          (const std::string &factory_definition);
  void                          load_string             (const std::string &defs_domain,
                                                         const std::string &xml_string,
                                                         const std::string &i18n_domain = "");
  WindowHandle                  create_window           (const std::string &window_identifier,
                                                         const StringSeq &arguments = StringSeq());
  bool                          finishable              ();
  void                          close_all               ();
  WindowHandle                  query_window            (const std::string &selector);
  WindowList                    query_windows           (const std::string &selector);
  WindowList                    list_windows            ();
  ListModelRelayHandle          create_list_model_relay (const std::string &name = "");
  void                          test_counter_set        (int val);
  void                          test_counter_add        (int val);
  int                           test_counter_get        ();
  int                           test_counter_inc_fetch  ();
  Rapicorn::Aida::int64         test_hook               ();
  // class_scope:Application:
  static int                      run            ();
  static void                     quit           (int quit_code = 0);
  static void                     shutdown       ();
  static int                      run_and_exit   () RAPICORN_NORETURN;
  static ApplicationHandle        the            ();
protected:
  static MainLoop*                main_loop     ();
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const ApplicationHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, ApplicationHandle&);
typedef ApplicationHandle ApplicationH; ///< Convenience alias for the IDL type Application.

/// @cond GeneratedEnums
enum TestEnum {
  TEST_ENUM_VALUE1 = 1,
  TEST_ENUM_VALUE2 = 2,
  TEST_ENUM_VALUE3 = 3,
};
inline void operator<<= (Rapicorn::Aida::FieldBuffer &fb,  TestEnum  e) { fb <<= Rapicorn::Aida::EnumValue (e); }
inline void operator>>= (Rapicorn::Aida::FieldReader &frr, TestEnum &e) { e = TestEnum (frr.pop_evalue()); }
/// @endcond

/** @interface IdlTestWidget
 * See also the corresponding C++ stub class IdlTestWidgetHandle. */
/// See also the corresponding IDL class IdlTestWidget.
class IdlTestWidgetHandle : public WidgetHandle
{
  static IdlTestWidgetHandle             __aida_cast__ (Rapicorn::Aida::SmartHandle&, const Rapicorn::Aida::TypeHashList&);
  static const Rapicorn::Aida::TypeHash& __aida_typeid__();
protected:
public:
  const Rapicorn::Aida::TypeHashList     __aida_typelist__();
  template<class SmartHandle>
  static IdlTestWidgetHandle    down_cast (SmartHandle smh) { return smh == NULL ? IdlTestWidgetHandle() : __aida_cast__ (smh, smh.__aida_typelist__()); }
  explicit                      IdlTestWidgetHandle ();
  bool                          bool_prop     () const;
  void                          bool_prop     (bool);
  int                           int_prop      () const;
  void                          int_prop      (int);
  double                        float_prop    () const;
  void                          float_prop    (double);
  std::string                   string_prop   () const;
  void                          string_prop   (const std::string&);
  TestEnum                      enum_prop     () const;
  void                          enum_prop     (TestEnum);
  Requisition                   record_prop   () const;
  void                          record_prop   (const Requisition&);
  StringSeq                     sequence_prop () const;
  void                          sequence_prop (const StringSeq&);
  IdlTestWidgetHandle           self_prop     () const;
  void                          self_prop     (IdlTestWidgetHandle);
};
void operator<<= (Rapicorn::Aida::FieldBuffer&, const IdlTestWidgetHandle&);
void operator>>= (Rapicorn::Aida::FieldReader&, IdlTestWidgetHandle&);
typedef IdlTestWidgetHandle IdlTestWidgetH; ///< Convenience alias for the IDL type IdlTestWidget.
} // Rapicorn

namespace Rapicorn {

namespace Aida {

template<> inline TypeCode TypeCode::from_enum<Rapicorn::AdjustmentSourceType>() { return TypeMap::lookup ("Rapicorn::AdjustmentSourceType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::AlignType>() { return TypeMap::lookup ("Rapicorn::AlignType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::AnchorType>() { return TypeMap::lookup ("Rapicorn::AnchorType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::ClickType>() { return TypeMap::lookup ("Rapicorn::ClickType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::ColorType>() { return TypeMap::lookup ("Rapicorn::ColorType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::ColorSchemeType>() { return TypeMap::lookup ("Rapicorn::ColorSchemeType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::DirType>() { return TypeMap::lookup ("Rapicorn::DirType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::EllipsizeType>() { return TypeMap::lookup ("Rapicorn::EllipsizeType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::FocusDirType>() { return TypeMap::lookup ("Rapicorn::FocusDirType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::FrameType>() { return TypeMap::lookup ("Rapicorn::FrameType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::LightingType>() { return TypeMap::lookup ("Rapicorn::LightingType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::SelectionMode>() { return TypeMap::lookup ("Rapicorn::SelectionMode"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::SizePolicyType>() { return TypeMap::lookup ("Rapicorn::SizePolicyType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::StateType>() { return TypeMap::lookup ("Rapicorn::StateType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::TextMode>() { return TypeMap::lookup ("Rapicorn::TextMode"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::WindowType>() { return TypeMap::lookup ("Rapicorn::WindowType"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::UpdateKind>() { return TypeMap::lookup ("Rapicorn::UpdateKind"); }

template<> inline TypeCode TypeCode::from_enum<Rapicorn::TestEnum>() { return TypeMap::lookup ("Rapicorn::TestEnum"); }
} // Aida
} // Rapicorn

// global_scope:
namespace Rapicorn {

bool              init_app_initialized    ();
ApplicationHandle init_app                (const String       &app_ident,
                                           int                *argcp,
                                           char              **argv,
                                           const StringVector &args = StringVector());
ApplicationHandle init_test_app           (const String       &app_ident,
                                           int                *argcp,
                                           char              **argv,
                                           const StringVector &args = StringVector());
void              exit_app                (int status) RAPICORN_NORETURN;

} // Rapicorn
#define RAPICORN_PIXBUF_TYPE    Rapicorn::Pixbuf
#include <ui/pixmap.hh>
#endif /* __RAPICORN_CLIENTAPI_HH_ */
