///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// main assembly algorithm
//
// this file is
// diretly include'd by elementary matrix files
// since matrix computation is inlined
//
// authors: Pierre.Saramito@imag.fr
//
// date: 7 july 1997
//
# include "rheolef/form_diag.h"
# include "rheolef/diag.h"
# include "form_diag_assembly.h"
using namespace std;
namespace rheolef { 

void
form_diag_assembly (form_diag& a, const form_element& form_e)
{
    typedef size_t size_type;
    const space& X = a.get_space();
    const geo& g = X.get_global_geo();
    form_e.initialize (X, X);
    //
    // use temporary dynamic matrix structures
    //
    a.uu.resize (X.n_unknown());
    a.bb.resize (X.n_blocked());
    a.uu = 0;
    a.bb = 0;
    ublas::matrix<Float> ak;
    tiny_vector<size_type> idx;

    for (geo::const_iterator iK = g.begin(); iK != g.end(); iK++) {
      const geo_element& K = *iK;
      // --------------------------------
      // compute elementary matrix ak
      // --------------------------------
      form_e (K, ak);
      // ------------------------------
      // assembly ak in sparse matrix a
      // ------------------------------
      X.set_global_dof (K, idx);
      size_type nx = ak.size1(); // nrow
      basic_diag<Float>::iterator auu = a.uu.begin();
      basic_diag<Float>::iterator abb = a.bb.begin();
      for (size_type i = 0; i < nx; i++) {

	    if (ak(i,i) == Float(0)) continue;

	    size_type i_dof = X.domain_dof(idx(i));
	    size_type ii    = X.index(i_dof);
   
	    if   (X.is_blocked(i_dof))
	      abb[ii] += ak(i,i);
	    else 
	      auu[ii] += ak(i,i);
      }
    }
}
}// namespace rheolef
