/* Public domain, no copyright. Use at your own risk. */

#include <stdio.h>
#include <gnutls/abstract.h>
#include <gnutls/x509.h>

#include <check.h>
#include <yder.h>
#include <orcania.h>
#include <ulfius.h>
#include <rhonabwy.h>

const char jwk_pubkey_rsa_str[] = "{\"kty\":\"RSA\",\"n\":\"0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86zwu1RK7aPFFxuhDR1L6tSoc_BJECPebWKRX"\
                                   "jBZCiFV4n3oknjhMstn64tZ_2W-5JsGY4Hc5n9yBXArwl93lqt7_RN5w6Cf0h4QyQ5v-65YGjQR0_FDW2QvzqY368QQMicAtaSqzs8KJZgnYb9c7d0zgdAZHzu6"\
                                   "qMQvRL5hajrn1n91CbOpbISD08qNLyrdkt-bFTWhAI4vMQFh6WeZu0fM4lFd2NcRwr3XPksINHaQ-G_xBniIqbw0Ls1jF44-csFCur-kEgU8awapJzKnqDKgw\""\
                                   ",\"e\":\"AQAB\",\"alg\":\"RS256\",\"kid\":\"2011-04-29\"}";
const char jwk_privkey_rsa_str[] = "{\"kty\":\"RSA\",\"n\":\"0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86zwu1RK7aPFFxuhDR1L6tSoc_BJECPebWKR"\
                                    "XjBZCiFV4n3oknjhMstn64tZ_2W-5JsGY4Hc5n9yBXArwl93lqt7_RN5w6Cf0h4QyQ5v-65YGjQR0_FDW2QvzqY368QQMicAtaSqzs8KJZgnYb9c7d0zgdAZHz"\
                                    "u6qMQvRL5hajrn1n91CbOpbISD08qNLyrdkt-bFTWhAI4vMQFh6WeZu0fM4lFd2NcRwr3XPksINHaQ-G_xBniIqbw0Ls1jF44-csFCur-kEgU8awapJzKnqDKg"\
                                    "w\",\"e\":\"AQAB\",\"d\":\"X4cTteJY_gn4FYPsXB8rdXix5vwsg1FLN5E3EaG6RJoVH-HLLKD9M7dx5oo7GURknchnrRweUkC7hT5fJLM0WbFAKNLWY2v"\
                                    "v7B6NqXSzUvxT0_YSfqijwp3RTzlBaCxWp4doFk5N2o8Gy_nHNKroADIkJ46pRUohsXywbReAdYaMwFs9tv8d_cPVY3i07a3t8MN6TNwm0dSawm9v47UiCl3Sk"\
                                    "5ZiG7xojPLu4sbg1U2jx4IBTNBznbJSzFHK66jT8bgkuqsk0GjskDJk19Z4qwjwbsnn4j2WBii3RL-Us2lGVkY8fkFzme1z0HbIkfz0Y6mqnOYtqc0X4jfcKoA"\
                                    "C8Q\",\"p\":\"83i-7IvMGXoMXCskv73TKr8637FiO7Z27zv8oj6pbWUQyLPQBQxtPVnwD20R-60eTDmD2ujnMt5PoqMrm8RfmNhVWDtjjMmCMjOpSXicFHj7"\
                                    "XOuVIYQyqVWlWEh6dN36GVZYk93N8Bc9vY41xy8B9RzzOGVQzXvNEvn7O0nVbfs\",\"q\":\"3dfOR9cuYq-0S-mkFLzgItgMEfFzB2q3hWehMuG0oCuqnb3v"\
                                    "obLyumqjVZQO1dIrdwgTnCdpYzBcOfW5r370AFXjiWft_NGEiovonizhKpo9VVS78TzFgxkIdrecRezsZ-1kYd_s1qDbxtkDEgfAITAG9LUnADun4vIcb6yelx"\
                                    "k\",\"dp\":\"G4sPXkc6Ya9y8oJW9_ILj4xuppu0lzi_H7VTkS8xj5SdX3coE0oimYwxIi2emTAue0UOa5dpgFGyBJ4c8tQ2VF402XRugKDTP8akYhFo5tAA7"\
                                    "7Qe_NmtuYZc3C3m3I24G2GvR5sSDxUyAN2zq8Lfn9EUms6rY3Ob8YeiKkTiBj0\",\"dq\":\"s9lAH9fggBsoFR8Oac2R_E2gw282rT2kGOAhvIllETE1efrA"\
                                    "6huUUvMfBcMpn8lqeW6vzznYY5SSQF7pMdC_agI3nG8Ibp1BUb0JUiraRNqUfLhcQb_d9GF4Dh7e74WbRsobRonujTYN1xCaP6TO61jvWrX-L18txXw494Q_cg"\
                                    "k\",\"qi\":\"GyM_p6JrXySiz1toFgKbWV-JdI3jQ4ypu9rbMWx3rQJBfmt0FoYzgUIZEVFEcOqwemRN81zoDAaa-Bk0KWNGDjJHZDdDmFhW3AN7lI-puxk_m"\
                                    "HZGJ11rxyR8O55XLSe3SPmRfKwZI6yU24ZxvQKFYItdldUKGzO6Ia6zTKhAVRU\",\"alg\":\"RS256\",\"kid\":\"2011-04-29\"}";
const char jwk_pubkey_ecdsa_str[] = "{\"kty\":\"EC\",\"crv\":\"P-256\",\"x\":\"MKBCTNIcKUSDii11ySs3526iDZ8AiTo7Tu6KPAqv7D4\","\
                                    "\"y\":\"4Etl6SRW2YiLUrN5vfvVHuhp7x8PxltmWWlbbM4IFyM\",\"use\":\"enc\",\"kid\":\"1\"}";
const char jwk_privkey_ecdsa_str[] = "{\"kty\":\"EC\",\"crv\":\"P-256\",\"x\":\"MKBCTNIcKUSDii11ySs3526iDZ8AiTo7Tu6KPAqv7D4\","\
                                      "\"y\":\"4Etl6SRW2YiLUrN5vfvVHuhp7x8PxltmWWlbbM4IFyM\",\"d\":\"870MB6gfuTJ4HtUnUvYMyJpr5eUZNP4Bk43bVdj3eAE\","\
                                      "\"use\":\"enc\",\"kid\":\"1\"}";

const unsigned char symmetric_key[] = "my-very-secret";
const unsigned char rsa_2048_pub[] = "-----BEGIN PUBLIC KEY-----\n"
"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwtpMAM4l1H995oqlqdMh\n"
"uqNuffp4+4aUCwuFE9B5s9MJr63gyf8jW0oDr7Mb1Xb8y9iGkWfhouZqNJbMFry+\n"
"iBs+z2TtJF06vbHQZzajDsdux3XVfXv9v6dDIImyU24MsGNkpNt0GISaaiqv51NM\n"
"ZQX0miOXXWdkQvWTZFXhmsFCmJLE67oQFSar4hzfAaCulaMD+b3Mcsjlh0yvSq7g\n"
"6swiIasEU3qNLKaJAZEzfywroVYr3BwM1IiVbQeKgIkyPS/85M4Y6Ss/T+OWi1Oe\n"
"K49NdYBvFP+hNVEoeZzJz5K/nd6C35IX0t2bN5CVXchUFmaUMYk2iPdhXdsC720t\n"
"BwIDAQAB\n"
"-----END PUBLIC KEY-----\n";
const unsigned char rsa_2048_priv[] = "-----BEGIN PRIVATE KEY-----\n"
"MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDC2kwAziXUf33m\n"
"iqWp0yG6o259+nj7hpQLC4UT0Hmz0wmvreDJ/yNbSgOvsxvVdvzL2IaRZ+Gi5mo0\n"
"lswWvL6IGz7PZO0kXTq9sdBnNqMOx27HddV9e/2/p0MgibJTbgywY2Sk23QYhJpq\n"
"Kq/nU0xlBfSaI5ddZ2RC9ZNkVeGawUKYksTruhAVJqviHN8BoK6VowP5vcxyyOWH\n"
"TK9KruDqzCIhqwRTeo0spokBkTN/LCuhVivcHAzUiJVtB4qAiTI9L/zkzhjpKz9P\n"
"45aLU54rj011gG8U/6E1USh5nMnPkr+d3oLfkhfS3Zs3kJVdyFQWZpQxiTaI92Fd\n"
"2wLvbS0HAgMBAAECggEAD8dTnkETSSjlzhRuI9loAtAXM3Zj86JLPLW7GgaoxEoT\n"
"n7lJ2bGicFMHB2ROnbOb9vnas82gtOtJsGaBslmoaCckp/C5T1eJWTEb+i+vdpPp\n"
"wZcmKZovyyRFSE4+NYlU17fEv6DRvuaGBpDcW7QgHJIl45F8QWEM+msee2KE+V4G\n"
"z/9vAQ+sOlvsb4mJP1tJIBx9Lb5loVREwCRy2Ha9tnWdDNar8EYkOn8si4snPT+E\n"
"3ZCy8mlcZyUkZeiS/HdtydxZfoiwrSRYamd1diQpPhWCeRteQ802a7ds0Y2YzgfF\n"
"UaYjNuRQm7zA//hwbXS7ELPyNMU15N00bajlG0tUOQKBgQDnLy01l20OneW6A2cI\n"
"DIDyYhy5O7uulsaEtJReUlcjEDMkin8b767q2VZHb//3ZH+ipnRYByUUyYUhdOs2\n"
"DYRGGeAebnH8wpTT4FCYxUsIUpDfB7RwfdBONgaKewTJz/FPswy1Ye0b5H2c6vVi\n"
"m2FZ33HQcoZ3wvFFqyGVnMzpOwKBgQDXxL95yoxUGKa8vMzcE3Cn01szh0dFq0sq\n"
"cFpM+HWLVr84CItuG9H6L0KaStEEIOiJsxOVpcXfFFhsJvOGhMA4DQTwH4WuXmXp\n"
"1PoVMDlV65PYqvhzwL4+QhvZO2bsrEunITXOmU7CI6kilnAN3LuP4HbqZgoX9lqP\n"
"I31VYzLupQKBgGEYck9w0s/xxxtR9ILv5XRnepLdoJzaHHR991aKFKjYU/KD7JDK\n"
"INfoAhGs23+HCQhCCtkx3wQVA0Ii/erM0II0ueluD5fODX3TV2ZibnoHW2sgrEsW\n"
"vFcs36BnvIIaQMptc+f2QgSV+Z/fGsKYadG6Q+39O7au/HB7SHayzWkjAoGBAMgt\n"
"Fzslp9TpXd9iBWjzfCOnGUiP65Z+GWkQ/SXFqD+SRir0+m43zzGdoNvGJ23+Hd6K\n"
"TdQbDJ0uoe4MoQeepzoZEgi4JeykVUZ/uVfo+nh06yArVf8FxTm7WVzLGGzgV/uA\n"
"+wtl/cRtEyAsk1649yW/KHPEIP8kJdYAJeoO8xSlAoGAERMrkFR7KGYZG1eFNRdV\n"
"mJMq+Ibxyw8ks/CbiI+n3yUyk1U8962ol2Q0T4qjBmb26L5rrhNQhneM4e8mo9FX\n"
"LlQapYkPvkdrqW0Bp72A/UNAvcGTmN7z5OCJGMUutx2hmEAlrYmpLKS8pM/p9zpK\n"
"tEOtzsP5GMDYVlEp1jYSjzQ=\n"
"-----END PRIVATE KEY-----\n";

#define JWT_CLAIM_ISS "https://rhonabwy.tld"
#define JWT_CLAIM_SUB "rhon_sub"
#define JWT_CLAIM_AUD "dave_lopper"
#define JWT_CLAIM_EXP 30
#define JWT_CLAIM_NBF 30
#define JWT_CLAIM_IAT 30
#define JWT_CLAIM_JTI "jit1234Xyz"
#define JWT_CLAIM_SCOPE "scope1"
#define JWT_CLAIM_AGE 42
#define JWT_CLAIM_VERIFIED json_true()
#define JWT_CLAIM_TYP "jwt+rhnabwy"
#define JWT_CLAIM_CTY "application/mater"

#define CLAIM_STR "grut"
#define CLAIM_INT 42
unsigned char cypher_key[] = {4, 211, 31, 197, 84, 157, 252, 254, 11, 100, 157, 250, 63, 170, 106, 206, 107, 124, 212, 45, 111, 107, 9, 219, 200, 177, 0, 240, 143, 156, 44, 207};
unsigned char iv[] = {3, 22, 60, 12, 43, 67, 104, 105, 108, 108, 105, 99, 111, 116, 104, 101};
const char pubkey[] = "{\"kty\":\"RSA\","\
    "\"n\":\"sXchDaQebHnPiGvyDOAT4saGEUetSyo9MKLOoWFsueri23bOdgWp4Dy1Wl"\
    "UzewbgBHod5pcM9H95GQRV3JDXboIRROSBigeC5yjU1hGzHHyXss8UDpre"\
    "cbAYxknTcQkhslANGRUZmdTOQ5qTRsLAt6BTYuyvVRdhS8exSZEy_c4gs_"\
    "7svlJJQ4H9_NxsiIoLwAEk7-Q3UXERGYw_75IDrGA84-lA_-Ct4eTlXHBI"\
    "Y2EaV7t7LjJaynVJCpkv4LKjTTAumiGUIuQhrNhZLuF_RJLqHpM2kgWFLU"\
    "7-VTdL1VbC2tejvcI2BlMkEpk1BzBZI0KQB0GaDWFLN-aEAw3vRw\","\
    "\"e\":\"AQAB\"}";
#define PAYLOAD "The true sign of intelligence is not knowledge but imagination."

#define HTTPS_CERT_KEY "cert/server.key"
#define HTTPS_CERT_PEM "cert/server.crt"

const unsigned char advanced_key_1[] = "-----BEGIN EC PRIVATE KEY-----\n"
"MHcCAQEEIAYMcQvkJcMXw5WYHEL05zOvksZ3JG6WAVc4PqupNxncoAoGCCqGSM49\n"
"AwEHoUQDQgAEKOIR+UzdL4i9/nP35uX5RIafqwsADRFiN74McMa3LVL/TDfougV5\n"
"plYuZz2/TzJbrwPDUYCB/rV8/hHku0tXnA==\n"
"-----END EC PRIVATE KEY-----";
const unsigned char advanced_cert_pem_1[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDDjCCAXagAwIBAgIUNdBXsS0f7w7zoqBV005eOeD2DMgwDQYJKoZIhvcNAQEL\n"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMTETMBEGA1UEChMKYmFiZWxvdWVzdDAe\n"
"Fw0yMTA5MTMyMTQ5MzhaFw0yMjA4MjkyMTQ5MzhaMCsxFDASBgNVBAMTC0RhdmUg\n"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D\n"
"AQcDQgAEKOIR+UzdL4i9/nP35uX5RIafqwsADRFiN74McMa3LVL/TDfougV5plYu\n"
"Zz2/TzJbrwPDUYCB/rV8/hHku0tXnKN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE\n"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBR/xAPVMRUg\n"
"SF2INrNsGrX9ZikSYDAfBgNVHSMEGDAWgBRZm42kTC+aL+0DVOySIDIN9SvUEjAN\n"
"BgkqhkiG9w0BAQsFAAOCAYEAHH8FtJ4CVfrSvlGxRkZH91XFK6ib110b/Nu9zIPG\n"
"2t+GaFhvCBtRfHhbzF7FG/o+NNhbUfWLnbPReNQy45QasqlrQMDkgeCAZskeadx1\n"
"MjrAN8EbFSmQxQ9dKJwZrXYxiT3IW1LFWyuHHA+avDyWyDQSoABZkVWzV3UHj6PF\n"
"GjNUhdWbU7WLF9zYX07K7u2FyV67/fJCPX9R1+cvVFpYtPQsOo5NFnELrlbRs8d1\n"
"g7JpfZX/juXBtYsiA71iOP9sVqWHM5UkWgd6xadOGFqiiSpJMn+k5LL9PVLZ6Bqd\n"
"qLOEFELIULM/mVvIvd3kbwiTiUkZTb6wtI/Z8bAPlKSQB/xHuxy8/H3cOc8COoq2\n"
"fnTtLBaQj4c4VEk+MPuLsK7smFWsQnQNRS+uHPIPW4Nv6nyUj54tqe8FaIzEioBU\n"
"D779sJ9gxiz68UPDo5ArHx3i2iS2ROkEGEUm93fYGi8y8yZtWb8MsPvqJi2Ar0tv\n"
"s3yOHp3+WqTOfToYSrrNz2rP\n"
"-----END CERTIFICATE-----";
const unsigned char advanced_cert_der_1[] = 
"MIIDDjCCAXagAwIBAgIUNdBXsS0f7w7zoqBV005eOeD2DMgwDQYJKoZIhvcNAQEL"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMTETMBEGA1UEChMKYmFiZWxvdWVzdDAe"
"Fw0yMTA5MTMyMTQ5MzhaFw0yMjA4MjkyMTQ5MzhaMCsxFDASBgNVBAMTC0RhdmUg"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D"
"AQcDQgAEKOIR+UzdL4i9/nP35uX5RIafqwsADRFiN74McMa3LVL/TDfougV5plYu"
"Zz2/TzJbrwPDUYCB/rV8/hHku0tXnKN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBR/xAPVMRUg"
"SF2INrNsGrX9ZikSYDAfBgNVHSMEGDAWgBRZm42kTC+aL+0DVOySIDIN9SvUEjAN"
"BgkqhkiG9w0BAQsFAAOCAYEAHH8FtJ4CVfrSvlGxRkZH91XFK6ib110b/Nu9zIPG"
"2t+GaFhvCBtRfHhbzF7FG/o+NNhbUfWLnbPReNQy45QasqlrQMDkgeCAZskeadx1"
"MjrAN8EbFSmQxQ9dKJwZrXYxiT3IW1LFWyuHHA+avDyWyDQSoABZkVWzV3UHj6PF"
"GjNUhdWbU7WLF9zYX07K7u2FyV67/fJCPX9R1+cvVFpYtPQsOo5NFnELrlbRs8d1"
"g7JpfZX/juXBtYsiA71iOP9sVqWHM5UkWgd6xadOGFqiiSpJMn+k5LL9PVLZ6Bqd"
"qLOEFELIULM/mVvIvd3kbwiTiUkZTb6wtI/Z8bAPlKSQB/xHuxy8/H3cOc8COoq2"
"fnTtLBaQj4c4VEk+MPuLsK7smFWsQnQNRS+uHPIPW4Nv6nyUj54tqe8FaIzEioBU"
"D779sJ9gxiz68UPDo5ArHx3i2iS2ROkEGEUm93fYGi8y8yZtWb8MsPvqJi2Ar0tv"
"s3yOHp3+WqTOfToYSrrNz2rP";

const unsigned char advanced_key_2[] = "-----BEGIN EC PRIVATE KEY-----\n"
"MHcCAQEEICXdcvJ68jTD5qOxv5a1QQLE7K6OcqSOjgNLd3pPE1z1oAoGCCqGSM49\n"
"AwEHoUQDQgAEO/I3Q8FsEFii5oHZB5HtZe46awSYxkmTtmVpWKab5T9SIfznVwL3\n"
"n5/ijLyQ54f6bWnLkxeuZxRfTdrDHNodOg==\n"
"-----END EC PRIVATE KEY-----";
const unsigned char advanced_cert_pem_2[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDDjCCAXagAwIBAgIUd1sYeALcC3nDDzlovmUm9S+IAaEwDQYJKoZIhvcNAQEL\n"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMTETMBEGA1UEChMKYmFiZWxvdWVzdDAe\n"
"Fw0yMTA5MTQxNTI0NDZaFw0yMjA4MzAxNTI0NDZaMCsxFDASBgNVBAMTC0RhdmUg\n"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D\n"
"AQcDQgAEO/I3Q8FsEFii5oHZB5HtZe46awSYxkmTtmVpWKab5T9SIfznVwL3n5/i\n"
"jLyQ54f6bWnLkxeuZxRfTdrDHNodOqN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE\n"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBSdjs0rqLgE\n"
"HvJoen2T0XIRRirS5TAfBgNVHSMEGDAWgBSTmEmG+THW/zrJM5ZfCPi259RA8zAN\n"
"BgkqhkiG9w0BAQsFAAOCAYEAECdRtFVERpkkAfj7mwC7Qu2nopMYcKCDagDKi16Y\n"
"JELQWDEx1djR9GFu19QERN0RGSOEgzPunifaUOGfkYsFaF9NA27KVGgpK3TgTl5A\n"
"JBIGIiKP8vSiqF6KOosbTU3WeKwT4mE3t1yWcG/ExCqXUcOUmH2BFMh74aO2yp8A\n"
"FiRAK51AlU7L3WRvdtaVL1rriiYnOh5SrSevVvebMdZxOzsl7wGhpW6gVfm0xmMP\n"
"KdCNhyjTlX6UzRDGpNxT5TNb3kYRGviZ/BsMpT1MrnIQRUUhLEz7dd4362XgRX1J\n"
"i6RvDKcQVxQNdIOTWyJIDenrbqmuA4ZeV/OI86Uf9iPkjKUGJiVhaYMWwgXSkfRy\n"
"U3uAVpelLX7/mzm3PuJV5RyBsJqNsumsdDSkA++5VhdOqi8Yr5gI0gF3ep5tggvV\n"
"BKgGmpZ2fEF6BKMTC4HyiCc9e2qeqLTIOZPiMpJm8N6fpEY37JEqqPHeY19WYxdE\n"
"TrY5XLCqtITFRVTMubJPyDnc\n"
"-----END CERTIFICATE-----";
const unsigned char advanced_cert_der_2[] = 
"MIIDDjCCAXagAwIBAgIUd1sYeALcC3nDDzlovmUm9S+IAaEwDQYJKoZIhvcNAQEL"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMTETMBEGA1UEChMKYmFiZWxvdWVzdDAe"
"Fw0yMTA5MTQxNTI0NDZaFw0yMjA4MzAxNTI0NDZaMCsxFDASBgNVBAMTC0RhdmUg"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D"
"AQcDQgAEO/I3Q8FsEFii5oHZB5HtZe46awSYxkmTtmVpWKab5T9SIfznVwL3n5/i"
"jLyQ54f6bWnLkxeuZxRfTdrDHNodOqN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBSdjs0rqLgE"
"HvJoen2T0XIRRirS5TAfBgNVHSMEGDAWgBSTmEmG+THW/zrJM5ZfCPi259RA8zAN"
"BgkqhkiG9w0BAQsFAAOCAYEAECdRtFVERpkkAfj7mwC7Qu2nopMYcKCDagDKi16Y"
"JELQWDEx1djR9GFu19QERN0RGSOEgzPunifaUOGfkYsFaF9NA27KVGgpK3TgTl5A"
"JBIGIiKP8vSiqF6KOosbTU3WeKwT4mE3t1yWcG/ExCqXUcOUmH2BFMh74aO2yp8A"
"FiRAK51AlU7L3WRvdtaVL1rriiYnOh5SrSevVvebMdZxOzsl7wGhpW6gVfm0xmMP"
"KdCNhyjTlX6UzRDGpNxT5TNb3kYRGviZ/BsMpT1MrnIQRUUhLEz7dd4362XgRX1J"
"i6RvDKcQVxQNdIOTWyJIDenrbqmuA4ZeV/OI86Uf9iPkjKUGJiVhaYMWwgXSkfRy"
"U3uAVpelLX7/mzm3PuJV5RyBsJqNsumsdDSkA++5VhdOqi8Yr5gI0gF3ep5tggvV"
"BKgGmpZ2fEF6BKMTC4HyiCc9e2qeqLTIOZPiMpJm8N6fpEY37JEqqPHeY19WYxdE"
"TrY5XLCqtITFRVTMubJPyDnc";

const unsigned char advanced_key_3[] = "-----BEGIN EC PRIVATE KEY-----\n"
"MHcCAQEEIEslWGWIe3xz8KResadYE+JZEfrPNp4wV7b19He998GLoAoGCCqGSM49\n"
"AwEHoUQDQgAEB8zD2LcZJt8GFMS07Z9k0aWm4r4VFOAm7BQOJzgsIUkFbVxKfABU\n"
"Xm1qDJIFMq/Ct9//ZMw3cHcvzJSDsqOuLQ==\n"
"-----END EC PRIVATE KEY-----";
const unsigned char advanced_cert_pem_3[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDDjCCAXagAwIBAgIUF6BNJxZDAJ79e+0I4OStbeBHNB4wDQYJKoZIhvcNAQEL\n"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMjETMBEGA1UEChMKYmFiZWxvdWVzdDAe\n"
"Fw0yMTA5MTMyMTQ5NDBaFw0yMjA4MjkyMTQ5NDBaMCsxFDASBgNVBAMTC0RhdmUg\n"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D\n"
"AQcDQgAEB8zD2LcZJt8GFMS07Z9k0aWm4r4VFOAm7BQOJzgsIUkFbVxKfABUXm1q\n"
"DJIFMq/Ct9//ZMw3cHcvzJSDsqOuLaN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE\n"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBSdgOkpqrAK\n"
"R71zgTVIPfKcF40SAzAfBgNVHSMEGDAWgBREM51ULZjY5niamwAnB62dRTAjZDAN\n"
"BgkqhkiG9w0BAQsFAAOCAYEAHe+d5uxOBNW+6o9gyn+g2Q1x0YFJhaCvvgoVVC71\n"
"E1WkdBMO0nRYJZNxmNgd13DNvrD+Y31IFmTgGidg9urDq6HLo9Q9UkpAYdOKTsXk\n"
"NDo1QL5Kjqspuf2Aco3cDcvR2a5OUAJigftpdjOSTvG3geltDsYcd/khY0dMOl3h\n"
"25OZm6KyZAORWw3LhXxtmDfPxe31cd/lEp19Gp8aokLorHc7/yYS5h4OhL146vm/\n"
"CHYSt8pAIP65IyKoHJpHdSc4uOz0HJ92lpR10Qa9wqrFzDVcHGDX/JBvS0/H5Uyd\n"
"OY4jO7FEImq434YOtSy0yGJh/soK8RNe0frGzoQsQ/WxMBeHnprp/eBVZ8jqvYJ4\n"
"GW8kTtl8SGitehjoFdby46nAzdt3dBUcmZhm9Yka4jRVN5mwd+s13Pu2zRSvEwvq\n"
"IiKlSjZYotFffUsrfHVYqlk58PX5j7P/fohvLnHkucbu9FVrvVLlqZHK3vzafdw6\n"
"SlefNWD4/90X/5VFOpePkjZY\n"
"-----END CERTIFICATE-----";
const unsigned char advanced_cert_der_3[] = 
"MIIDDjCCAXagAwIBAgIUcqJBzjg4lb0vBeFBGZ2uuY9ZoLkwDQYJKoZIhvcNAQEL"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMTETMBEGA1UEChMKYmFiZWxvdWVzdDAe"
"Fw0yMTA5MTMyMTQ5MzlaFw0yMjA4MjkyMTQ5MzlaMCsxFDASBgNVBAMTC0RhdmUg"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D"
"AQcDQgAE/TPAuX0MdUL6H1xse1VwixvR6wxmy6+GS5XS4P8H6lcczryuu+8Oqz2h"
"6sw1ChDIRt00l25j92h1SjFknnbE2qN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBScRf4VnU2d"
"71JxFeUmXa5uqaMclTAfBgNVHSMEGDAWgBRZm42kTC+aL+0DVOySIDIN9SvUEjAN"
"BgkqhkiG9w0BAQsFAAOCAYEAmhXg8uHQcAttx1gOKrLi77q1RpeGIu4dYy0UtOW1"
"ucNJuOGs8prcPROPElZEkZmfcgwDd2wwjNfs8tqPrcgSDyipLG7yMEj3uxxSZW7S"
"DN72f3qL2QavZ4joVZI5v2VplBFbCqC3Fr06Pg8xRcihfb+SnsrhQ4hVuG6GxIF+"
"n/khTXsEW6kEi6V0s79AIFBzYa/nH3sfK4gWQvcmUoBJ3Hzz2EIroB9v+P8OdJcR"
"37pfw+IDZx2Ri/W18nLwDTF0NVydT2ZGxHRFjankV2uM5q79nW1fsRCTrfoKxWGN"
"pKG9IxeXORwv87pETRxQA8W08AGqBsk62f5/lEuxfJqIw6wZKLtb2nqN912QDXLc"
"q0F6StYQHYB7WMZM2FA3AzaYeCjfI5a1/LirKm8okt96HXVo2rpqaDB3sJq5C5u+"
"yUZ3i+PlDEkUv3CTYSVYaBjKBDTgj6Z4kxKTdBE/A5rXRwIi14LyddTcPRKDrHlh"
"MQJL7ADzfeTbVYOHJx8XEE0F";

const unsigned char advanced_key_4[] = "-----BEGIN EC PRIVATE KEY-----\n"
"MHcCAQEEIF+8UMnI9we1opth9BXqoNmsyj7bpeyMl6gnj8y4jejaoAoGCCqGSM49\n"
"AwEHoUQDQgAErXNalVG5Ylar4cutzXQVVA02QJLCo7b21E3C2nHhBLdF/27T27R6\n"
"KeiN/+ym/O780uZLwqCaFR9ix5I3/Jxpdg==\n"
"-----END EC PRIVATE KEY-----";
const unsigned char advanced_cert_pem_4[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDDjCCAXagAwIBAgIUVWRCzRVkKkvSV8p5hX2em+k5NH0wDQYJKoZIhvcNAQEL\n"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMjETMBEGA1UEChMKYmFiZWxvdWVzdDAe\n"
"Fw0yMTA5MTQxNTI0NDdaFw0yMjA4MzAxNTI0NDdaMCsxFDASBgNVBAMTC0RhdmUg\n"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D\n"
"AQcDQgAErXNalVG5Ylar4cutzXQVVA02QJLCo7b21E3C2nHhBLdF/27T27R6KeiN\n"
"/+ym/O780uZLwqCaFR9ix5I3/JxpdqN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE\n"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBTLd4oWdCho\n"
"wKLuBKrx0Gq1C8W4mDAfBgNVHSMEGDAWgBRK5ldhst/tVyTQRn8g0Sc3gWnqkDAN\n"
"BgkqhkiG9w0BAQsFAAOCAYEAjq6QQM2ghdIvYkPwVV1r3oovuX9jTflslmzcZhuA\n"
"Mf41hKXjx/Y56n5YgWm6IeDWNfD7Q0u+ewe9k8sOA/6SROlrhW/1mFSVUDACd0uw\n"
"NubxeQQBLuYC+aoXOVacWX3zPXti7AcmYCHXtHnIp9ug3mYPyXg5idKRAqaaujZw\n"
"lN9DXB8L40PcujjzG/2rYhUx0xasyZZsbUotwn8YxvqPtEFls/3KWNTguu64VE3a\n"
"ha+NYJHcyyK8anNSTGV2snHNyCQagvb/lu+hsLYx3QkfknqWnbLHaA5Be86jZNQ8\n"
"EfAKsVN2N1NsIZfeRJ7jkeoFztI+sEuJjXEKJfQ69KoDAiIVfNuooMlYH9r2ldCJ\n"
"WZp5QzZ+cMXLrf3quKudH6QvdD0uKkHX9vQ9pfMDhMNgAbrUyI4dMgWJcW788N1N\n"
"Yj7MxshEtderX2xwlf0atGNyj/MQjhiuBzYCuvbzLxD8CkZMMjPwEHbwGkVaSdTa\n"
"Cggnp64OVIyU5OqLa4BVmWQl\n"
"-----END CERTIFICATE-----";
const unsigned char advanced_cert_der_4[] = 
"MIIDDjCCAXagAwIBAgIUVWRCzRVkKkvSV8p5hX2em+k5NH0wDQYJKoZIhvcNAQEL"
"BQAwKjETMBEGA1UEAwwKZ2xld2x3eWRfMjETMBEGA1UEChMKYmFiZWxvdWVzdDAe"
"Fw0yMTA5MTQxNTI0NDdaFw0yMjA4MzAxNTI0NDdaMCsxFDASBgNVBAMTC0RhdmUg"
"TG9wcGVyMRMwEQYDVQQKEwpiYWJlbG91ZXN0MFkwEwYHKoZIzj0CAQYIKoZIzj0D"
"AQcDQgAErXNalVG5Ylar4cutzXQVVA02QJLCo7b21E3C2nHhBLdF/27T27R6KeiN"
"/+ym/O780uZLwqCaFR9ix5I3/JxpdqN2MHQwDAYDVR0TAQH/BAIwADATBgNVHSUE"
"DDAKBggrBgEFBQcDAjAPBgNVHQ8BAf8EBQMDB4AAMB0GA1UdDgQWBBTLd4oWdCho"
"wKLuBKrx0Gq1C8W4mDAfBgNVHSMEGDAWgBRK5ldhst/tVyTQRn8g0Sc3gWnqkDAN"
"BgkqhkiG9w0BAQsFAAOCAYEAjq6QQM2ghdIvYkPwVV1r3oovuX9jTflslmzcZhuA"
"Mf41hKXjx/Y56n5YgWm6IeDWNfD7Q0u+ewe9k8sOA/6SROlrhW/1mFSVUDACd0uw"
"NubxeQQBLuYC+aoXOVacWX3zPXti7AcmYCHXtHnIp9ug3mYPyXg5idKRAqaaujZw"
"lN9DXB8L40PcujjzG/2rYhUx0xasyZZsbUotwn8YxvqPtEFls/3KWNTguu64VE3a"
"ha+NYJHcyyK8anNSTGV2snHNyCQagvb/lu+hsLYx3QkfknqWnbLHaA5Be86jZNQ8"
"EfAKsVN2N1NsIZfeRJ7jkeoFztI+sEuJjXEKJfQ69KoDAiIVfNuooMlYH9r2ldCJ"
"WZp5QzZ+cMXLrf3quKudH6QvdD0uKkHX9vQ9pfMDhMNgAbrUyI4dMgWJcW788N1N"
"Yj7MxshEtderX2xwlf0atGNyj/MQjhiuBzYCuvbzLxD8CkZMMjPwEHbwGkVaSdTa"
"Cggnp64OVIyU5OqLa4BVmWQl";
const char advanced_jku_4[] = "{\"keys\":[{\"kty\":\"EC\",\"x\":\"rXNalVG5Ylar4cutzXQVVA02QJLCo7b21E3C2nHhBLc\",\"y\":\"Rf9u09u0einojf_spvzu_NLmS8KgmhUfYseSN_ycaXY\",\"crv\":\"P-256\",\"kid\":\"OsipzlLJ1CAOU_WnT2zuB4u31IlgFPsZfT4j4r5qZUA\"}]}";

#define ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY "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.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.u04kxvLdO4YFtqeLDXu0dMaf_RFraL5Oeh3hkavwQBfhQr_XdmOByDn8K8znelDUsEw398-LP8x2xl4SG84FMg"

#define ADVANCED_TOKEN_SIGNED_WITH_KEY_1 "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.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.PjdVrjXaGNpLVW1bZmIQVQFXd65JR6bjbt02SOWUgGAKP0SPrpK4NOt6mmHgtREL8RbQZH_ytHhWZsxJu71KcQ"
#define ADVANCED_TOKEN_SIGNED_WITH_KEY_2 "eyJraWQiOiJuZTQ1Sk9WVXFCOGFwelhPbU9fdDY1ekwtU0dkOUtuTVdfT0NtOUNUZUJRIiwiandrIjp7Imt0eSI6IkVDIiwieCI6IktPSVItVXpkTDRpOV9uUDM1dVg1UklhZnF3c0FEUkZpTjc0TWNNYTNMVkkiLCJ5IjoiXzB3MzZMb0ZlYVpXTG1jOXYwOHlXNjhEdzFHQWdmNjFmUDRSNUx0TFY1dyIsImNydiI6IlAtMjU2Iiwia2lkIjoiMSIsIng1YyI6WyJNSUlERGpDQ0FYYWdBd0lCQWdJVU5kQlhzUzBmN3c3em9xQlYwMDVlT2VEMkRNZ3dEUVlKS29aSWh2Y05BUUVMQlFBd0tqRVRNQkVHQTFVRUF3d0taMnhsZDJ4M2VXUmZNVEVUTUJFR0ExVUVDaE1LWW1GaVpXeHZkV1Z6ZERBZUZ3MHlNVEE1TVRNeU1UUTVNemhhRncweU1qQTRNamt5TVRRNU16aGFNQ3N4RkRBU0JnTlZCQU1UQzBSaGRtVWdURzl3Y0dWeU1STXdFUVlEVlFRS0V3cGlZV0psYkc5MVpYTjBNRmt3RXdZSEtvWkl6ajBDQVFZSUtvWkl6ajBEQVFjRFFnQUVLT0lSK1V6ZEw0aTkvblAzNXVYNVJJYWZxd3NBRFJGaU43NE1jTWEzTFZML1REZm91Z1Y1cGxZdVp6Mi9UekpicndQRFVZQ0IvclY4L2hIa3UwdFhuS04yTUhRd0RBWURWUjBUQVFIL0JBSXdBREFUQmdOVkhTVUVEREFLQmdnckJnRUZCUWNEQWpBUEJnTlZIUThCQWY4RUJRTURCNEFBTUIwR0ExVWREZ1FXQkJSL3hBUFZNUlVnU0YySU5yTnNHclg5WmlrU1lEQWZCZ05WSFNNRUdEQVdnQlJabTQya1RDK2FMKzBEVk95U0lESU45U3ZVRWpBTkJna3Foa2lHOXcwQkFRc0ZBQU9DQVlFQUhIOEZ0SjRDVmZyU3ZsR3hSa1pIOTFYRks2aWIxMTBiL051OXpJUEcydCtHYUZodkNCdFJmSGhiekY3RkcvbytOTmhiVWZXTG5iUFJlTlF5NDVRYXNxbHJRTURrZ2VDQVpza2VhZHgxTWpyQU44RWJGU21ReFE5ZEtKd1pyWFl4aVQzSVcxTEZXeXVISEErYXZEeVd5RFFTb0FCWmtWV3pWM1VIajZQRkdqTlVoZFdiVTdXTEY5ellYMDdLN3UyRnlWNjcvZkpDUFg5UjErY3ZWRnBZdFBRc09vNU5GbkVMcmxiUnM4ZDFnN0pwZlpYL2p1WEJ0WXNpQTcxaU9QOXNWcVdITTVVa1dnZDZ4YWRPR0ZxaWlTcEpNbitrNUxMOVBWTFo2QnFkcUxPRUZFTElVTE0vbVZ2SXZkM2tid2lUaVVrWlRiNnd0SS9aOGJBUGxLU1FCL3hIdXh5OC9IM2NPYzhDT29xMmZuVHRMQmFRajRjNFZFaytNUHVMc0s3c21GV3NRblFOUlMrdUhQSVBXNE52Nm55VWo1NHRxZThGYUl6RWlvQlVENzc5c0o5Z3hpejY4VVBEbzVBckh4M2kyaVMyUk9rRUdFVW05M2ZZR2k4eTh5WnRXYjhNc1B2cUppMkFyMHR2czN5T0hwMytXcVRPZlRvWVNyck56MnJQIl19LCJ4NWMiOlsiTUlJRERqQ0NBWGFnQXdJQkFnSVVkMXNZZUFMY0MzbkREemxvdm1VbTlTK0lBYUV3RFFZSktvWklodmNOQVFFTEJRQXdLakVUTUJFR0ExVUVBd3dLWjJ4bGQyeDNlV1JmTVRFVE1CRUdBMVVFQ2hNS1ltRmlaV3h2ZFdWemREQWVGdzB5TVRBNU1UUXhOVEkwTkRaYUZ3MHlNakE0TXpBeE5USTBORFphTUNzeEZEQVNCZ05WQkFNVEMwUmhkbVVnVEc5d2NHVnlNUk13RVFZRFZRUUtFd3BpWVdKbGJHOTFaWE4wTUZrd0V3WUhLb1pJemowQ0FRWUlLb1pJemowREFRY0RRZ0FFTy9JM1E4RnNFRmlpNW9IWkI1SHRaZTQ2YXdTWXhrbVR0bVZwV0thYjVUOVNJZnpuVndMM241L2lqTHlRNTRmNmJXbkxreGV1WnhSZlRkckRITm9kT3FOMk1IUXdEQVlEVlIwVEFRSC9CQUl3QURBVEJnTlZIU1VFRERBS0JnZ3JCZ0VGQlFjREFqQVBCZ05WSFE4QkFmOEVCUU1EQjRBQU1CMEdBMVVkRGdRV0JCU2RqczBycUxnRUh2Sm9lbjJUMFhJUlJpclM1VEFmQmdOVkhTTUVHREFXZ0JTVG1FbUcrVEhXL3pySk01WmZDUGkyNTlSQTh6QU5CZ2txaGtpRzl3MEJBUXNGQUFPQ0FZRUFFQ2RSdEZWRVJwa2tBZmo3bXdDN1F1Mm5vcE1ZY0tDRGFnREtpMTZZSkVMUVdERXgxZGpSOUdGdTE5UUVSTjBSR1NPRWd6UHVuaWZhVU9HZmtZc0ZhRjlOQTI3S1ZHZ3BLM1RnVGw1QUpCSUdJaUtQOHZTaXFGNktPb3NiVFUzV2VLd1Q0bUUzdDF5V2NHL0V4Q3FYVWNPVW1IMkJGTWg3NGFPMnlwOEFGaVJBSzUxQWxVN0wzV1J2ZHRhVkwxcnJpaVluT2g1U3JTZXZWdmViTWRaeE96c2w3d0docFc2Z1ZmbTB4bU1QS2RDTmh5alRsWDZVelJER3BOeFQ1VE5iM2tZUkd2aVovQnNNcFQxTXJuSVFSVVVoTEV6N2RkNDM2MlhnUlgxSmk2UnZES2NRVnhRTmRJT1RXeUpJRGVucmJxbXVBNFplVi9PSTg2VWY5aVBraktVR0ppVmhhWU1Xd2dYU2tmUnlVM3VBVnBlbExYNy9tem0zUHVKVjVSeUJzSnFOc3Vtc2REU2tBKys1VmhkT3FpOFlyNWdJMGdGM2VwNXRnZ3ZWQktnR21wWjJmRUY2QktNVEM0SHlpQ2M5ZTJxZXFMVElPWlBpTXBKbThONmZwRVkzN0pFcXFQSGVZMTlXWXhkRVRyWTVYTENxdElURlJWVE11YkpQeURuYyJdLCJ4NXUiOiJodHRwczovL2xvY2FsaG9zdDo3NDY4L3g1dSIsImprdSI6Imh0dHBzOi8vbG9jYWxob3N0Ojc0Njgvamt1IiwidHlwIjoiSldUIiwiYWxnIjoiRVMyNTYifQ.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.FKGb5rBB-FrwjhC3CLe1CmBuhE3yJBqVeOPawojCGRUpXAm4i6bXv1Ynu3_7EkuwYy6z43_hz1_3JEjaFxCh9A"
#define ADVANCED_TOKEN_SIGNED_WITH_KEY_3 "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.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.gl8ulx70V61AUXMUfeTfUDGKYAFkvXoGwtwPFg5MsktjY8t1g3D8dkOrMvI_vZHiZNC4rrT3yf6YB-g7T933hQ"
#define ADVANCED_TOKEN_SIGNED_WITH_KEY_4 "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.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.6ULy8B5R__8Ie8Rah47jE4dkZJXwJkrthfYFQAMrPzgvbIKVOLchujW7C7u_k_fojDsBXeXHGcND5Fdaxzxjlw"
#define ADVANCED_NESTED_TOKEN_SE_SIGNED_WITH_KEY_2 "eyJqd2siOnsia3R5IjoiRUMiLCJ4IjoiT19JM1E4RnNFRmlpNW9IWkI1SHRaZTQ2YXdTWXhrbVR0bVZwV0thYjVUOCIsInkiOiJVaUg4NTFjQzk1LWY0b3k4a09lSC1tMXB5NU1Ycm1jVVgwM2F3eHphSFRvIiwiY3J2IjoiUC0yNTYiLCJraWQiOiJuZTQ1Sk9WVXFCOGFwelhPbU9fdDY1ekwtU0dkOUtuTVdfT0NtOUNUZUJRIiwieDVjIjpbIk1JSUREakNDQVhhZ0F3SUJBZ0lVZDFzWWVBTGNDM25ERHpsb3ZtVW05UytJQWFFd0RRWUpLb1pJaHZjTkFRRUxCUUF3S2pFVE1CRUdBMVVFQXd3S1oyeGxkMngzZVdSZk1URVRNQkVHQTFVRUNoTUtZbUZpWld4dmRXVnpkREFlRncweU1UQTVNVFF4TlRJME5EWmFGdzB5TWpBNE16QXhOVEkwTkRaYU1Dc3hGREFTQmdOVkJBTVRDMFJoZG1VZ1RHOXdjR1Z5TVJNd0VRWURWUVFLRXdwaVlXSmxiRzkxWlhOME1Ga3dFd1lIS29aSXpqMENBUVlJS29aSXpqMERBUWNEUWdBRU8vSTNROEZzRUZpaTVvSFpCNUh0WmU0NmF3U1l4a21UdG1WcFdLYWI1VDlTSWZ6blZ3TDNuNS9pakx5UTU0ZjZiV25Ma3hldVp4UmZUZHJESE5vZE9xTjJNSFF3REFZRFZSMFRBUUgvQkFJd0FEQVRCZ05WSFNVRUREQUtCZ2dyQmdFRkJRY0RBakFQQmdOVkhROEJBZjhFQlFNREI0QUFNQjBHQTFVZERnUVdCQlNkanMwcnFMZ0VIdkpvZW4yVDBYSVJSaXJTNVRBZkJnTlZIU01FR0RBV2dCU1RtRW1HK1RIVy96ckpNNVpmQ1BpMjU5UkE4ekFOQmdrcWhraUc5dzBCQVFzRkFBT0NBWUVBRUNkUnRGVkVScGtrQWZqN213QzdRdTJub3BNWWNLQ0RhZ0RLaTE2WUpFTFFXREV4MWRqUjlHRnUxOVFFUk4wUkdTT0VnelB1bmlmYVVPR2ZrWXNGYUY5TkEyN0tWR2dwSzNUZ1RsNUFKQklHSWlLUDh2U2lxRjZLT29zYlRVM1dlS3dUNG1FM3QxeVdjRy9FeENxWFVjT1VtSDJCRk1oNzRhTzJ5cDhBRmlSQUs1MUFsVTdMM1dSdmR0YVZMMXJyaWlZbk9oNVNyU2V2VnZlYk1kWnhPenNsN3dHaHBXNmdWZm0weG1NUEtkQ05oeWpUbFg2VXpSREdwTnhUNVROYjNrWVJHdmlaL0JzTXBUMU1ybklRUlVVaExFejdkZDQzNjJYZ1JYMUppNlJ2REtjUVZ4UU5kSU9UV3lKSURlbnJicW11QTRaZVYvT0k4NlVmOWlQa2pLVUdKaVZoYVlNV3dnWFNrZlJ5VTN1QVZwZWxMWDcvbXptM1B1SlY1UnlCc0pxTnN1bXNkRFNrQSsrNVZoZE9xaThZcjVnSTBnRjNlcDV0Z2d2VkJLZ0dtcFoyZkVGNkJLTVRDNEh5aUNjOWUycWVxTFRJT1pQaU1wSm04TjZmcEVZMzdKRXFxUEhlWTE5V1l4ZEVUclk1WExDcXRJVEZSVlRNdWJKUHlEbmMiXX0sImtpZCI6Im5lNDVKT1ZVcUI4YXB6WE9tT190NjV6TC1TR2Q5S25NV19PQ205Q1RlQlEiLCJ0eXAiOiJKV1QiLCJjdHkiOiJKV1QiLCJhbGciOiJFQ0RILUVTK0ExMjhLVyIsImVwayI6eyJrdHkiOiJFQyIsIngiOiJGS3pXWTRVQWM4V04taGRURG5MSXZwOHVDLXlnVGVsbzg5bGVGMlFnUFRvIiwieSI6IkhJMUlCWk80bnQtenIzTWtNNmZNMGp2VC1NdFMxZjM3WW9IRklpNUFRTm8iLCJjcnYiOiJQLTI1NiJ9LCJlbmMiOiJBMTI4Q0JDLUhTMjU2In0.-l-XNKt-YghvBJRkrVkfOk4pMecbY1NVnLtWjUjzLBkYPlNTsGJhhA.W2GeMAwSQcmpnrwYM707eA.fCoZXpzRBSA0-Ds_g9T7kIl8dhqVlgeWrZDxGTnzpgAmQklZss2gQ3YP5j8wo8wqjB7fC1M8oPFc9HP_OHfy0iCUdy9Nc2iinMtXHiS-n9TB3s5pkAA66fd4FCzJewB4YzSprLdYo_knQhmbOhQ0bgmPR489nU42yYp8Q8ssJAo3Ksz4mGE9edbpYXiKansQiXYzqOJglIlef-htndnUj5gEKEQs_sfu0NM9Qm7nqJuHzPC5b5uaiXAdkNQaWue9V5Lluse6hcSYDPcBmAiwfSqNTauP4p__srYfu9aEkCnsk8PsRkn-IWnqVZHOlc7K91xHVGknxQJPCFNf03d1ybPxIAU8-Ms1xAf3F4R1RXKYweZTeqzCjcRGQ52UD7bMTkkwAlawO8uazw3KDY41kDaNxQWhvGBKuO4ybOE-dBsRvvZahiHqX95wfJOgsTSwSAKwmjcda0xAYuqn_sTVPWsLI3q1yMkXo_8YbQr6PYQf66h9cnAkHfQPV2QqHER7KNzKEscmbAI2LUCpxZIqZYJswwtRGCQaJB50-1RV-_HUyx3iW-6OBjjVFCMntpYjqzzRdT-wlDwy3VoBs0cWkMpuovBxeBRwg0j3gXN4aWcUL7dKqecz_PE-qput5iAHPmuaUGZh24bZ-ekxapBvUFb7iOvdavrpn7A1g4NezoGe5N-OySzv49uSJvsNy6ks0Q9ZmgSSbyiv4FwYx0tZZZT8L_59yYcBaeGbU-yYlUVPmACEgqY9whpxZjuea57bvr8IFlwcYxmxEFCrtrc1vQMJs5oEFNxyO9HIkiWT95SWsDOc7a8F_S_IidiAm4Z7bitAxiSN-6wgqGLzF4cgUoylV0dsBzncfpHiKbM7gJJAeN_RYS8pkfdUqjiI4Qbz2HpDJLHBgFBx5FqEQcB-P9enikL3Tvi5NzYH1k9IqnbZk3spLoAHUyGxU85izZ6_fQpunlO53cpwQriFArV3s51xfYyXxbsKYfGx523YA7A-AHASjtG-Kx863GiRAxN2oxBQIZYFcG0iMTmy6Bv9yQlGjYXROTtme11iqzQrhfiVHMZKb65MzjIpU7EvwlhWrOmUZZWiG4TbwfywPlnAZUB9yCcveGTC27u9C1NF4xF95bfN8ngOBK3rYEvRfRqy6pdNDHCQKs-sUv2T1K-wh6bIqUa30U4nBopCX1oJju3ZHltZdCZZEhzqIEkG3T46UaC9xqGTwxijfjl38YLGgZ9OLeI3_Y4U7W3kAWdyEI6PdOv_wknpPWkNCDlb5Scyzjpr45rafpONg0tkZHKo18JQW_O0xjd0hnyl1l7N724KsiWKm-PPX76_4pyWXQ-hsCaST6xSedJn5dWV6J_MA0m6K7I69_-tE1dPGvG2TmbREemPHoT7mCwA-Wg1o1FXBj9OrKqTqxWKCV4JsBZhWzQt3ZHNeTlPRqN16bZE_tIDEwnXDlJnAdWtl8oHMw09iK7OxtLeJr9WwykwBQKrAVGbzP45t7qMPbvbFfrkalMmUzZmDIhXO_viatM6EwAVRUKHUywhMExS9zRdDKm291MGhM8kMQmArfYG7bUmx065xFRq-z77BHHL4QFu5ph9I-n6po366kL7vCPdLpotyOA6e-TSO3bQSVUto9mtY3jWNJr5VdijSWnDB6KZ3uf0HPC8m_40_Wpi3UbbSAzwG6X2sUw2CwmrhFxkLjINWI6LmqBujSrnhdQ0DdPahl_CfEDnZfBECG7_gw0SeBHpBli99N1sqVGoB8-7_ps-9GuDdqf3PR8MMWO6J8rbecQzWd0zvAaml8nmvZVBxOA__AHCarC7fn6gdaFMppEhKVgQuxEYUgnvS6_V6wycn1swxMDA9AhgJyZbhEH9Hwdd3w8MKmxiYKS8HOwjeJw7hJCeVLjy4dO9BhMvuglkAgNeGGEMKeYtCSQ84xBicWSyEqYF66eD1hWGD3a8a4NsmucbLcyO5Azn57ls-HTzVdh1I2dm02tUIuAF8xozIS1Zr17zbkUO3xjgWiVSUhnoAOJMaXCTHjXJfM9K-sU4-ElMKa4e_FxlBiPdTuzJe6E6ya3Eru-KPeN4cKayV2tMY2astHJLWOrvAMgR25wtpgXMNbJk6QtuoNKrDe-m8lb4duM3iG9gTT7dYFrFoUIZug6s24f4Q2GAtWzpTTBv1na_EsT38-feaUyEnHYgpz9_cvIr7bEXrlosgQIM2WKgk4CPBQn9-Xt2FBakuVlGr2IwveyDxvoOsHBY5zpkRV9sY-LPgHDEcjT1Hoa6r0TmxTE96tI_iKQxyd2U3REVATguVS9ntjDRwUTDwcL8Ve43tKyyD29chC6P32MKzff0XsqGLioPd1G4T2N7nw9ReOmXTH2elkBnnqPf85rz1XXmZzZcx9xPIgaeLpIaYrizahWeUlhRDa3i5PaZ_U-RjVO9Pcs02caitDx24Tzo3LqbZ7ylUEHKzO04npIo8cl7Sr8M0cXL90WG3VccwoJHP_P--TexUDxsWA3_jfydxAZmZ50AElbByrlaaIqBBbH7J5o.oIdhT5DGgVLYY0BeC2N5sA"

#define TOKEN "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjMifQ.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_INVALID_HEADER "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6Ij.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_INVALID_HEADER_B64 ";error;.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_INVALID_CLAIMS "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjMifQ.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cn.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_INVALID_CLAIMS_B64 "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjMifQ.;error;.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_INVALID_DOTS "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjMifQeyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ.SgopnfP3vEE7HbuvfyYqZQZZsbu49GBR5w2YCesW7J0i_s5pVYPMIjl6xU4vOs-nV1lEwn7Z_OaQiyEhVftlOUkM5n7w57YViBZkus5C64S6LuQli150oXWNnis4La6qpg_12EocKffvmG940gL2dWg3dnQYenC-fgtX-CNcaIDZUL-NKq3iaQrwvdbuzNADlSBQUfHh80b7uyKgqcT4tboRyAnJXhcjZ-0NWxCIEusnbskmQEqdxEiq28xL8b_F2hDYe5ZuuHw8tmXcXNHUplswEefTCm0phbvi5D490nVBav6ri6zLTkC9IEOR0hA-1f5AYmvsE5NUepLfpjqCsg"
#define TOKEN_UNSECURE "eyJhbGciOiJub25lIn0.eyJzdHIiOiJncnV0IiwiaW50Ijo0Miwib2JqIjp0cnVlfQ."

START_TEST(test_rhonabwy_init)
{
  jwt_t * jwt;
  
  ck_assert_int_eq(r_jwt_init(NULL), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_sign_alg)
{
  jwt_t * jwt;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_get_sign_alg(jwt), R_JWA_ALG_UNKNOWN);

  ck_assert_int_eq(r_jwt_set_sign_alg(NULL, R_JWA_ALG_ES256), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_sign_alg(jwt, R_JWA_ALG_ES256), RHN_OK);
  ck_assert_int_eq(r_jwt_get_sign_alg(jwt), R_JWA_ALG_ES256);
  
  ck_assert_int_eq(r_jwt_set_sign_alg(jwt, R_JWA_ALG_RS512), RHN_OK);
  ck_assert_int_eq(r_jwt_get_sign_alg(jwt), R_JWA_ALG_RS512);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_enc_alg)
{
  jwt_t * jwt;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_get_enc_alg(jwt), R_JWA_ALG_UNKNOWN);

  ck_assert_int_eq(r_jwt_set_enc_alg(NULL, R_JWA_ALG_RSA1_5), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_enc_alg(jwt, R_JWA_ALG_RSA1_5), RHN_OK);
  ck_assert_int_eq(r_jwt_get_enc_alg(jwt), R_JWA_ALG_RSA1_5);
  
  ck_assert_int_eq(r_jwt_set_enc_alg(jwt, R_JWA_ALG_ECDH_ES), RHN_OK);
  ck_assert_int_eq(r_jwt_get_enc_alg(jwt), R_JWA_ALG_ECDH_ES);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_header)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true());
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_header_str_value(NULL, "key", "value"), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, NULL, "value"), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "key", NULL), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "key", "value"), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_header_int_value(NULL, "key", 42), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_int_value(jwt, NULL, 42), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_int_value(jwt, "key", 42), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_header_json_t_value(NULL, "key", j_value), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_json_t_value(jwt, NULL, j_value), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_json_t_value(jwt, "key", NULL), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_json_t_value(jwt, "key", j_value), RHN_OK);
  
  json_decref(j_value);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_get_header)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), * j_result;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_int_value(jwt, "keyint", 42), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_json_t_value(jwt, "keyjson", j_value), RHN_OK);
  
  ck_assert_str_eq("value", r_jwt_get_header_str_value(jwt, "keystr"));
  ck_assert_int_eq(42, r_jwt_get_header_int_value(jwt, "keyint"));
  ck_assert_int_eq(json_equal(j_value, (j_result = r_jwt_get_header_json_t_value(jwt, "keyjson"))) , 1);
  
  ck_assert_ptr_eq(NULL, r_jwt_get_header_str_value(jwt, "error"));
  ck_assert_int_eq(0, r_jwt_get_header_int_value(jwt, "error"));
  ck_assert_ptr_eq(NULL, r_jwt_get_header_json_t_value(jwt, "error"));
  
  json_decref(j_value);
  json_decref(j_result);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_full_header_error)
{
  jwt_t * jwt;
  json_t * j_header;
  
  j_header = json_pack("{ssss}", "alg", r_jwa_alg_to_str(R_JWA_ALG_RSA_OAEP_256), "enc", "error");
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, j_header), RHN_ERROR_PARAM);
  r_jwt_free(jwt);
  json_decref(j_header);
  
  j_header = json_pack("{ssss}", "alg", "error", "enc", r_jwa_enc_to_str(R_JWA_ENC_A256GCM));
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, j_header), RHN_ERROR_PARAM);
  r_jwt_free(jwt);
  json_decref(j_header);
  
  j_header = json_pack("{ss}", "alg", "error");
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, j_header), RHN_ERROR_PARAM);
  r_jwt_free(jwt);
  json_decref(j_header);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, NULL), RHN_ERROR_PARAM);
  r_jwt_free(jwt);
  
  j_header = json_pack("{ssss}", "alg", r_jwa_alg_to_str(R_JWA_ALG_RSA_OAEP_256), "enc", r_jwa_enc_to_str(R_JWA_ENC_A256GCM));
  ck_assert_int_eq(r_jwt_set_full_header_json_t(NULL, j_header), RHN_ERROR_PARAM);
  json_decref(j_header);
  
}
END_TEST

START_TEST(test_rhonabwy_set_full_header)
{
  jwt_t * jwt;
  json_t * j_header = json_pack("{sssisossss}", "str", JWT_CLAIM_AUD, "int", JWT_CLAIM_AGE, "obj", json_true(), "alg", r_jwa_alg_to_str(R_JWA_ALG_RSA_OAEP_256), "enc", r_jwa_enc_to_str(R_JWA_ENC_A256GCM));
  char * str_header = json_dumps(j_header, JSON_COMPACT);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, j_header), RHN_OK);
  ck_assert_str_eq(r_jwt_get_header_str_value(jwt, "str"), JWT_CLAIM_AUD);
  ck_assert_int_eq(r_jwt_get_header_int_value(jwt, "int"), JWT_CLAIM_AGE);
  ck_assert_ptr_eq(r_jwt_get_header_json_t_value(jwt, "obj"), json_true());
  ck_assert_int_eq(r_jwt_get_enc_alg(jwt), R_JWA_ALG_RSA_OAEP_256);
  ck_assert_int_eq(r_jwt_get_enc(jwt), R_JWA_ENC_A256GCM);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_str(jwt, str_header), RHN_OK);
  ck_assert_str_eq(r_jwt_get_header_str_value(jwt, "str"), JWT_CLAIM_AUD);
  ck_assert_int_eq(r_jwt_get_header_int_value(jwt, "int"), JWT_CLAIM_AGE);
  ck_assert_ptr_eq(r_jwt_get_header_json_t_value(jwt, "obj"), json_true());
  ck_assert_int_eq(r_jwt_get_enc_alg(jwt), R_JWA_ALG_RSA_OAEP_256);
  ck_assert_int_eq(r_jwt_get_enc(jwt), R_JWA_ENC_A256GCM);
  r_jwt_free(jwt);
  
  o_free(str_header);
  json_decref(j_header);
  
  j_header = json_pack("{sssisoss}", "str", JWT_CLAIM_AUD, "int", JWT_CLAIM_AGE, "obj", json_true(), "alg", r_jwa_alg_to_str(R_JWA_ALG_RS256));
  str_header = json_dumps(j_header, JSON_COMPACT);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_t(jwt, j_header), RHN_OK);
  ck_assert_str_eq(r_jwt_get_header_str_value(jwt, "str"), JWT_CLAIM_AUD);
  ck_assert_int_eq(r_jwt_get_header_int_value(jwt, "int"), JWT_CLAIM_AGE);
  ck_assert_ptr_eq(r_jwt_get_header_json_t_value(jwt, "obj"), json_true());
  ck_assert_int_eq(r_jwt_get_sign_alg(jwt), R_JWA_ALG_RS256);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_full_header_json_str(jwt, str_header), RHN_OK);
  ck_assert_str_eq(r_jwt_get_header_str_value(jwt, "str"), JWT_CLAIM_AUD);
  ck_assert_int_eq(r_jwt_get_header_int_value(jwt, "int"), JWT_CLAIM_AGE);
  ck_assert_ptr_eq(r_jwt_get_header_json_t_value(jwt, "obj"), json_true());
  ck_assert_int_eq(r_jwt_get_sign_alg(jwt), R_JWA_ALG_RS256);
  r_jwt_free(jwt);
  
  o_free(str_header);
  json_decref(j_header);
}
END_TEST

START_TEST(test_rhonabwy_get_full_header)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), * j_header = json_pack("{sssisO}", "keystr", "value", "keyint", 42, "keyjson", j_value), * j_result;
  
  ck_assert_ptr_ne(j_header, NULL);
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_int_value(jwt, "keyint", 42), RHN_OK);
  ck_assert_int_eq(r_jwt_set_header_json_t_value(jwt, "keyjson", j_value), RHN_OK);
  ck_assert_int_eq(r_jwt_set_sign_alg(jwt, R_JWA_ALG_RSA1_5), RHN_OK);
  ck_assert_int_eq(json_equal(j_header, (j_result = r_jwt_get_full_header_json_t(jwt))) , 1);
  json_decref(j_value);
  json_decref(j_header);
  json_decref(j_result);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_claim)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true());
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(NULL, "key", "value"), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, NULL, "value"), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "key", NULL), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "key", "value"), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_int_value(NULL, "key", 42), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, NULL, 42), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "key", 42), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(NULL, "key", j_value), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, NULL, j_value), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "key", NULL), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "key", j_value), RHN_OK);
  
  json_decref(j_value);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_get_claim)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), * j_result;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "keyint", 42), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "keyjson", j_value), RHN_OK);
  
  ck_assert_str_eq("value", r_jwt_get_claim_str_value(jwt, "keystr"));
  ck_assert_int_eq(42, r_jwt_get_claim_int_value(jwt, "keyint"));
  ck_assert_int_eq(json_equal(j_value, (j_result = r_jwt_get_claim_json_t_value(jwt, "keyjson"))) , 1);
  
  ck_assert_ptr_eq(NULL, r_jwt_get_claim_str_value(jwt, "error"));
  ck_assert_int_eq(0, r_jwt_get_claim_int_value(jwt, "error"));
  ck_assert_ptr_eq(NULL, r_jwt_get_claim_json_t_value(jwt, "error"));
  
  json_decref(j_value);
  json_decref(j_result);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_full_claims)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), * j_claims;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_str_eq("value", r_jwt_get_claim_str_value(jwt, "keystr"));
  
  ck_assert_int_eq(r_jwt_set_full_claims_json_t(NULL, j_value), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_full_claims_json_t(jwt, NULL), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_full_claims_json_t(jwt, j_value), RHN_OK);
  
  ck_assert_ptr_eq(NULL, r_jwt_get_claim_str_value(jwt, "keystr"));
  
  ck_assert_ptr_ne(j_claims = r_jwt_get_full_claims_json_t(jwt), NULL);
  ck_assert_int_eq(1, json_equal(j_claims, j_value));
  
  json_decref(j_value);
  json_decref(j_claims);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_full_claims_str)
{
  jwt_t * jwt;
  char str_value[] = "{\"str\":\"grut\",\"int\":42,\"obj\":true}";
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), * j_claims;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_str_eq("value", r_jwt_get_claim_str_value(jwt, "keystr"));
  
  ck_assert_int_eq(r_jwt_set_full_claims_json_str(jwt, str_value), RHN_OK);
  
  ck_assert_ptr_eq(NULL, r_jwt_get_claim_str_value(jwt, "keystr"));
  
  ck_assert_ptr_ne(j_claims = r_jwt_get_full_claims_json_t(jwt), NULL);
  ck_assert_int_eq(1, json_equal(j_claims, j_value));
  
  json_decref(j_value);
  json_decref(j_claims);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_get_full_claims)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), 
         * j_claims, 
         * j_expected = json_pack("{sssisO}", "keystr", "value", "keyint", 42, "keyjson", j_value);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "keyint", 42), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "keyjson", j_value), RHN_OK);
  
  ck_assert_ptr_ne(j_claims = r_jwt_get_full_claims_json_t(jwt), NULL);
  ck_assert_int_eq(1, json_equal(j_claims, j_expected));
  
  json_decref(j_value);
  json_decref(j_claims);
  json_decref(j_expected);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_append_claims)
{
  jwt_t * jwt;
  json_t * j_value = json_pack("{sssiso}", "str", "grut", "int", 42, "obj", json_true()), 
         * j_claims, 
         * j_expected_1 = json_pack("{sssi}", "keystr", "value", "keyint", 42),
         * j_expected_2 = json_pack("{sssisO}", "keystr", "value", "keyint", 42, "keyjson", j_value);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "keystr", "value"), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "keyint", 42), RHN_OK);
  
  ck_assert_ptr_ne(j_claims = r_jwt_get_full_claims_json_t(jwt), NULL);
  ck_assert_int_eq(1, json_equal(j_claims, j_expected_1));
  json_decref(j_claims);
  
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "keyjson", j_value), RHN_OK);
  
  ck_assert_ptr_ne(j_claims = r_jwt_get_full_claims_json_t(jwt), NULL);
  ck_assert_int_eq(1, json_equal(j_claims, j_expected_2));
  
  json_decref(j_value);
  json_decref(j_claims);
  json_decref(j_expected_1);
  json_decref(j_expected_2);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_sign_keys)
{
  jwt_t * jwt;
  jwk_t * jwk_pubkey_ecdsa, * jwk_privkey_ecdsa, * jwk_pubkey_rsa, * jwk_privkey_rsa;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_rsa), RHN_OK);
  
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_ecdsa, jwk_pubkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_ecdsa, jwk_privkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwt_add_sign_keys(jwt, jwk_pubkey_ecdsa, jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_rsa, jwk_pubkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_rsa, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwt_add_sign_keys(jwt, jwk_pubkey_rsa, jwk_privkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwt_add_sign_keys(NULL, jwk_pubkey_ecdsa, jwk_privkey_ecdsa), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_add_sign_keys(jwt, NULL, NULL), RHN_ERROR_PARAM);
  
  r_jwk_free(jwk_pubkey_ecdsa);
  r_jwk_free(jwk_privkey_ecdsa);
  r_jwk_free(jwk_pubkey_rsa);
  r_jwk_free(jwk_privkey_rsa);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_sign_jwks)
{
  jwt_t * jwt;
  jwk_t * jwk_pubkey_ecdsa, * jwk_privkey_ecdsa, * jwk_pubkey_rsa, * jwk_privkey_rsa;
  jwks_t * jwks_pubkey, * jwks_privkey, * jwks;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwks_init(&jwks_pubkey), RHN_OK);
  ck_assert_int_eq(r_jwks_init(&jwks_privkey), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_rsa), RHN_OK);
  
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_ecdsa, jwk_pubkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_pubkey, jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_rsa, jwk_pubkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_pubkey, jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_ecdsa, jwk_privkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_privkey, jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_rsa, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_privkey, jwk_privkey_rsa), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(0, r_jwks_size(jwt->jwks_privkey_sign));
  ck_assert_int_eq(0, r_jwks_size(jwt->jwks_pubkey_sign));
  ck_assert_int_eq(r_jwt_add_sign_jwks(jwt, jwks_privkey, jwks_pubkey), RHN_OK);
  ck_assert_int_eq(2, r_jwks_size(jwt->jwks_privkey_sign));
  ck_assert_int_eq(2, r_jwks_size(jwt->jwks_pubkey_sign));
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  r_jwk_free(jwk_pubkey_ecdsa);
  r_jwk_free(jwk_privkey_ecdsa);
  r_jwk_free(jwk_pubkey_rsa);
  r_jwk_free(jwk_privkey_rsa);
  r_jwks_free(jwks_pubkey);
  r_jwks_free(jwks_privkey);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_add_sign_keys_by_content)
{
  jwt_t * jwt;
  jwk_t * jwk_priv, * jwk_pub;
  jwks_t * jwks;
#if GNUTLS_VERSION_NUMBER >= 0x030600
  gnutls_privkey_t g_privkey;
  gnutls_pubkey_t g_pubkey;
#endif
  json_t * j_privkey, * j_pubkey;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_priv), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_priv, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pub, jwk_pubkey_rsa_str), RHN_OK);
#if GNUTLS_VERSION_NUMBER >= 0x030600
  ck_assert_ptr_ne(g_privkey = r_jwk_export_to_gnutls_privkey(jwk_priv), NULL);
  ck_assert_ptr_ne(g_pubkey = r_jwk_export_to_gnutls_pubkey(jwk_pub, 0), NULL);
#endif
  ck_assert_ptr_ne(j_privkey = r_jwk_export_to_json_t(jwk_priv), NULL);
  ck_assert_ptr_ne(j_pubkey = r_jwk_export_to_json_t(jwk_pub), NULL);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_sign_keys_json_str(jwt, jwk_privkey_rsa_str, jwk_pubkey_rsa_str), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(1, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(1, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_sign_keys_json_t(jwt, j_privkey, j_pubkey), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_sign_keys_pem_der(jwt, R_FORMAT_PEM, rsa_2048_priv, sizeof(rsa_2048_priv), rsa_2048_pub, sizeof(rsa_2048_pub)), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(3, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(3, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_sign_key_symmetric(jwt, symmetric_key, sizeof(symmetric_key)), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(4, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(4, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
#if GNUTLS_VERSION_NUMBER >= 0x030600
  ck_assert_int_eq(r_jwt_add_sign_keys_gnutls(jwt, g_privkey, g_pubkey), RHN_OK);
  
  jwks = r_jwt_get_sign_jwks_privkey(jwt);
  ck_assert_int_eq(5, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_sign_jwks_pubkey(jwt);
  ck_assert_int_eq(5, r_jwks_size(jwks));
  r_jwks_free(jwks);
#endif
  
  r_jwt_free(jwt);
#if GNUTLS_VERSION_NUMBER >= 0x030600
  gnutls_privkey_deinit(g_privkey);
  gnutls_pubkey_deinit(g_pubkey);
#endif
  json_decref(j_privkey);
  json_decref(j_pubkey);
  r_jwk_free(jwk_priv);
  r_jwk_free(jwk_pub);
}
END_TEST

START_TEST(test_rhonabwy_set_enc_keys)
{
  jwt_t * jwt;
  jwk_t * jwk_pubkey_ecdsa, * jwk_privkey_ecdsa, * jwk_pubkey_rsa, * jwk_privkey_rsa;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_rsa), RHN_OK);
  
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_ecdsa, jwk_pubkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_ecdsa, jwk_privkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwt_add_enc_keys(jwt, jwk_pubkey_ecdsa, jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_rsa, jwk_pubkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_rsa, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwt_add_enc_keys(jwt, jwk_pubkey_rsa, jwk_privkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwt_add_enc_keys(NULL, jwk_pubkey_ecdsa, jwk_privkey_ecdsa), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_add_enc_keys(jwt, NULL, NULL), RHN_ERROR_PARAM);
  
  r_jwk_free(jwk_pubkey_ecdsa);
  r_jwk_free(jwk_privkey_ecdsa);
  r_jwk_free(jwk_pubkey_rsa);
  r_jwk_free(jwk_privkey_rsa);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_enc_jwks)
{
  jwt_t * jwt;
  jwk_t * jwk_pubkey_ecdsa, * jwk_privkey_ecdsa, * jwk_pubkey_rsa, * jwk_privkey_rsa;
  jwks_t * jwks_pubkey, * jwks_privkey, * jwks;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwks_init(&jwks_pubkey), RHN_OK);
  ck_assert_int_eq(r_jwks_init(&jwks_privkey), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_privkey_rsa), RHN_OK);
  
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_ecdsa, jwk_pubkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_pubkey, jwk_pubkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pubkey_rsa, jwk_pubkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_pubkey, jwk_pubkey_rsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_ecdsa, jwk_privkey_ecdsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_privkey, jwk_privkey_ecdsa), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_privkey_rsa, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwks_privkey, jwk_privkey_rsa), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(0, r_jwks_size(jwt->jwks_privkey_enc));
  ck_assert_int_eq(0, r_jwks_size(jwt->jwks_pubkey_enc));
  ck_assert_int_eq(r_jwt_add_enc_jwks(jwt, jwks_privkey, jwks_pubkey), RHN_OK);
  ck_assert_int_eq(2, r_jwks_size(jwt->jwks_privkey_enc));
  ck_assert_int_eq(2, r_jwks_size(jwt->jwks_pubkey_enc));
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  r_jwk_free(jwk_pubkey_ecdsa);
  r_jwk_free(jwk_privkey_ecdsa);
  r_jwk_free(jwk_pubkey_rsa);
  r_jwk_free(jwk_privkey_rsa);
  r_jwks_free(jwks_pubkey);
  r_jwks_free(jwks_privkey);
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_add_enc_keys_by_content)
{
  jwt_t * jwt;
  jwk_t * jwk_priv, * jwk_pub;
  jwks_t * jwks;
#if GNUTLS_VERSION_NUMBER >= 0x030600
  gnutls_privkey_t g_privkey;
  gnutls_pubkey_t g_pubkey;
#endif
  json_t * j_privkey, * j_pubkey;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_priv), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_priv, jwk_privkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pub, jwk_pubkey_rsa_str), RHN_OK);
#if GNUTLS_VERSION_NUMBER >= 0x030600
  ck_assert_ptr_ne(g_privkey = r_jwk_export_to_gnutls_privkey(jwk_priv), NULL);
  ck_assert_ptr_ne(g_pubkey = r_jwk_export_to_gnutls_pubkey(jwk_pub, 0), NULL);
#endif
  ck_assert_ptr_ne(j_privkey = r_jwk_export_to_json_t(jwk_priv), NULL);
  ck_assert_ptr_ne(j_pubkey = r_jwk_export_to_json_t(jwk_pub), NULL);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(0, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_enc_keys_json_str(jwt, jwk_privkey_rsa_str, jwk_pubkey_rsa_str), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(1, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(1, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_enc_keys_json_t(jwt, j_privkey, j_pubkey), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(2, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_enc_keys_pem_der(jwt, R_FORMAT_PEM, rsa_2048_priv, sizeof(rsa_2048_priv), rsa_2048_pub, sizeof(rsa_2048_pub)), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(3, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(3, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  ck_assert_int_eq(r_jwt_add_enc_key_symmetric(jwt, symmetric_key, sizeof(symmetric_key)), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(4, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(4, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
#if GNUTLS_VERSION_NUMBER >= 0x030600
  ck_assert_int_eq(r_jwt_add_enc_keys_gnutls(jwt, g_privkey, g_pubkey), RHN_OK);
  
  jwks = r_jwt_get_enc_jwks_privkey(jwt);
  ck_assert_int_eq(5, r_jwks_size(jwks));
  r_jwks_free(jwks);
  
  jwks = r_jwt_get_enc_jwks_pubkey(jwt);
  ck_assert_int_eq(5, r_jwks_size(jwks));
  r_jwks_free(jwks);
#endif
  
  r_jwt_free(jwt);
#if GNUTLS_VERSION_NUMBER >= 0x030600
  gnutls_privkey_deinit(g_privkey);
  gnutls_pubkey_deinit(g_pubkey);
#endif
  json_decref(j_privkey);
  json_decref(j_pubkey);
  r_jwk_free(jwk_priv);
  r_jwk_free(jwk_pub);
}
END_TEST

START_TEST(test_rhonabwy_set_claims)
{
  jwt_t * jwt;
  time_t exp;

  time(&exp);
  exp+=JWT_CLAIM_EXP;
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS,
                                         R_JWT_CLAIM_SUB, JWT_CLAIM_SUB,
                                         R_JWT_CLAIM_AUD, JWT_CLAIM_AUD,
                                         R_JWT_CLAIM_JTI, JWT_CLAIM_JTI,
                                         R_JWT_CLAIM_EXP, exp,
                                         R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW,
                                         R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW,
                                         R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE,
                                         R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE,
                                         R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED,
                                         R_JWT_CLAIM_TYP, JWT_CLAIM_TYP,
                                         R_JWT_CLAIM_CTY, JWT_CLAIM_CTY,
                                         R_JWT_CLAIM_NOP), RHN_OK);

  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS,
                                              R_JWT_CLAIM_SUB, JWT_CLAIM_SUB,
                                              R_JWT_CLAIM_AUD, JWT_CLAIM_AUD,
                                              R_JWT_CLAIM_JTI, JWT_CLAIM_JTI,
                                              R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE,
                                              R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE,
                                              R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED,
                                              R_JWT_CLAIM_TYP, JWT_CLAIM_TYP,
                                              R_JWT_CLAIM_CTY, JWT_CLAIM_CTY,
                                              R_JWT_CLAIM_NOP), RHN_OK);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_validate_claims)
{
  jwt_t * jwt;
  time_t now;

  time(&now);
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_SUB, JWT_CLAIM_SUB, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_AUD, JWT_CLAIM_AUD, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JTI, JWT_CLAIM_JTI, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_TYP, JWT_CLAIM_TYP, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_CTY, JWT_CLAIM_CTY, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_SUB, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_AUD, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JTI, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, R_JWT_CLAIM_PRESENT, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, R_JWT_CLAIM_PRESENT, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, R_JWT_CLAIM_PRESENT, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_STR, "scope", NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JSN, "verified", NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_TYP, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_CTY, NULL, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "iss", JWT_CLAIM_ISS), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "sub", JWT_CLAIM_SUB), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_SUB, JWT_CLAIM_SUB, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_SUB, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "aud", JWT_CLAIM_AUD), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_AUD, JWT_CLAIM_AUD, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_AUD, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "jti", JWT_CLAIM_JTI), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JTI, JWT_CLAIM_JTI, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JTI, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "exp", (now+JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, now+1, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, (now+JWT_CLAIM_EXP+JWT_CLAIM_EXP), R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "nbf", (now-JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, now-1, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, (now-JWT_CLAIM_NBF-JWT_CLAIM_NBF), R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "iat", (now-JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, now-1, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, (now-JWT_CLAIM_IAT-JWT_CLAIM_IAT), R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "scope", JWT_CLAIM_SCOPE), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_STR, "scope", "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "age", JWT_CLAIM_AGE), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE-1, R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "verified", JWT_CLAIM_VERIFIED), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JSN, "verified", json_null(), R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "typ", JWT_CLAIM_TYP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_TYP, JWT_CLAIM_TYP, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_TYP, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  ck_assert_int_eq(r_jwt_set_header_str_value(jwt, "cty", JWT_CLAIM_CTY), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_CTY, JWT_CLAIM_CTY, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_CTY, "error", R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_SUB, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_AUD, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JTI, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_EXP, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_NBF, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_IAT, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_STR, "scope", NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_JSN, "verified", NULL, R_JWT_CLAIM_NOP), RHN_OK);
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_TYP, NULL, R_JWT_CLAIM_NOP), RHN_OK);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS,
                                              R_JWT_CLAIM_SUB, JWT_CLAIM_SUB,
                                              R_JWT_CLAIM_AUD, JWT_CLAIM_AUD,
                                              R_JWT_CLAIM_JTI, JWT_CLAIM_JTI,
                                              R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE,
                                              R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE,
                                              R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED,
                                              R_JWT_CLAIM_NOP), RHN_OK);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, NULL,
                                              R_JWT_CLAIM_SUB, NULL,
                                              R_JWT_CLAIM_AUD, NULL,
                                              R_JWT_CLAIM_JTI, NULL,
                                              R_JWT_CLAIM_EXP, R_JWT_CLAIM_PRESENT,
                                              R_JWT_CLAIM_NBF, R_JWT_CLAIM_PRESENT,
                                              R_JWT_CLAIM_IAT, R_JWT_CLAIM_PRESENT,
                                              R_JWT_CLAIM_STR, "scope", NULL,
                                              R_JWT_CLAIM_JSN, "verified", NULL,
                                              R_JWT_CLAIM_NOP), RHN_OK);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS,
                                              R_JWT_CLAIM_SUB, JWT_CLAIM_SUB,
                                              R_JWT_CLAIM_AUD, "error",
                                              R_JWT_CLAIM_JTI, JWT_CLAIM_JTI,
                                              R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE,
                                              R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE,
                                              R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED,
                                              R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  
  ck_assert_int_eq(r_jwt_validate_claims(jwt, R_JWT_CLAIM_ISS, JWT_CLAIM_ISS,
                                              R_JWT_CLAIM_SUB, JWT_CLAIM_SUB,
                                              R_JWT_CLAIM_AUD, JWT_CLAIM_AUD,
                                              R_JWT_CLAIM_JTI, JWT_CLAIM_JTI,
                                              R_JWT_CLAIM_EXP, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_NBF, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_IAT, R_JWT_CLAIM_NOW,
                                              R_JWT_CLAIM_STR, "scope", JWT_CLAIM_SCOPE,
                                              R_JWT_CLAIM_INT, "age", JWT_CLAIM_AGE,
                                              R_JWT_CLAIM_JSN, "verified", JWT_CLAIM_VERIFIED,
                                              R_JWT_CLAIM_STR, "error", JWT_CLAIM_SCOPE,
                                              R_JWT_CLAIM_NOP), RHN_ERROR_PARAM);
  
  r_jwt_free(jwt);
}
END_TEST

START_TEST(test_rhonabwy_set_properties_error)
{
  jwt_t * jwt;
  jwk_t * jwk;

  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk, jwk_privkey_ecdsa_str), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_properties(jwt, RHN_OPT_PAYLOAD, PAYLOAD, o_strlen(PAYLOAD),
                                             RHN_OPT_NONE), RHN_ERROR_PARAM);

  r_jwt_free(jwt);
  r_jwk_free(jwk);
}
END_TEST

START_TEST(test_rhonabwy_set_properties)
{
  jwt_t * jwt;
  jwk_t * jwk;
  const unsigned char * key_iv;
  size_t key_iv_len;

  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwk_init(&jwk), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk, jwk_privkey_ecdsa_str), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_properties(jwt, RHN_OPT_HEADER_INT_VALUE, "int", CLAIM_INT,
                                             RHN_OPT_HEADER_RHN_INT_VALUE, "rhn_int", (rhn_int_t)CLAIM_INT,
                                             RHN_OPT_HEADER_STR_VALUE, "str", CLAIM_STR,
                                             RHN_OPT_HEADER_JSON_T_VALUE, "json", json_true(),
                                             RHN_OPT_CLAIM_INT_VALUE, "int", CLAIM_INT,
                                             RHN_OPT_CLAIM_RHN_INT_VALUE, "rhn_int", (rhn_int_t)CLAIM_INT,
                                             RHN_OPT_CLAIM_STR_VALUE, "str", CLAIM_STR,
                                             RHN_OPT_CLAIM_JSON_T_VALUE, "json", json_true(),
                                             RHN_OPT_ENC_ALG, R_JWA_ALG_RSA1_5,
                                             RHN_OPT_ENC, R_JWA_ENC_A256GCM,
                                             RHN_OPT_SIG_ALG, R_JWA_ALG_RS256,
                                             RHN_OPT_CIPHER_KEY, cypher_key, sizeof(cypher_key),
                                             RHN_OPT_IV, iv, sizeof(iv),
                                             RHN_OPT_ENCRYPT_KEY_JWK, jwk,
                                             RHN_OPT_DECRYPT_KEY_JWK, jwk,
                                             RHN_OPT_SIGN_KEY_JWK, jwk,
                                             RHN_OPT_VERIFY_KEY_JWK, jwk,
                                             RHN_OPT_NONE), RHN_OK);

  ck_assert_int_eq(CLAIM_INT, r_jwt_get_header_int_value(jwt, "int"));
  ck_assert_int_eq(CLAIM_INT, r_jwt_get_header_int_value(jwt, "rhn_int"));
  ck_assert_str_eq(CLAIM_STR, r_jwt_get_header_str_value(jwt, "str"));
  ck_assert_ptr_eq(json_true(), r_jwt_get_header_json_t_value(jwt, "json"));
  ck_assert_int_eq(CLAIM_INT, r_jwt_get_claim_int_value(jwt, "int"));
  ck_assert_int_eq(CLAIM_INT, r_jwt_get_claim_int_value(jwt, "rhn_int"));
  ck_assert_str_eq(CLAIM_STR, r_jwt_get_claim_str_value(jwt, "str"));
  ck_assert_ptr_eq(json_true(), r_jwt_get_claim_json_t_value(jwt, "json"));
  ck_assert_int_eq(R_JWA_ALG_RSA1_5, r_jwt_get_enc_alg(jwt));
  ck_assert_int_eq(R_JWA_ENC_A256GCM, r_jwt_get_enc(jwt));
  ck_assert_int_eq(R_JWA_ALG_RS256, r_jwt_get_sign_alg(jwt));
  ck_assert_ptr_ne(NULL, key_iv = r_jwt_get_enc_cypher_key(jwt, &key_iv_len));
  ck_assert_int_eq(sizeof(cypher_key), key_iv_len);
  ck_assert_int_eq(0, memcmp(key_iv, cypher_key, key_iv_len));
  ck_assert_ptr_ne(NULL, key_iv = r_jwt_get_enc_iv(jwt, &key_iv_len));
  ck_assert_int_eq(sizeof(iv), key_iv_len);
  ck_assert_int_eq(0, memcmp(key_iv, iv, key_iv_len));
  ck_assert_int_eq(1, r_jwks_size(jwt->jwks_privkey_sign));
  ck_assert_int_eq(1, r_jwks_size(jwt->jwks_pubkey_sign));
  ck_assert_int_eq(1, r_jwks_size(jwt->jwks_privkey_enc));
  ck_assert_int_eq(1, r_jwks_size(jwt->jwks_pubkey_enc));
  
  r_jwt_free(jwt);
  r_jwk_free(jwk);
}
END_TEST

START_TEST(test_rhonabwy_copy)
{
  jwt_t * jwt, * jwt_copy;
  char * token = NULL, * token_copy;
  time_t now;
  
  time(&now);
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "iss", JWT_CLAIM_ISS), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "sub", JWT_CLAIM_SUB), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "aud", JWT_CLAIM_AUD), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "jti", JWT_CLAIM_JTI), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "exp", (now+JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "nbf", (now-JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "iat", (now-JWT_CLAIM_EXP)), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "scope", JWT_CLAIM_SCOPE), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_int_value(jwt, "age", JWT_CLAIM_AGE), RHN_OK);
  ck_assert_int_eq(r_jwt_set_claim_json_t_value(jwt, "verified", JWT_CLAIM_VERIFIED), RHN_OK);
  ck_assert_int_eq(r_jwt_add_enc_keys_json_str(jwt, jwk_privkey_rsa_str, jwk_pubkey_rsa_str), RHN_OK);
  ck_assert_int_eq(r_jwt_add_sign_key_symmetric(jwt, (const unsigned char *)symmetric_key, sizeof(symmetric_key)), RHN_OK);
  
  ck_assert_int_eq(r_jwt_set_enc_alg(jwt, R_JWA_ALG_RSA1_5), RHN_OK);
  ck_assert_int_eq(r_jwt_set_enc(jwt, R_JWA_ENC_A128CBC), RHN_OK);
  ck_assert_int_eq(r_jwt_set_sign_alg(jwt, R_JWA_ALG_HS256), RHN_OK);
  ck_assert_ptr_ne((token = r_jwt_serialize_nested(jwt, R_JWT_TYPE_NESTED_SIGN_THEN_ENCRYPT, NULL, 0, NULL, 0)), NULL);
  
  ck_assert_ptr_ne((jwt_copy = r_jwt_copy(jwt)), NULL);
  ck_assert_ptr_ne((token_copy = r_jwt_serialize_nested(jwt_copy, R_JWT_TYPE_NESTED_SIGN_THEN_ENCRYPT, NULL, 0, NULL, 0)), NULL);
  
  ck_assert_int_eq(r_jwt_parse(jwt_copy, token, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_decrypt_verify_signature_nested(jwt_copy, NULL, 0, NULL, 0), RHN_OK);
  
  o_free(token);
  o_free(token_copy);
  r_jwt_free(jwt);
  r_jwt_free(jwt_copy);
}
END_TEST

START_TEST(test_rhonabwy_set_enc_cypher_key_iv)
{
  jwt_t * jwt;
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  char * token, ** token_split;
  
  ck_assert_int_eq(r_jwt_set_claim_str_value(jwt, "iss", JWT_CLAIM_ISS), RHN_OK);
  ck_assert_int_eq(r_jwt_set_enc_alg(jwt, R_JWA_ALG_RSA1_5), RHN_OK);
  ck_assert_int_eq(r_jwt_set_enc(jwt, R_JWA_ENC_A128CBC), RHN_OK);
  ck_assert_int_eq(r_jwt_set_enc_cypher_key(jwt, cypher_key, sizeof(cypher_key)), RHN_OK);
  ck_assert_int_eq(r_jwt_set_enc_iv(jwt, iv, sizeof(iv)), RHN_OK);
  ck_assert_int_eq(r_jwt_add_enc_keys_json_str(jwt, NULL, pubkey), RHN_OK);
  ck_assert_ptr_ne((token = r_jwt_serialize_encrypted(jwt, NULL, 0)), NULL);
  ck_assert_int_eq(split_string(token, ".", &token_split), 5);
  ck_assert_str_eq("AxY8DCtDaGlsbGljb3RoZQ", token_split[2]);
  ck_assert_str_eq("FgA-dGeGpV_KbHo21rm9i0cLuAKdqhEm6nXaPSrRdAw", token_split[3]);
  
  free_string_array(token_split);
  o_free(token);
  r_jwt_free(jwt);
}
END_TEST

#if GNUTLS_VERSION_NUMBER >= 0x030600 && defined(R_WITH_CURL)
static char * get_file_content(const char * file_path) {
  char * buffer = NULL;
  size_t length, res;
  FILE * f;

  f = fopen (file_path, "rb");
  if (f) {
    fseek (f, 0, SEEK_END);
    length = ftell (f);
    fseek (f, 0, SEEK_SET);
    buffer = o_malloc((length+1)*sizeof(char));
    if (buffer) {
      res = fread (buffer, 1, length, f);
      if (res != length) {
        fprintf(stderr, "fread warning, reading %zu while expecting %zu", res, length);
      }
      // Add null character at the end of buffer, just in case
      buffer[length] = '\0';
    }
    fclose (f);
  } else {
    fprintf(stderr, "error opening file %s\n", file_path);
  }
  
  return buffer;
}

int callback_x5u_ecdsa_crt (const struct _u_request * request, struct _u_response * response, void * user_data) {
  ulfius_set_string_body_response(response, 200, (const char *)advanced_cert_pem_3);
  return U_CALLBACK_CONTINUE;
}

int callback_jku_ecdsa_crt (const struct _u_request * request, struct _u_response * response, void * user_data) {
  ulfius_set_response_properties(response, U_OPT_STATUS, 200,
                                           U_OPT_HEADER_PARAMETER, "Content-Type", "application/json",
                                           U_OPT_STRING_BODY, advanced_jku_4,
                                           U_OPT_NONE);
  return U_CALLBACK_CONTINUE;
}

START_TEST(test_rhonabwy_advanced_parse)
{
  jwk_t * jwk_pub, * jwk_priv, * jwk_pubkey_1;
  jwt_t * jwt;
  struct _u_instance instance;
  char * http_key, * http_cert;
  
  ck_assert_ptr_ne(NULL, http_key = get_file_content(HTTPS_CERT_KEY));
  ck_assert_ptr_ne(NULL, http_cert = get_file_content(HTTPS_CERT_PEM));
  
  ck_assert_int_eq(ulfius_init_instance(&instance, 7468, NULL, NULL), U_OK);
  ck_assert_int_eq(ulfius_add_endpoint_by_val(&instance, "GET", "/x5u", NULL, 0, &callback_x5u_ecdsa_crt, NULL), U_OK);
  ck_assert_int_eq(ulfius_add_endpoint_by_val(&instance, "GET", "/jku", NULL, 0, &callback_jku_ecdsa_crt, NULL), U_OK);
  
  ck_assert_int_eq(ulfius_start_secure_framework(&instance, http_key, http_cert), U_OK);
  
  ck_assert_int_eq(r_jwk_init(&jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pub, jwk_pubkey_ecdsa_str), RHN_OK);
  
  ck_assert_int_eq(r_jwk_init(&jwk_priv), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_priv, jwk_privkey_ecdsa_str), RHN_OK);
  
  ck_assert_int_eq(r_jwk_init(&jwk_pubkey_1), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_pem_der(jwk_pubkey_1, R_X509_TYPE_CERTIFICATE, R_FORMAT_PEM, advanced_cert_pem_1, sizeof(advanced_cert_pem_1)), RHN_OK);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_JWK, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_JKU, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_X5C, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_X5U, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_X5U|R_PARSE_HEADER_X5C, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 2);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_ALL, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  r_jwt_free(jwt);
  
  // Attack vectors tested
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_1, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK); // This is dangerous
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_1, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_1, R_PARSE_HEADER_X5C|R_PARSE_HEADER_X5U|R_PARSE_HEADER_JKU, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 3);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_1, R_PARSE_HEADER_JWK, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This isn't safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);

  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_2, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK); // This is dangerous
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_2, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_2, R_PARSE_HEADER_JWK|R_PARSE_HEADER_X5U|R_PARSE_HEADER_JKU, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 3);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_2, R_PARSE_HEADER_X5C, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This isn't safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_3, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK); // This is dangerous
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_3, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_3, R_PARSE_HEADER_JWK|R_PARSE_HEADER_X5C|R_PARSE_HEADER_JKU, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 3);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_3, R_PARSE_HEADER_X5U, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This isn't safe
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_4, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK); // This is dangerous
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_4, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_4, R_PARSE_HEADER_JWK|R_PARSE_HEADER_X5C|R_PARSE_HEADER_X5U, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 3);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_TOKEN_SIGNED_WITH_KEY_4, R_PARSE_HEADER_JKU, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This isn't safe
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);

#if GNUTLS_VERSION_NUMBER >= 0x030600 && NETTLE_VERSION_NUMBER >= 0x030600
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_parse(jwt, ADVANCED_NESTED_TOKEN_SE_SIGNED_WITH_KEY_2, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK);
  ck_assert_int_eq(r_jwt_decrypt_nested(jwt, jwk_priv, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pubkey_1), RHN_OK); // This is dangerous
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, jwk_pubkey_1, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_NESTED_TOKEN_SE_SIGNED_WITH_KEY_2, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This is safe
  ck_assert_int_eq(r_jwt_decrypt_nested(jwt, jwk_priv, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pubkey_1), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, jwk_pubkey_1, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
  
  ck_assert_int_eq(r_jwt_init(&jwt), RHN_OK);
  ck_assert_int_eq(r_jwt_advanced_parse(jwt, ADVANCED_NESTED_TOKEN_SE_SIGNED_WITH_KEY_2, R_PARSE_HEADER_JWK, R_FLAG_IGNORE_SERVER_CERTIFICATE), RHN_OK); // This isn't safe
  ck_assert_int_eq(r_jwt_decrypt_nested(jwt, jwk_priv, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 1);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwks_append_jwk(jwt->jwks_pubkey_sign, jwk_pubkey_1), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, NULL, 0), RHN_OK);
  ck_assert_int_eq(r_jwt_verify_signature_nested(jwt, jwk_pubkey_1, 0), RHN_ERROR_INVALID);
  r_jwt_free(jwt);
#endif
  
  r_jwk_free(jwk_pub);
  r_jwk_free(jwk_priv);
  r_jwk_free(jwk_pubkey_1);
  o_free(http_key);
  o_free(http_cert);
  ulfius_stop_framework(&instance);
  ulfius_clean_instance(&instance);
}
END_TEST

START_TEST(test_rhonabwy_quick_parse)
{
  jwk_t * jwk_pub;
  jwt_t * jwt;
  struct _u_instance instance;
  char * http_key, * http_cert;
  
  ck_assert_ptr_ne(NULL, http_key = get_file_content(HTTPS_CERT_KEY));
  ck_assert_ptr_ne(NULL, http_cert = get_file_content(HTTPS_CERT_PEM));
  
  ck_assert_int_eq(ulfius_init_instance(&instance, 7468, NULL, NULL), U_OK);
  ck_assert_int_eq(ulfius_add_endpoint_by_val(&instance, "GET", "/x5u", NULL, 0, &callback_x5u_ecdsa_crt, NULL), U_OK);
  ck_assert_int_eq(ulfius_add_endpoint_by_val(&instance, "GET", "/jku", NULL, 0, &callback_jku_ecdsa_crt, NULL), U_OK);
  
  ck_assert_int_eq(ulfius_start_secure_framework(&instance, http_key, http_cert), U_OK);
  
  ck_assert_int_eq(r_jwk_init(&jwk_pub), RHN_OK);
  ck_assert_int_eq(r_jwk_import_from_json_str(jwk_pub, jwk_pubkey_ecdsa_str), RHN_OK);

  ck_assert_ptr_ne(NULL, jwt = r_jwt_quick_parse(TOKEN, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  r_jwt_free(jwt);

  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_INVALID_DOTS, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_INVALID_HEADER, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_INVALID_HEADER_B64, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_INVALID_CLAIMS, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_INVALID_CLAIMS_B64, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_ptr_eq(NULL, jwt = r_jwt_quick_parse(TOKEN_UNSECURE, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  
  ck_assert_ptr_ne(NULL, jwt = r_jwt_quick_parse(TOKEN_UNSECURE, R_PARSE_UNSIGNED, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  r_jwt_free(jwt);

  ck_assert_ptr_ne(NULL, jwt = r_jwt_quick_parse(ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_NONE, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 0);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  r_jwt_free(jwt);

  ck_assert_ptr_ne(NULL, jwt = r_jwt_quick_parse(ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_ALL, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 4);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  r_jwt_free(jwt);

  ck_assert_ptr_ne(NULL, jwt = r_jwt_quick_parse(ADVANCED_TOKEN_SIGNED_WITH_ROOT_KEY, R_PARSE_HEADER_JWK|R_PARSE_HEADER_X5C, R_FLAG_IGNORE_SERVER_CERTIFICATE));
  ck_assert_int_eq(r_jwks_size(jwt->jwks_pubkey_sign), 2);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, NULL, 0), RHN_ERROR_INVALID);
  ck_assert_int_eq(r_jwt_verify_signature(jwt, jwk_pub, 0), RHN_OK);
  r_jwt_free(jwt);

  r_jwk_free(jwk_pub);
  o_free(http_key);
  o_free(http_cert);
  ulfius_stop_framework(&instance);
  ulfius_clean_instance(&instance);
}
END_TEST

#endif

static Suite *rhonabwy_suite(void)
{
  Suite *s;
  TCase *tc_core;

  s = suite_create("Rhonabwy JWT core function tests");
  tc_core = tcase_create("test_rhonabwy_core");
  tcase_add_test(tc_core, test_rhonabwy_init);
  tcase_add_test(tc_core, test_rhonabwy_sign_alg);
  tcase_add_test(tc_core, test_rhonabwy_enc_alg);
  tcase_add_test(tc_core, test_rhonabwy_set_header);
  tcase_add_test(tc_core, test_rhonabwy_get_header);
  tcase_add_test(tc_core, test_rhonabwy_set_full_header_error);
  tcase_add_test(tc_core, test_rhonabwy_set_full_header);
  tcase_add_test(tc_core, test_rhonabwy_get_full_header);
  tcase_add_test(tc_core, test_rhonabwy_set_claim);
  tcase_add_test(tc_core, test_rhonabwy_get_claim);
  tcase_add_test(tc_core, test_rhonabwy_set_full_claims);
  tcase_add_test(tc_core, test_rhonabwy_set_full_claims_str);
  tcase_add_test(tc_core, test_rhonabwy_get_full_claims);
  tcase_add_test(tc_core, test_rhonabwy_append_claims);
  tcase_add_test(tc_core, test_rhonabwy_set_sign_keys);
  tcase_add_test(tc_core, test_rhonabwy_set_sign_jwks);
  tcase_add_test(tc_core, test_rhonabwy_add_sign_keys_by_content);
  tcase_add_test(tc_core, test_rhonabwy_set_enc_keys);
  tcase_add_test(tc_core, test_rhonabwy_set_enc_jwks);
  tcase_add_test(tc_core, test_rhonabwy_add_enc_keys_by_content);
  tcase_add_test(tc_core, test_rhonabwy_set_claims);
  tcase_add_test(tc_core, test_rhonabwy_validate_claims);
  tcase_add_test(tc_core, test_rhonabwy_set_properties_error);
  tcase_add_test(tc_core, test_rhonabwy_set_properties);
  tcase_add_test(tc_core, test_rhonabwy_copy);
  tcase_add_test(tc_core, test_rhonabwy_set_enc_cypher_key_iv);
#if GNUTLS_VERSION_NUMBER >= 0x030600 && defined(R_WITH_CURL)
  tcase_add_test(tc_core, test_rhonabwy_advanced_parse);
  tcase_add_test(tc_core, test_rhonabwy_quick_parse);
#endif
  tcase_set_timeout(tc_core, 30);
  suite_add_tcase(s, tc_core);

  return s;
}

int main(int argc, char *argv[])
{
  int number_failed;
  Suite *s;
  SRunner *sr;
  //y_init_logs("Rhonabwy", Y_LOG_MODE_CONSOLE, Y_LOG_LEVEL_DEBUG, NULL, "Starting Rhonabwy JWT core tests");
  r_global_init();
  s = rhonabwy_suite();
  sr = srunner_create(s);

  srunner_run_all(sr, CK_VERBOSE);
  number_failed = srunner_ntests_failed(sr);
  srunner_free(sr);
  
  r_global_close();
  //y_close_logs();
  return (number_failed == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
