/**
 * Copyright (c) 2001-2018 Mathew A. Nelson and Robocode contributors
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://robocode.sourceforge.net/license/epl-v10.html
 */
package net.sf.robocode.test.robotscs;


import net.sf.robocode.test.helpers.RobocodeTestBed;
import org.junit.Assert;
import robocode.control.events.TurnEndedEvent;


/**
 * @author Flemming N. Larsen (original)
 */
public class TestReflectionAttack extends RobocodeTestBed {

	private boolean securityException;
	private boolean fieldAccessException;
	
	@Override
	public String getRobotNames() {
		return "tested.robotscs.ReflectionAttack,SampleCs.Target";
	}

	@Override
	public void onTurnEnded(TurnEndedEvent event) {
		super.onTurnEnded(event);

		final String out = event.getTurnSnapshot().getRobots()[0].getOutputStreamSnapshot();

		if (out.contains("System.Security.SecurityException")) {
			securityException = true;	
		} else if (out.contains("System.FieldAccessException")) {
			fieldAccessException = true;
		}
	}

	@Override
	protected void runTeardown() {
		Assert.assertTrue("Reflection is not allowed", securityException || fieldAccessException);
	}

	@Override
	protected int getExpectedErrors() {
		return securityException ? 1 : 0; // Security error must be reported as an error
	}
}
