/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file SystemTools.h
    \author Romain BONDUE
    \date 20/12/2005 */
#ifndef __SYSTEMTOOLS_H__
#define __SYSTEMTOOLS_H__

#include <string>

extern"C"{
#include <sys/types.h>
}

#include "Exceptions.h"



namespace nsSystem
{
    void Ioctl (int, void*, const std::string&) throw (nsErrors::CSystemExc);


    /** \return True in the child process. */
    bool Fork () throw (nsErrors::CSystemExc);


    /** \warning The array is not checked, it must respect execv() conventions.
     */
    void Exec (const char* []) throw (nsErrors::CSystemExc);


    class CLocalSocket
    {
      public :
        CLocalSocket () throw (nsErrors::CSystemExc);
        ~CLocalSocket () throw (nsErrors::CSystemExc);

        void Close () throw (nsErrors::CSystemExc);
        void Connect (const std::string&) throw (nsErrors::CSystemExc);
        void Bind (const std::string&) throw (nsErrors::CSystemExc);
        void Listen (unsigned = 0) throw (nsErrors::CSystemExc);
            // The socket returned must be deleted by the callder.
        CLocalSocket* Accept () throw (nsErrors::CSystemExc, std::bad_alloc);
        void Write (const char*, size_t) throw (nsErrors::CSystemExc);
        size_t Read (char*, size_t) throw (nsErrors::CSystemExc);
        void SendCredential () throw (nsErrors::CSystemExc);
        bool CheckCredentialUID (::uid_t) throw (nsErrors::CSystemExc);
        bool CheckCredentialPID (::pid_t) throw (nsErrors::CSystemExc);


      private :
        static const int InvalidSocket = -1;

        CLocalSocket (int) throw();

        int m_Sd;

    }; // CLocalSocket

} // namespace nsSystem

#include "private/SystemTools.hxx"

#endif // __SYSTEMTOOLS_H__
