/*
 * Decompiled with CFR 0.152.
 */
package glguerin.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CaptureOutputStream
extends FilterOutputStream {
    private byte[] captured;
    private int put;
    private boolean around;

    public CaptureOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        if (n < 2) {
            throw new IllegalArgumentException("N must be >= 2: " + n);
        }
        this.captured = new byte[n];
        this.put = 0;
        this.around = false;
    }

    public byte[] getCaptured() {
        byte[] byArray;
        if (this.around) {
            byArray = new byte[this.captured.length];
            int n = this.captured.length - this.put;
            System.arraycopy(this.captured, this.put, byArray, 0, n);
            System.arraycopy(this.captured, 0, byArray, n, this.put);
        } else {
            byArray = new byte[this.put];
            System.arraycopy(this.captured, 0, byArray, 0, this.put);
        }
        return byArray;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        this.captured[this.put++] = (byte)n;
        if (this.put >= this.captured.length) {
            this.put = 0;
            this.around = true;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (n2 >= this.captured.length) {
            n = n + n2 - this.captured.length;
            System.arraycopy(byArray, n, this.captured, 0, this.captured.length);
            this.put = 0;
            this.around = true;
            return;
        }
        if (this.put + n2 >= this.captured.length) {
            int n3 = this.captured.length - this.put;
            System.arraycopy(byArray, n, this.captured, this.put, n3);
            this.put = 0;
            this.around = true;
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.captured, this.put, n2);
            this.put += n2;
        }
    }
}

