/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This is a utility for extracting needed resource data from different language
 * version of the Mortevielle executable files into a new file mort.dat - this
 * is required for the ScummVM Mortevielle module to work properly
 */

#ifndef GAMEDATA_H
#define GAMEDATA_H

const char *gameDataEn[] =  {
	"Calm within the storm$",
	"Discussed in colours$",
	"Your mauve!$",
	"Be kind enough to leave the room...$",
	"If you're NOT overdrawn...$",
	"If you're feeling blue...$",
	"Read what's on the walls?$",
	"Water sports$",
	"Room for envy?$",
	"A glance at the forbidden$",
	"Smell of a woodfire and tobacco$",
	"Tobacco and old books$",
	"Onions, cinnamon and spirits$",
	"A place seldom visited$",
	"Humidity and decay$",
	"Sorry, no ""door to door""$",
	"Rotting corpse: deady cryptomania$",
	"And what's more, there are disused traps$",
	"It's already open$",
	"Danger: avalanches$",
	"Proper Charlie's place?$",
	"An imposing building$",
	"The other side of the mystery$",
	"Strange horoscope$",
	"Look out... but she wishes well?$",
	"An oak door$",
	"A photograph$",
	"The coat of arms$",
	"$",
	"Max, the servant, welcomes you and shows you to your room$",
	// FIXME: Spelling incorrect. apropriate should be appropriate. Fixing changes game data and thus may cause issues
	"Mortville     6/2/51@         My dear Jerome@Regarding my telegram, I must tell  you  the reason for my wor-@ries. A year ago, Murielle, my lady companion, disappeared. The de@part may have had something to do@with the financial success of themanor, or... A silence hard to un@derstand for my son Guy.  Not  ha@ving been able to see the  light of day over this affair, I count @on you to sort things out. If my state of health doesn't improve, @take the decisions that you feel @are apropriate.@             Kind regards, Julia DEFRANCK$",
	"Later, Guy will inform you of Leo's suicide after a@heavy bet at the races$",
	"F3: AGAIN             F8: STOP$",
	"The master of the premises$",
	"The future heir$",
	"JULIA's son$",
	"A pretty picture$",
	"Superman!$",
	"Ida's husband$",
	"Interesting remarks?$",
	"Service included!$",
	"Nothing underneath$",
	"You could hear a pin drop$",
	"Half an hour passes: nothing! Wait any longer?$",
	"Admire! Contemplate!$",
	"No! Nothing!$",
	"Impossible$",
	"That stains!$",
	"A treatise on the history of the area$",
	"A few coins...$",
	"First commandment...$",
	"Pleasing to the nostrils!$",
	"Spades, Hearts...$",
	"Just a spoonful of sugar...$",
	"A romantic novel$",
	"Worth more than a penny, (whistle)$",
	"Just needs a little patience$",
	"Watch the sharp bends$",
	"Deep and dark$",
	"Normal sensations$",
	"Sniff!$",
	"Not discreet! Be content to watch!$",
	"Bless you! Dusty!$",
	"The canvas is signed, the wallpaper is not!$",
	"Nothing, Unlucky!$",
	"Be more discreet!$",
	"The shutters are closed$",
	"Snow! And more snow!$",
	"Brilliant! The work of a master!$",
	"No doubt at all! A genuine fake!$",
	"Hmm! A cheap reproduction!$",
	"A rare and valuable piece$",
	"Nothing special$",
	"Linen, personal belongings...$",
	"Not just anywhere!$",
	"It's not time!$",
	"One doesn't speak with ones mouth full! So once the meal is over...$",
	"Someone comes in, messes about then goes out again$",
	"Someone's approaching your hiding-place$",
	"Someone surprises you!$",
	"Impossible! You're too loaded!$",
	"Try again!$",
	"Still puzzled!?$",
	"You leave Mortville.In Paris a message awaits you...$",
	"You hurt yourself$",
	"Nothing more here$",
	"The sound seems normal$",
	"It doesn't move$",
	"You are answered$",
	"Not the right moment!$",
	"The same matter, from another angle!$",
	"The reflection is tarnished, but the frame is gold!$",
	"Bric-a-brac$",
	"Facing failure!$",
	"Smells like something you'd rather not see!$",
	"Cleaning products$",
	"Got an itch?$",
	"It's stuck, frozen. Brrr!$",
	"All the locks are jammed!$",
	"Papers$",
	"No! Father christmas hasn't got himself stuck!$",
	"It leads onto a corridor$",
	"China, silverware...$",
	"No! It's not Julia's remains!$",
	"An old engraving$",
	"You find a deep diamond-shaped opening$",
	"The wall slides open! A passage! Do you follow it?$",
	"The passageway closes$",
	"A secret drawer: a notebook! Do you read it?$",
	"The drawer shuts$",
	"Nothing! Flesh and blood stuck to the stone$",
	"Certain details lead you to believe death was not immediate!$",
	"A rotten affair!$",
	"Did she cling to dear life with just one finger?$",
	"Has the treasure packed its trunk?$",
	"A slot the size of a coin$",
	"Part of the stone wall pivots.A crypt! Do you enter?$",
	"The ring turns, the wall closes$",
	"A stone column behind the altar$",
	"There is a noise!$",
	"Occupied!$",
	"Take another chance?$",
	"Too deep!$",
	"The cellar wall pivots$",
	"Nothing$",
	"The one and only!$",
	"The object slides to the bottom$",
	"You have nothing in hand$",
	"It is not open$",
	"There is already something$",
	"The door is locked$",
	"No reply$",
	"A solid wooden ball$",
	"There's no more space$",
	"A wooden ball pierced through the side$",
	"? ?$",
	"Your move$",
	"OK !$",
	"Suddenly  Max  arrives with your suitcase:  \"Thank  you  for your visit!\".@Mister discreet \"private eye\" (in need of a private optician!). Thoroughly demoralised, you leave the manor. You are useless!$",
	"Leo interrupts:  \"The storm has  died down,I am going into town in 1 hour. Get ready\".@You have lost time...but not your life$",
	"Congestion, the deadly flu... You are stuck here! Your  whole  case sinks slowly beneath the water$",
	"The water is rising fast, freezing your last illusions. Before you have time to react... you are dead$",
	"As soon as you reach the bottom  of the well, a hand cuts the rope Farewell sweet life!$",
	"The storm covers your footprints.A wall of  silence falls heavily on your shoulders. Slowly you  succumb to frosbite...$",
	"You're not completely alone!  A  cold blade plunges into your back. In future, be more careful!$",
	"You don't know what implication Leo may have had in Murielle's death. Was she dead outright? In any case, the family problems that you have uncovered in the course of your enquiries would explain Leo's behaviour. You're not sure that's the reason Julia had asked for your help, but that's reason enough for you! Out of respect for her, after taking certain precautions you have a revealing talk with Leo.$",
	"$",
	"You don't have the keys to  the  manor. Your  cries  rest  unheard You're   going   to   catch...             your death!$",
	"With  a  circular  movement, the sword slices across you. Guts and intestines spill out all over. A sorry state of affairs!$",
	"Home, Sweet home !$",
	"The mystery behind a closed door$",
	"Bewitching charm of these old rooms$",
	"An empty stomach$",
	"Closer to heaven? Not so sure$",
	"Afraid of the dark?$",
	"Old rugs and a glint of gold$",
	"Anguish!$",
	"Safe? Perhaps not!$",
	"A little ill at ease, eh!?$",
	"Always further$",
	"Your way of the cross!$",
	"On the trail of...$",
	"Watch what's hiding$",
	"The road down to hell$",
	"Feeling well? You look a little pale$",
	"What lurks behind...?$",
	"Close-up on:$",
	"You notice, amongst other things$",
	"And...$",
	"That's all!$",
	"A bit of reading$",
	"The adventure awaits, you set off!$",
	"Don't mess up YOUR next ADVENTURE!$",
	"I don't understand$",
	"There is an easier way$",
	"No, not just now$",
	"Too late$",
	"$",
	"Like a deep stony stare, a solitary eye that points towards the@stars; the artery that links hea-ven and hell. You must fathom@these depths keeping hold of that@which is, and will become. Monday, Tuesday, Wednesday, Sunday, from@the first Monday to the first Sunday,plunging from one day to the next your@\"IS\" or \"WILL BECOME\". Carrying your burden with love and light,@the smallest oversight will seal your fate.$",
	"10/1/51: We think we've solved the mystery of the manuscript and@located the crypt. Is it the idea@of success in what seems like a dream that disturbs me so? I feel@I have committed myself rather too much, as far as Leo is @concerned... No! I mustgo on. @I should have put Guy in the picture but for a week now, I've had@no news of him$",
	"Take your prayers as you would to the holy place.  From  the  pillar@of wisdom, bring the sun to  his@knees. Thus will it show you the place to  offer  alms of another@kind and like young Arthur, open the way of darkness.White is your@colour, golden your hearth.  So@advance with caution Orpheus and light  your  way  unto  the  sad@virgin. Offer her the circle  of the man with three faces. That he@may regain the  world  and  turn with it to its original@inglory!$",
	"The mountains are the fangs in a monstrous mouth opening on the@finity of a celestial orgy, grin-ding the stars as we  grind  our@teeth into dust.  You  will drop your chord of stone at your feet.@The  laugh  of  silence  at  the@highest pitch, and in your right hand, the measure of genius. Thus@will you pass between  the  two  crescents beyond the abyss of the@wall of silence. The key to the  melody is within your grasp.  It@suffices to find the note  that  clashes.$",
	"  9/12 INTER. 518  3/13 EXPENS.  23@  9/12 SALES 1203  7/12 CHEQUE 1598@      TOTAL 1721       TOTAL  1721$",
	"   5/1/51@@              Luc, my love@ Guy knows about us. After an argument I told  him  everything! I@think only of you. Max keeps pes-tering me, but it's finished with @him. He should stick to his pots and pans! When can you and I be  alone together? For you I  would@get a divorce.@I love you.@                             Eva$",
	"             Mortville, 10/2/51@@              Pat@ I recall you owe me  50000 frs that I lent you for your business@I need that money, can you repay me quickly?@              Guy$",
	"             Mortville, 15/2/51@           Dear Sir@ I am writing to you on the sub-ject of our business deal. I have@decided to go all the way in the certainty that  my  partner, Pat@DEFRANCK, has been forging the accounts. @In spite of$",
	" A pipe$",
	" A pen$",
	" A lighter$",
	" A retort$",
	" A shaving brush$",
	" A tin of paint$",
	" A flute$",
	" An expensive ring$",
	" A reel of thread$",
	" An old book$",
	" A wallet$",
	" A dagger$",
	" A pistol$",
	" A bible$",
	" A candle$",
	" A jewellery box$",
	" An iron$",
	" A photo$",
	" A pocket watch$",
	" A rope$",
	" Keys$",
	" A pearl necklace$",
	" A bottle of perfume$",
	" Binoculars$",
	" Glasses$",
	" A leather purse$",
	" A tennis ball$",
	" Ammunition$",
	" A cut-throat razor$",
	" A hairbrush$",
	" A clothes brush$",
	" A pack of cards$",
	" A shoe horn$",
	" A screwdriver$",
	" A hammer$",
	" Keys$",
	" Keys$",
	" An ashtray$",
	" A paintbrush$",
	" A rope$",
	" A wooden object$",
	" Sleeping pills$",
	" A gold ring$",
	" A jewellery box$",
	" An alarm clock$",
	" A coat of armour$",
	" A candlestick$",
	" A pair of gloves$",
	" A engraved goblet$",
	" A parchment$",
	" A dagger$",
	" A dossier$",
	" A parchment$",
	" A parchment$",
	" A dossier$",
	" A dossier$",
	" A letter$",
	" A novel$",
	" A wooden rod$",
	" An envelope$",
	" A letter$",
	" An envelope$",
	"Julia$",
	"Julia's death$",
	"Julia's relationships$",
	"A message from Julia$",
	"Julia's inheritance$",
	"Julia's final actions$",
	"Julia's gifts$",
	"Julia's bedroom$",
	"The photo at Julia's home$",
	"Julia and yourself...$",
	"L\202o's occupations$",
	"Pat's occupations$",
	"Guy's occupations$",
	"Bob's occupations$",
	"Eva's occupations$",
	"Luc's occupations$",
	"Ida's occupations$",
	"Max's occupations$",
	"Your occupations$",
	"L\202o's relationships$",
	"Pat's relationships$",
	"Guy's relationships$",
	"Bob's relationships$",
	"Eva's relationships$",
	"Luc's relationships$",
	"Ida's relationships$",
	"Max's relationships$",
	"Your relationships$",
	"Murielle$",
	"Murielle's relationships$",
	"Murielle and yourself...$",
	"Murielle's disappearance$",
	"The wall of silence$",
	"The manuscripts$",
	"The coat of arms$",
	"Engravings in the cellar$",
	"The well$",
	"The secret passages$",
	"The chapel$",
	"The paintings$",
	"The photo of the attic$",
	"The body in the crypt$",
	"$",
	"$",
	"END OF THE CONVERSATION$",
	"That was the name old people gave to the mountain range that lies at the foot of the manor!$",
	"These are the mountains one can see in front of the manor$",
	"I don't know!$",
	"She died from pulmonary embolism$",
	"Mother died suddenly. And yet her health had seemed to improve\202$",
	"Miss DEFRANCK died from a cold$",
	"She died from pulmonary embolism$",
	"Excuse me but I prefer to say nothing for now$",
	"Only the good die young$",
	"I loved my mother . My only regret is that she died in the DEFRANCK's manor$",
	"That region has a lot of history and there is plenty to keep me busy. And also I love horses..$",
	"He is a history enthusiast and a gambler. By the way he won a large sum one year ago$",
	"He is already very busy with the management and maintenance of the mansion...$",
	"I am the CEO of a small perfume company. But when I am here, I rest$",
	"He is a dynamic man who has succeeded in perfurmes$",
	"Him! He is an upstart rogue! Perfumes must have killed his common sense. Moreover, when he's here he spends his evenings in his room$",
	"I was very concerned about my mother's health, and now I don't feel like doing anything at all$",
	"He would have done better to look after me a bit more and a bit less after his mother$",
	"It is not my business...$",
	"He does not have much luck at the moment although his business is satisfactory$",
	"I work with Pat but it's not going too well at the moment$",
	"Oh really?! He has occupations? He should take them seriously then$",
	"Him and Pat are patners. I think it's going pretty well$",
	"I take care of myself and that's already lots. How about you?$",
	"Oh for that I trust her! She knows how to keep herself busy$",
	"What! You have not yet discovered her main occupation..?$",
	"She is working in the decoration business, and tastefully with that. She is always very well dressed$",
	"If you like jewels, I have some good deals to propose for a short while$",
	"The jewels...$",
	"I don't know, but I'd like him to give me a bit more slack!$",
	"When one is a housewife, one always find something to do...$",
	"She could stay there doing nothing, but no! She sews, she reads...$",
	"She has probably not very fulfilling occupations...$",
	"A woman like there is no more: She is interested in everything!$",
	"With the cooking and the cleaning I do not have much time for you$",
	"I do not know how he manages to do everything. That's wonderful!",
	"He would do more if he showed less interest in gossip and alcohol$",
	// FIXME: Spelling incorrect. independant should be independent. Fixing changes game data and thus may cause issues
	"I am very independant. As long as nobody interferes in my business: No problem$",
	"He is selfish. I wonder if he likes something other than his horses and grimoires$",
	"I think he gets along well with everyone, except, perhaps, with Guy$",
	"He has a temper. You have to learn how to deal with him...$",
	"Business is business. As for the family, I leave it as it is...$",
	"Relations? Friendly relations? Financial relations, without a doubt$",
	"Oh, I have no issue with this person$",
	"He is a resourceful businessman. He sometimes tries to swim upstream but... he will always find a way to make it work$",
	"They are all boring .. No! Not even that .. Even if .. some of them ..$",
	"Contrary to his mother, he is a very shy person ! So when you say relations...$",
	"He must be trying very hard to remain nice despite all his troubles$",
	"His romantic relationship: it's over. His relationship with me: hasn't really started. As for the other ones: I don't follow the \"other ones\"$",
	"I like everyone, as long as they are not trying to screw me over$",
	"It is not enough to have a bit of money and to know how to talk for everyone to like you$",
	"Not much to say about him... He is a nice and generous man. And what's more, he can be quite funny$",
	"Nowadays I get along rather well with everyone. But, here, I am not going to say more about this$",
	"Nice feathers, but a bird's brain... Ask her husband$",
	"Is it for an appointment?$",
	"She is very lively! She does not burden herself with stupids prejudices$",
	"In my line of work, one mostly encounters beautiful women and gangsters$",
	// FIXME: Spelling incorrect. jewelery should be jewellery. Fixing changes game data and thus may cause issues
	"The only sure thing he has going for him, it's his jewelery... And his wife, but he doesn't realize that$",
	"It's an interesting character. Who is not always very easy to follow, but worth knowing$",
	"I hate no one, but I like things and people when they stay where they should be$",
	"This stays between us. But you see: when I speak with her, I soon start to feel a bit uncomfortable!$",
	"You'd have to try hard to not get along with her$",
	"You know, in my line of work you hear everything but don't remember anything, and service is well done$",
	"He's a submissive hypocrite! Personally I don't trust him$",
	"I don't know what he thinks deep down inside, but he's always polite and impeccable$",
	"Someone who lived in the manor, a year ago... maybe more$",
	"She was more than a friend to my mother. In these moments, I would have loved to have her by my side$",
	"Murielle has been Julia's lady-in-waiting$",
	"She, too, was doing some research....$",
	"She was a very educated person. Her abrupt leaving, a year ago, surprised me and caused me great sorrow$",
	"Her and Leo shared a common passion for history and the local area$",
	"I think everyone liked her$",
	"She got along with everyone. She loved her son dearly. As for the relations between mother-in-law and daughter-in-law...$",
	"Apart from Leo, she got along very well with Max...$",
	"Even if your relations were unfrequent, Jerome, there was still a place for you in her heart...$",
	"Apart from her family, not a lot of people$",
	"Oh right! I think she deeply regretted this friend's leaving... err! Marielle... or Mireille...$",
	"No, nothing!$",
	"No... Not that I know of$",
	"I met Julia when buying the manor. It was the only thing she owned. But all my wealth was hers...$",
	"Apart from a few personal belongings, I think she didn't own anything anymore$",
	"I think all her fortune came from Leo. So, pfft!$",
	"Apart from the letter for you I posted, nothing very important!$",
	"I was very happy she gave me her bound bible as a present$",
	"It happened fast and she didn't have time to make any particular will$",
	// FIXME: Spelling incorrect. suprised should be surprised. Fixing changes game data and thus may cause issues
	"Her last gift suprised me$",
	"Which gift?$",
	"A chandelier...$",
	"Yes, I got a present. My wife even got a bible$",
	"Well yes! Like everyone, I believe$",
	"A dagger$",
	"I have never been looking around in the attic!$",
	"You can either see through walls or pick a door$",
	"The portrait of a young girl: it's Murielle...$",
	"You know, I didn't know her that well$",
	"She was very charming, but above all she was Julia's lady-in-waiting$",
	"She was the only truly interesting woman I've met$",
	"She had a great knowledge in history, and you learned a great deal when you asked her about it$",
	"I've always wondered why some people fancied her!$",
	"If the room is closed, ask Leo$",
	"I closed her door after her death and I'd like it to remain this way for a while$",
	"You know how it is: family relations$",
	"All those years, I've never regretted serving her$",
	"I loved her as much as she loved me, I think$",
	"What made you think you could enter my wife's room?!!$",
	"It must be the picture of Murielle with Julia's godson$",
	"I don't remember$",
	"This is Murielle. I took that picture, and actually they developed it backwards$",
	"You sure are curious!... It's not worth anything$",
	"Grimoires, parchment and manuscripts: it is Leo's realm$",
	"Too bad the motto doesn't appear here...$",
	"This is beautiful... And very old...$",
	"Hey! That's a place I've never visited$",
	"According to Leo, it seems that the Moons are more recent$",
	"Even under this weather, you managed to find a sun...$",
	"Profound and disturbing: Progress is good$",
	"For me, it remains the biggest of all mysteries$",
	"The last days she was talking about a trip. And then...$",
	"A little over a year ago, one night, she decided to leave...$",
	"In any case, she wasn't meant to live here$",
	"What?! Whose body? Which crypt?$",
	"If there are any, I have never found them...$",
	"Of course! And ghosts too...$",
	"It's the oldest in the area: it is from the 11th century$",
	"It was slightly renovated after the French Revolution$",
	"Julia loved paintings$",
	"They are different in styles, but not all of them are worth a lot$",
	"What are you doing h-$",
	"I'm sure you are looking for something in here$",
	"I'm listening$",
	"What do you want?$",
	"Yes?$",
	"I'm all yours...$",
	"What's the matter?$",
	"Go ahead$",
	"What is it about?$",
	"Max: at your service, sir$",
	"In any case you have no business being in here! Get out!!$",
	"You are too curious!$",
	"Jerome! It's been a while... I'm very sad to announce you that Julia died. Her family is here: Guy, her son; Eva, her daughter-in-law; Leo, her husband, of course; her son-in-law Pat; cousins, too: Bob, Ida, Luc. The storm is getting stronger, you must stay here. Meals are served at 12am and 7pm, and there is a mass at the chapel every day at 10am$",
	"When I saw you I knew you would uncover the truth... I knew why you were here: I had found the draft of Julia's letter. But I love to play, so... She hadn't wanted your task to be too easy, to protect me, probably, but she couldn't die knowing this mystery would remain unsolved. Did you find out that the wall of silence is the name the builders gave, during the construction of the manor, to the wall on which the coat of arms hangs?... And those gifts Julia left before dying were as many false leads, and their true purpose was to highlight how important the parchments were... That's right, more than a year ago I was working with Murielle on the decryption of those manuscripts I had just found. My wife made the connection between our work and Murielle's disappearance, but she never had any proof. Except that ring she found one day while going through my belongings. One night, we went exploring the secret passage we had found. Murielle died by accident in the room of the Virgin. I quickly took the ring from her, found the treasure and ran away. I didn't think she was still alive, and I didn't say a word because I needed the money. I told everyone the money was coming from a winning bet at the horseraces... Leave now, since you're not a policeman. Leave me alone!$",
	"February 1951... Occupation: private eye. The cold was freezing Paris off, and my cases as well, when...$",
	"A letter, a call, memories from a childhood not that long ago. Echoes of the many games we played in the disused rooms of Mortville Manor... And Julia, now an old woman.$",
	" to the office$",
	" to the kitchen$",
	" to the cellar$",
	" to the landing$",
	" outside$",
	" to the dining room$",
	" inside the manor$",
	" front of the manor$",
	" to the chapel$",
	" to the well$",
	" north$",
	" behind the manor$",
	" south$",
	" east$",
	" west$",
	" towards the manor$",
	" further$",
	" in the water$",
	" out of the well$",
	" in the well$",
	" choice on screen$",
	"In the MYSTERY series...$",
	"MORTVILLE MANOR$",
	"$",
	"From an original idea of...$",
	"Bernard GRELAUD and Bruno GOURIER$",
	"$",
	"Directed by: KYILKHOR CREATION and LANGLOIS$",
	"$",
	"With the cooperation of...$",
	"B\202atrice et Jean_Luc LANGLOIS$",
	"for the music and the voices,$",
	"Bernard GRELAUD for the graphic conception,$",
	"MARIA-DOLORES for the graphic direction,$",
	"Bruno GOURIER for the technical direction,$",
	"Mick ANDON for the translation. $",
	"$",
	"Publisher: KYILKHOR and B&JL LANGLOIS $",
	"COPYRIGHT 1987: KYILKHOR and B&JL LANGLOIS$",
	"$",
	"YOUR MOVE$",
	" attach$",
	" close$",
	" eat$",
	" enter$",
	" force$",
	" knock$",
	" leave$",
	" lift$",
	" listen$",
	" look$",
	" open$",
	" place$",
	" read$",
	" scratch$",
	" search$",
	" sleep$",
	" smell$",
	" sound$",
	" take$",
	" turn$",
	" wait$",
	" hide yourself$",
	" look$",
	" put$",
	" read$",
	" search$",
	" Leo$",
	" Pat$",
	" Guy$",
	" Eva$",
	" Bob$",
	" Luc$",
	" Ida$",
	" Max$",
	"JULIA...$",
	"- Did she commit suicide?$",
	"- Was she murdered?$",
	"- Did she die by accident?$",
	"- Did she die of natural causes?$",
	"Where did the money used for the@restoration of the manor come from?$",
	"- Blackmail$",
	"- Honest work$",
	"- Inheritance$",
	"- Races$",
	"- Rents$",
	"- Hold-up$",
	"- Other$",
	"What is Leo's hobby?$",
	"- Historical research$",
	"- Politics$",
	"- Painting$",
	"- Drugs$",
	"- Occult sciences$",
	"- Leader of a sect$",
	"Julia left several clues that are@represented in one place. Which one?$",
	"- Chapel$",
	"- Outside$",
	"- Cellar$",
	"- Attic$",
	"- Kitchen$",
	"- Dining room$",
	"- Julia's room$",
	"- Leo's room$",
	"- Pat's room$",
	"- Bob's room$",
	"- Max's room$",
	"- Luc/Ida's room$",
	"- Guy/Eva's room$",
	"The main clue that lead you@to the underground door is:$",
	"- A dagger$",
	"- A ring$",
	"- A book$",
	"- A parchment$",
	"- A letter$",
	"- A pendulum$",
	"How many parchments were there in the manor?$",
	"- None$",
	"- Just one$",
	"- Two$",
	"- Three$",
	"- Four$",
	"- Five$",
	"How many persons are involved in@this story?@(including Julia, but not yourself)$",
	"- Nine$",
	"- Ten$",
	"- Eleven$",
	"What was the first name@of the unknown character?$",
	"- Mireille$",
	"- Fran\207oise$",
	"- Maguy$",
	"- Emilie$",
	"- Murielle$",
	"- Sophie$",
	"Who did Murielle have an affair with?$",
	"- Bob$",
	"- Luc$",
	"- Guy$",
	"- Leo$",
	"- Max$",
	"Murielle shared an occupation@with one other person. Who?$",
	"[1][You realize that certain elements of|this investigation remain a mystery for you.|Therefore, you decide first to learn|more before undertaking new risks..][ok]$",
	"[3][ | insert disk 1 | in drive A ][ok]$",
	"[1][ | Disk error | All stop... ][ok]$",
	"[1][ | You should have noticed |00% of the clues ][ok]$",
	"[3][ | insert disk 2 | in drive A ][ok]$",
	"[1][ |Before going any further, you decide to| look back on the knowledge you gained][ok]$",
	"TBT -  MASTER .$",
	"TBT -   rorL$",
	NULL
};

const char *gameDataFr[] = {
	"Le calme dans la tourmente$",
	"Des go\227ts et des couleurs!$",
	"Mauve qui peut!$",
	"Pri\212re de laisser en sortant...$",
	"Trou noir troublant$",
	"Bleu... comme \"peur bleue\"!$",
	"Chambre de \"Saigneur\"!$",
	"Histoire d'eaux$",
	"Vert nid$",
	"Coup d'oeil sur l'interdit$",
	"Odeur de feux de bois et de tabac$",
	"Tabac et vieux bouquins$",
	"Oignons, cannelle et spiritueux$",
	"Un endroit bien peu visit\202$",
	"Humidit\202 et moisissure$",
	"Avis aux colporteurs...$",
	"Corps putr\202fi\202 : cryptomanie mortelle!$",
	"Et en plus... des pi\212ges d\202samorc\202s!$",
	"C'est d\202j\205 ouvert$",
	"Danger : avalanches$",
	"Une odeur de saintet\202!$",
	"Une b\203tisse imposante$",
	"L'envers du myst\212re!$",
	"Dr\223le d'horoscope!$",
	"Tant va la cruche...$",
	"Une porte en ch\212ne$",
	"Une photo$",
	"Les armoiries$",
	"$",
	"Max, le domestique, vous accueille puis vous conduit \205 votre chambre$",
	"Mortevielle, le 16/2/51@         Mon cher J\202r\223me,@ Suite \205 mon t\202l\202gramme, je vous fais part des raisons de mon inqui\202tude :il y a un an, Murielle, ma dame de compagnie, disparaissait . D\202part ayant rapport avec le renouveau financier du Manoir, ou... Silence difficile \205 comprendre, surtout pour mon fils Guy . N'ayant pu jusqu'\205 pr\202sent, faire le jour sur cette affaire, je compte sur vous pour la mener \205 bien . Si mon \202tat de sant\202 ne s'am\202liorait pas, prenez les d\202cisions qui vous sembleront le plus  appropri\202es...@             Amiti\202s. JULIA DEFRANCK$",
	"Plus tard, Guy vous apprendra le suicide de L\202o...  apr\212s un pari insens\202 aux courses!$",
	"F3: encore@F8: suite$",
	"Le ma\214tre des lieux$",
	"Le futur h\202ritier$",
	"Le fils de JULIA$",
	"Joli brin!!!$",
	"Superman!$",
	"Le mari d'Ida$",
	"Propos int\202ressants?$",
	"Service compris...$",
	"Rien dessous!$",
	"Un ange passe...$",
	"Une 1/2 h passe: rien! Attendez-vous encore?$",
	"Admirez! Contemplez!$",
	"Non ! Rien !$",
	"Impossible$",
	"\207a tache !$",
	"Un trait\202 sur l'histoire de la r\202gion$",
	"Quelques pi\212ces$",
	"Premier commandement...$",
	"Des p\202tales plein les narines !$",
	"Pique, Coeur...$",
	"\207a ne manque pas de cachets !$",
	"Un roman d'amour$",
	"Souffler n'est pas jouer$",
	"Pas une r\202ussite!$",
	"Gare aux rebondissements !$",
	"Sombre et profond...$",
	"Sensations normales$",
	"Sniff!$",
	"Pas discret ! Contentez-vous de regarder !$",
	"Atchoum! De la p... poussi\212re$",
	"La toile est sign\202e... pas le papier peint !$",
	"Pas de chance, rien !$",
	"Soyez plus discret !$",
	"Les volets sont clos$",
	"De la neige, encore de la neige !$",
	"G\202nial : une toile de ma\214tre !$",
	"Aucun doute : une v\202ritable imitation$",
	"Hum ! Vous tiquez : de l'antique en toc !$",
	"Une pi\212ce rare de valeur !$",
	"Rien de remarquable$",
	"Linge, objets personnels...$",
	"Pas n'importe o\227 !$",
	"Ce n'est pas l'heure !$",
	"On ne parle pas la bouche pleine ! Donc, une fois le repas termin\202...$",
	"Quelqu'un entre, s'affaire, ressort...$",
	"On s'approche de votre cachette !$",
	"On vous surprend !$",
	"Non : vous \210tes trop charg\202 !$",
	"Essayez de nouveau$",
	"Vous restez perplexe !?$",
	"Vous quittez le Manoir. A Paris, un message vous attend...$",
	"A\213e, a\213e, a\213e !$",
	"Rien de plus$",
	"Le son para\214t normal$",
	"Ca ne bouge pas$",
	"On vous r\202pond$",
	"Pas le moment !$",
	"M\210me mati\212re, autre face !$",
	"Le reflet est piqu\202, mais le cadre est d'or$",
	"Bibelots, babioles...$",
	"Vous essuyez un \202chec !$",
	"Il est des odeurs... qu'il vaut mieux ne pas voir !$",
	"Des produits m\202nagers$",
	"\207a vous d\202mange ?$",
	"C'est coinc\202, gel\202 ! Brrrr...$",
	"Les huisseries sont bloqu\202es !$",
	"Des papiers...$",
	"Non ! Le p\212re No\210l n'est pas coinc\202 !$",
	"\207a donne sur un couloir$",
	"Vaisselle, argenterie...$",
	"Non ! Ce ne sont pas les restes de Julia !$",
	"Une gravure ancienne$",
	"Il y a une profonde ouverture en losange$",
	"Le mur coulisse... Un passage !  L'empruntez-vous ?$",
	"Le passage se ferme$",
	"Un tiroir secret... Un livret ! Le lisez-vous ?$",
	"Le tiroir se referme$",
	"Rien ! Sang et chairs collent \205 la pierre !$",
	"Des d\202tails vous font supposer que... la mort ne fut pas imm\202diate !$",
	"Des projets v\202reux ?$",
	"Sa vie n'aurait-elle tenu qu'\205 un doigt ?$",
	"Un tr\202sor se serait-il fait la malle ?$",
	"Une fente de la taille d'une pi\212ce !$",
	"Quelques pierres pivotent... Une crypte ! Y p\202n\202trez-vous ?$",
	"La bague tourne, le mur se referme...$",
	"Une colonne de pierres derri\212re l'autel$",
	"Il y a du bruit...$",
	"Occup\202 !$",
	"Retentez-vous votre chance ?$",
	"Trop profond !$",
	"Le mur de la cave pivote$",
	"Nothing !$",
	"L'unique !$",
	"L'objet glisse au fond...$",
	"Vous n'avez rien en main$",
	"Ce n'est pas ouvert$",
	"Il y a d\202j\205 quelque chose$",
	"La porte est ferm\202e$",
	"Pas de r\202ponse$",
	"Une boule de bois pleine$",
	"Il n'y a plus de place$",
	"Une boule de bois perc\202e par le travers$",
	"? ?$",
	"A vous de jouer$",
	"OK !$",
	"Soudain Max survient avec votre  valise : \"Merci de votre visite !  D\202tective \"priv\202\"... de bon sens et de discr\202tion sans doute\" . D\202\207u d\202moralis\202, vous quittez le manoir@Vous \212tes NUL !$",
	"L\202o vous interrompt : \"la temp\212te est calm\202e. Je pars en ville dans 1 heure. Tenez-vous pr\210t!\"... Bon... Vous avez perdu du temps...  mais pas la vie$",
	"Congestion, grippe fatale : vous y restez ! Votre enqu\212te tombe \205 l'eau$",
	"L'eau monte tr\212s vite et refroidit vos derni\212res illusions...  Avant que vous n'ayez eu le temps de r\202agir, vous \212tes mort!$",
	"A peine \212tes-vous au fond du puits qu'une main tranche la corde... Adieu la vie!$",
	"La temp\212te recouvre vos traces . Un mur de silence s'abat sur vos \202paules . Lentement vous succombez \205 la morsure du froid !$",
	"Pas si seul que \207a ! Une lame glac\202e s'enfonce dans votre dos. A l'avenir, soyez plus prudent!$",
	"Vous ignorez la responsabilit\202 exacte de L\202o dans la mort de Murielle... Est-elle morte sur le coup ? De toutes fa\207ons les probl\212mes familiaux d\202couverts lors de votre enqu\212te justifient l'attitude de L\202o... Vous n'\212tes pas s\227r que Julia vous ait appel\202 pour \207a mais c'est suffisant pour vous ! Par respect pour elle, et apr\212s  certaines pr\202cautions, vous avez une entrevue r\202v\202latrice avec L\202o$",
	"$",
	"Vous n'avez pas les clefs du Manoir . Vos appels restent sans r\202ponse . Vous allez attraper... la mort !$",
	"D'un mouvement circulaire, l'\202p\202e vous fend par le travers : tripes et boyaux \205 l'air, bonjour les vers!$",
	"Home, Sweet home !$",
	"Myst\212re d'une porte close$",
	"Charme envo\227tant de vieilles pi\212ces$",
	"La faim au ventre$",
	"Plus pr\212s du ciel? Pas s\227r !$",
	"Peur du noir?$",
	"Vieux tapis et reflets d'or$",
	"Angoisse !$",
	"Sauv\202 ? Pas certain !$",
	"Mal \205 l'aise, hein !$",
	"Toujours plus loin !$",
	"Votre chemin de croix !$",
	"A la d\202couverte de...$",
	"Attention \205 ce que cache...$",
	"Une descente aux Enfers !$",
	"Si ce n'est pas dans vos cordes :@       ne soyez pas sot!$",
	"Avant la mise en pi\212ce !$",
	"Gros plan sur :$",
	"Vous remarquez particuli\212rement...$",
	"Et encore...$",
	"C'est fini !$",
	"Un peu de lecture$",
	"L'aventure vous attend, vous partez...$",
	"Ne ratez pas VOTRE prochaine AVENTURE...$",
	"Je ne comprends pas$",
	"Il y a plus simple$",
	"Non ! Pas ce coup-ci$",
	"Trop tard$",
	"$",
	"Comme un regard profond tout couvert de peaux-pierres, pointant  son oeil obscur aux astres de lumi\212re, il est la gorge reliant le ciel et les enfers . Il faut aller au fond de cette art\212re comme un rat au coeur m\210me de la terre !@Lundi,  Mardi,  Mercredi, Dimanche du 1e lundi au 1e dimanche, tu installeras \"ce rat\" entre chacun des jours . N'omets rien car ta venue serait ta retenue !@Porte ton fardeau comme un oeuf nouveau et donne lui le jour avec force et amour.$",
	"10/1/50: Nous avons r\202solu le myst\212re du manuscrit et localis\202 la crypte . Est-ce l'id\202e d'aboutir dans ce qui n'\202tait qu'un \"r\212ve\" qui me rend si anxieuse ?@Je regrette de m'\210tre engag\202e vis \205 vis de L\202o . Non! je dois continuer ! J'aurais d\227 mettre Guy au courant... mais, depuis une semaine, je n'ai aucune nouvelle .$",
	"Porte ta pri\212re au lieu saint qui se doit, changes-en l'air, tu auras la mati\212re !@Du pilier de la haute sagesse, le soleil aux genoux te montrera l'espace par lequel ton \205me s'ouvrira un chemin et gagnera son \212re . Avance comme un Orph\202e peu soucieux des t\202n\212bres : le blanc est ta couleur, l'or ta demeure . Eclaire ton chemin jusqu'\205 la myst\202rieuse . Offre-lui le cercle de l'homme aux trois facettes . Qu'il regagne le monde et qu'il tourne avec lui dans la richesse premi\212re.$",
	"Les montagnes sont les crocs d'une gueule dantesque ouverte \205 l'infini de quelqu' orgie c\202leste, mastiquant des \202toiles comme nous broyons du noir .@Tu d\202poseras l'accord de pierre \205 tes pieds, le rire du silence sur la gamme d'en haut et dans ta main droite, une toile d'un m\212tre . Tu passeras ainsi entre les deux croissants, par del\205 les ab\214mes du Mur du Silence . La Cl\202 des champs est \205 ta port\202e, tu n'as qu'\205 retrouver la note qui d\202note.$",
	"                DECEMBRE@   9 REMISE     518    13 AGIOS       23@  19 VIREMENT  1203    17 TRESOR    1598@      TOTAL     1721        TOTAL    1721$",
	"  Le 5/01/51@@              Luc, mon amour@ Guy conna\214t notre liaison . A la suite d'une dispute, je lui ai tout dit . Je ne pense qu'\205 toi !  Max me relance mais j'ai d\202finitivement rompu avec lui . Qu'il reste \205 ses gamelles . Quand pourrons-nous nous voir seuls ? Pour toi je divorcerai...   Je t'aime .@             ton Eva$",
	"  Mortevielle, le 10/2/51@@              Pat,@ Je te rappelle que tu me dois  50000 F que je t'ai pr\202t\202s pour ton affaire . J'en ai besoin, peux-tu me les rendre assez vite?@              Guy$",
	"  Mortevielle, le 15/2/51@              Ma\214tre,@ Je vous \202cris au sujet de notre affaire.  Je suis d\202cid\202  \205 aller jusqu'au bout, certain que mon associ\202, Pat DEFRANCK, a falsifi\202  un livre de comptes . Malgr\202$",
	" Une pipe$",
	" Un stylo \205 plume$",
	" Un briquet \205 essence$",
	" Une cornue$",
	" Un blaireau$",
	" Un pot de peinture$",
	" Une flute$",
	" Une bague de valeur$",
	" Une bobine de fil$",
	" Un vieux bouquin$",
	" Un porte-monnaie$",
	" Un poignard$",
	" Un r\202volver$",
	" Une bible$",
	" Une bougie$",
	" Un coffret \205 bijoux$",
	" Un fer \205 repasser$",
	" Une photo$",
	" Une montre \205 gousset$",
	" Une corde$",
	" Des clefs$",
	" Un collier de perles$",
	" Un flacon de parfum$",
	" Des jumelles$",
	" Des lunettes$",
	" Une bourse en cuir$",
	" Une balle de tennis$",
	" Des munitions$",
	" Un rasoir \205 main$",
	" Une brosse \205 cheveux$",
	" Une brosse \205 linge$",
	" Un jeu de cartes$",
	" Un chausse pied$",
	" Un tournevis$",
	" Un marteau$",
	" Des clefs$",
	" Des clefs$",
	" Un cendrier$",
	" Un pinceau$",
	" Une corde$",
	" Un objet en bois$",
	" Des somnif\212res$",
	" Une bague en or$",
	" Un coffret \205 bijoux$",
	" Un r\202veil matin$",
	" Une cotte de mailles$",
	" Un chandellier$",
	" Une paire de gants$",
	" Une coupe cisel\202e$",
	" Un parchemin$",
	" Un poignard$",
	" Un dossier$",
	" Un parchemin$",
	" Un parchemin$",
	" Un dossier$",
	" Un dossier$",
	" Une lettre$",
	" Un roman$",
	" Une baguette en bois$",
	" Une enveloppe$",
	" Une lettre$",
	" Une enveloppe$",
	"Julia$",
	"La mort de Julia$",
	"Les relations de Julia$",
	"Un message de Julia$",
	"L'h\202ritage de Julia$",
	"Derniers actes de Julia$",
	"Les cadeaux de Julia$",
	"La chambre de Julia$",
	"La photo chez Julia$",
	"Julia et vous...$",
	"Les occupations de L\202o$",
	"Les occupations de Pat$",
	"Les occupations de Guy$",
	"Les occupations de Bob$",
	"Les occupations d'Eva$",
	"Les occupations de Luc$",
	"Les occupations d'Ida$",
	"Les occupations de Max$",
	"Vos occupations$",
	"Les relations de L\202o$",
	"Les relations de Pat$",
	"Les relations de Guy$",
	"Les relations de Bob$",
	"Les relations d'Eva$",
	"Les relations de Luc$",
	"Les relations d'Ida$",
	"Les relations de Max$",
	"Vos relations$",
	"Murielle$",
	"Les relations de Murielle$",
	"Murielle et vous...$",
	"Disparition de Murielle$",
	"Le mur du silence$",
	"Les manuscrits$",
	"Le blason$",
	"Les gravures dans la cave$",
	"Le puits$",
	"Les passages secrets$",
	"La chapelle$",
	"Les tableaux$",
	"La photo du grenier$",
	"Le corps dans la crypte$",
	"$",
	"$",
	"FIN DE LA CONVERSATION$",
	"Les vieux appelaient ainsi la chaine de montagne qui se dresse au pied du manoir !$",
	"C'est le massif montagneux que l'on aper\207oit devant le manoir$",
	"Je n'en sais rien !$",
	"Elle est morte d'une embolie pulmonaire$",
	"Ma m\202re est morte soudainement . Son \202tat semblait pourtant s'\210tre am\202lior\202$",
	"Madame DEFRANCK est morte d'un coup de froid$",
	"Elle est morte d'une embolie pulmonaire$",
	"Pardonnez moi mais je pr\202f\212re, actuellement garder le silence$",
	"Ce sont toujours les meilleurs qui partent les premiers$",
	"J'aimais beaucoup ma m\212re . Je regrette seulement qu'elle soit morte dans le manoir des DEFRANCK$",
	"C'est une r\202gion qui a un pass\202 charg\202 et j'ai largement de quoi m'occuper . Et puis j'aime beaucoup les chevaux..$",
	"C'est un passionn\202 d'histoire et un joueur inv\202t\202r\202 . D'ailleurs, voici un an il a gagn\202 une grosse somme$",
	"Il a d\202j\205 beaucoup a faire avec la gestion et l'entretien du manoir...$",
	"Je suis PDG d'une petite soci\202t\202 de parfums . Mais quand je suis ici, je me repose$",
	"C'est un homme dynamique qui a r\202ussi dans le parfum$",
	"Lui ! C'est un arriviste v\202reux ! Les parfums ont du endormir son bon sens . D'ailleurs ici il passe ses soir\202es dans sa chambre$",
	"J'ai \202t\202 tr\212s pr\202occup\202 par la sant\202 de ma m\212re, et maintenant je n'ai plus go\226t \205 rien$",
	"Il aurait mieux fait de s'occuper un peu plus de moi et un peu moins de sa m\212re$",
	"Ce sont ses affaires...$",
	"Il n'a pas trop de chance en ce moment bien que ses affaires soient satisfaisantes$",
	"Je travaille avec Pat mais \207a ne va pas tr\212s fort en ce moment$",
	"Ah oui ?! Il a des occupations ? Il ferait bien de s'en occuper s\202rieusement alors$",
	"Lui et Pat sont associ\202s . Je crois que \207a ne va pas trop mal$",
	"Je m'occupe de moi et c'est d\202j\205 beaucoup . Et vous ?$",
	"Oh \207a ! Je lui fais confiance . Elle sait s'occuper$",
	"Mais ! Vous n'avez pas encore d\202couvert son occupation principale..?$",
	"Elle fait dans la d\202coration avec beaucoup dego\226t d'ailleurs. Elle est toujours tr\212s bien habill\202e$",
	"Si les bijoux vous interessent, j'ai quelques affaires interessantes \205 saisir rapidement$",
	"Les bijoux...$",
	"Je ne sais pas, mais j'aimerais bien qu'il s'occupe un peu moins de mes affaires !$",
	"Quand on est une femme d'int\202rieur on trouve toujours de quoi s'occuper...$",
	"Elle pourrait rester sans rien faire, mais non ! Elle coud, elle lit ...$",
	"Elle n'a s\226rement pas des occupations tr\212s \202panouissantes ...$",
	"Une femme comme il n'y en a plus : Elle s'interesse a tout !$",
	"Entre la cuisine et le m\202nage, je n'ai pas beaucoup de temps \205 vous accorder$",
	"Je ne sais pas comment il s'y prend pour tout faire . C'est merveilleux !$",
	"Il en ferait plus si il s'occupait moins des rag\223ts et de la bouteille$",
	"Je suis tr\212s ind\202pendant . Tant qu'on ne s'occupe pas de mes affaires : Pas de probl\212me$",
	"C'est un \202go\213ste . Je me demande si il aime autre chose que ses chevaux et ses grimoires$",
	"Je crois qu'il s'entend bien avec tout le monde, mis \205 part, peut \210tre, avec Guy$",
	"C'est un homme de caract\212re . Il faut savoir le prendre ..$",
	"Les affaires sont les affaires . Quant \205 la famille, je la laisse pour ce qu'elle est ...$",
	"Relations ? Relations amicales ? Relations financi\212res sans doute$",
	"Moi je n'ai rien \205 lui reprocher$",
	"C'est un homme d'affaire d\202brouillard . Il nage parfois \205 contre-courant mais ... il s'en sortira toujours$",
	"Ils m'ennuient tous .. Non ! Ce n'est m\210me pas \207a .. Quoique .. certains ..$",
	"A l'inverse de sa m\212re, c'est une personne tr\212s renferm\202e ! Alors question relations ..$",
	"Il doit sans doute faire beaucoup d'effort pour rester agr\202able malgr\202 tous ses ennuis$",
	"Ses relations amoureuses : C'est termin\202 . Ses relations avec moi : Pas vraiment commenc\202es . Quant aux autres : Je ne suis pas les \"autres\"$",
	"J'aime bien tout le monde, tant qu'on ne m'escroque pas$",
	"Il ne suffit pas d'avoir un peu d'argent et d'\210tre beau parleur pour plaire \205 tout le monde$",
	"Sans histoire .. C'est quelqu'un d'agr\202able et g\202n\202reux . De plus, il ne manque pas d'humour$",
	"Actuellement je m'entends plut\223t bien avec tout le monde . Mais, ici, je ne vais pas m'\202tendre sur le sujet$",
	"Beau plumage, mais \207a ne vole pas haut ... Parlez en \205 son mari$",
	"C'est pour un rendez-vous ?$",
	"Elle est tr\212s vivante ! Elle ne s'embarrasse pas de pr\202jug\202s stupides$",
	"Dans mon m\202tier, on c\223toit surtout des belles femmes et des truands$",
	"La seule valeur s\226re chez lui, c'est ses bijoux .. Et sa femme, mais \207a il ne s'en rend pas compte$",
	"C'est quelqu'un d'interessant . De pas toujours facile \205 comprendre, mais qui m\202rite le d\202tour$",
	"Je ne d\202teste personne, mais j'aime les choses et les gens quand ils sont \205 leur place$",
	"C'est entre nous . Mais voyez : quand je parle avec elle, je me sens vite \205 l'\202troit !$",
	"Pour ne pas s'entendre avec elle, faut y mettre de la mauvaise volont\202$",
	"Vous savez dans mon m\202tier on entend tout mais on ne retient rien, et le service est bien fait$",
	"C'est un hypocrite, un larbin ! Personnellement je ne lui fais pas confiance$",
	"Je ne connait pas le fond de sa pens\202e mais c'est quelqu'un de toujours tr\212s correct et impeccable$",
	"C'\202tait une personne qui a v\202cu au manoir, il y a un an .. peut \210tre plus$",
	"C'\202tait plus qu'une amie pour ma m\212re . En ces moments, j'aurais aim\202 qu'elle soit \205 mes cot\202s$",
	"Murielle a \202t\202 la dame de compagnie de Julia$",
	"Elle aussi, faisait des recherches ...$",
	"C'\202tait une femme tr\212s cultiv\202e . Son brusque d\202part, il y a un an, m'a surpris et beaucoup chagrin\202$",
	"Elle partageait avec L\202o sa passion de l'histoire et de la r\202gion$",
	"Je crois que tout le monde l'aimait bien$",
	"Elle s'entendait bien avec tout le monde . Elle aimait beaucoup son fils . Quant aux relations belle-m\212re, belle-fille ..$",
	"A part L\202o, elle avait de tr\212s bon rapport avec Max ...$",
	"Bien que vos relations furent peu soutenues, J\202r\223me, elle vous portait toujours dans son coeur ...$",
	"A part sa famille, pas grand monde$",
	"Ah oui ! Je crois qu'elle a beaucoup regrett\202 le d\202part de cette amie .. euh ! Marielle .. ou Mireille ...$",
	"Non rien !$",
	"Non ... Pas que le sache$",
	"J'ai connu Julia en achetant le manoir . C'\202tait son seul bien . Mais toute ma fortune \202tait la sienne ...$",
	"Si ce n'est quelques objets personnels, je crois qu'elle n'avait plus rien \205 elle$",
	"Je crois que toute sa fortune venait de L\202o . Alors, Pfuuut !$",
	"A part la lettre pour vous que j'ai post\202, rien de bien important !$",
	"J'ai \202t\202 tr\212s heureuse qu'elle m'offre sa bible reli\202e$",
	"Ca a \202t\202 rapide et elle n'a pas eu le temps de prendre des dispositions particuli\212res$",
	"Son dernier pr\202sent m'a surpris$",
	"Quel cadeau ?$",
	"Un chandellier ...$",
	"Oui, j'ai eu un cadeau . Ma femme a m\210me eu une bible$",
	"Et bien oui ! Comme tout le monde, je crois$",
	"Un poignard$",
	"Je n'ai jamais \202t\202 fouiller dans le grenier !$",
	"Vous avez un don de double-vue ou un passe-partout$",
	"Le portrait d'une jeune fille : C'est Murielle ...$",
	"Vous savez, je la connaissais assez peu$",
	"Elle \202tait tr\212s charmante, mais c'\202tait surtout la dame de compagnie de Julia$",
	"C'est la seule femme vraiment interessante que j'ai rencontr\202$",
	"Elle avait de grandes connaissances historiques, et la consulter \202tait tr\212s enrichissant$",
	"Je me suis toujours demand\202 ce que certains pouvaient lui trouver !$",
	"Si la chambre est ferm\202e, demandez \205 L\202o$",
	"J'ai ferm\202 sa chambre apr\212s sa mort et j'aimerais qu'il en soit ainsi encore un certain temps$",
	"Vous savez ce que c'est : Des relations familiales$",
	"Durant toutes ces ann\202es, je ne l'ai jamais servie \205 contre-coeur$",
	"Je l'aimais autant qu'elle m'aimais, je crois$",
	"De quel droit avez-vous p\202n\202tr\202 dans la chambre de ma femme ?!!$",
	"C'est sans doute la photo de Murielle avec le filleul de Julia$",
	"Je ne me rappelle pas$",
	"C'est Murielle . C'est moi qui l'ai prise. et d'ailleurs elle est tir\202e \205 l'envers$",
	"Vous \210tes bien curieux !... C'est sans valeur$",
	"Grimoires, parchemins et manuscrits : C'est le domaine de L\202o$",
	"Dommage que la devise soit manquante ...$",
	"C'est tr\212s beau ... Et tr\212s vieux ...$",
	"Tiens ! C'est un endroit que je n'ai jamais visit\202$",
	"D'apr\202s L\202o, il semblerait que les Lunes soient plus r\202centes$",
	"M\210me par ce temps, vous avez d\202nich\202 un soleil ...$",
	"Profond et inqui\202tant : Le progr\212s a du bon$",
	"Ca reste pour moi le plus grand des myst\212res$",
	"Les derniers temps elle parlait d'un voyage . Et puis ...$",
	"Il y a un peu plus d'un an, un soir, elle a d\202cid\202 de partir ...$",
	"De toutes fa\207ons elle n'\202tait pas faite pour vivre ici$",
	"Quoi ?! Quel corps ? Quel crypte ?$",
	"Si il y en a, je ne les ai jamais trouv\202 ...$",
	"Bien s\226r ! ... Et des fant\223mes aussi ...$",
	"C'est la plus vielle de la r\202gion : Elle date du XI eme si\212cle$",
	"Elle fut l\202g\212rement restaur\202e apr\212s la r\202volution$",
	"Julia aimait beaucoup la peinture$",
	"Ils ont diff\202rents styles, mais n'ont pas tous une tr\212s grande valeur$",
	"Que faites-vous l\205 ?$",
	"Je suis s\226r que vous cherchez quelque chose ici$",
	"Je vous \202coute$",
	"Que d\202sirez-vous ?$",
	"Oui ?$",
	"Je suis \205 vous ...$",
	"C'est pourquoi ?$",
	"Allez-y$",
	"C'est \205 quel sujet ?$",
	"Max : \205 votre service, monsieur$",
	"De toutes fa\207ons vous n'avez rien \205 faire ici ! Sortez !!$",
	"Vous \210tes trop curieux !$",
	"J\202r\223me ! Il y a longtemps ... Quelle tristesse, Julia est morte . Sa famille est ici : Guy, son fils . Eva, sa brue . L\202o, son mari bien s\226r . Son beau fils, Pat . Des cousins : Bob, Ida, Luc . La temp\212te redouble, il vous faut rester . Les repas sont \205 12h et 19h et il y a un recueillement \205 la chapelle tous les jours \205 10h$",
	"En vous voyant j'ai compris que vous decouvririez la v\202rit\202 ... Car je savais pourquoi vous veniez : J'avais retrouv\202 le brouillon de la lettre de Julia . Mais je suis tr\212s joueur, alors ... Elle n'avait pas voulu que votre t\203che soit trop facile, pour me prot\202ger, sans doute, mais elle n'a pu mourir avec cette incertitude sur la conscience . Avez vous d\202couvert que le mur du silence est le nom que les ma\207ons ont donn\202 au mur qui porte ce blason, lors de la construction du manoir ? .. Et ces cadeaux que Julia a laiss\202 avant de mourir \202taient autant de faux indices qui ne servaient qu'\205 faire ressortir l'importance des parchemins ... Effectivement, il y a plus d'un an, je travailais avec Murielle au d\202cryptage de ces manuscrits que je venais de trouver . Ma femme a fait la relation entre notre travail et la disparition de Murielle mais elle n'a jamais eu de preuves . Si ce n'est cette bague qu'elle a retrouv\202 un jour dans mes affaires . Une nuit, nous nous sommes aventur\202s dans le passage secret que nous avions d\202couvert . Murielle est morte par accident dans la pi\212ce de la vierge . J'ai r\202cup\202r\202 la bague rapidement, trouv\202 le tr\202sor et me suis enfuis . Je ne pensais pas qu'elle vivait encore, et je n'ai rien dit car j'avais besoin d'argent . J'ai fait passer cette somme sur le compte des courses de chevaux ...Partez maintenant, puisque vous n'\210tes pas de la police . Laissez moi seul !$",
	"F\202vrier 1951 ... Profession : detective priv\202 . Le froid figeait Paris et mes affaires lorsque ...$",
	"Une lettre, un appel, des souvenirs d'une enfance encore proche . Que de jeux dans les pi\212ces d\202labr\202es du manoir de Mortevielle . Julia, une vieille femme a pr\202sent .$",
	" au bureau$",
	" \205 la cuisine$",
	" \205 la cave$",
	" dans le couloir$",
	" dehors$",
	" la salle \205 manger$",
	" dans le manoir$",
	" devant le manoir$",
	" \205 la chapelle$",
	" devant le puits$",
	" au nord$",
	" derri\212re le manoir$",
	" au sud$",
	" \205 l'est$",
	" \205 l'ouest$",
	" vers le manoir$",
	" plus loin$",
	" dans l'eau$",
	" hors du puits$",
	" dans le puits$",
	" choix sur \202cran$",
	" Dans la serie MYSTERE...$",
	" LE MANOIR DE MORTEVIELLE$",
	"$",
	" Sur une idee de...$",
	" Bernard GRELAUD et Bruno GOURIER$",
	"$",
	" Realisation: LANKHOR$",
	"$",
	" Avec la participation de...$",
	" Beatrice et Jean-Luc LANGLOIS$",
	" pour la musique et les voix,$",
	" Bernard GRELAUD pour la conception graphique,$",
	" MARIA-DOLORES  pour la realisation graphique,$",
	" Bruno GOURIER pour la realisation technique,$",
	" Clement ROQUES pour l'adaptation sur IBM PC et compatibles .$",
	"$",
	" Edition: LANKHOR$",
	" COPYRIGHT 1988: LANKHOR$",
	"$",
	" A VOUS DE JOUER$",
	" attacher$",
	" attendre$",
	" d\202foncer$",
	" dormir$",
	" \202couter$",
	" entrer$",
	" fermer$",
	" fouiller$",
	" frapper$",
	" gratter$",
	" lire$",
	" manger$",
	" mettre$",
	" ouvrir$",
	" prendre$",
	" regarder$",
	" sentir$",
	" sonder$",
	" sortir$",
	" soulever$",
	" tourner$",
	" se cacher$",
	" fouiller$",
	" lire$",
	" poser$",
	" regarder$",
	" L\202o$",
	" Pat$",
	" Guy$",
	" Eva$",
	" Bob$",
	" Luc$",
	" Ida$",
	" Max$",
	"Comment Julia est-elle morte ?$",
	"Elle s'est suicid\202e$",
	"Elle est morte assassin\202e$",
	"Elle est morte accidentellement$",
	"Elle est morte naturellement$",
	"D'o\227 provenait l'argent qui a permis la restauration du manoir ?$",
	"chantage$",
	"travail$",
	"h\202ritage$",
	"courses$",
	"rentes$",
	"hold-up$",
	"d\202couverte$",
	"Quel est le hobby de L\202o ?$",
	"recherches historiques$",
	"politique$",
	"peinture$",
	"drogue$",
	"sciences occultes$",
	"direction d'une secte$",
	"Julia a laiss\202 une s\202rie d'indices . Ceux-ci sont repr\202sent\202s en un seul lieu . Lequel ?$",
	"Chapelle$",
	"Ext\202rieur$",
	"Cave$",
	"Grenier$",
	"Cuisine$",
	"Salle \205 manger$",
	"Chambre Julia$",
	"Chambre L\202o$",
	"Chambre Pat$",
	"Chambre Bob$",
	"Chambre Max$",
	"Chambre Luc/Ida$",
	"Chambre Guy/Eva$",
	"L'indice principal qui vous a permis d'arriver \205 la porte du souterrain est :$",
	"Un poignard$",
	"Une bague$",
	"Un livre$",
	"Un parchemin$",
	"Une lettre$",
	"Un pendule$",
	"Combien y avait-il de parchemin dans le manoir ?$",
	"Aucun$",
	"Un seul$",
	"Deux$",
	"Trois$",
	"Quatre$",
	"Cinq$",
	"Combien de personnes sont m\202l\202es \205 cette histoire - Julia y comprise, vous except\202 - ?$",
	"Neuf$",
	"Dix$",
	"Onze$",
	"Quel \202tait le pr\202nom de la personne inconnue ?$",
	"Mireille$",
	"Fran\207oise$",
	"Maguy$",
	"Emilie$",
	"Murielle$",
	"Sophie$",
	"De qui Murielle \202tait-elle la ma\214tresse ?$",
	"Bob$",
	"Luc$",
	"Guy$",
	"L\202o$",
	"Max$",
	"Murielle partageait une occupation avec une autre personne . Qui ?$",
	"[1][ |Seul le hazard vous a permis d'arriver ici . Vous pr\202f\202rez|retourner enqu\202ter afin de mieux comprendre ...][ok]$",
	"[1][ |Ins\202rez la disquette 1 dans le lecteur A][ok]$",
	"[1][ |! ERREUR DISQUETTE !|On arrete tout][ok]$",
	"[1][ |Vous devriez avoir remarqu\202|00% des indices][ok]$",
	"[1][ |Ins\202rez la disquette 2 dans le lecteur A][ok]$",
	"[1][ |Avant d'aller plus loin, vous faites|un point sur l'\202tat de vos connaissances][ok]$",
	" MASTER .$",
	"  rorL$",
};

const char *gameDataDe[] =  {
	"Ruhe vor dem Sturm$",
	"Geschmacklose Farben$",
	"Lila, der letzte Versuch$",
	"Diesen Ort bitte sauberhalten...$",
	"Beaengstigendes schwarzes Loch$",
	"Der blaue Salon$",
	"Das blutrote Zimmer$",
	"Wassersport$",
	"Der gruene Star$",
	"Ein Auge aufs Verbotene werfen$",
	"Geruch von Kaminfeuer und Tabak$",
	"Tabak und alte Buecher$",
	"Zwiebeln, Zimt und Spirituosen$",
	"Ein wenig besuchter Ort$",
	"Feuchtigkeit und Moder$",
	"Hausieren verboten!$",
	"Ein verwester Koerper: toedliche Kryptomanie!$",
	"Da wird einem angst$",
	"Es ist schon offen$",
	"Achtung: Lawinen$",
	"Ein Hauch von \"Heiligkeit\"$",
	"Eine grosses eindrucksvolles Gemaeuer...$",
	"Die Kehrseite des Geheimnisses!$",
	"Ein merkwuerdiges Horoskop!$",
	"Der Krug geht so lange...$",
	"Eine Eichentuer$",
	"Ein Foto$",
	"Die Wappen$",
	"$",
	"Max, der Diener, empfaengt Sie und wird Sie dann in Ihr Zimmer begleiten$",
	"             Morteville  16/2/51@      Mein lieber Jer\223me@Im Anschluss an mein Telegramm teile ich Ihnen die Gruende meiner Unruhe mit: vor 1 Jahr verschwand meine Gesellschafterin Murielle. Eventuell hat das Verschwinden etwas mit dem finanziel len Umschwung auf dem Landsitz zu tun, oder... Eine Stille, die schwer zu verstehen ist fuer mei-nen Sohn Guy. Da ich bis heute nichts bezueglich dieser Sache unternehmen konnte, zaehle ich auf Sie, um die Affaere zu regeln. Falls sich mein Gesundheitszustand nicht bessert, treffen Sie bitte die Entscheidungen, die Sie fuer richtig halten. @            In Freundschaft.  JULIA DEFRANCK$",
	"Spaeter erzaehlt Ihnen Guy von Leo's Selbstmord nach einer verrueckten Wette beim Rennen!$",
	"F3: WIEDERHOLUNG@F8: STOP$",
	"Der Hausherr$",
	"Der Zukuenftige Erbe$",
	"Julias Sohn$",
	"Ein niedliches Maedchen!$",
	"Superman!$",
	"Der Mann von Ida$",
	"Interessante Aeusserungen?$",
	"Service inbegriffen!$",
	"Nichts darunter!$",
	"Kein Mucks...$",
	"Eine halbe Stunde spaeter: nichts! Warten Sie immer noch?$",
	"Bewundern Sie! Denken Sie nach!$",
	"Nein! Nichts!$",
	"Unmoeglich$",
	"Das macht Flecken!$",
	"Eine Abhandlung ueber die Geschichte der Gegend$",
	"Einige Muenzen$",
	"Erstes Gebot...$",
	"Das riecht gut!$",
	"Pik, Herz...$",
	"Es mangelt nicht an Pillen!$",
	"Ein Liebesroman$",
	"Pusten heisst noch nicht spielen$",
	"Kein Erfolg!$",
	"Vorsicht vor Ueberraschungen!$",
	"Dunkel und tief...$",
	"Normale Gefuehle$",
	"Sniff!$",
	"Unverschaemt! Begnuegen Sie sich mit anschauen!$",
	"Gesundheit! St... Staub$",
	"Das Bild ist unterzeichnet... aber nicht die Tapeten$",
	"Kein Glueck, Nichts!$",
	"Seien Sie diskreter!$",
	"Die Vorhaenge sind geschlossen$",
	"Schnee! Und noch mehr Schnee!$",
	"Genial: ein Bild vom Meister!$",
	"Kein Zweifel, das ist eine Faelschung!$",
	"Hum! Sie stutzen - Antikes oder Schund?$",
	"Ein selten wertvolles Stueck!$",
	"Nichts Bemerkenswertes$",
	"Waesche, persoenliche Objekte...$",
	"Nicht irgendwo!$",
	"Das ist nicht der Zeitpunkt!$",
	"Man spricht nicht mit vollem Mund! Nenn erst einmal das essen beendet ist$",
	"Jemand kommt rein, beeilt sich und geht wieder raus$",
	"Man naehert sich Ihrem Versteck!$",
	"Man ueberrascht Sie!$",
	"Unmoeglich! Sie sind ueberlastet!$",
	"Versuchen Sie es aufs neue$",
	"Sie sind perplex!?$",
	"Sie verlassen Morteville. In Paris erwartet Sie eine Nachricht...$",
	"Sie tun sich weh!$",
	"Nichts weiteres mehr hier$",
	"Der Ton erscheint normal$",
	"Es bewegt sich nicht$",
	"Man antwortet Ihnen$",
	"Nicht der Augenblick!$",
	"Gleiches Material, andere Seite!$",
	"Der Widerschein ist fleckig, aber der Rahmen ist aus Gold$",
	"Nippsachen, wertlose Dinge...$",
	"Sie erleiden einen Misserfolg!$",
	"Hier stinkt es... Besser nicht anschauen!$",
	"Haushaltsprodukte$",
	"Da juckt Ihnen das Fell?$",
	"Das ist esklemmt, zugefroren! Brrrr...$",
	"Die Fensterrahmen sind blockiert!$",
	"Papiere...$",
	"Nein! Der Weihnachtsmann hat keine Schwierigkeiten!$",
	"Da geht es auf einen Flur$",
	"Geschirr, Silber...$",
	"Nein! Das sind nicht die Reste von Julia!$",
	"Eine alte Gravur$",
	"Sie entdecken eine tiefe rhombenfoermige Oeffnung$",
	"Die Mauer gleitet zur Seite! Eine Passage! Benutzen Sie sie?$",
	"Der Durchgang schliesst sich$",
	"Eine Geheimschublade. Ein Buechlein... Lesen Sie es?$",
	"Die Schublade schliesst sich wieder$",
	"Nichts! Blut und Haut kleben am Stein!$",
	"Die Details lassen Sie darauf schliessen, dass der Tod nicht unmitte lbar eingetreten ist!$",
	"Verdorbene Vorhaben?$",
	"Hing ihr Leben an einem \"Finger\"?$",
	"Ein Schatz sei verschwunden?$",
	"Eine Ritze in Groesse einer Muenze!$",
	"Einige Steine bewegen sich... Eine Krypta! Gehen Siehinein?$",
	"Der Ring dreht sich, die Mauer schliesst sich wieder$",
	"Eine Steinsaeule hinter dem Altar$",
	"Es war laut...$",
	"Besetzt!$",
	"Versuchen Sie noch einmal Ihr Glueck?$",
	"Zu tief!$",
	"Die Mauer am Ende des Ganges dreht sich$",
	"Nothing!$",
	"Der einzigue!$",
	"Das Objekt faellt hinunter...$",
	"Sie haben nichts in den Haenden$",
	"Es ist nicht offen$",
	"Das ist schon etwas$",
	"Die Tuer ist zu$",
	"Keine Antwort$",
	"Eine volle Holzkugel$",
	"Es ist kein Platz mehr$",
	"Eine, in der Mitte durchbohrte, Holzkugel$",
	"? ?$",
	"Sie sind dran!$",
	"OK!$",
	"Ploetzlich erscheint Max mit Ihrem Koffer : \"Danke fuer Ihren Besuch\" Privatdetektiv mit gutem Gespuer und zweifellos diskret. Demoralisiert verlassen Sie den Landsitz. Sie sind UNBEDEUTEND!$",
	"Leo unterbricht Sie:\"Das Unwetterhat sich beruhigt. In 1 Stunde gehe ich in die Stadt. Halten Siesich bereit.\" Sie haben Zeit verloren...aber noch nicht das Leben$",
	"Hochrotes Gesicht, fatale Grippe.Sie bleiben da. Ihre Nachforschun gen fallen ins Wasser$",
	"Das Wasser steigt sehr schnell und daempft Ihre letzten Illusionen ... Bevor Sie Zeit haben, zu reagiren, sind Sie tot!$",
	"Sie sind kaum auf dem Grund des Brunnens, als eine Hand das Seil durchschneidet. Leben, adieu!$",
	"Der Sturm verwischt Ihre Spuren. Eine Mauer des Schweigens huellt Sie ein. Langsam sterben Sie den Erfrierungstod!$",
	"Sie sind nicht so allein wie Sie denken. Eine kalte Klinge bohrt sich in Ihren Ruecken. Seien Sie in Zukunft vorsichtiger!$",
	"Sie ignorieren die Schuld von Leoam Tode Murielles. War sie sofort tot? Auf jeden Fall gerechtfertigen die familiaeren Probleme, die waehrend Ihrer Untersuchung aufgedeckt wurden, die Haltung Leos. Sie sind nicht sicher, ob Julia Sie deswegen angerufen hat,  aber es genuegt Ihnen. Aus Respekt fuer sie und nach einigen Vorsichtsmassnahmen, fuehren Sie ein aufschlussreiches Gespraech mit Leo.$",
	"$",
	"Sie haben keinen Schluessel fuer den Landsitz. Ihre Rufe bleiben ohne Antwort. Sie werden sterben.$",
	"Mit einem fuerchterlichen Rundschlag spaltet Sie das Schwert entzwei - das Innere kehrt sich nach aussen.$",
	"Home, Sweet home!$",
	"Geheimnis einer geschlossenen Tuer$",
	"Charme verzaubert die alten Zimmer$",
	"Leerer Magen$",
	"Naeher 'gen Himmel? Nicht sicher!$",
	"Angst vorm Dunkeln?$",
	"Alte Teppiche und Goldschimmer$",
	"Angst!$",
	"Gerettet? Nicht sicher!$",
	"Man fuehlt sich unwohl, was!$",
	"Immer noch weiter!$",
	"Ihr Kreuzweg!$",
	"Bei der Entdeckung von...$",
	"Achtung, auf das was sich versteckt...$",
	"Abstieg in die Hoelle!$",
	"Na fuehlen Sie sich gut? Sie sehen etwas@             blass aus!$",
	"Vor dem Eintreten!$",
	"Zoom:$",
	"Unter anderem bemerken Sie...$",
	"Und noch mal...$",
	"Es ist zu Ende!$",
	"Ein wenig Lektuere$",
	"Das Abenteuer wartet auf Sie: also los!$",
	"Verpassen Sie nicht IHR naechstes ABENTEUER!$",
	"Ich verstehe nicht$",
	"Es gibt Einfacheres$",
	"Nein! Nicht Diesmal$",
	"Zu spaet$",
	"$",
	"Wie ein tiefer verschleierter Blick, sein lebloses Auge auf die Sterne gerichtet, ist er wie der Schlund, der Himmel und Hoelle verbindet. Du musst in diese Tiefe vordringen, so wie eine Ratte in die Erde. Montag, Dienstag, Mittwoch, Sonntag, vom 1. Montag bis zum 1. Sonntag -so wird jeder Tag durch das SEIN oder WERDEN bestimmt. Vebersieh nichts, denn sonst ist Dein Schicksal besiegelt.$",
	"10/1/50: Wir haben das Mysterium des Manuskriptes geloest und die Krypta lokalisiert. Ist es der Gedanke, in diesem Traum mein Ziel zu erreichen, der mir so angst macht? Ich bedauere, dass ich mich gegenueber Leo so engagiert habe. Nein, ich muss weitermachen Ich haette Guy informieren muessen, aber ich habe seit einer Woche nichts mehr von ihm gehoert$",
	"Trag deine Bitte an den heiligen Ort - so wirst Du mehr erfahren! Der Pfeiler der Weisheit und die Sonne an den Knien werden Dir die Stelle zeigen , die Deiner Seele den Weg in eine neue Welt oeffnen Vorwaerts Orpheus, ohne Angst vordem Ungewissen:  Weiss ist Deine Farbe, Gold ist Dein Zuhause. Be-leuchte Deinen Weg,  bis hin zur traurigen Jungfrau. Gib ihr den  Kreis  des  Mannes  mit den drei Gesichtern, auf dass er die Welt wieder erreicht und sich dreht in seinem urspruenglichen Reichtum$",
	"Die Berge sind die Zaehne eines gigantischen unendlichen Schlundes, einer himmlischen Orgie, die Sterne verschlingend, so wie uns die Dunkelheit verschlingt. Du laesst das Seil der Steine zu Dei nen Fuessen fallen. Das  Lachen der Stille und in Deiner rechten Hand das Werk eines Meisters. Anschliessend wirst Du zwischen den beiden Monden hindurchgehen; jenseits des Abgrundes der Mauer des Schweigens wirst Du den Schluessel zur Melodie findenes fehlt nur noch die passende Note...$",
	"           DEZEMBER@ 9 ABZUG     518  13 ZINSEN   23@19 VEBERWE. 1203  17 GUTHAB 1598@   TOTAL    1721     TOTAL  1721@$",
	"                        5/01/51@       Luc, mein Liebling@ Guy weiss von unserer Beziehung.Nach einem Streit habe ich ihm alles gesagt. Ich liebe nur Dich. Max sitzt mir dauernd auf dem Hals, aber ich habe definitiv mitihm gebrochen. Soll er doch bei seinen Toepfen bleiben. Wann koennen wir uns allein sehen? Wegen dir wuerde ich mich scheiden lassen@              Deine Eva$",
	"            Morteville, 10/2/51@               Pat@     Ich erinnere Dich daran, dass Du mir noch FF 5000,- schuldest, die ich Dir fuer Dein Geschaeft geliehen habe. Ich brauche sie jetzt. Kannst Du sie mir bitte moeglichst schnell wiedergeben?@                Guy$",
	"            Morteville, 15/2/51@          Lieber Herr@     Ich schreibe Ihnen unser Geschaeft betreffend. Ich bin entschlossen, bis zum Aeusserstenzu gehen, da ich mir sicher bin, dass mein Teilhaber, Pat Defranck ein Rechnungsbuch gefaelscht hat.$",
	"Eine Pfeife$",
	"Ein Fuellfederhalter$",
	"Ein Gasfeuerzeug$",
	"Eine Retorte$",
	"Ein Rasierpinsel$",
	"Ein Farbeimer$",
	"Eine Floete$",
	"Ein wertvoller Ring$",
	"Eine Garnrolle$",
	"Ein altes Buch$",
	"Ein Portemonnaie$",
	"Ein Dolch$",
	"Ein Revolver$",
	"Eine Bibel$",
	"Eine Kerze$",
	"Ein Schmuckkoffer$",
	"Ein Buegeleisen$",
	"Ein Foto$",
	"Eine Taschenuhr$",
	"Ein Seil$",
	"Schluessel$",
	"Ein Perlenkollier$",
	"Ein Parfumflakon$",
	"Ein Fernglas$",
	"Eine Brille$",
	"Ein Ledergeldbeutel$",
	"Ein Tennisball$",
	"Munition$",
	"Ein Nassrasierer$",
	"Eine Haarbuerste$",
	"Eine Kleiderbuerste$",
	"Ein Kartenspiel$",
	"Ein Schuhanzieher$",
	"Ein Schraubenzieher$",
	"Ein Hammer$",
	"Schluessel$",
	"Schluessel$",
	"Ein Aschenbecher$",
	"Ein Pinsel$",
	"Ein Seil$",
	"Ein Gegenstand aus Holz$",
	"Schlafmittel$",
	"Ein goldener Ring$",
	"Ein Schmuckkoffer$",
	"Ein Wecker$",
	"Ein Panzerhemd$",
	"Ein Kerzenhalter$",
	"Ein Paar Handschuhe$",
	"Ein Ziselierter Becher$",
	"Ein Pergament$",
	"Ein Dolch$",
	"Ein Dossier$",
	"Ein Pergament$",
	"Ein Pergament$",
	"Ein Dossier$",
	"Ein Dossier$",
	"Ein Brief$",
	"Ein Roman$",
	"Ein Holzstock$",
	"Ein Umschlag$",
	"Ein Brief$",
	"Ein Umschlag$",
	"Julia$",
	"Julias Tod$",
	"Julias Beziehungen$",
	"eine Nachricht von Julia$",
	"Julias Erbschaft$",
	"letzte Handlungen Julias$",
	"Geschenk von Julia$",
	"Julias Zimmer$",
	"die Fotos bei Julia$",
	"Julia und Sie...$",
	"die Geschaefte von Leo$",
	"die Geschaefte von Pat$",
	"die Geschaefte von Guy$",
	"die Geschaefte von Bob$",
	"die Geschaefte von Eva$",
	"die Geschaefte von Luc$",
	"die Geschaefte von Ida$",
	"die Geschaefte von Max$",
	"Ihre Geschaefte$",
	"Leos Beziehungen$",
	"Pats Beziehungen$",
	"Guys Beziehungen$",
	"Bobs Beziehungen$",
	"Evas Beziehungen$",
	"Lucs Beziehungen$",
	"Idas Beziehungen$",
	"Maxs Beziehungen$",
	"Ihre Beziehungen$",
	"Murielle$",
	"Murielles Beziehungen$",
	"Murielle und Sie...$",
	"Murielles Vershwinden$",
	"Die Mauer des Schweigens$",
	"Die manuskripte$",
	"Das Wappen$",
	"Die Inschriften im Keller$",
	"Der Brunnen$",
	"Die Geheimgaenge$",
	"Die Kapelle$",
	"Die Bilder$",
	"Die Fotos vom Dachboden$",
	"Koerper in der Krypta$",
	"$",
	"$",
	"ENDE DER UNTERHALTUNG$",
	"Die Alten nannten die Bergkette am Fusse des Landsitzes so.$",
	"Das ist das Bergmassiv, das man vor dem Landsitz sieht.$",
	"Ich weiss nichts davon.$",
	"Sie ist an einer Lungenembolie gestorben.$",
	"Meine Mutter ist ploetzlich gestorben, obwohl es schien, dass sich ihr Zustand verbesserte.$",
	"Frau Defranck ist gestorben.$",
	"Sie ist an einer Lungenembolie gestorben.$",
	"Verzeihen Sie mir, aber ich ziehe es vor, im Moment Schweigen zu bewahren.$",
	"Es sind immer die Guten, die als erste gehen muessen.$",
	"Ich habe meine Mutter sehr geliebt; ich bedauere, dass sie auf dem Gut der Defrancks gestorben ist.$",
	"Dies ist  eine Gegend, die eine sehr bewegte Vergangenheit hat und es gibt genug Dinge, um die ich mich kuemmern kann und ausserdem liebe ich Pferde.$",
	"Er interessiert sich sehr fuer Geschichte und er ist ein erfolgloser Spieler. Uebrigens hat er vor einem Jahr eine bedeutende Summe gewonnen.$",
	"Er hat schon viel zu tun mit der Buchhaltung und der Verwaltung des Gutes.$",
	"Ich bin Direktor einer Parfumfirma. Aber hier... Erholung.$",
	"Ein dymamischer Mann, der in der Parfumbranche viel erreicht hat.$",
	"Das ist ein uebler Emporkoemmling. Die Parfums muessen seinen gesunden Menschenverstand eingeschlaefert haben. Hier verbringt er seine Abende in seinem Zimmer.$",
	"Vorher galt meine Hauptsorge der Gesundheit meiner Mutter. Jetzt finde ich an nichts mehr Gefallen.$",
	"Er haette gut daran getan, sich ein bisschen mehr um mich zu kuemmern und etwas weniger um seine Mutter.$",
	"Das sind seine Angelegenheiten.$",
	"Er hat nicht viel Glueck im Moment, obwohl seine Geschaefte zufriedenstellend sind.$",
	"Ich arbeite mit Pat. Es geht nicht besonders gut im Moment.$",
	"Ah ja! Hat er Beschaeftigungen? Er taete besser daran, sich ernsthaft zu beschaeftigen.$",
	"Er und Pat sind Geschaeftspartner. Ich glaube, es laeuft gar nicht mal schlecht.$",
	"Ich kuemmere mich um mich und das ist schon genug. Und Sie?$",
	"Oh, ich vetraue ihr. Sie versteht, sich zu beschaeftigen.$",
	"Aber haben Sie noch nicht ihre Hauptbeschaeftigung entdeckt?$",
	"Sie arbeitet in der Dekoration mit sehr viel Geschmack. Ausserdem ist sie immer sehr gut angezogen.$",
	"Interessiert sie der Schmuck. Ich habe ein Geschaeft vorzuschlagen.$",
	"Der Schmuck...$",
	"Ich weiss nicht, aber ich glaube, ich wuerde es vorziehen, wenn er sich ein bisschen weniger um meine Angelegenheiten kuemmern wuerde.$",
	"Eine Hausfrau hat immer zu tun.$",
	"Sie koennte auch ohne Arbeit auskommen. Aber nein, sie naeht, sie liest...$",
	"Sie hat sicherlich keine sehr erheiternden Taetigkeiten.$",
	"Eine aussergewoehnliche Frau. Sie interessiert sich fuer alles.$",
	"Zwischen Kueche und Haushalt habe ich nicht viel Zeit fuer sie.$",
	"Wie schafft er es nur, alles zu machen? Oh Wunder!$",
	"Er taete gut daran, wenn er sich weniger mit Klatsch und der Flasche beschaeftigen wuerde.$",
	"Ich bin sehr selbstaendig. Solange man sich nicht um meine Angelegenheiten kuemmert, gibt es keine Probleme.$",
	"Er ist ein Egoist. Ich frage mich, ob es fuer ihn noch etwas anderes gibt, als seine Pferde und seine Maerchenbuecher.$",
	"Er versteht sich gut mit allen, ausser vielleicht mit Guy.$",
	"Er ist ein Mann mit Charakter. Man muss ihn zu nehmen wissen.$",
	"Geschaeft ist Geschaeft. Was die Familie anbetrifft...$",
	"Beziehungen? Freundschaften? Finanzen zweifellos.$",
	"Ich habe ihm nichts vorzuwerfen.$",
	"Er ist ein pfiffiger Geschaeftsmann. Manchmal schwimmt er gegen den Strom, aber er weiss sich immer zu helfen.$",
	"Sie langweilen mich alle. Nein, obwohl... einige...$",
	"Im Gegensatz zur Mutter ist es eine sehr verschlossene Person. Also Frage: Beziehung.$",
	"Er muss sich zweifellos sehr anstrengen, um trotz seiner Sorgen freundlich zu bleiben.$",
	"Seine Liebesaffairen? Aus und vorbei. Mit mir? Es hat nie richtig angefangen. Was die anderen betrifft... ich bin nicht \"die anderen\".$",
	"Ich mag jeden, solange man mich nicht betruegt.$",
	"Es reicht nicht, ein bisschen Geld zu haben und ein guter Redner zu sein, um bei allen beliebt zu sein.$",
	"Jemand, der nett ist und ausserdem noch Humor hat.$",
	"Ueber diese Sache kann ich mich nicht auslassen.$",
	"Das ist nicht besonders intelligent. Sprechen Sie mit dem Ehemann darueber.$",
	"Ist es wegen eines Rendez-vous?$",
	"Sie ist sehr lebhaft. sie laesst sich nicht durch Vorurteile in Verwirrung brignen.$",
	"In meinem Beruf ist man vor allem schoenen Frauen und Gaunern sehr nahe.$",
	"Sein einziges Vermoegen sind sein Schmuck und seine Frau, aber er ist sich dessen nicht bewusst.$",
	"Jemand interessantes, aber nicht immer leicht zu verstehen, der aber die Muehe wert ist.$",
	"Ich verachte niemanden, aber ich mag es sehr, wenn alles und alle dort sind, wo sie hingehoeren.$",
	"Unter uns.. sehen Sie, wenn ich mit ihr spreche, fuehle ich mich schnell beengt.$",
	"Um sich nicht mit ihr zu verstehen, braucht man wirklich viel schlechten Willen.$",
	"In meinem Beruf hoert man alles, aber behaelt nichts. Nur der Service zaehlt.$",
	"Das ist ein Heuchler, ein Kriecher. Ich persoenlich habe kein Vertrauen zu Ihm.$",
	"Ich kenne seine wahren Gedanken nicht, aber er war stets korrekt.$",
	"Sie hat vor einem Jahr, vielleicht laenger, auf dem Landsitz gewohnt.$",
	"Mehr als eine Freundin fuer meine Mutter. In solchen Augenblicken haette ich gewuenscht, dass sie da ist.$",
	"Sie war die Hausdame von Julia.$",
	"Sie hat ebenfalls Recherchen angestellt. Aber Guy, der sie besser kennt als jeder andere, kann Ihnen mehr sagen.$",
	"Ihre Beziehungen?... Sie war sehr kultiviert. Ihr ploetzliches Verschwinden vor einem Jahr hat mich erstaunt.$",
	"Sie teilte mit Leo ihre Leidenschaft fuer Geschichte und fuer die Gegend.$",
	"Ich glaube, jeder hatte sie gern.$",
	"Sie verstand sich mit allen gut, aber ganz besonders liebte sie ihren Sohn. Was die Beziehungen Schwiegermutter Scwiegertochter anbetrifft...$",
	"Ausser zu Leo hatte sie auch gute Beziehungen zu Max.$",
	"Obwohl ihre Beziehungen nicht von Dauer waren, lag ihr immer viel an ihnen.$",
	"Ausser ihrer Familie, nicht viele.$",
	"Aber ja. Sie hat das Weggehen dieser Freundin sehr bedauert. Eh, Mireille, oder Marielle.$",
	"Nein, nichts.$",
	"Nein, nicht das ich wuesste.$",
	"Ich habe Julia kennengelernt, als ich das Landgut kaufte. Es war das einzige, was ihr gehoerte, aber mein Besitz war auch der ihre.$",
	"Wenn nicht einige persoenliche Dinge gewesen waeren, ich glaube, dann haette sie nichts eigenes mehr gehabt.$",
	"Ich glaube, all ihr Reichtum kam von Leo. Also!$",
	"Ausser des Briefes, den ich fuer sie aufgegeben habe, nichts wichtiges.$",
	"Ich war gluecklich, als sie mir ihre eingebundene Bibel schenkte.$",
	"Es ging schnell und sie hatte nicht die Zeit, um spezielle Entscheidungen zu treffen.$",
	"Ihr letztes Geschenk hat mich ueberrascht.$",
	"Was fuer ein Geschenk?$",
	"Ein Kerzenleuchter.$",
	"Ja, ich habe ein Geschenk bekommen. Meine Frau hat sogar eine Bibel bekommen.$",
	"Aber ja. wie jeder, glaube ich.$",
	"Ein Dolch$",
	"Ich habe nie den Dachboden durchwuehlt.$",
	"Haben Sie die Gabe eines Hellsehers, oder haben Sie einen Dietrich?$",
	"Das Portrait einer jungen Frau? Das ist Murielle.$",
	"Ich kannte sie zu wenig.$",
	"Sehr charmant. Sie war vor allem die Hausdame von Julia.$",
	"Das war die einzige wirklich interessante Frau, die ich getroffen habe.$",
	"Sie hatte ein grosses Wissen vorzuweisen. Sie zu besuchen, war stets sehr bereichernd.$",
	"Ich habe mich immer gefragt, was manche an ihr fanden.$",
	"Das Zimmer ist verschlossen? Fragen Sie Leo.$",
	"Ich habe ihr Zimmer nach ihrem Tod abgeschlossen und ich moechte, dass das auch noch eine zeitlang so bleibt.$",
	"Wissen Sie, was das sind? Familienbeziehungen.$",
	"In all den Jahren habe ich sie niemals gegen meinen Willen bedient.$",
	"Ich habe sie so sehr geliebt, wie sie mich, glaube ich.$",
	"Mit welchem Recht sind Sie in das Zimmer meiner Frau eingedrungen?$",
	"Zweifellos das Foto von Murielle mit dem Patenkind von Julia.$",
	"Ich erinnere mich nicht.$",
	"Das ist Murielle. Ich war es, der sie fotografiert hat. Uebrigens ist das Foto seitenverkehrt abgezogen.$",
	"Sie sind wirklich neugierig. Das ist wertlos.$",
	"Maerchen, Pergamente und Manuskripte das ist Leos Spezialitaet.$",
	"Schade, dass die Losung fehlt.$",
	"Das ist sehr schoen und sehr alt.$",
	"Das ist ein Ort, den ich nie gesehen habe.$",
	"Leos Meinung nach schien es, als seien die Monde spaeter gemacht worden.$",
	"M\210me par ce temps, vous avez d\202nich\202 un soleil ...$",
	"Tief und beunruhigend. Der Fortschritt hat gutes an sich.$",
	"Der Rest bleibt fuer mich eines der groessten Raetsel.$",
	"In letzter Zeit sprach sie oft von einer Reise und dann...$",
	"An einem Abend vor mehr als einem Jahr hat sie sich entschieden wegzugehen.$",
	"Auf jeden Fall war sie fuer das Leben hier nicht geschaffen.$",
	"Welcher Koerper? Welche Krypta?$",
	"Wenn es sie ueberhaupt gibt, ich habe sie nie gefunden.$",
	"Aber sicher! Und die Fantome auch.$",
	"Es ist die aelteste der Stadt. Sie stammt aus dem 11. Jahrhundert.$",
	"Nach der Revolution wurde sie leicht restauriert.$",
	"Julia liebte die Malerei sehr.$",
	"Sie haben verschiedene Stilrichtungen, aber sie haben nicht alle Wert.$",
	"Was machen Sie da ?$",
	"Ich bin sicher, Sie suchen etwas!$",
	"Ich hoere.$",
	"Was wuenschen Sie?$",
	"Ja ?$",
	"Ich stehe zu Ihrer Verfuegung.$",
	"Weswegen?$",
	"Na los doch!$",
	"Wegen was?$",
	"Max: Zu Ihren Diensten, Monsieur.$",
	"Auf jeden Fall haben Sie hier nichts zu suchen! Gehen  Sie raus!$",
	"Sie sind zu neugierig!$",
	"Jerome, es ist lange her. Wie traurig, Julia ist tot. Ihre Familie ist hier. Guy, ihr Sohn, und Eva, ihre Schwiegertochter. Leo, ihr Mann, sowie  ihr Schwiegersohn Pat und die Cousins Bob, Ida und Luc. Das Unwetter verstaerkt sich. Sie muessen noch bleiben. Die Mahlzeiten sind um 12 Uhr und um 19 Uhr und es findet jeden Tag um 10 Uhr eine Andacht in der Kapelle statt.$",
	"Als ich Sie sah, habe ich sofort begriffen, dass Sie die Wahrheit aufdecken wuerden, da ich wusste, warum Sie gekommen sind. Ich hatte den Entwurf von Julias Brief gefunden. Aber ich bin ein begeisterter Spieler, also.... Sie haette nicht gewollte, dass ihre Aufgabe zu leicht ausfaellt, zweifellos, um mich zu schuetzen, aber sie konnten nicht sterben mit dieser Ungewissheit.Haben Sie herausgefunden, dass die \"Mauer des Schweigens\" der Name ist, den  die Maurer waehrend des Baus des Landsitzes der Mauer gegeben haben, die das Wappen traegt...? Und die Geschenke, die Julia vor ihrem Tod hinterlassen hat waren sowohl falsche Hinweise wie auch ein Mittel, um die Wichtigkeit der Pergamente herauszustellen. Tatsaechlich arbeitete ich vor mehr als einem Jahr mit Murielle an der Entzifferung dieser Pergamente, die ich gefunden hatte. Meine Frau sah einen Zusammenhang zwischen unserer Arbeit und dem Verschwinden Murielles,aber sie hat nie Beweise dafuer gehabt; wenn da nicht dieser Ring gewesen waere, den sie eines Tages unter meinen Sachen wiedergefunden hat. Eines nachts sind wir in dem Geheimgang, den wir entdeckt hatten,auf Erkundung gegangen. Murielle ist durch einen Unfall im \"Jungfrauenzimmer\" ums Leben gekommen. Ich habe ihren Ring schnell an mich genommen, habe den Schatz entdeckt und mich dann aus dem Staub gemacht. Ich dachte nicht daran, dass  sie unter Umstaenden noch leben koennte, und ich habe nichts gesagt, da ich Geld brauchte. Ich habe das Geld beim Pferderennen verspielt. Gehen Sie jetzt, da sie ja nicht von der Polizei sind. Lassen Sie mich allein.$",
	"Februar '51, Beruf: Privatdetektiv. Die Kaelte laesst Paris und meine Unternehmungen erstarren, als...$",
	"Julia, heute eine alte Frau. Nichts als Erinnerungen und Spiele in den alten Zimmern des Landsitzes von Morteville.$",
	"im Buero$",
	"in der Kueche$",
	"im Keller$",
	"auf dem Flur$",
	"draussen$",
	"im Esszimmer$",
	"im Landsitz$",
	"vor dem Landsitz$",
	"in der Kapelle$",
	"vor dem Brunnen$",
	"im Norden$",
	"hinter dem Landsitz$",
	"im Sueden$",
	"im Osten$",
	"im Westen$",
	"in Richtung Landsitz$",
	"noch weiter$",
	"im Wasser$",
	"ausser des Brunnens$",
	"im Brunnen$",
	"Wahl auf dem Bild$",
	" In der Reihe RAETSEL...$",
	" DER LANDSITZ VON MORTEVILLE$",
	"$",
	" Nach einer Idee von...$",
	" Bernard GRELAUD und Bruno GOURIER$",
	"$",
	" Realisation: LANKHOR$",
	"$",
	" in Zusammenarbeit mit...$",
	" Beatrice und Jean-Luc LANGLOIS Musik und Stimmen,$",
	" Bernard GRELAUD graphische Gestaltung,$",
	" Dominique SABLONS graphische Realisation ,$",
	" Bruno GOURIER technische Realisation,$",
	" Gabi NURGE Uebersetzung,$",
	" Clement ROQUES IBM PC Realisation.$",
	"$",
	" Ausgabe: LANKHOR$",
	" COPYRIGHT 1989: LANKHOR$",
	"$",
	" SIE SIND AM ZUG$",
	"abkratzen$",
	"anschauen$",
	"ausgehen$",
	"befestig.$",
	"drehen$",
	"durchsuch$",
	"eindrueck$",
	"eintreten$",
	"essen$",
	"fuehlen$",
	"hochheben$",
	"klopfen$",
	"lesen$",
	"nehmen$",
	"oeffnen$",
	"schlafen$",
	"schliess.$",
	"setzen$",
	"sondieren$",
	"warten$",
	"zuhoeren$",
	"anschauen$",
	"durchsuch.$",
	"hinlegen$",
	"lesen$",
	"s. verstec$",
	"Leo$",
	"Pat$",
	"Guy$",
	"Eva$",
	"Bob$",
	"Luc$",
	"Ida$",
	"Max$",
	" JULIA$",
	"hat sie Selbstmord begangen ?$",
	"ist sie ermordet worden ?$",
	"ist sie durch Unfall gestorben ?$",
	"ist sie eines natuerlichen Todes gestorben ?$",
	" Woher kam das Geld, das die restaurierung des landsitzes erlaubte ?$",
	"Erpressung$",
	"Arbeit$",
	"Erbschaft$",
	"Rennen$",
	"Renten$",
	"Raub$",
	"Verschiedenes$",
	" Was ist Leos Hobby ?$",
	"Historische Recherchen$",
	"Politik$",
	"Malerei$",
	"Drogen$",
	"Okkultismus$",
	"Fuehrung einer Sekte$",
	" Julia Hat verschiedene Indizien hinterlassen. Diese befinden sich an einem einzigen Ort. Welchem ?$",
	"Kapelle$",
	"Draussen$",
	"Keller$",
	"Dachboden$",
	"Kueche$",
	"Esszimmer$",
	"Julias Zimmer$",
	"Leos Zimmer$",
	"Pats Zimmer$",
	"Bobs Zimmer$",
	"Maxs Zimmer$",
	"Luc/Idas Zimmer$",
	"Guy/Evas Zimmer$",
	" Der entscheidende Hinweis, der es Ihnen ermoeglichte, bis an die Tuer des Souterrains zu gelangen, war :$",
	"ein Dolch$",
	"ein Ring$",
	"ein Buch$",
	"ein Pergament$",
	"ein Brief$",
	"ein Pendel$",
	" Wievele Pergamente befinden sich auf dem Landsitz ?$",
	"kein$",
	"eins$",
	"zwei$",
	"drei$",
	"vier$",
	"f\201nf$",
	" Wieviele Personen sind in die Geschichte verwickelt ? (Julia eingeschlossen, ausgenommen Sie)$",
	"neun$",
	"zehn$",
	"elf$",
	" Wie war der Name der unbekannten Person ?$",
	"Mireille$",
	"Fran\207oise$",
	"Maguy$",
	"Emilie$",
	"Murielle$",
	"Sophie$",
	" Wessen Geliebte war Murielle ?$",
	"Bob$",
	"Luc$",
	"Guy$",
	"Leo$",
	"Max$",
	" Murielle teilte eine Beschaeftigung mit einer anderen Person. Mit wem ?$",
	"[1][Allein der Zufall hat es Ihnen ermoeglicht bis hierher zu komen.| Gehen Sie zurueck und forschen Sie noch einmal nach,|damit Sie das Gaze besser verstehen...][ok]$",
	"[1][Legen Sie die Diskette 1 ein][ok]$",
	"[1][Problem mit der Diskette | Alles abstellen...][OK]$",
	"[1][Sie haetten 00% der Hinweise|      bemerken muessen][ OK ]$",
	"[1][Legen Sie die Diskette 2 ein][ok]$",
	"[1][Bevor Sie weitermachen, fassen Sie Ihre Kenntnisse Zusammen][ok]$",
	" MASTER .$",
	" sgaf",
	NULL
};
#endif
