# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** shared html parts

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/html_parts.rb;hb=HEAD]

=end
module SiSU_Parts_Generic
  def the_url
    def urify(uri)
      URI.parse(uri)
    end
    def sisu
      'http://www.sisudoc.org/'
    end
    def sisudoc
      'http://www.sisudoc.org'
    end
    def footer_signature
      'http://www.sisudoc.org/'
    end
    def rl_root
      '/sisu' #watch
    end
    def root_http
      'http://www.sisudoc.org/' #watch
    end
    def home
      'http://www.sisudoc.org/' # used in pdf header
    end
    def site #used as stub... where there are subdirectories and is different from home
      home
    end
    def home_txt
      'www.sisudoc.org'
    end
    def sisu_txt
      'www.sisudoc.org'
    end
    self
  end
  def the_text
    def home
      'SiSU'
    end
    def txt_hp
      '&nbsp;SiSU'
    end
    def txt_hp_alias
      'SiSU'
    end
    def txt_home
      'SiSU'
    end
    def txt_signature # used in latex/pdf footer
      'SiSU'
    end
    def url_open
      '<'
    end
    def url_close
      '>'
    end
    self
  end
  def the_icon
    def i_ico
      'rb7.ico'
    end
    def i_home_button
      'sisu.png'
    end
    def i_choice
      'b_choice.png'
    end
    def i_new
      'b_new.png'
    end
    self
  end
end
__END__
