7.3 Opciones con Deslizadores

# Opciones con Deslizadores

Mientras explorábamos las opciones con sintetizadores y efectos, habrás
notado que hay un número de opciones que terminan en `_slide`. Quizás
intentaste utilizarlos y no hubo efecto. Esto es porque ellos son parámetros
especiales que sólo funcionan cuando controlas los sintetizadores como 
dijimos en la sección anterior.

Considera el siguiente ejemplo:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Aquí puedes escuchar el sintetizador cambiando tono inmediatamente en cada
llamada de `control`. Sin embargo, quizás querramos que el tono se deslice
entre cambios. Ya que estamos controlando el parámetro `note`, para añadir
deslizamiento (slide), debemos setear el `note_slide` del sintetizador:


```
s = play 60, release: 5, note_slide: 1
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```
Ahora escuchamos las notas "deslizadas" entre cada llamada de `control`.
¿suena bien, no? Puedes acelerar/desacelerar el arraster usando tiempos
más cortos en `note_slide: 0.2`.

Cada parámetro que puede ser controlado, tiene su correspondiente `_slide`
con el que jugar.


## Deslizar es pegajoso

Una vez que determines un parámetro de `_slide` en un sintetizador, será
recordado y usado cada vez que deslices el correspondiente parámetro. Para
detener el deslizamiento, debes setear el valor de  `_slide` a 0 antes de la
siguiente llamada a control.


## Deslizando opciones de Efectos (FX)

También es posible deslizar opciones de efectos (FX):

```
with_fx :wobble, phase: 1, phase_slide: 5 do |e|
  use_synth :dsaw
  play 50, release: 5
  control e, phase: 0.025
end
```

Ve y diviértete deslizando todo para unas transiciones suaves y control
fluído...
Now have fun sliding things around for smooth transitions and flowing
control...
