/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_27 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 5562, "epsg", 5562,
        "UCS-2000 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 4\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",21],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5562\"]]");
    p = add_epsg_def_ex (filter, first, last, 5563, "epsg", 5563,
        "UCS-2000 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 5\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",27],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",5500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5563\"]]");
    p = add_epsg_def_ex (filter, first, last, 5564, "epsg", 5564,
        "UCS-2000 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 6\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",33],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",6500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5564\"]]");
    p = add_epsg_def_ex (filter, first, last, 5565, "epsg", 5565,
        "UCS-2000 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 7\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",39],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",7500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5565\"]]");
    p = add_epsg_def_ex (filter, first, last, 5566, "epsg", 5566,
        "UCS-2000 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 21E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",21],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5566\"]]");
    p = add_epsg_def_ex (filter, first, last, 5567, "epsg", 5567,
        "UCS-2000 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 27E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",27],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5567\"]]");
    p = add_epsg_def_ex (filter, first, last, 5568, "epsg", 5568,
        "UCS-2000 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 33E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",33],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5568\"]]");
    p = add_epsg_def_ex (filter, first, last, 5569, "epsg", 5569,
        "UCS-2000 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 39E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",39],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5569\"]]");
    p = add_epsg_def_ex (filter, first, last, 5570, "epsg", 5570,
        "UCS-2000 / 3-degree Gauss-Kruger zone 7 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 7 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",75000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"5570\"]]");
    p = add_epsg_def_ex (filter, first, last, 5571, "epsg", 5571,
        "UCS-2000 / 3-degree Gauss-Kruger zone 8 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 8 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",24],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",85000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"5571\"]]");
    p = add_epsg_def_ex (filter, first, last, 5572, "epsg", 5572,
        "UCS-2000 / 3-degree Gauss-Kruger zone 9 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 9 (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",27],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",95000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"5572\"]]");
    p = add_epsg_def_ex (filter, first, last, 5573, "epsg", 5573,
        "UCS-2000 / 3-degree Gauss-Kruger zone 10 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 10 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",30],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",10500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"5573\"]]");
    p = add_epsg_def_ex (filter, first, last, 5574, "epsg", 5574,
        "UCS-2000 / 3-degree Gauss-Kruger zone 11 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 11 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",33],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",11500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"5574\"]]");
    p = add_epsg_def_ex (filter, first, last, 5575, "epsg", 5575,
        "UCS-2000 / 3-degree Gauss-Kruger zone 12 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 12 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",36],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",12500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"5575\"]]");
    p = add_epsg_def_ex (filter, first, last, 5576, "epsg", 5576,
        "UCS-2000 / 3-degree Gauss-Kruger zone 13 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 13 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",39],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",13500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"5576\"]]");
    p = add_epsg_def_ex (filter, first, last, 5577, "epsg", 5577,
        "UCS-2000 / 3-degree Gauss-Kruger CM 21E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 21E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5577\"]]");
    p = add_epsg_def_ex (filter, first, last, 5578, "epsg", 5578,
        "UCS-2000 / 3-degree Gauss-Kruger CM 24E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 24E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",24],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5578\"]]");
    p = add_epsg_def_ex (filter, first, last, 5579, "epsg", 5579,
        "UCS-2000 / 3-degree Gauss-Kruger CM 27E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 27E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",27],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5579\"]]");
    p = add_epsg_def_ex (filter, first, last, 5580, "epsg", 5580,
        "UCS-2000 / 3-degree Gauss-Kruger CM 30E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 30E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",30],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5580\"]]");
    p = add_epsg_def_ex (filter, first, last, 5581, "epsg", 5581,
        "UCS-2000 / 3-degree Gauss-Kruger CM 33E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 33E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",33],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5581\"]]");
    p = add_epsg_def_ex (filter, first, last, 5582, "epsg", 5582,
        "UCS-2000 / 3-degree Gauss-Kruger CM 36E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 36E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",36],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5582\"]]");
    p = add_epsg_def_ex (filter, first, last, 5583, "epsg", 5583,
        "UCS-2000 / 3-degree Gauss-Kruger CM 39E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 39E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",39],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"5583\"]]");
    p = add_epsg_def_ex (filter, first, last, 5588, "epsg", 5588,
        "NAD27 / New Brunswick Stereographic (NAD27)", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Oblique_Stereographic", "foot",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=3");
    add_proj4text (p, 1,
        "04800 +y_0=304800 +datum=NAD27 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Brunswick Stereographic (NAD27)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Oblique_Stereogra");
    add_srs_wkt (p, 8,
        "phic\"],PARAMETER[\"latitude_of_origin\",46.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-66.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999912],PARAMETER[\"false_easting\",1000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",1000000],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"5588\"]]");
    p = add_epsg_def_ex (filter, first, last, 5589, "epsg", 5589,
        "Sibun Gorge 1922 / Colony Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Sibun_Gorge_1922", "Transverse_Mercator", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +to_meter=0.3047972");
    add_proj4text (p, 3,
        "654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sibun Gorge 1922 / Colony Grid\",GEOGCS[\"Sibun");
    add_srs_wkt (p, 1,
        " Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1858\",6378293.645208759,294.2606763692606,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"1071\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"5464\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",17.06124194444444],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-88.6318575],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",217259.26]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",445474.83],UNIT[\"Clarke's");
    add_srs_wkt (p, 12,
        " foot\",0.3047972654,AUTHORITY[\"EPSG\",\"9005\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"5589\"]]");
    p = add_epsg_def_ex (filter, first, last, 5593, "epsg", 5593,
        "FEH2010", 1, 1,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FEH2010\",DATUM[\"Fehmarnbelt_Datum_2010\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"1078\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"5593\"]]");
    p = add_epsg_def_ex (filter, first, last, 5596, "epsg", 5596,
        "FEH2010 / Fehmarnbelt TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FEH2010 / Fehmarnbelt TM\",GEOGCS[\"FEH2010\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1078\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"5593\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",11.33333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"5596\"]]");
    p = add_epsg_def_ex (filter, first, last, 5598, "epsg", 5598,
        "FEH2010 / Fehmarnbelt TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"FEH2010 / Fehmarnbelt TM + FCSVR10 height\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"FEH2010 / Fehmarnbelt TM\",GEOGCS[\"FEH2010\",DA");
    add_srs_wkt (p, 2,
        "TUM[\"Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 4,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1078\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 7,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"5593\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",11.33333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"5596\"]],VERT_CS[\"FCSVR10 height\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"Fehmarnbelt Vertical Reference 2010\",2005");
    add_srs_wkt (p, 16,
        ",AUTHORITY[\"EPSG\",\"1079\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 18,
        ",\"5597\"]],AUTHORITY[\"EPSG\",\"5598\"]]");
    p = add_epsg_def_ex (filter, first, last, 5623, "epsg", 5623,
        "NAD27 / Michigan East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",41.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "83.66666666666667],PARAMETER[\"scale_factor\",0.99994285");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"5623\"]]");
    p = add_epsg_def_ex (filter, first, last, 5624, "epsg", 5624,
        "NAD27 / Michigan Old Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan Old Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.5],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-85.75],PARAMETER[\"scale_factor\",0.999909091],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"5624\"]]");
    p = add_epsg_def_ex (filter, first, last, 5625, "epsg", 5625,
        "NAD27 / Michigan West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",41.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "88.75],PARAMETER[\"scale_factor\",0.999909091],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5625\"]]");
    p = add_epsg_def_ex (filter, first, last, 5627, "epsg", 5627,
        "ED50 / TM 6 NE", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 6 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",6],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5627\"]]");
    p = add_epsg_def_ex (filter, first, last, 5628, "epsg", 5628,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 + RH2000 height\",GEOGCS[\"SWEREF99\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4619\"]],VERT_CS[\"RH2000 height\",VERT_DATUM[\"Rikets h");
    add_srs_wkt (p, 8,
        "ojdsystem 2000\",2005,AUTHORITY[\"EPSG\",\"5208\"]],UNIT");
    add_srs_wkt (p, 9,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",U");
    add_srs_wkt (p, 10,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 11,
        "28\"]]");
    p = add_epsg_def_ex (filter, first, last, 5629, "epsg", 5629,
        "Moznet / UTM zone 38S", 0, 0,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moznet / UTM zone 38S\",GEOGCS[\"Moznet\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Moznet_ITRF94\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6130\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"413");
    add_srs_wkt (p, 7,
        "0\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",45]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"5629\"]]");
    p = add_epsg_def_ex (filter, first, last, 5631, "epsg", 5631,
        "Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_srs_wkt (p, 4,
        ".844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",2500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5631\"]]");
    p = add_epsg_def_ex (filter, first, last, 5632, "epsg", 5632,
        "PTRA08 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LCC Europe\",GEOGCS[\"PTRA08\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_2\",65],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",52],PARAMETER[\"central_meridian\",10],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",4000000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"5632\"]]");
    p = add_epsg_def_ex (filter, first, last, 5633, "epsg", 5633,
        "PTRA08 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Lambert_Azimuthal_Equal_Area", "metre",
        "Y", "North", "X", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LAEA Europe\",GEOGCS[\"PTRA08\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_Azimut");
    add_srs_wkt (p, 8,
        "hal_Equal_Area\"],PARAMETER[\"latitude_of_center\",52],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"longitude_of_center\",10],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",4321000],PARAMETER[\"false_northing\",3210000],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"X\",EAST],AUTHORITY[\"EPSG\",\"5633\"]]");
    p = add_epsg_def_ex (filter, first, last, 5634, "epsg", 5634,
        "REGCAN95 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LCC Europe\",GEOGCS[\"REGCAN95\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_2\",65],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",52],PARAMETER[\"central_meridian\",10],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",4000000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"5634\"]]");
    p = add_epsg_def_ex (filter, first, last, 5635, "epsg", 5635,
        "REGCAN95 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LAEA Europe\",GEOGCS[\"REGCAN95\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Azimutha");
    add_srs_wkt (p, 8,
        "l_Equal_Area\"],PARAMETER[\"latitude_of_center\",52],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"longitude_of_center\",10],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",4321000],PARAMETER[\"false_northing\",3210000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5635\"]]");
    p = add_epsg_def_ex (filter, first, last, 5636, "epsg", 5636,
        "TUREF / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Lambert_Azimuthal_Equal_Area", "metre",
        "Y", "North", "X", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LAEA Europe\",GEOGCS[\"TUREF\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Turkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Azimuthal_E");
    add_srs_wkt (p, 8,
        "qual_Area\"],PARAMETER[\"latitude_of_center\",52],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"longitude_of_center\",10],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",4321000],PARAMETER[\"false_northing\",3210000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"X\",EAST],AUTHORITY[\"EPSG\",\"5636\"]]");
    p = add_epsg_def_ex (filter, first, last, 5637, "epsg", 5637,
        "TUREF / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LCC Europe\",GEOGCS[\"TUREF\",DATUM[\"T");
    add_srs_wkt (p, 1,
        "urkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",35],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",65],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 10,
        "rigin\",52],PARAMETER[\"central_meridian\",10],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",4000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"5637\"]]");
    p = add_epsg_def_ex (filter, first, last, 5638, "epsg", 5638,
        "ISN2004 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "Lambert_Azimuthal_Equal_Area", "metre",
        "Y", "North", "X", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LAEA Europe\",GEOGCS[\"ISN2004\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"5324\"]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_center\",52],PARAMETER[\"longit");
    add_srs_wkt (p, 9,
        "ude_of_center\",10],PARAMETER[\"false_easting\",4321000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",3210000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",NORTH],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"5638\"]]");
    p = add_epsg_def_ex (filter, first, last, 5639, "epsg", 5639,
        "ISN2004 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LCC Europe\",GEOGCS[\"ISN2004\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "5324\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",35],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",65],PARAMETER[\"latitude_of_origin\",52],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",10],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",4000000],PARAMETER[\"false_northing\",2800000],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5639\"]]");
    p = add_epsg_def_ex (filter, first, last, 5641, "epsg", 5641,
        "SIRGAS 2000 / Brazil Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Mercator_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=-43 +lat_ts=-2 +x_0=5000000 +y_0=10000");
    add_proj4text (p, 1,
        "000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Mercator\",GEOGCS[\"SIRGAS");
    add_srs_wkt (p, 1,
        " 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_l");
    add_srs_wkt (p, 2,
        "as_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 8,
        "74\"]],PROJECTION[\"Mercator_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",-2],PARAMETER[\"central_meridian\",-43],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",5000000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5641\"]]");
    p = add_epsg_def_ex (filter, first, last, 5643, "epsg", 5643,
        "ED50 / SPBA LCC", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=52.66666666666666 +lat_2=54.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=48 +lon_0=10 +x_0=815000 +y_0=0 +ellps=intl +");
    add_proj4text (p, 2,
        "towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / SPBA LCC\",GEOGCS[\"ED50\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Datum_1950\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4230\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",52.66666666666666],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",54.33333333333334],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",48],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",10],PARAMETER[\"false_easting\",815000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"5643\"]]");
    p = add_epsg_def_ex (filter, first, last, 5644, "epsg", 5644,
        "RGR92 / UTM zone 39S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGR92 / UTM zone 39S\",GEOGCS[\"RGR92\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_de_la_Reunion_1992\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6627\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4627\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",51],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"5644\"]]");
    p = add_epsg_def_ex (filter, first, last, 5646, "epsg", 5646,
        "NAD83 / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Vermont (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-72.5],PARAMETER[\"scale_factor\",0.999964");
    add_srs_wkt (p, 10,
        "286],PARAMETER[\"false_easting\",1640416.6667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5646\"]]");
    p = add_epsg_def_ex (filter, first, last, 5649, "epsg", 5649,
        "ETRS89 / UTM zone 31N (zE-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",3],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9996],PARAMETER[\"false_easting\",31500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"5649\"]]");
    p = add_epsg_def_ex (filter, first, last, 5650, "epsg", 5650,
        "ETRS89 / UTM zone 33N (zE-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",33500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5650\"]]");
    p = add_epsg_def_ex (filter, first, last, 5651, "epsg", 5651,
        "ETRS89 / UTM zone 31N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",3],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9996],PARAMETER[\"false_easting\",31500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"5651\"]]");
    p = add_epsg_def_ex (filter, first, last, 5652, "epsg", 5652,
        "ETRS89 / UTM zone 32N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9996],PARAMETER[\"false_easting\",32500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"5652\"]]");
    p = add_epsg_def_ex (filter, first, last, 5653, "epsg", 5653,
        "ETRS89 / UTM zone 33N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",33500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"5653\"]]");
    p = add_epsg_def_ex (filter, first, last, 5654, "epsg", 5654,
        "NAD83(HARN) / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Vermont (ftUS)\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "42.5],PARAMETER[\"central_meridian\",-72.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999964286],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "1640416.6667],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"5654\"]]");
    p = add_epsg_def_ex (filter, first, last, 5655, "epsg", 5655,
        "NAD83(NSRS2007) / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Vermont (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",42.5],PARAMETER[\"central_meridian\",-72");
    add_srs_wkt (p, 10,
        ".5],PARAMETER[\"scale_factor\",0.999964286],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1640416.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"5655\"]]");
    p = add_epsg_def_ex (filter, first, last, 5659, "epsg", 5659,
        "Monte Mario / TM Emilia-Romagna", 0, 0,
        "International 1924", "Greenwich",
        "Monte_Mario", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=500053 +y_0");
    add_proj4text (p, 1,
        "=-3999820 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-");
    add_proj4text (p, 2,
        "2.917,0.714,-11.68 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario / TM Emilia-Romagna\",GEOGCS[\"Mont");
    add_srs_wkt (p, 1,
        "e Mario\",DATUM[\"Monte_Mario\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4265\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50005");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_northing\",-3999820],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"5659\"]]");
    p = add_epsg_def_ex (filter, first, last, 5663, "epsg", 5663,
        "Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_srs_wkt (p, 4,
        ".844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",3500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"5663\"]]");
    p = add_epsg_def_ex (filter, first, last, 5664, "epsg", 5664,
        "Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",2500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"5664\"]]");
    p = add_epsg_def_ex (filter, first, last, 5665, "epsg", 5665,
        "Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",3500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5665\"]]");
    p = add_epsg_def_ex (filter, first, last, 5666, "epsg", 5666,
        "PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"566");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 5667, "epsg", 5667,
        "PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"566");
    add_srs_wkt (p, 13,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 5668, "epsg", 5668,
        "RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5668\"]]");
    p = add_epsg_def_ex (filter, first, last, 5669, "epsg", 5669,
        "RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",5500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5669\"]]");
    p = add_epsg_def_ex (filter, first, last, 5670, "epsg", 5670,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",3500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"5670\"]]");
    p = add_epsg_def_ex (filter, first, last, 5671, "epsg", 5671,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",12],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",4500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"5671\"]]");
    p = add_epsg_def_ex (filter, first, last, 5672, "epsg", 5672,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",15],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",5500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"5672\"]]");
    p = add_epsg_def_ex (filter, first, last, 5673, "epsg", 5673,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",350");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5673\"]]");
    p = add_epsg_def_ex (filter, first, last, 5674, "epsg", 5674,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",12],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",45");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5674\"]]");
    p = add_epsg_def_ex (filter, first, last, 5675, "epsg", 5675,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",55");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5675\"]]");
    p = add_epsg_def_ex (filter, first, last, 5676, "epsg", 5676,
        "DHDN / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5676\"]]");
    p = add_epsg_def_ex (filter, first, last, 5677, "epsg", 5677,
        "DHDN / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",3500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5677\"]]");
    p = add_epsg_def_ex (filter, first, last, 5678, "epsg", 5678,
        "DHDN / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",4500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5678\"]]");
    p = add_epsg_def_ex (filter, first, last, 5679, "epsg", 5679,
        "DHDN / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",5500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5679\"]]");
    p = add_epsg_def_ex (filter, first, last, 5680, "epsg", 5680,
        "DHDN / 3-degree Gauss-Kruger zone 1 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 1 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5680\"]]");
    p = add_epsg_def_ex (filter, first, last, 5681, "epsg", 5681,
        "DB_REF", 1, 1,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5681\"]]");
    p = add_epsg_def_ex (filter, first, last, 5682, "epsg", 5682,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",6],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",2500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"5682\"]]");
    p = add_epsg_def_ex (filter, first, last, 5683, "epsg", 5683,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",9],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",3500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"5683\"]]");
    p = add_epsg_def_ex (filter, first, last, 5684, "epsg", 5684,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",12],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",4500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"5684\"]]");
    p = add_epsg_def_ex (filter, first, last, 5685, "epsg", 5685,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"5685\"]]");
    p = add_epsg_def_ex (filter, first, last, 5698, "epsg", 5698,
        "RGF93 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RGF93 / Lambert-93 + NGF-IGN69 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"RGF93 / Lambert-93\",GEOGCS[\"RGF93\",DATUM[\"Reseau");
    add_srs_wkt (p, 2,
        "_Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 9,
        "P\"],PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",44],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",46.5],PARAMETER[\"central_meridian\",3],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",700000],PARAMETER[\"false_northing\",660000");
    add_srs_wkt (p, 13,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2154\"]");
    add_srs_wkt (p, 15,
        "],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM[\"Nivellement ");
    add_srs_wkt (p, 16,
        "General de la France - IGN69\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 18,
        "AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5720\"]],AUTHORITY[");
    add_srs_wkt (p, 19,
        "\"EPSG\",\"5698\"]]");
    p = add_epsg_def_ex (filter, first, last, 5699, "epsg", 5699,
        "RGF93 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RGF93 / Lambert-93 + NGF-IGN78 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"RGF93 / Lambert-93\",GEOGCS[\"RGF93\",DATUM[\"Reseau");
    add_srs_wkt (p, 2,
        "_Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 9,
        "P\"],PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",44],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",46.5],PARAMETER[\"central_meridian\",3],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",700000],PARAMETER[\"false_northing\",660000");
    add_srs_wkt (p, 13,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2154\"]");
    add_srs_wkt (p, 15,
        "],VERT_CS[\"NGF-IGN78 height\",VERT_DATUM[\"Nivellement ");
    add_srs_wkt (p, 16,
        "General de la France - IGN78\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5120\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 18,
        "AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5721\"]],AUTHORITY[");
    add_srs_wkt (p, 19,
        "\"EPSG\",\"5699\"]]");
    p = add_epsg_def_ex (filter, first, last, 5700, "epsg", 5700,
        "NZGD2000 / UTM zone 1S", 0, 0,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 1S\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-177],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"5700\"]]");
    p = add_epsg_def_ex (filter, first, last, 5707, "epsg", 5707,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone I + NGF-IGN69 heig");
    add_srs_wkt (p, 1,
        "ht\",PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NT");
    add_srs_wkt (p, 2,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 3,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 4,
        "2936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,3");
    add_srs_wkt (p, 5,
        "20,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 6,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 7,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[");
    add_srs_wkt (p, 8,
        "\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 9,
        "EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 10,
        "SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",0],PARAMETER[\"scale_factor\",0.999877");
    add_srs_wkt (p, 12,
        "341],PARAMETER[\"false_easting\",600000],PARAMETER[\"fal");
    add_srs_wkt (p, 13,
        "se_northing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"27571\"]],VERT_CS[\"NGF-IGN69 height\",VER");
    add_srs_wkt (p, 16,
        "T_DATUM[\"Nivellement General de la France - IGN69\",200");
    add_srs_wkt (p, 17,
        "5,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"5720\"]],AUTHORITY[\"EPSG\",\"5707\"]]");
    p = add_epsg_def_ex (filter, first, last, 5708, "epsg", 5708,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone IV + NGF-IGN78 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 5,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 6,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 7,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 8,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 10,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 12,
        ".99994471],PARAMETER[\"false_easting\",234.358],PARAMETE");
    add_srs_wkt (p, 13,
        "R[\"false_northing\",4185861.369],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"27574\"]],VERT_CS[\"NGF-IGN78 h");
    add_srs_wkt (p, 16,
        "eight\",VERT_DATUM[\"Nivellement General de la France - ");
    add_srs_wkt (p, 17,
        "IGN78\",2005,AUTHORITY[\"EPSG\",\"5120\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 18,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORI");
    add_srs_wkt (p, 19,
        "TY[\"EPSG\",\"5721\"]],AUTHORITY[\"EPSG\",\"5708\"]]");
    p = add_epsg_def_ex (filter, first, last, 5825, "epsg", 5825,
        "AGD66 / ACT Standard Grid", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-35.31773627777778 +lon_0=149.0092948");
    add_proj4text (p, 1,
        "305555 +k=1.000086 +x_0=200000 +y_0=600000 +ellps=aust_S");
    add_proj4text (p, 2,
        "A +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0");
    add_proj4text (p, 3,
        ".29 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / ACT Standard Grid\",GEOGCS[\"AGD66\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"Austra");
    add_srs_wkt (p, 2,
        "lian National Spheroid\",6378160,298.25,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.4");
    add_srs_wkt (p, 4,
        "46,0.234,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 7,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",-35.31773627777778],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"central_meridian\",149.0092948305555],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"scale_factor\",1.000086],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "200000],PARAMETER[\"false_northing\",600000],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5825\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5832, "epsg", 5832,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 2 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 2 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",6],PARAMETER[\"scale_");
    add_srs_wkt (p, 11,
        "factor\",1],PARAMETER[\"false_easting\",2500000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"5682\"]],VERT_CS[\"DHHN92 h");
    add_srs_wkt (p, 15,
        "eight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",20");
    add_srs_wkt (p, 16,
        "05,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5783\"]],AUTHORITY[\"EPSG\",\"5832\"]]");
    p = add_epsg_def_ex (filter, first, last, 5833, "epsg", 5833,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 3 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 3 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_");
    add_srs_wkt (p, 11,
        "factor\",1],PARAMETER[\"false_easting\",3500000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"5683\"]],VERT_CS[\"DHHN92 h");
    add_srs_wkt (p, 15,
        "eight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",20");
    add_srs_wkt (p, 16,
        "05,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5783\"]],AUTHORITY[\"EPSG\",\"5833\"]]");
    p = add_epsg_def_ex (filter, first, last, 5834, "epsg", 5834,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 4 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 4 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"scale");
    add_srs_wkt (p, 11,
        "_factor\",1],PARAMETER[\"false_easting\",4500000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"5684\"]],VERT_CS[\"DHHN92 h");
    add_srs_wkt (p, 15,
        "eight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",20");
    add_srs_wkt (p, 16,
        "05,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5783\"]],AUTHORITY[\"EPSG\",\"5834\"]]");
    p = add_epsg_def_ex (filter, first, last, 5835, "epsg", 5835,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 5 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 5 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 11,
        "_factor\",1],PARAMETER[\"false_easting\",5500000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"5685\"]],VERT_CS[\"DHHN92 h");
    add_srs_wkt (p, 15,
        "eight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",20");
    add_srs_wkt (p, 16,
        "05,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5783\"]],AUTHORITY[\"EPSG\",\"5835\"]]");
    p = add_epsg_def_ex (filter, first, last, 5836, "epsg", 5836,
        "Yemen NGN96 / UTM zone 37N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 37N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"5836\"]]");
    p = add_epsg_def_ex (filter, first, last, 5837, "epsg", 5837,
        "Yemen NGN96 / UTM zone 40N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 40N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",57],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"5837\"]]");
    p = add_epsg_def_ex (filter, first, last, 5839, "epsg", 5839,
        "Peru96 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Peru96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 17S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5373\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-81],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",10000000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 13,
        "839\"]]");
    p = add_epsg_def_ex (filter, first, last, 5842, "epsg", 5842,
        "WGS 84 / TM 12 SE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 12 SE\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",12],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"5842\"]]");
    p = add_epsg_def_ex (filter, first, last, 5844, "epsg", 5844,
        "RGRDC 2005 / Congo TM zone 30", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 30\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",30],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9999],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"5844\"]]");
    p = add_epsg_def_ex (filter, first, last, 5845, "epsg", 5845,
        "SWEREF99 TM", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 TM + RH2000 height\",PROJCS[\"SWEREF");
    add_srs_wkt (p, 1,
        "99 TM\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"661");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"3006\"]],VERT_CS[\"RH2000 height");
    add_srs_wkt (p, 14,
        "\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 16,
        "\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613\"]]");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"5845\"]]");
    p = add_epsg_def_ex (filter, first, last, 5846, "epsg", 5846,
        "SWEREF99 12 00", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 12 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 12 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",12],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",150000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"3007\"]],VERT_CS[\"RH2000 hei");
    add_srs_wkt (p, 14,
        "ght\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"5846\"]]");
    p = add_epsg_def_ex (filter, first, last, 5847, "epsg", 5847,
        "SWEREF99 13 30", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 13 30 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 13 30\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",13.5],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",150000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"3008\"]],VERT_CS[\"RH2000 he");
    add_srs_wkt (p, 14,
        "ight\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613");
    add_srs_wkt (p, 17,
        "\"]],AUTHORITY[\"EPSG\",\"5847\"]]");
    p = add_epsg_def_ex (filter, first, last, 5848, "epsg", 5848,
        "SWEREF99 15 00", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 15 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 15 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",150000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"3009\"]],VERT_CS[\"RH2000 hei");
    add_srs_wkt (p, 14,
        "ght\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"5848\"]]");
    p = add_epsg_def_ex (filter, first, last, 5849, "epsg", 5849,
        "SWEREF99 16 30", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 16 30 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 16 30\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",16.5],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",150000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"3010\"]],VERT_CS[\"RH2000 he");
    add_srs_wkt (p, 14,
        "ight\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613");
    add_srs_wkt (p, 17,
        "\"]],AUTHORITY[\"EPSG\",\"5849\"]]");
    p = add_epsg_def_ex (filter, first, last, 5850, "epsg", 5850,
        "SWEREF99 18 00", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 18 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 18 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",18],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",150000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"3011\"]],VERT_CS[\"RH2000 hei");
    add_srs_wkt (p, 14,
        "ght\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5613\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"5850\"]]");
    p = add_epsg_def_ex (filter, first, last, 5851, "epsg", 5851,
        "SWEREF99 14 15", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 14 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 14 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",14.25],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3012\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5851\"]]");
    p = add_epsg_def_ex (filter, first, last, 5852, "epsg", 5852,
        "SWEREF99 15 45", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 15 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 15 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",15.75],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3013\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5852\"]]");
    p = add_epsg_def_ex (filter, first, last, 5853, "epsg", 5853,
        "SWEREF99 17 15", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 17 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 17 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",17.25],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3014\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5853\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

