/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [sysbase0.h]                Standard Definitions ( Part 0 )                */
/*                                                                            */
/* Copyright (c) 1993 by D\olle, Manns                                        */
/* -------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef sysbase0_INCL
#define sysbase0_INCL


#include "styconf0.h"
#include "syscbhdl.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ---------------------- Global Types -------------------------------------- */

#ifdef _MSDOS
typedef long     INT;
typedef long     LONG_INT;
#define __FAR    __far
#define __HUGE   __huge
typedef void     __HUGE *HugeCPtr;
#else
typedef int      INT;
typedef long     int LONG_INT;
#define __FAR
#define __HUGE
#define HugeCPtr StdCPtr
#define NewHMem  NewMem
#define FreeHMem FreeMem
#endif

typedef void *StdCPtr;

#if !defined( __GNUC__ )
typedef signed char      c_int8;
typedef signed short     c_int16;
typedef signed long      c_int32;
typedef unsigned char    c_uint8;
typedef unsigned short   c_uint16;
typedef unsigned long    c_uint32;
#if defined(STYX_CONFIG_OSMS) && defined(_INTEGRAL_MAX_BITS) && _INTEGRAL_MAX_BITS >= 64
#define STYX_CONFIG_TINT64
typedef signed   __int64 c_int64;
typedef unsigned __int64 c_uint64;
#endif
#else /*__GNUC__*/
#define STYX_CONFIG_TINT64
typedef int8_t           c_int8;
typedef int16_t          c_int16;
typedef int32_t          c_int32;
typedef int64_t          c_int64;
typedef u_int8_t         c_uint8;
typedef u_int16_t        c_uint16;
typedef u_int32_t        c_uint32;
typedef u_int64_t        c_uint64;
#endif

#define ConcreteImp(Name)  struct Name##_imp
#define ConcreteDecl(Name) typedef ConcreteImp(Name) *Name
#define ConcreteType(Name) typedef ConcreteImp(Name) *Name; ConcreteImp(Name)
#define SizeOf(Name)       sizeof(ConcreteImp(Name))

#define ExternalType(TYPENAME) ConcreteType(TYPENAME)
#define ExternalDecl(TYPENAME) ConcreteDecl(TYPENAME)

#define AbstractType(TYPENAME) typedef StdCPtr TYPENAME

#define AbstractHugeType( TYPENAME ) \
typedef HugeCPtr TYPENAME

#define Tupel( TYPENAME ) \
struct TYPENAME

AbstractType( Abs_T );
AbstractType( Any_T );

#define ABS_CAST(t,a) ((t)(long)(a))
#define intCAST(a) ABS_CAST(int,a)

/*NOCONVERSION*/
typedef unsigned char  c_byte;
typedef unsigned short c_word;
#ifndef __cplusplus
typedef c_byte byte;
typedef c_word word;
#endif

/*NOCONVERSION*/
#define c_bool  int
#define C_False 0
#define C_True  1
#ifndef __cplusplus
#define bool  c_bool
#define False C_False
#define True  C_True
#endif

/*NOCONVERSION*/
typedef c_byte           *c_bstring; /* sizeof(long) Bytes Len, Len Bytes */
typedef char             *c_string;
#ifndef __cplusplus
typedef c_string          string;
#endif
#if defined(WEOF)
typedef wint_t            wc_int;
typedef wchar_t           wc_char;
typedef wchar_t          *wc_string;
#define WCHAR_LITERAL(c) L##c
#else
typedef unsigned long     wc_int;
typedef unsigned long     wc_char;
typedef unsigned long    *wc_string;
#define WCHAR_LITERAL(c) ((unsigned long)c)
#endif

#define OBJ_REF(obj)    ( &(obj) )
#define REF_OBJ(objref) ( *(objref) )
#define _               (NULL)

#define STD_BUFFLEN 512
#define ERR_BUFFLEN 4096

#define _NO_DLL_EXPORT_
#if defined( _MSDOS ) || defined( _WIN32 )
#define _DLL_EXPORT_DECL_   extern __declspec( dllexport )
#define _DLL_EXPORT_        __declspec( dllexport )
#define _DLL_IMPORT_        __declspec( dllimport )
#define _C_DECL_            __cdecl
#else
#define _DLL_EXPORT_DECL_   extern
#define _DLL_EXPORT_
#define _DLL_IMPORT_
#define _C_DECL_
#endif

/* -------------------- CommandLine I/O & Exception ------------------------- */

FILE* StdOutFile(void)
#define STDOUT StdOutFile()
/* stdout */
;

FILE* StdErrFile(void)
#define STDERR StdErrFile()
/* stderr */
;

void fprint_raw(FILE* fp, c_string s, size_t size)
/* prints string 's' in a printable form to file 'fp'
   'size' >= 0: number of characters to print
*/
;

void prMsg_stdout(c_string s)
/* prints string 's' in a printable form to stdout */
;

void prMsg_stderr(c_string s)
/* prints string 's' in a printable form to stderr */
;

void AbortApp(c_string errmsg)
#define STD_ERREXIT AbortApp("")
/* aborts application with error message 'errmsg' */
;

PHDL_TRAP  getTrapHdl(void);                   /* gets the trap handler     */

void setTrapHdl(PHDL_TRAP h_trap)
/* sets a trap handler
   ( xaron error callback )
*/
;

PHDL_ABORT getErrExitHdl(void);                /* gets the abort handler    */
void       setErrExitHdl(PHDL_ABORT h_abort);  /* sets an abort handler     */

PHDL_FREEMEM getFreeMemHdl(void)
/* gets the handler to organize free memory from heap */
;

void setFreeMemHdl(PHDL_FREEMEM h_freemem)
/* sets a handler to organize free memory from heap */
;

void       initStdFiles(FILE* out, FILE* err); /* overwrites stdout, stderr */
void       quitStdFiles(void);                 /* resets stdout, stderr     */

/* -------------------- Thread/Process Synchronisation ---------------------- */

StdCPtr initSem(c_string id, int maxcnt, int initcnt)
/* creates or opens semaphore 'id [NULL]' to synchronize
   a maximum of 'maxcnt' concurrent threads
   with an initial value of 'initcnt'
   RC: semaphore or NULL
   non-MS: 'id', 'maxcnt' not used
*/
;

c_bool quitSem(StdCPtr sem)
/* closes and - on OK - destroys semaphore 'sem'
   RC: True=OK
*/
;

int waitSem(StdCPtr sem)
/*
   waits and enters critical section 'sem' ( blocking )
   RC: 1=OK, 0=occupied, -1=error
*/
;

int trySem(StdCPtr sem)
/*
   tries to enter critical section 'sem' ( non-blocking )
   RC: 1=OK, 0=occupied, -1=error
*/
;

c_bool postSem(StdCPtr sem, int cnt)
/*
   leaves critical section 'sem' and releases 'cnt' resources
   RC: True=OK
   non-MS: 'cnt' not used (=1)
*/
;


/* -------------------- Error Handling -------------------------------------- */

typedef void (*PF_ERROR)(c_bool cond, c_string format, ...);

void ForceCore(void)
/* since we didn't find an appropriate function in the c-lib */
;

PF_ERROR _AssCheck(c_string kind, c_string file, int line)
/* saves assertion type, source position and
   returns assert function
*/
;


#define c_assert (*(_AssCheck("Restriction error",__FILE__,__LINE__)))
#define c_bug    (*(_AssCheck("Internal error",   __FILE__,__LINE__)))
#define C_BUG    c_bug(C_False,"")
#ifndef __cplusplus
#define assert   c_assert
#define bug      c_bug
#define BUG      C_BUG
#endif

#define assert0(cond,txt)     ((!(cond)) ? (c_assert(C_False,(txt)),0):0)
#define assert1(cond,txt,a1)  ((!(cond)) ? (c_assert(C_False,(txt),(a1)),0):0)
#define assert2(cond,txt,a,b) ((!(cond)) ? (c_assert(C_False,(txt),(a),(b)),0):0)
#define bug0(cond,txt)        ((!(cond)) ? (c_bug(C_False,(txt)),0):0)
#define bug1(cond,txt,a1)     ((!(cond)) ? (c_bug(C_False,(txt),(a1)),0):0)
#define bug2(cond,txt,a,b)    ((!(cond)) ? (c_bug(C_False,(txt),(a),(b)),0):0)
#define BUG_NULL(obj)         bug0( (StdCPtr)(obj) != (StdCPtr)NULL, \
                                    "Null Object" )
#define BUG_VRNG(val,min,max) bug0( (val) >= (min) && (val) <= (max), \
                                    "Value out of Range" )
#define BUG_RNG0(val,max)     BUG_VRNG((val),0,(max)-1)
#define BUG_RNG1(val,max)     BUG_VRNG((val),1,(max))
#define BUG_VMIN(val,min)     bug0( (val) > (min), "Value below Minimum" )
#define BUG_VEQU(lft,rgt)     bug0( (lft) == (rgt), "Values not equal" )
#define BUG_VNEQ(lft,rgt)     bug0( (lft) != (rgt), "Values equal" )
#define BUG_MOD0(lft,rgt)     bug0( (rgt) > 0 && ! ( (lft) % (rgt) ), \
                                    "Non Zero Modulo" )

/*  
   Usage of the macros 'assert', 'bug':
   assert | bug ( condition, which has to be true,
                  message format string ( see printf ),
                  any further parameter, according to the above format string );
*/

/* ---------------------------- System-Init & Quit -------------------------- */

void    sysbase_init(void);     /* initializes module ( for thread-savety ) */
void    sysbase_quit(void);     /* terminates module ( for thread-savety )  */
StdCPtr sysbase_sem(void);      /* system semaphore ( for thread-savety )   */

/* ---------------------------- Global Macros ------------------------------- */

#define I32_HIGHVAL(v)    ( (short)(((long)(v)) >> 16) )
#define I32_LOWVAL(v)     ( (short)(((long)(v)) & 0xFFFFL) )
#define SET_I32_VAL(h,l)  ( ((((long)(h)) << 16) & 0xFFFF0000L) | \
                            (((long)(l)) & 0x0000FFFFL) )

#define STR_EMPTY(s)      ( (s) == (c_string)NULL || *(s) == '\0' )
#define INRANGE(a,x,b)    ( ( (a) <= (x) ) && ( (x) <= (b) ) )
#define ABS(x)            ( (x) < 0 ? - (x) : (x) )
#define MAX(a,b)          ( (a) < (b) ? (b) : (a) )
#define MIN(a,b)          ( (a) < (b) ? ( a ) : (b) )
#define EQSIGN(a,b)       ( ( ( (a) <= 0 ) && ( (b) <= 0 ) ) || \
                            ( ( (a) >= 0 ) && ( (b) >= 0 ) ) )

#define FTAB(F,N)    fprintf(F,"\n%*s",N,"")
#define FNLIND(F)    FTAB(F,indent)
#define FNL(F)       fprintf(F,"\n")
#define TAB(N)       FTAB(STDOUT,N)
#define NLIND        TAB(indent)
#define NL           FNL(STDOUT)
#define FPCHR(F,C)   fprintf(F,"%c",C)
#define PCHR(C)      FPCHR(STDOUT,C)
#define FPNLSNL(F,S) fprintf(F,"\n%s\n",S)
#define PNLSNL(F,S)  FPNLSNL(STDOUT,S)
#define HERE         fprintf(STDOUT,"File: %s, Line: %d\n",__FILE__,__LINE__)


#ifdef __cplusplus
}
#endif

#endif
