
[//000000001]: # (fileutil::multi::op \- file utilities)
[//000000002]: # (Generated from file 'multiop\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (fileutil::multi::op\(n\) 0\.5\.4 tcllib "file utilities")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

fileutil::multi::op \- Multi\-file operation, scatter/gather

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [CLASS API](#section2)

  - [OBJECT API](#section3)

  - [FILE API](#section4)

  - [EXAMPLES](#section5)

  - [Bugs, Ideas, Feedback](#section6)

  - [Keywords](#keywords)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require fileutil::multi::op ?0\.5\.4?  
package require wip ?1\.0?  

[__::fileutil::multi::op__ ?*opName*? ?*word*\.\.\.?](#1)  
[__opName__ *option* ?*arg arg \.\.\.*?](#2)  
[__$opName__ __do__ ?*word*\.\.\.?](#3)  
[__into__ *directory*](#4)  
[__in__ *directory*](#5)  
[__to__ *directory*](#6)  
[__from__ *directory*](#7)  
[__not__ *pattern*](#8)  
[__for__ *pattern*](#9)  
[__exclude__ *pattern*](#10)  
[__but__](#11)  
[__except__](#12)  
[__as__ *name*](#13)  
[__recursive__](#14)  
[__recursively__](#15)  
[__[copy](\.\./\.\./\.\./\.\./index\.md\#copy)__](#16)  
[__[move](\.\./\.\./\.\./\.\./index\.md\#move)__](#17)  
[__[remove](\.\./\.\./\.\./\.\./index\.md\#remove)__](#18)  
[__expand__](#19)  
[__invoke__ *cmdprefix*](#20)  
[__reset__](#21)  
[__\(__](#22)  
[__\)__](#23)  
[__cd__ *directory*](#24)  
[__up__](#25)  
[__for\-windows__](#26)  
[__for\-win__](#27)  
[__for\-unix__](#28)  
[__the__ *pattern*](#29)  
[__the\-set__ *varname*](#30)  
[__\->__ *varname*](#31)  
[__strict__](#32)  
[__\!strict__](#33)  
[__files__](#34)  
[__links__](#35)  
[__directories__](#36)  
[__dirs__](#37)  
[__all__](#38)  
[__state?__](#39)  
[__as?__](#40)  
[__excluded?__](#41)  
[__from?__](#42)  
[__into?__](#43)  
[__operation?__](#44)  
[__recursive?__](#45)  
[__strict?__](#46)  
[__type?__](#47)  

# <a name='description'></a>DESCRIPTION

This package provides objects which are able to perform actions on multiple
files selected by glob patterns\.

At the core is a domain specific language allowing the easy specification of
multi\-file copy and/or move and/or deletion operations\. Alternate names would be
scatter/gather processor, or maybe even assembler\.

# <a name='section2'></a>CLASS API

The main command of the package is:

  - <a name='1'></a>__::fileutil::multi::op__ ?*opName*? ?*word*\.\.\.?

    The command creates a new multi\-file operation object with an associated
    global Tcl command whose name is *opName*\. This command can be used to
    invoke the various possible file operations\. It has the following general
    form:

      * <a name='2'></a>__opName__ *option* ?*arg arg \.\.\.*?

        *Option* and the *arg*s determine the exact behavior of the command\.

    If the string __%AUTO%__ is used as the *opName* then the package will
    generate a unique name on its own\.

    If one or more *word*s are specified they are interpreted as an initial
    set of file commands to execute\. I\.e\. the method __do__ of the newly
    constructed object is implicitly invoked using the words as its arguments\.

# <a name='section3'></a>OBJECT API

The following methods are possible for multi\-file operation objects:

  - <a name='3'></a>__$opName__ __do__ ?*word*\.\.\.?

    This method interprets the specified words as file commands to execute\. See
    the section [FILE API](#section4) for the set of acceptable commands,
    their syntax, and semantics\.

    The result of the method is the result generated by the last file command it
    executed\.

# <a name='section4'></a>FILE API

Both object constructor and method __do__ take a list of words and interpret
them as file commands to execute\. The names were chosen to allow the
construction of operations as sentences in near\-natural language\. Most of the
commands influence just the state of the object, i\.e\. are simply providing the
configuration used by the command triggering the actual action\.

  - <a name='4'></a>__into__ *directory*

    Specifies the destination directory for operations\.

  - <a name='5'></a>__in__ *directory*

    Alias for __into__\.

  - <a name='6'></a>__to__ *directory*

    Alias for __into__\.

  - <a name='7'></a>__from__ *directory*

    Specifies the source directory for operations\.

  - <a name='8'></a>__not__ *pattern*

    Specifies a glob pattern for paths to be excluded from the operation\.

  - <a name='9'></a>__for__ *pattern*

    Alias for __not__\.

  - <a name='10'></a>__exclude__ *pattern*

    Alias for __not__\.

  - <a name='11'></a>__but__

    Has no arguments of its own, but looks ahead in the list of words and
    executes all __not__ commands immediately following it\. This allows the
    construction of "but not" and "but exclude" clauses for a more natural
    sounding specification of excluded paths\.

  - <a name='12'></a>__except__

    A semi\-alias for __but__\. Has no arguments of its own, but looks ahead
    in the list of words and executes all __for__ commands immediately
    following it\. This allows the construction of "except for" clauses for a
    more natural sounding specification of excluded paths\.

  - <a name='13'></a>__as__ *name*

    Specifies a new name for the first file handled by the current operation\.
    I\.e\. for the renaming of a single file during the operation\.

  - <a name='14'></a>__recursive__

    Signals that file expansion should happen in the whole directory hierarchy
    and not just the directory itself\.

  - <a name='15'></a>__recursively__

    An alias for __recursive__\.

  - <a name='16'></a>__[copy](\.\./\.\./\.\./\.\./index\.md\#copy)__

    Signals that the operation is the copying of files from source to
    destination directory per the specified inclusion and exclusion patterns\.

  - <a name='17'></a>__[move](\.\./\.\./\.\./\.\./index\.md\#move)__

    Signals that the operation is the moving of files from source to destination
    directory per the specified inclusion and exclusion patterns\.

  - <a name='18'></a>__[remove](\.\./\.\./\.\./\.\./index\.md\#remove)__

    Signals that the operation is the removal of files in the destination
    directory per the specified inclusion and exclusion patterns\.

  - <a name='19'></a>__expand__

    Signals that there is no operation but the calculation of the set of files
    from the include and exclude patterns\. This operation is not available if
    __the\-set__ is used\.

  - <a name='20'></a>__invoke__ *cmdprefix*

    Signals that the user\-specified command prefix *cmdprefix* is the
    operation to perform\. The command prefix is executed at the global level and
    given the source directory, destination directory, and set of files \(as
    dictionary mapping from source to destination files\), in this order\.

  - <a name='21'></a>__reset__

    Forces the object into the ground state where all parts of the configuration
    have default values\.

  - <a name='22'></a>__\(__

    Saves a copy of the current object state on a stack\.

  - <a name='23'></a>__\)__

    Takes the state at the top of the state stack and restores it, i\.e\. makes it
    the new current object state\.

  - <a name='24'></a>__cd__ *directory*

    Changes the destination directory to the sub\-directory *directory* of the
    current destination\.

  - <a name='25'></a>__up__

    Changes the destination directory to the parent directory of the current
    destination\.

  - <a name='26'></a>__for\-windows__

    Checks that Windows is the current platform\. Aborts processing if not\.

  - <a name='27'></a>__for\-win__

    An alias for __for\-windows__\.

  - <a name='28'></a>__for\-unix__

    Checks that Unix is the current platform\. Aborts processing if not\.

  - <a name='29'></a>__the__ *pattern*

    This command specifies the files to operate on per a glob pattern, and is
    also the active element, i\.e\. the command which actually performs the
    specified operation\. All the other commands only modified the object state
    to set the operation up, but di nothing else\.

    To allow for a more natural sounding syntax this command also looks ahead in
    the list of words looks and executes several commands immediately following
    it before performing its own actions\. These commands are __as__,
    __but__, __exclude__, __except__, __from__, and __into__
    \(and aliases\)\. That way these commands act like qualifiers, and still take
    effect as if they had been written before this command\.

    After the operation has been performed the object state the exclude patterns
    and the alias name, if specified, are reset to their default values \(i\.e\.
    empty\), but nothing else\.

  - <a name='30'></a>__the\-set__ *varname*

    Like __the__, however the set of files to use is not specified
    implicitly per a glob pattern, but contained and loaded from the specified
    variable\. The operation __expand__ is not available if this command is
    used\.

  - <a name='31'></a>__\->__ *varname*

    Saves the set of files from the last expansion into the specified variable\.

  - <a name='32'></a>__strict__

    Make file expansion and definition of destination directory \(__in__ and
    aliases\) strict, i\.e\. report errors for missing directories, and empty
    expansion\.

  - <a name='33'></a>__\!strict__

    Complement of __strict__\. A missing destination directory or empty
    expansion are not reported as errors\.

  - <a name='34'></a>__files__

    Limit the search to files\. Default is to accept every type of path\.

  - <a name='35'></a>__links__

    Limit the search to symbolic links\. Default is to accept every type of path\.

  - <a name='36'></a>__directories__

    Limit the search to directories\. Default is to accept every type of path\.

  - <a name='37'></a>__dirs__

    An alias for __directories__\.

  - <a name='38'></a>__all__

    Accept all types of paths \(default\)\.

  - <a name='39'></a>__state?__

    Returns the current state of the object as dictionary\. The dictionary keys
    and their meanings are:

      * __as__

        Last setting made by __as__\.

      * __excluded__

        List of currently known exclusion patterns\.

      * __from__

        Current source directory, set by __from__\.

      * __into__

        Current destination directory, set by __into__ \(and aliases\)\.

      * __operation__

        Current operation to perform, set by
        __[copy](\.\./\.\./\.\./\.\./index\.md\#copy)__,
        __[move](\.\./\.\./\.\./\.\./index\.md\#move)__,
        __[remove](\.\./\.\./\.\./\.\./index\.md\#remove)__, __expand__, or
        __invoke__\.

      * __recursive__

        Current recursion status\. Set/unset by __recursive__ and
        __\!recursive__\.

      * __strict__

        Current strictness\. Set/unset by __strict__ and __\!strict__\.

      * __type__

        Current path type limiter\. Set by either __files__,
        __directories__, __links__, or __all__\.

  - <a name='40'></a>__as?__

    Returns the current alias name\.

  - <a name='41'></a>__excluded?__

    Returns the current set of exclusion patterns\.

  - <a name='42'></a>__from?__

    Returns the current source directory\.

  - <a name='43'></a>__into?__

    Returns the current destination directory\.

  - <a name='44'></a>__operation?__

    Returns the current operation to perform\.

  - <a name='45'></a>__recursive?__

    Returns the current recursion status\.

  - <a name='46'></a>__strict?__

    Returns the current strictness\.

  - <a name='47'></a>__type?__

    Returns the current path type limiter\.

# <a name='section5'></a>EXAMPLES

The following examples assume that the variable __F__ contains a reference
to a multi\-file operation object\.

        $F do copy                       \
    	the  *.dll                    \
    	from c:/TDK/PrivateOpenSSL/bin \
    	to   [installdir_of tls]

        $F do move      \
    	the  *       \
    	from /sources \
    	into /scratch  \
    	but not *.html

        # Alternatively use 'except for *.html'.

        $F do           \
    	move         \
    	the  index    \
    	from /sources  \
    	into /scratch   \
    	as   pkgIndex.tcl

        $F do         \
    	remove     \
    	the *.txt  \
    	in /scratch

Note that the fact that most commands just modify the object state allows us to
use more off forms as specifications instead of just nearly\-natural language
sentences\. For example the second example in this section can re\-arranged into:

        $F do            \
    	from /sources \
    	into /scratch  \
    	but not *.html \
    	move           \
    	the  *

and the result is not only still a valid specification, but even stays
relatively readable\.

Further note that the information collected by the commands __but__,
__except__, and __as__ is automatically reset after the associated
__the__ was executed\. However no other state is reset in that manner,
allowing the user to avoid repetitions of unchanging information\. For example
the second and third examples of this section can be merged and rewritten into
the equivalent:

    $F do                   \
        move                 \
        the  *                \
        from /sources          \
        into /scratch           \
        but not *.html not index \
        the  index               \
        as   pkgIndex.tcl

# <a name='section6'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *fileutil* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[copy](\.\./\.\./\.\./\.\./index\.md\#copy), [file
utilities](\.\./\.\./\.\./\.\./index\.md\#file\_utilities),
[move](\.\./\.\./\.\./\.\./index\.md\#move),
[multi\-file](\.\./\.\./\.\./\.\./index\.md\#multi\_file),
[remove](\.\./\.\./\.\./\.\./index\.md\#remove)

# <a name='category'></a>CATEGORY

Programming tools
