/* Copyright 2022 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include "tensorflow/compiler/xla/service/cpu/cpu_shape_verifier.h"

namespace xla {

Status CpuShapeVerifier::Preprocess(HloInstruction* hlo) {
  TF_RETURN_IF_ERROR(ShapeUtil::ForEachSubshapeWithStatus(
      hlo->shape(), [&](const Shape& shape, const ShapeIndex&) {
        if (shape.has_layout()) {
          if (LayoutUtil::IsSparseArray(shape)) {
            return InvalidArgument(
                "The XLA CPU backend does not support sparse shapes: %s",
                hlo->ToString());
          }
          if (shape.layout().element_size_in_bits() != 0) {
            return InvalidArgument(
                "The XLA CPU backend does not support custom element sizes: %s",
                hlo->ToString());
          }
        }
        return OkStatus();
      }));

  return ShapeVerifier::Preprocess(hlo);
}

}  // namespace xla
