#
# Usage:
#
#   TRIL_SET_CACHE_VAR(<varName> <varVal> CACHE <type>)
#
FUNCTION(TRIL_SET_CACHE_VAR  VAR_NAME  VAR_VALUE  CACHE_STR  TYPE_STR)
  IF ("${${VAR_NAME}}" STREQUAL "")
    MESSAGE("-- " "Setting ${VAR_NAME}='${VAR_VALUE}' by default")
    SET(${VAR_NAME} "${VAR_VALUE}" ${CACHE_STR}  ${TYPE_STR}
      "Set in ${CMAKE_CURRENT_LIST_FILE}")
  ENDIF()
ENDFUNCTION()

#
# Usage:
#
#   TRIL_SET_BOOL_CACHE_VAR(<varName> <varVal>)
#
FUNCTION(TRIL_SET_BOOL_CACHE_VAR  VAR_NAME  VAR_VALUE)
  TRIL_SET_CACHE_VAR(${VAR_NAME}  ${VAR_VALUE}  CACHE  BOOL)
ENDFUNCTION()
