/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.hanim;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimHumanoid;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimSite;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBoundedNodeType;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLHAnimHumanoidNodeType;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimJoint;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimSegment;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimSite;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseHAnimHumanoid
extends AbstractNode
implements VRMLChildNodeType,
VRMLBoundedNodeType,
VRMLHAnimHumanoidNodeType {
    protected static final int FIELD_CENTER = 1;
    protected static final int FIELD_ROTATION = 2;
    protected static final int FIELD_SCALE = 3;
    protected static final int FIELD_SCALE_ORIENTATION = 4;
    protected static final int FIELD_TRANSLATION = 5;
    protected static final int FIELD_NAME = 6;
    protected static final int FIELD_INFO = 7;
    protected static final int FIELD_JOINTS = 8;
    protected static final int FIELD_SEGMENTS = 9;
    protected static final int FIELD_SITES = 10;
    protected static final int FIELD_SKELETON = 11;
    protected static final int FIELD_SKIN = 12;
    protected static final int FIELD_SKIN_COORD = 13;
    protected static final int FIELD_SKIN_NORMAL = 14;
    protected static final int FIELD_VERSION = 15;
    protected static final int FIELD_VIEWPOINTS = 16;
    protected static final int FIELD_BBOX_CENTER = 17;
    protected static final int FIELD_BBOX_SIZE = 18;
    protected static final int LAST_HUMANOID_INDEX = 18;
    protected static final int NUM_FIELDS = 19;
    protected static final String INITONLY_FIELD_MSG = "Writing to initialize only field was attempted";
    protected static final String COORD_PROTO_MSG = "Proto does not describe a X3DCoordinateNode object";
    protected static final String COORD_NODE_MSG = "Node does not describe a X3DCoordinateNode object";
    protected static final String NORMAL_PROTO_MSG = "Proto does not describe a X3DNormalNode object";
    protected static final String NORMAL_NODE_MSG = "Node does not describe a X3DNormalNode object";
    protected static final String JOINT_PROTO_MSG = "Proto does not describe a HAnimJoint object";
    protected static final String JOINT_NODE_MSG = "Node does not describe a HAnimJoint object";
    protected static final String SEGMENT_PROTO_MSG = "Proto does not describe a HAnimSegment object";
    protected static final String SEGMENT_NODE_MSG = "Node does not describe a HAnimSegment object";
    protected static final String SITE_PROTO_MSG = "Proto does not describe a HAnimSite object";
    protected static final String SITE_NODE_MSG = "Node does not describe a HAnimSite object";
    protected static final String CHILD_PROTO_MSG = "Proto does not describe a X3DChildNode object";
    protected static final String CHILD_NODE_MSG = "Node does not describe a X3DChildNode object";
    protected static final String VIEWPOINT_PROTO_MSG = "Proto does not describe a Viewpoint object";
    protected static final String VIEWPOINT_NODE_MSG = "Node does not describe a Viewpoint object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    protected String vfName;
    protected VRMLCoordinateNodeType vfSkinCoord;
    protected VRMLProtoInstance pSkinCoord;
    protected VRMLNormalNodeType vfSkinNormal;
    protected VRMLProtoInstance pSkinNormal;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize;
    protected String vfVersion;
    protected String[] vfInfo;
    protected int numInfo;
    protected ArrayList vfJoints;
    protected ArrayList vfSegments;
    protected ArrayList vfSites;
    protected ArrayList vfSkeleton;
    protected ArrayList vfSkin;
    protected ArrayList vfViewpoints;
    protected VRMLNodeType[] nodeTmp;
    protected int shareCount;
    protected HAnimHumanoid hanimImpl;
    protected HAnimFactory hanimFactory;

    public BaseHAnimHumanoid() {
        super("HAnimJoint");
        this.hasChanged = new boolean[19];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfInfo = FieldConstants.EMPTY_MFSTRING;
        this.vfJoints = new ArrayList();
        this.vfSegments = new ArrayList();
        this.vfSites = new ArrayList();
        this.vfSkeleton = new ArrayList();
        this.vfSkin = new ArrayList();
        this.vfViewpoints = new ArrayList();
        this.shareCount = 0;
    }

    public BaseHAnimHumanoid(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        VRMLBoundedNodeType vRMLBoundedNodeType = (VRMLBoundedNodeType)vRMLNodeType;
        float[] fArray = vRMLBoundedNodeType.getBboxCenter();
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
        fArray = vRMLBoundedNodeType.getBboxSize();
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("version");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVersion = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("info");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfInfo.length < vRMLFieldData.numElements) {
                this.vfInfo = new String[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfInfo, 0, vRMLFieldData.numElements);
            this.numInfo = vRMLFieldData.numElements;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void updateMesh() {
        this.hanimImpl.updateSkeleton();
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        Object object;
        int n;
        int n2;
        this.hanimFactory = hAnimFactory;
        int n3 = this.vfSkeleton.size();
        for (n2 = 0; n2 < n3; ++n2) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfSkeleton.get(n2);
            vRMLHAnimNodeType.setHAnimFactory(hAnimFactory);
        }
        n2 = this.vfSites.size();
        for (n = 0; n < n2; ++n) {
            object = (VRMLHAnimNodeType)this.vfSites.get(n);
            object.setHAnimFactory(hAnimFactory);
        }
        this.hanimImpl = hAnimFactory.createHumanoid();
        this.hanimImpl.setErrorReporter(this.errorReporter);
        this.hanimImpl.setName(this.vfName);
        this.hanimImpl.setCenter(this.vfCenter);
        this.hanimImpl.setScale(this.vfScale);
        this.hanimImpl.setRotation(this.vfRotation);
        this.hanimImpl.setTranslation(this.vfTranslation);
        this.hanimImpl.setScaleOrientation(this.vfScaleOrientation);
        this.hanimImpl.setBboxCenter(this.vfBboxCenter);
        this.hanimImpl.setBboxSize(this.vfBboxSize);
        this.hanimImpl.setVersion(this.vfVersion);
        this.hanimImpl.setInfo(this.vfInfo, this.numInfo);
        if (this.vfSkinCoord != null) {
            n = this.vfSkinCoord.getNumPoints();
            object = this.vfSkinCoord.getPointRef();
            this.hanimImpl.setSkinCoord((float[])object, n / 3);
        }
        if (this.vfSkinNormal != null) {
            n = this.vfSkinNormal.getNumNormals();
            object = this.vfSkinNormal.getVectorRef();
            this.hanimImpl.setSkinNormal((float[])object, n / 3);
        }
        HAnimObject[] hAnimObjectArray = new HAnimObject[n3];
        for (int i = 0; i < n3; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfSkeleton.get(i);
            hAnimObjectArray[i] = vRMLHAnimNodeType.getHAnimObject();
        }
        this.hanimImpl.setSkeleton(hAnimObjectArray, n3);
        HAnimSite[] hAnimSiteArray = new HAnimSite[n2];
        for (int i = 0; i < n2; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfSkeleton.get(i);
            hAnimSiteArray[i] = (HAnimSite)vRMLHAnimNodeType.getHAnimObject();
        }
        this.hanimImpl.setSites(hAnimSiteArray, n2);
    }

    public HAnimObject getHAnimObject() {
        return this.hanimImpl;
    }

    public void setupFinished() {
        VRMLNodeType vRMLNodeType;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pSkinCoord != null) {
            this.pSkinCoord.setupFinished();
        } else if (this.vfSkinCoord != null) {
            this.vfSkinCoord.setupFinished();
        }
        if (this.pSkinNormal != null) {
            this.pSkinNormal.setupFinished();
        } else if (this.vfSkinNormal != null) {
            this.vfSkinNormal.setupFinished();
        }
        int n2 = this.vfJoints.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfJoints.get(n);
            vRMLNodeType.setupFinished();
        }
        n2 = this.vfSegments.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfSegments.get(n);
            vRMLNodeType.setupFinished();
        }
        n2 = this.vfSites.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfSites.get(n);
            vRMLNodeType.setupFinished();
        }
        n2 = this.vfSkeleton.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfSkeleton.get(n);
            vRMLNodeType.setupFinished();
        }
        n2 = this.vfSkin.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfSkin.get(n);
            vRMLNodeType.setupFinished();
        }
        n2 = this.vfViewpoints.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfViewpoints.get(n);
            vRMLNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 18) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 77;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 1: {
                vRMLFieldData.floatArrayValue = this.vfCenter;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 2: {
                vRMLFieldData.floatArrayValue = this.vfRotation;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 3: {
                vRMLFieldData.floatArrayValue = this.vfScale;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 4: {
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 5: {
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 6: {
                vRMLFieldData.stringValue = this.vfName;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 15: {
                vRMLFieldData.stringValue = this.vfVersion;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 7: {
                vRMLFieldData.stringArrayValue = this.vfInfo;
                vRMLFieldData.numElements = this.numInfo;
                vRMLFieldData.dataType = (short)14;
                break;
            }
            case 18: {
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 17: {
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 13: {
                vRMLFieldData.nodeValue = this.pSkinCoord != null ? this.pSkinCoord : this.vfSkinCoord;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 14: {
                vRMLFieldData.nodeValue = this.pSkinNormal != null ? this.pSkinNormal : this.vfSkinNormal;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 8: {
                vRMLFieldData.numElements = this.vfJoints.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfJoints.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 9: {
                vRMLFieldData.numElements = this.vfSegments.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfSegments.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 10: {
                vRMLFieldData.numElements = this.vfSites.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfSites.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 11: {
                vRMLFieldData.numElements = this.vfSkeleton.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfSkeleton.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 12: {
                vRMLFieldData.numElements = this.vfSkin.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfSkin.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 16: {
                vRMLFieldData.numElements = this.vfViewpoints.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfViewpoints.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 13: {
                    if (this.pSkinCoord != null) {
                        vRMLNodeType.setValue(n2, this.pSkinCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfSkinCoord);
                    break;
                }
                case 14: {
                    if (this.pSkinNormal != null) {
                        vRMLNodeType.setValue(n2, this.pSkinNormal);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfSkinNormal);
                    break;
                }
                case 8: {
                    int n3 = this.vfJoints.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfJoints.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                case 9: {
                    int n4 = this.vfSegments.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n4) {
                        this.nodeTmp = new VRMLNodeType[n4];
                    }
                    this.vfSegments.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n4);
                    break;
                }
                case 10: {
                    int n5 = this.vfSites.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n5) {
                        this.nodeTmp = new VRMLNodeType[n5];
                    }
                    this.vfSites.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n5);
                    break;
                }
                case 11: {
                    int n6 = this.vfSkeleton.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n6) {
                        this.nodeTmp = new VRMLNodeType[n6];
                    }
                    this.vfSkeleton.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n6);
                    break;
                }
                case 12: {
                    int n7 = this.vfSkin.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n7) {
                        this.nodeTmp = new VRMLNodeType[n7];
                    }
                    this.vfSkin.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n7);
                    break;
                }
                case 16: {
                    int n8 = this.vfViewpoints.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n8) {
                        this.nodeTmp = new VRMLNodeType[n8];
                    }
                    this.vfViewpoints.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n8);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseHAnimHumanoid.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                this.setCenter(fArray);
                break;
            }
            case 2: {
                this.setRotation(fArray);
                break;
            }
            case 3: {
                this.setScale(fArray);
                break;
            }
            case 4: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 5: {
                this.setTranslation(fArray);
                break;
            }
            case 17: {
                this.setBboxCenter(fArray);
                break;
            }
            case 18: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hanimImpl.setName(this.vfName);
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            case 15: {
                this.vfVersion = string;
                if (this.inSetup) break;
                this.hasChanged[15] = true;
                this.fireFieldChanged(15);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 7: {
                if (this.vfInfo.length < n2) {
                    this.vfInfo = new String[n2];
                }
                System.arraycopy(stringArray, 0, this.vfInfo, 0, n2);
                this.numInfo = n2;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 8: {
                if (!this.inSetup) {
                    this.clearJoints();
                }
                if (vRMLNodeType != null) {
                    this.addJointNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            case 9: {
                if (!this.inSetup) {
                    this.clearSegments();
                }
                if (vRMLNodeType != null) {
                    this.addSegmentNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    this.clearSites();
                }
                if (vRMLNodeType != null) {
                    this.addSiteNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                break;
            }
            case 11: {
                if (!this.inSetup) {
                    this.clearSkeleton();
                }
                if (vRMLNodeType != null) {
                    this.addSkeletonNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            case 12: {
                if (!this.inSetup) {
                    this.clearSkin();
                }
                if (vRMLNodeType != null) {
                    this.addSkinNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
                break;
            }
            case 16: {
                if (!this.inSetup) {
                    this.clearViewpoints();
                }
                if (vRMLNodeType != null) {
                    this.addViewpointNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[16] = true;
                this.fireFieldChanged(16);
                break;
            }
            case 13: {
                this.setSkinCoord(vRMLNodeType);
                break;
            }
            case 14: {
                this.setSkinNormal(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 8: {
                if (!this.inSetup) {
                    this.clearJoints();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addJointNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            case 9: {
                if (!this.inSetup) {
                    this.clearSegments();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addSegmentNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    this.clearSites();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addSiteNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                break;
            }
            case 11: {
                if (!this.inSetup) {
                    this.clearSkeleton();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addSkeletonNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            case 12: {
                if (!this.inSetup) {
                    this.clearSkin();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addSkinNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
                break;
            }
            case 16: {
                if (!this.inSetup) {
                    this.clearViewpoints();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addViewpointNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[16] = true;
                this.fireFieldChanged(16);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public boolean isShared() {
        return this.shareCount > 1;
    }

    public void setShared(boolean bl) {
        Object e;
        int n;
        this.shareCount = bl ? ++this.shareCount : --this.shareCount;
        int n2 = this.vfSkeleton.size();
        for (n = 0; n < n2; ++n) {
            e = this.vfSkeleton.get(n);
            if (!(e instanceof VRMLGroupingNodeType)) continue;
            ((VRMLGroupingNodeType)e).setShared(bl);
        }
        n2 = this.vfSkin.size();
        for (n = 0; n < n2; ++n) {
            e = this.vfSkin.get(n);
            if (!(e instanceof VRMLGroupingNodeType)) continue;
            ((VRMLGroupingNodeType)e).setShared(bl);
        }
    }

    protected void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    protected void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    protected void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void setBboxCenter(float[] fArray) throws InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException(INITONLY_FIELD_MSG);
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException, InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException(INITONLY_FIELD_MSG);
        }
        FieldValidator.checkBBoxSize(this.getVRMLNodeName(), fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    protected void setSkinCoord(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = this.pSkinCoord != null ? this.pSkinCoord : this.vfSkinCoord;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORD_PROTO_MSG);
            }
            this.pSkinCoord = (VRMLProtoInstance)vRMLNodeType;
            this.vfSkinCoord = (VRMLCoordinateNodeType)vRMLNodeType3;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORD_NODE_MSG);
            }
            this.pSkinCoord = null;
            this.vfSkinCoord = (VRMLCoordinateNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    protected void setSkinNormal(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = this.pSkinCoord != null ? this.pSkinNormal : this.vfSkinNormal;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLNormalNodeType)) {
                throw new InvalidFieldValueException(NORMAL_PROTO_MSG);
            }
            this.pSkinNormal = (VRMLProtoInstance)vRMLNodeType;
            this.vfSkinNormal = (VRMLNormalNodeType)vRMLNodeType3;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLNormalNodeType)) {
                throw new InvalidFieldValueException(NORMAL_NODE_MSG);
            }
            this.pSkinNormal = null;
            this.vfSkinNormal = (VRMLNormalNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    protected void clearJoints() {
        int n = this.vfJoints.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfJoints.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfJoints.clear();
        this.hanimImpl.setJoints(null, 0);
    }

    protected void addJointNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseHAnimJoint)) {
                throw new InvalidFieldValueException(JOINT_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseHAnimJoint)) {
            throw new InvalidFieldValueException(JOINT_NODE_MSG);
        }
        this.vfJoints.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    protected void clearSegments() {
        int n = this.vfSegments.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfSegments.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfSegments.clear();
        this.hanimImpl.setSegments(null, 0);
    }

    protected void addSegmentNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseHAnimSegment)) {
                throw new InvalidFieldValueException(SEGMENT_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseHAnimSegment)) {
            throw new InvalidFieldValueException(SEGMENT_NODE_MSG);
        }
        this.vfSegments.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    protected void clearSites() {
        int n = this.vfSites.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfSites.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfSites.clear();
        this.hanimImpl.setSites(null, 0);
    }

    protected void addSiteNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseHAnimSite)) {
                throw new InvalidFieldValueException(SITE_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseHAnimSite)) {
            throw new InvalidFieldValueException(SITE_NODE_MSG);
        }
        this.vfSites.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    protected void clearSkeleton() {
        int n = this.vfSkeleton.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfSkeleton.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfSkeleton.clear();
        this.hanimImpl.setSkeleton(null, 0);
    }

    protected void addSkeletonNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseHAnimJoint)) {
                throw new InvalidFieldValueException(JOINT_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseHAnimJoint)) {
            throw new InvalidFieldValueException(JOINT_NODE_MSG);
        }
        this.vfSkeleton.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    protected void clearSkin() {
        int n = this.vfSkin.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfSkin.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfSkin.clear();
    }

    protected void addSkinNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLChildNodeType)) {
                throw new InvalidFieldValueException(CHILD_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLChildNodeType)) {
            throw new InvalidFieldValueException(CHILD_NODE_MSG);
        }
        this.vfSkin.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    protected void clearViewpoints() {
        int n = this.vfViewpoints.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfViewpoints.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfViewpoints.clear();
        this.hanimImpl.setViewpoints(null, 0);
    }

    protected void addViewpointNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLViewpointNodeType)) {
                throw new InvalidFieldValueException(VIEWPOINT_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLViewpointNodeType)) {
            throw new InvalidFieldValueException(VIEWPOINT_NODE_MSG);
        }
        this.vfViewpoints.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    static {
        nodeFields = new int[]{8, 9, 10, 11, 12, 13, 14, 16, 0};
        fieldDecl = new VRMLFieldDeclaration[19];
        fieldMap = new HashMap(19);
        BaseHAnimHumanoid.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseHAnimHumanoid.fieldDecl[17] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseHAnimHumanoid.fieldDecl[18] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseHAnimHumanoid.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseHAnimHumanoid.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseHAnimHumanoid.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseHAnimHumanoid.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseHAnimHumanoid.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseHAnimHumanoid.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseHAnimHumanoid.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFString", "info");
        BaseHAnimHumanoid.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFNode", "joints");
        BaseHAnimHumanoid.fieldDecl[9] = new VRMLFieldDeclaration(3, "MFNode", "segments");
        BaseHAnimHumanoid.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFNode", "sites");
        BaseHAnimHumanoid.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFNode", "skeleton");
        BaseHAnimHumanoid.fieldDecl[12] = new VRMLFieldDeclaration(3, "MFNode", "skin");
        BaseHAnimHumanoid.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFNode", "skinCoord");
        BaseHAnimHumanoid.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFNode", "skinNormal");
        BaseHAnimHumanoid.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFString", "version");
        BaseHAnimHumanoid.fieldDecl[16] = new VRMLFieldDeclaration(3, "MFNode", "viewpoints");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("bboxCenter", new Integer(17));
        fieldMap.put("bboxSize", new Integer(18));
        n = new Integer(1);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(2);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(3);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(4);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(5);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(6);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        n = new Integer(7);
        fieldMap.put("info", n);
        fieldMap.put("set_info", n);
        fieldMap.put("info_changed", n);
        n = new Integer(8);
        fieldMap.put("joints", n);
        fieldMap.put("set_joints", n);
        fieldMap.put("joints_changed", n);
        n = new Integer(9);
        fieldMap.put("segments", n);
        fieldMap.put("set_segments", n);
        fieldMap.put("segments_changed", n);
        n = new Integer(10);
        fieldMap.put("sites", n);
        fieldMap.put("set_sites", n);
        fieldMap.put("sites_changed", n);
        n = new Integer(11);
        fieldMap.put("skeleton", n);
        fieldMap.put("set_skeleton", n);
        fieldMap.put("skeleton_changed", n);
        n = new Integer(12);
        fieldMap.put("skin", n);
        fieldMap.put("set_skin", n);
        fieldMap.put("skin_changed", n);
        n = new Integer(13);
        fieldMap.put("skinCoord", n);
        fieldMap.put("set_skinCoord", n);
        fieldMap.put("skinCoord_changed", n);
        n = new Integer(14);
        fieldMap.put("skinNormal", n);
        fieldMap.put("set_skinNormal", n);
        fieldMap.put("skinNormal_changed", n);
        n = new Integer(15);
        fieldMap.put("version", n);
        fieldMap.put("set_version", n);
        fieldMap.put("version_changed", n);
        n = new Integer(16);
        fieldMap.put("viewpoints", n);
        fieldMap.put("set_viewpoints", n);
        fieldMap.put("viewpoints_changed", n);
    }
}

