/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseDragSensorNode;

public abstract class BaseCylinderSensor
extends BaseDragSensorNode {
    protected static final int FIELD_MAXANGLE = 7;
    protected static final int FIELD_MINANGLE = 8;
    protected static final int FIELD_DISKANGLE = 9;
    protected static final int FIELD_ROTATION_CHANGED = 10;
    protected static final int FIELD_OFFSET = 11;
    protected static final int LAST_PLANESENSOR_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    private static final float[] ORIGIN = new float[3];
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float vfMaxAngle;
    protected float vfMinAngle;
    protected float vfDiskAngle;
    protected float vfOffset;
    protected float[] vfRotationChanged;
    private boolean useDiskCalc;
    private double initialRotation;
    private float radius;

    public BaseCylinderSensor() {
        super("CylinderSensor");
        this.hasChanged = new boolean[12];
        this.vfRotationChanged = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfMaxAngle = -1.0f;
        this.vfDiskAngle = 0.262f;
    }

    public BaseCylinderSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLDragSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("offset");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOffset = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("minAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("diskAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDiskAngle = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void notifySensorDragStart(float[] fArray, float[] fArray2) {
        super.notifySensorDragStart(fArray, fArray2);
        this.radius = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[2] * fArray[2]);
        double d = Math.atan(this.radius / fArray[1]);
        this.useDiskCalc = d < (double)this.vfDiskAngle;
        this.initialRotation = this.calcAngle(fArray[0], fArray[2]);
    }

    public void notifySensorDragEnd(float[] fArray, float[] fArray2) {
        super.notifySensorDragEnd(fArray, fArray2);
        if (this.vfAutoOffset) {
            this.vfOffset = this.vfRotationChanged[3];
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfRotationChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMaxAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMinAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfDiskAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfOffset;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfRotationChanged, 4);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfMaxAngle);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfMinAngle);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfDiskAngle);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfOffset);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseCylinderSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseCylinderSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.vfMinAngle = f;
                break;
            }
            case 7: {
                this.vfMaxAngle = f;
                break;
            }
            case 9: {
                this.vfDiskAngle = f;
                break;
            }
            case 11: {
                this.vfOffset = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void processDrag(float[] fArray, float[] fArray2) {
        if (!intersectionUtils.rayCylinder(fArray, fArray2, 2, ORIGIN, this.radius, wkPoint)) {
            return;
        }
        double d = this.calcAngle(wkPoint[0], wkPoint[2]) - this.initialRotation;
        d += (double)this.vfOffset;
        if (this.vfMaxAngle >= this.vfMinAngle) {
            if (d >= (double)this.vfMaxAngle) {
                d = this.vfMaxAngle;
            }
            if (d < (double)this.vfMinAngle) {
                d = this.vfMinAngle;
            }
        }
        this.vfRotationChanged[0] = 0.0f;
        this.vfRotationChanged[1] = 1.0f;
        this.vfRotationChanged[2] = 0.0f;
        this.vfRotationChanged[3] = (float)d;
        this.hasChanged[10] = true;
        this.fireFieldChanged(10);
        if (this.useDiskCalc) {
            this.vfTrackPointChanged[0] = wkPoint[0];
            this.vfTrackPointChanged[1] = 0.0f;
            this.vfTrackPointChanged[2] = wkPoint[2];
        } else {
            float f = wkPoint[0];
            float f2 = wkPoint[2];
            double d2 = Math.sqrt(f * f + f2 * f2);
            if (d2 != 0.0) {
                f = (float)((double)f / d2);
                f2 = (float)((double)f2 / d2);
            }
            this.vfTrackPointChanged[0] = f *= this.radius;
            this.vfTrackPointChanged[1] = wkPoint[1];
            this.vfTrackPointChanged[2] = f2 *= this.radius;
        }
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    private double calcAngle(float f, float f2) {
        double d = -Math.atan(f2 / f);
        if (f < 0.0f && f2 < 0.0f) {
            d += Math.PI;
        } else if (f < 0.0f) {
            d += -Math.PI;
        } else if (f2 < 0.0f) {
            d += 1.5707963267948966;
        }
        return d;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseCylinderSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCylinderSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseCylinderSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "autoOffset");
        BaseCylinderSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "trackPoint_changed");
        BaseCylinderSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseCylinderSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BaseCylinderSensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFRotation", "rotation_changed");
        BaseCylinderSensor.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "minAngle");
        BaseCylinderSensor.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "maxAngle");
        BaseCylinderSensor.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFFloat", "offset");
        BaseCylinderSensor.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "diskAngle");
        BaseCylinderSensor.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFString", "description");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(5);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("isOver", new Integer(6));
        fieldMap.put("trackPoint_changed", new Integer(4));
        n = new Integer(3);
        fieldMap.put("autoOffset", n);
        fieldMap.put("set_autoOffset", n);
        fieldMap.put("autoOffset_changed", n);
        n = new Integer(11);
        fieldMap.put("offset", n);
        fieldMap.put("set_offset", n);
        fieldMap.put("offset_changed", n);
        n = new Integer(7);
        fieldMap.put("maxAngle", n);
        fieldMap.put("set_maxAngle", n);
        fieldMap.put("maxAngle_changed", n);
        n = new Integer(8);
        fieldMap.put("minAngle", n);
        fieldMap.put("set_minAngle", n);
        fieldMap.put("minAngle_changed", n);
        n = new Integer(9);
        fieldMap.put("diskAngle", n);
        fieldMap.put("set_diskAngle", n);
        fieldMap.put("diskAngle_changed", n);
        fieldMap.put("rotation_changed", new Integer(10));
    }
}

