/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.ByteStack;
import org.javia.arity.CompiledFunction;
import org.javia.arity.DoubleStack;
import org.javia.arity.FunctionStack;
import org.javia.arity.Symbol;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class SimpleCodeGen
extends TokenConsumer {
    private CompiledFunction compiledFunction = new CompiledFunction();
    static final SyntaxException HAS_ARGUMENTS = new SyntaxException();
    ByteStack code = new ByteStack();
    DoubleStack consts = new DoubleStack();
    FunctionStack funcs = new FunctionStack();
    Symbols symbols;
    SyntaxException exception;

    SimpleCodeGen(SyntaxException syntaxException) {
        this.exception = syntaxException;
    }

    SimpleCodeGen setSymbols(Symbols symbols) {
        this.symbols = symbols;
        return this;
    }

    void start() {
        this.code.clear();
        this.consts.clear();
        this.funcs.clear();
    }

    void push(Token token) throws SyntaxException {
        int n;
        switch (token.id) {
            case 9: {
                n = 1;
                this.consts.push(token.value);
                break;
            }
            case 10: 
            case 11: {
                Symbol symbol = this.symbols.lookup(token.name, token.arity);
                if (symbol == null) {
                    throw this.exception.set("undefined '" + token.name + "' with arity " + token.arity, token.position);
                }
                if (symbol.op > 0) {
                    n = symbol.op;
                    if (n < 37 || n > 41) break;
                    throw HAS_ARGUMENTS.set("eval() on implicit function", this.exception.position);
                }
                if (symbol.fun != null) {
                    n = 2;
                    this.funcs.push(symbol.fun);
                    break;
                }
                n = 1;
                this.consts.push(symbol.value);
                break;
            }
            default: {
                n = token.vmop;
                if (n > 0) break;
                throw new Error("wrong vmop: " + n);
            }
        }
        this.code.push((byte)n);
    }

    double getValue() {
        this.compiledFunction.init(0, this.code.toArray(), this.consts.toArray(), this.funcs.toArray());
        try {
            return this.compiledFunction.eval();
        }
        catch (ArityException arityException) {
            throw new Error("" + arityException);
        }
    }
}

