# -*- coding: utf-8 -*-
# vim:fenc=utf-8

# Copyright (C) 2012-2020 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# X2Go Session Broker is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# X2Go Session Broker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

class X2GoBrokerAuthMech(object):
    """\

    X2Go Session Broker's **none** *authentication mechanism*:

        Use this *authentication mechanism* for setups, where users are always
        granted access to the broker. No authentication is required.

        **WARNING:** Only use this authentication mechanism on private or VPN'ed
        networks. Don't use it, if your broker is reachable on the internet or in
        networks with non-trusted hosts.

        **NOTE:** The broker will not be able to distinguish between users when delivering
        available servers and session profiles to the user's X2Go Client application.
    """

    def authenticate(self, username, password, **kwargs):
        """\
        The **none** authentication mechanism's :func:`authenticate()` method always
        returns ``True`` to the user, so X2Go Session Broker access gets always granted.

        :param username: The broker username sent by the client (ignored)
        :type username: ``str``
        :param password: The broker password sent by the client (ignored)
        :type password: ``str``
        :param kwargs: Any other parameter (for future features' compatibility, all ignored for now)
        :type kwargs: ``dict``

        :returns: Authentication success (always!)
        :rtype: ``bool``

        """
        return True
