/** @file lua/except.i
 * @brief Custom Lua exception handling.
 */
/* Warning: This file is generated by /data/home/olly/tmp/xapian-git-snapshot/tags/v1.3.4/xapian/xapian-bindings/lua/generate-lua-exceptions
 * - do not modify directly!
 *
 * Copyright (C) 2003,2004,2006,2007,2008,2011,2012 Olly Betts
 * Copyright (C) 2007 Lemur Consulting Ltd
 * Copyright (C) 2007 Richard Boulton
 * Copyright (C) 2011 Xiaona Han
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception(lua_State* L) {
    try {
	throw;
    } catch (const Xapian::WildcardError &e) {
	SWIG_NewPointerObj(L, (void *)new WildcardError(e), SWIGTYPE_p_Xapian__WildcardError, 1);
    } catch (const Xapian::RangeError &e) {
	SWIG_NewPointerObj(L, (void *)new RangeError(e), SWIGTYPE_p_Xapian__RangeError, 1);
    } catch (const Xapian::SerialisationError &e) {
	SWIG_NewPointerObj(L, (void *)new SerialisationError(e), SWIGTYPE_p_Xapian__SerialisationError, 1);
    } catch (const Xapian::QueryParserError &e) {
	SWIG_NewPointerObj(L, (void *)new QueryParserError(e), SWIGTYPE_p_Xapian__QueryParserError, 1);
    } catch (const Xapian::NetworkTimeoutError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkTimeoutError(e), SWIGTYPE_p_Xapian__NetworkTimeoutError, 1);
    } catch (const Xapian::NetworkError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkError(e), SWIGTYPE_p_Xapian__NetworkError, 1);
    } catch (const Xapian::InternalError &e) {
	SWIG_NewPointerObj(L, (void *)new InternalError(e), SWIGTYPE_p_Xapian__InternalError, 1);
    } catch (const Xapian::FeatureUnavailableError &e) {
	SWIG_NewPointerObj(L, (void *)new FeatureUnavailableError(e), SWIGTYPE_p_Xapian__FeatureUnavailableError, 1);
    } catch (const Xapian::DocNotFoundError &e) {
	SWIG_NewPointerObj(L, (void *)new DocNotFoundError(e), SWIGTYPE_p_Xapian__DocNotFoundError, 1);
    } catch (const Xapian::DatabaseVersionError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseVersionError(e), SWIGTYPE_p_Xapian__DatabaseVersionError, 1);
    } catch (const Xapian::DatabaseOpeningError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseOpeningError(e), SWIGTYPE_p_Xapian__DatabaseOpeningError, 1);
    } catch (const Xapian::DatabaseModifiedError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseModifiedError(e), SWIGTYPE_p_Xapian__DatabaseModifiedError, 1);
    } catch (const Xapian::DatabaseLockError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseLockError(e), SWIGTYPE_p_Xapian__DatabaseLockError, 1);
    } catch (const Xapian::DatabaseCreateError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCreateError(e), SWIGTYPE_p_Xapian__DatabaseCreateError, 1);
    } catch (const Xapian::DatabaseCorruptError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCorruptError(e), SWIGTYPE_p_Xapian__DatabaseCorruptError, 1);
    } catch (const Xapian::DatabaseError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseError(e), SWIGTYPE_p_Xapian__DatabaseError, 1);
    } catch (const Xapian::UnimplementedError &e) {
	SWIG_NewPointerObj(L, (void *)new UnimplementedError(e), SWIGTYPE_p_Xapian__UnimplementedError, 1);
    } catch (const Xapian::InvalidOperationError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidOperationError(e), SWIGTYPE_p_Xapian__InvalidOperationError, 1);
    } catch (const Xapian::InvalidArgumentError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidArgumentError(e), SWIGTYPE_p_Xapian__InvalidArgumentError, 1);
    } catch (const Xapian::AssertionError &e) {
	SWIG_NewPointerObj(L, (void *)new AssertionError(e), SWIGTYPE_p_Xapian__AssertionError, 1);
    } catch (const Xapian::RuntimeError &e) {
	SWIG_NewPointerObj(L, (void *)new RuntimeError(e), SWIGTYPE_p_Xapian__RuntimeError, 1);
    } catch (const Xapian::LogicError &e) {
	SWIG_NewPointerObj(L, (void *)new LogicError(e), SWIGTYPE_p_Xapian__LogicError, 1);
    } catch (const std::exception& e) {
	lua_pushfstring(L, "std::exception: %s", e.what());
    } catch (...) {
	lua_pushstring(L, "Unknown exception");
    }
}
}
%}

/* Functions and methods which are marked as "nothrow": */
%exception Xapian::Compactor::get_constinfo_();
%exception Xapian::Database::postlist_end(const std::string &) const;
%exception Xapian::Database::termlist_end(Xapian::docid) const;
%exception Xapian::Database::positionlist_end(Xapian::docid, const std::string &) const;
%exception Xapian::Database::allterms_end(const std::string & = std::string()) const;
%exception Xapian::Database::valuestream_end(Xapian::valueno) const;
%exception Xapian::Database::spellings_end() const;
%exception Xapian::Database::synonyms_end(const std::string &) const;
%exception Xapian::Database::synonym_keys_end(const std::string & = std::string()) const;
%exception Xapian::Database::metadata_keys_end(const std::string & = std::string()) const;
%exception Xapian::Document::termlist_end() const;
%exception Xapian::Document::values_end() const;
%exception Xapian::MSetIterator::MSetIterator();
%exception Xapian::ESetIterator::ESetIterator();
%exception Xapian::ESetIterator::operator++();
%exception Xapian::ESetIterator::operator--();
%exception Xapian::ESetIterator::operator==(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator!=(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::Enquire::get_matching_terms_end(Xapian::docid  ) const;
%exception Xapian::Enquire::get_matching_terms_end(const MSetIterator & ) const;
%exception Xapian::ErrorHandler::ErrorHandler();
%exception Xapian::ExpandDeciderFilterPrefix::miles_to_metres(double miles);
%exception Xapian::ExpandDeciderFilterPrefix::metres_to_miles(double metres);
%exception Xapian::ExpandDeciderFilterPrefix::LatLongCoord();
%exception Xapian::ExpandDeciderFilterPrefix::operator<(const LatLongCoord & other) const;
%exception Xapian::MatchSpy::MatchSpy();
%exception Xapian::ValueCountMatchSpy::get_total() const;
%exception Xapian::ValueCountMatchSpy::values_end() const;
%exception Xapian::ValueCountMatchSpy::top_values_end(size_t) const;
%exception Xapian::PositionIterator::PositionIterator();
%exception Xapian::PositionIterator::operator==(const PositionIterator &a, const PositionIterator &b);
%exception Xapian::PositionIterator::operator!=(const PositionIterator &a, const PositionIterator &b);
%exception Xapian::PostingIterator::PostingIterator();
%exception Xapian::PostingIterator::positionlist_end() const;
%exception Xapian::PostingIterator::operator==(const PostingIterator &a, const PostingIterator &b);
%exception Xapian::PostingIterator::operator!=(const PostingIterator &a, const PostingIterator &b);
%exception Xapian::PostingSource::PostingSource();
%exception Xapian::PostingSource::get_maxweight() const;
%exception Xapian::Query::Query();
%exception Xapian::Query::get_terms_end() const;
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::empty() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Query::Internal();
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::QueryParser::stoplist_end() const;
%exception Xapian::QueryParser::unstem_end(const std::string &) const;
%exception Xapian::QueryParser::sortable_serialise_(double value, char * buf);
%exception Xapian::QueryParser::sortable_unserialise(const std::string & serialised);
%exception Xapian::TermIterator::TermIterator();
%exception Xapian::TermIterator::positionlist_end() const;
%exception Xapian::TermIterator::operator==(const TermIterator &a, const TermIterator &b);
%exception Xapian::TermIterator::operator!=(const TermIterator &a, const TermIterator &b);
%exception Xapian::Utf8Iterator::calculate_sequence_length() const;
%exception Xapian::Utf8Iterator::Utf8Iterator();
%exception Xapian::Utf8Iterator::operator*() const;
%exception Xapian::Utf8Iterator::strict_deref() const;
%exception Xapian::Utf8Iterator::operator==(const Utf8Iterator &other) const;
%exception Xapian::Utf8Iterator::operator!=(const Utf8Iterator &other) const;
%exception Xapian::Utf8Iterator::get_character_info(unsigned ch);
%exception Xapian::ValueIterator::ValueIterator();
%exception Xapian::ValueIterator::operator==(const ValueIterator &a, const ValueIterator &b);
%exception Xapian::ValueIterator::operator!=(const ValueIterator &a, const ValueIterator &b);

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception(L);
	SWIG_fail;
    }
}
