/*
 * Copyright (C) Maxime Coquelin 2015
 * Author:  Maxime Coquelin <mcoquelin.stm32@gmail.com>
 * License terms:  GNU General Public License (GPL), version 2
 */
#include <linux/init.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include "pinctrl-stm32.h"

static const struct stm32_desc_pin stm32f429_pins[] = {
	STM32_PIN(
		PINCTRL_PIN(0, "PA0"),
		STM32_FUNCTION(0, "GPIOA0"),
		STM32_FUNCTION(2, "TIM2_CH1 TIM2_ETR"),
		STM32_FUNCTION(3, "TIM5_CH1"),
		STM32_FUNCTION(4, "TIM8_ETR"),
		STM32_FUNCTION(8, "USART2_CTS"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(12, "ETH_MII_CRS"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(1, "PA1"),
		STM32_FUNCTION(0, "GPIOA1"),
		STM32_FUNCTION(2, "TIM2_CH2"),
		STM32_FUNCTION(3, "TIM5_CH2"),
		STM32_FUNCTION(8, "USART2_RTS"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(12, "ETH_MII_RX_CLK ETH_RMII_REF_CLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(2, "PA2"),
		STM32_FUNCTION(0, "GPIOA2"),
		STM32_FUNCTION(2, "TIM2_CH3"),
		STM32_FUNCTION(3, "TIM5_CH3"),
		STM32_FUNCTION(4, "TIM9_CH1"),
		STM32_FUNCTION(8, "USART2_TX"),
		STM32_FUNCTION(12, "ETH_MDIO"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(3, "PA3"),
		STM32_FUNCTION(0, "GPIOA3"),
		STM32_FUNCTION(2, "TIM2_CH4"),
		STM32_FUNCTION(3, "TIM5_CH4"),
		STM32_FUNCTION(4, "TIM9_CH2"),
		STM32_FUNCTION(8, "USART2_RX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D0"),
		STM32_FUNCTION(12, "ETH_MII_COL"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(4, "PA4"),
		STM32_FUNCTION(0, "GPIOA4"),
		STM32_FUNCTION(6, "SPI1_NSS"),
		STM32_FUNCTION(7, "SPI3_NSS I2S3_WS"),
		STM32_FUNCTION(8, "USART2_CK"),
		STM32_FUNCTION(13, "OTG_HS_SOF"),
		STM32_FUNCTION(14, "DCMI_HSYNC"),
		STM32_FUNCTION(15, "LCD_VSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(5, "PA5"),
		STM32_FUNCTION(0, "GPIOA5"),
		STM32_FUNCTION(2, "TIM2_CH1 TIM2_ETR"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(6, "SPI1_SCK"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_CK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(6, "PA6"),
		STM32_FUNCTION(0, "GPIOA6"),
		STM32_FUNCTION(2, "TIM1_BKIN"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(4, "TIM8_BKIN"),
		STM32_FUNCTION(6, "SPI1_MISO"),
		STM32_FUNCTION(10, "TIM13_CH1"),
		STM32_FUNCTION(14, "DCMI_PIXCLK"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(7, "PA7"),
		STM32_FUNCTION(0, "GPIOA7"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(6, "SPI1_MOSI"),
		STM32_FUNCTION(10, "TIM14_CH1"),
		STM32_FUNCTION(12, "ETH_MII_RX_DV ETH_RMII_CRS_DV"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(8, "PA8"),
		STM32_FUNCTION(0, "GPIOA8"),
		STM32_FUNCTION(1, "MCO1"),
		STM32_FUNCTION(2, "TIM1_CH1"),
		STM32_FUNCTION(5, "I2C3_SCL"),
		STM32_FUNCTION(8, "USART1_CK"),
		STM32_FUNCTION(11, "OTG_FS_SOF"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(9, "PA9"),
		STM32_FUNCTION(0, "GPIOA9"),
		STM32_FUNCTION(2, "TIM1_CH2"),
		STM32_FUNCTION(5, "I2C3_SMBA"),
		STM32_FUNCTION(8, "USART1_TX"),
		STM32_FUNCTION(14, "DCMI_D0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(10, "PA10"),
		STM32_FUNCTION(0, "GPIOA10"),
		STM32_FUNCTION(2, "TIM1_CH3"),
		STM32_FUNCTION(8, "USART1_RX"),
		STM32_FUNCTION(11, "OTG_FS_ID"),
		STM32_FUNCTION(14, "DCMI_D1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(11, "PA11"),
		STM32_FUNCTION(0, "GPIOA11"),
		STM32_FUNCTION(2, "TIM1_CH4"),
		STM32_FUNCTION(8, "USART1_CTS"),
		STM32_FUNCTION(10, "CAN1_RX"),
		STM32_FUNCTION(11, "OTG_FS_DM"),
		STM32_FUNCTION(15, "LCD_R4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(12, "PA12"),
		STM32_FUNCTION(0, "GPIOA12"),
		STM32_FUNCTION(2, "TIM1_ETR"),
		STM32_FUNCTION(8, "USART1_RTS"),
		STM32_FUNCTION(10, "CAN1_TX"),
		STM32_FUNCTION(11, "OTG_FS_DP"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(13, "PA13"),
		STM32_FUNCTION(0, "GPIOA13"),
		STM32_FUNCTION(1, "JTMS SWDIO"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(14, "PA14"),
		STM32_FUNCTION(0, "GPIOA14"),
		STM32_FUNCTION(1, "JTCK SWCLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(15, "PA15"),
		STM32_FUNCTION(0, "GPIOA15"),
		STM32_FUNCTION(1, "JTDI"),
		STM32_FUNCTION(2, "TIM2_CH1 TIM2_ETR"),
		STM32_FUNCTION(6, "SPI1_NSS"),
		STM32_FUNCTION(7, "SPI3_NSS I2S3_WS"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(16, "PB0"),
		STM32_FUNCTION(0, "GPIOB0"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(3, "TIM3_CH3"),
		STM32_FUNCTION(4, "TIM8_CH2N"),
		STM32_FUNCTION(10, "LCD_R3"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D1"),
		STM32_FUNCTION(12, "ETH_MII_RXD2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(17, "PB1"),
		STM32_FUNCTION(0, "GPIOB1"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(3, "TIM3_CH4"),
		STM32_FUNCTION(4, "TIM8_CH3N"),
		STM32_FUNCTION(10, "LCD_R6"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D2"),
		STM32_FUNCTION(12, "ETH_MII_RXD3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(18, "PB2"),
		STM32_FUNCTION(0, "GPIOB2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(19, "PB3"),
		STM32_FUNCTION(0, "GPIOB3"),
		STM32_FUNCTION(1, "JTDO TRACESWO"),
		STM32_FUNCTION(2, "TIM2_CH2"),
		STM32_FUNCTION(6, "SPI1_SCK"),
		STM32_FUNCTION(7, "SPI3_SCK I2S3_CK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(20, "PB4"),
		STM32_FUNCTION(0, "GPIOB4"),
		STM32_FUNCTION(1, "NJTRST"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(6, "SPI1_MISO"),
		STM32_FUNCTION(7, "SPI3_MISO"),
		STM32_FUNCTION(8, "I2S3EXT_SD"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(21, "PB5"),
		STM32_FUNCTION(0, "GPIOB5"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(5, "I2C1_SMBA"),
		STM32_FUNCTION(6, "SPI1_MOSI"),
		STM32_FUNCTION(7, "SPI3_MOSI I2S3_SD"),
		STM32_FUNCTION(10, "CAN2_RX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D7"),
		STM32_FUNCTION(12, "ETH_PPS_OUT"),
		STM32_FUNCTION(13, "FMC_SDCKE1"),
		STM32_FUNCTION(14, "DCMI_D10"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(22, "PB6"),
		STM32_FUNCTION(0, "GPIOB6"),
		STM32_FUNCTION(3, "TIM4_CH1"),
		STM32_FUNCTION(5, "I2C1_SCL"),
		STM32_FUNCTION(8, "USART1_TX"),
		STM32_FUNCTION(10, "CAN2_TX"),
		STM32_FUNCTION(13, "FMC_SDNE1"),
		STM32_FUNCTION(14, "DCMI_D5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(23, "PB7"),
		STM32_FUNCTION(0, "GPIOB7"),
		STM32_FUNCTION(3, "TIM4_CH2"),
		STM32_FUNCTION(5, "I2C1_SDA"),
		STM32_FUNCTION(8, "USART1_RX"),
		STM32_FUNCTION(13, "FMC_NL"),
		STM32_FUNCTION(14, "DCMI_VSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(24, "PB8"),
		STM32_FUNCTION(0, "GPIOB8"),
		STM32_FUNCTION(3, "TIM4_CH3"),
		STM32_FUNCTION(4, "TIM10_CH1"),
		STM32_FUNCTION(5, "I2C1_SCL"),
		STM32_FUNCTION(10, "CAN1_RX"),
		STM32_FUNCTION(12, "ETH_MII_TXD3"),
		STM32_FUNCTION(13, "SDIO_D4"),
		STM32_FUNCTION(14, "DCMI_D6"),
		STM32_FUNCTION(15, "LCD_B6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(25, "PB9"),
		STM32_FUNCTION(0, "GPIOB9"),
		STM32_FUNCTION(3, "TIM4_CH4"),
		STM32_FUNCTION(4, "TIM11_CH1"),
		STM32_FUNCTION(5, "I2C1_SDA"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(10, "CAN1_TX"),
		STM32_FUNCTION(13, "SDIO_D5"),
		STM32_FUNCTION(14, "DCMI_D7"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(26, "PB10"),
		STM32_FUNCTION(0, "GPIOB10"),
		STM32_FUNCTION(2, "TIM2_CH3"),
		STM32_FUNCTION(5, "I2C2_SCL"),
		STM32_FUNCTION(6, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D3"),
		STM32_FUNCTION(12, "ETH_MII_RX_ER"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(27, "PB11"),
		STM32_FUNCTION(0, "GPIOB11"),
		STM32_FUNCTION(2, "TIM2_CH4"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(8, "USART3_RX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D4"),
		STM32_FUNCTION(12, "ETH_MII_TX_EN ETH_RMII_TX_EN"),
		STM32_FUNCTION(15, "LCD_G5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(28, "PB12"),
		STM32_FUNCTION(0, "GPIOB12"),
		STM32_FUNCTION(2, "TIM1_BKIN"),
		STM32_FUNCTION(5, "I2C2_SMBA"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(10, "CAN2_RX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D5"),
		STM32_FUNCTION(12, "ETH_MII_TXD0 ETH_RMII_TXD0"),
		STM32_FUNCTION(13, "OTG_HS_ID"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(29, "PB13"),
		STM32_FUNCTION(0, "GPIOB13"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(6, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(8, "USART3_CTS"),
		STM32_FUNCTION(10, "CAN2_TX"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_D6"),
		STM32_FUNCTION(12, "ETH_MII_TXD1 ETH_RMII_TXD1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(30, "PB14"),
		STM32_FUNCTION(0, "GPIOB14"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(4, "TIM8_CH2N"),
		STM32_FUNCTION(6, "SPI2_MISO"),
		STM32_FUNCTION(7, "I2S2EXT_SD"),
		STM32_FUNCTION(8, "USART3_RTS"),
		STM32_FUNCTION(10, "TIM12_CH1"),
		STM32_FUNCTION(13, "OTG_HS_DM"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(31, "PB15"),
		STM32_FUNCTION(0, "GPIOB15"),
		STM32_FUNCTION(1, "RTC_REFIN"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(4, "TIM8_CH3N"),
		STM32_FUNCTION(6, "SPI2_MOSI I2S2_SD"),
		STM32_FUNCTION(10, "TIM12_CH2"),
		STM32_FUNCTION(13, "OTG_HS_DP"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(32, "PC0"),
		STM32_FUNCTION(0, "GPIOC0"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_STP"),
		STM32_FUNCTION(13, "FMC_SDNWE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(33, "PC1"),
		STM32_FUNCTION(0, "GPIOC1"),
		STM32_FUNCTION(12, "ETH_MDC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(34, "PC2"),
		STM32_FUNCTION(0, "GPIOC2"),
		STM32_FUNCTION(6, "SPI2_MISO"),
		STM32_FUNCTION(7, "I2S2EXT_SD"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_DIR"),
		STM32_FUNCTION(12, "ETH_MII_TXD2"),
		STM32_FUNCTION(13, "FMC_SDNE0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(35, "PC3"),
		STM32_FUNCTION(0, "GPIOC3"),
		STM32_FUNCTION(6, "SPI2_MOSI I2S2_SD"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_NXT"),
		STM32_FUNCTION(12, "ETH_MII_TX_CLK"),
		STM32_FUNCTION(13, "FMC_SDCKE0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(36, "PC4"),
		STM32_FUNCTION(0, "GPIOC4"),
		STM32_FUNCTION(12, "ETH_MII_RXD0 ETH_RMII_RXD0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(37, "PC5"),
		STM32_FUNCTION(0, "GPIOC5"),
		STM32_FUNCTION(12, "ETH_MII_RXD1 ETH_RMII_RXD1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(38, "PC6"),
		STM32_FUNCTION(0, "GPIOC6"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(4, "TIM8_CH1"),
		STM32_FUNCTION(6, "I2S2_MCK"),
		STM32_FUNCTION(9, "USART6_TX"),
		STM32_FUNCTION(13, "SDIO_D6"),
		STM32_FUNCTION(14, "DCMI_D0"),
		STM32_FUNCTION(15, "LCD_HSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(39, "PC7"),
		STM32_FUNCTION(0, "GPIOC7"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(4, "TIM8_CH2"),
		STM32_FUNCTION(7, "I2S3_MCK"),
		STM32_FUNCTION(9, "USART6_RX"),
		STM32_FUNCTION(13, "SDIO_D7"),
		STM32_FUNCTION(14, "DCMI_D1"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(40, "PC8"),
		STM32_FUNCTION(0, "GPIOC8"),
		STM32_FUNCTION(3, "TIM3_CH3"),
		STM32_FUNCTION(4, "TIM8_CH3"),
		STM32_FUNCTION(9, "USART6_CK"),
		STM32_FUNCTION(13, "SDIO_D0"),
		STM32_FUNCTION(14, "DCMI_D2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(41, "PC9"),
		STM32_FUNCTION(0, "GPIOC9"),
		STM32_FUNCTION(1, "MCO2"),
		STM32_FUNCTION(3, "TIM3_CH4"),
		STM32_FUNCTION(4, "TIM8_CH4"),
		STM32_FUNCTION(5, "I2C3_SDA"),
		STM32_FUNCTION(6, "I2S_CKIN"),
		STM32_FUNCTION(13, "SDIO_D1"),
		STM32_FUNCTION(14, "DCMI_D3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(42, "PC10"),
		STM32_FUNCTION(0, "GPIOC10"),
		STM32_FUNCTION(7, "SPI3_SCK I2S3_CK"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(13, "SDIO_D2"),
		STM32_FUNCTION(14, "DCMI_D8"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(43, "PC11"),
		STM32_FUNCTION(0, "GPIOC11"),
		STM32_FUNCTION(6, "I2S3EXT_SD"),
		STM32_FUNCTION(7, "SPI3_MISO"),
		STM32_FUNCTION(8, "USART3_RX"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(13, "SDIO_D3"),
		STM32_FUNCTION(14, "DCMI_D4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(44, "PC12"),
		STM32_FUNCTION(0, "GPIOC12"),
		STM32_FUNCTION(7, "SPI3_MOSI I2S3_SD"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(9, "UART5_TX"),
		STM32_FUNCTION(13, "SDIO_CK"),
		STM32_FUNCTION(14, "DCMI_D9"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(45, "PC13"),
		STM32_FUNCTION(0, "GPIOC13"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(46, "PC14"),
		STM32_FUNCTION(0, "GPIOC14"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(47, "PC15"),
		STM32_FUNCTION(0, "GPIOC15"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(48, "PD0"),
		STM32_FUNCTION(0, "GPIOD0"),
		STM32_FUNCTION(10, "CAN1_RX"),
		STM32_FUNCTION(13, "FMC_D2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(49, "PD1"),
		STM32_FUNCTION(0, "GPIOD1"),
		STM32_FUNCTION(10, "CAN1_TX"),
		STM32_FUNCTION(13, "FMC_D3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(50, "PD2"),
		STM32_FUNCTION(0, "GPIOD2"),
		STM32_FUNCTION(3, "TIM3_ETR"),
		STM32_FUNCTION(9, "UART5_RX"),
		STM32_FUNCTION(13, "SDIO_CMD"),
		STM32_FUNCTION(14, "DCMI_D11"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(51, "PD3"),
		STM32_FUNCTION(0, "GPIOD3"),
		STM32_FUNCTION(6, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(8, "USART2_CTS"),
		STM32_FUNCTION(13, "FMC_CLK"),
		STM32_FUNCTION(14, "DCMI_D5"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(52, "PD4"),
		STM32_FUNCTION(0, "GPIOD4"),
		STM32_FUNCTION(8, "USART2_RTS"),
		STM32_FUNCTION(13, "FMC_NOE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(53, "PD5"),
		STM32_FUNCTION(0, "GPIOD5"),
		STM32_FUNCTION(8, "USART2_TX"),
		STM32_FUNCTION(13, "FMC_NWE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(54, "PD6"),
		STM32_FUNCTION(0, "GPIOD6"),
		STM32_FUNCTION(6, "SPI3_MOSI I2S3_SD"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(8, "USART2_RX"),
		STM32_FUNCTION(13, "FMC_NWAIT"),
		STM32_FUNCTION(14, "DCMI_D10"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(55, "PD7"),
		STM32_FUNCTION(0, "GPIOD7"),
		STM32_FUNCTION(8, "USART2_CK"),
		STM32_FUNCTION(13, "FMC_NE1 FMC_NCE2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(56, "PD8"),
		STM32_FUNCTION(0, "GPIOD8"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(13, "FMC_D13"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(57, "PD9"),
		STM32_FUNCTION(0, "GPIOD9"),
		STM32_FUNCTION(8, "USART3_RX"),
		STM32_FUNCTION(13, "FMC_D14"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(58, "PD10"),
		STM32_FUNCTION(0, "GPIOD10"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(13, "FMC_D15"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(59, "PD11"),
		STM32_FUNCTION(0, "GPIOD11"),
		STM32_FUNCTION(8, "USART3_CTS"),
		STM32_FUNCTION(13, "FMC_A16"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(60, "PD12"),
		STM32_FUNCTION(0, "GPIOD12"),
		STM32_FUNCTION(3, "TIM4_CH1"),
		STM32_FUNCTION(8, "USART3_RTS"),
		STM32_FUNCTION(13, "FMC_A17"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(61, "PD13"),
		STM32_FUNCTION(0, "GPIOD13"),
		STM32_FUNCTION(3, "TIM4_CH2"),
		STM32_FUNCTION(13, "FMC_A18"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(62, "PD14"),
		STM32_FUNCTION(0, "GPIOD14"),
		STM32_FUNCTION(3, "TIM4_CH3"),
		STM32_FUNCTION(13, "FMC_D0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(63, "PD15"),
		STM32_FUNCTION(0, "GPIOD15"),
		STM32_FUNCTION(3, "TIM4_CH4"),
		STM32_FUNCTION(13, "FMC_D1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(64, "PE0"),
		STM32_FUNCTION(0, "GPIOE0"),
		STM32_FUNCTION(3, "TIM4_ETR"),
		STM32_FUNCTION(9, "UART8_RX"),
		STM32_FUNCTION(13, "FMC_NBL0"),
		STM32_FUNCTION(14, "DCMI_D2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(65, "PE1"),
		STM32_FUNCTION(0, "GPIOE1"),
		STM32_FUNCTION(9, "UART8_TX"),
		STM32_FUNCTION(13, "FMC_NBL1"),
		STM32_FUNCTION(14, "DCMI_D3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(66, "PE2"),
		STM32_FUNCTION(0, "GPIOE2"),
		STM32_FUNCTION(1, "TRACECLK"),
		STM32_FUNCTION(6, "SPI4_SCK"),
		STM32_FUNCTION(7, "SAI1_MCLK_A"),
		STM32_FUNCTION(12, "ETH_MII_TXD3"),
		STM32_FUNCTION(13, "FMC_A23"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(67, "PE3"),
		STM32_FUNCTION(0, "GPIOE3"),
		STM32_FUNCTION(1, "TRACED0"),
		STM32_FUNCTION(7, "SAI1_SD_B"),
		STM32_FUNCTION(13, "FMC_A19"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(68, "PE4"),
		STM32_FUNCTION(0, "GPIOE4"),
		STM32_FUNCTION(1, "TRACED1"),
		STM32_FUNCTION(6, "SPI4_NSS"),
		STM32_FUNCTION(7, "SAI1_FS_A"),
		STM32_FUNCTION(13, "FMC_A20"),
		STM32_FUNCTION(14, "DCMI_D4"),
		STM32_FUNCTION(15, "LCD_B0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(69, "PE5"),
		STM32_FUNCTION(0, "GPIOE5"),
		STM32_FUNCTION(1, "TRACED2"),
		STM32_FUNCTION(4, "TIM9_CH1"),
		STM32_FUNCTION(6, "SPI4_MISO"),
		STM32_FUNCTION(7, "SAI1_SCK_A"),
		STM32_FUNCTION(13, "FMC_A21"),
		STM32_FUNCTION(14, "DCMI_D6"),
		STM32_FUNCTION(15, "LCD_G0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(70, "PE6"),
		STM32_FUNCTION(0, "GPIOE6"),
		STM32_FUNCTION(1, "TRACED3"),
		STM32_FUNCTION(4, "TIM9_CH2"),
		STM32_FUNCTION(6, "SPI4_MOSI"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(13, "FMC_A22"),
		STM32_FUNCTION(14, "DCMI_D7"),
		STM32_FUNCTION(15, "LCD_G1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(71, "PE7"),
		STM32_FUNCTION(0, "GPIOE7"),
		STM32_FUNCTION(2, "TIM1_ETR"),
		STM32_FUNCTION(9, "UART7_RX"),
		STM32_FUNCTION(13, "FMC_D4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(72, "PE8"),
		STM32_FUNCTION(0, "GPIOE8"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(9, "UART7_TX"),
		STM32_FUNCTION(13, "FMC_D5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(73, "PE9"),
		STM32_FUNCTION(0, "GPIOE9"),
		STM32_FUNCTION(2, "TIM1_CH1"),
		STM32_FUNCTION(13, "FMC_D6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(74, "PE10"),
		STM32_FUNCTION(0, "GPIOE10"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(13, "FMC_D7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(75, "PE11"),
		STM32_FUNCTION(0, "GPIOE11"),
		STM32_FUNCTION(2, "TIM1_CH2"),
		STM32_FUNCTION(6, "SPI4_NSS"),
		STM32_FUNCTION(13, "FMC_D8"),
		STM32_FUNCTION(15, "LCD_G3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(76, "PE12"),
		STM32_FUNCTION(0, "GPIOE12"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(6, "SPI4_SCK"),
		STM32_FUNCTION(13, "FMC_D9"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(77, "PE13"),
		STM32_FUNCTION(0, "GPIOE13"),
		STM32_FUNCTION(2, "TIM1_CH3"),
		STM32_FUNCTION(6, "SPI4_MISO"),
		STM32_FUNCTION(13, "FMC_D10"),
		STM32_FUNCTION(15, "LCD_DE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(78, "PE14"),
		STM32_FUNCTION(0, "GPIOE14"),
		STM32_FUNCTION(2, "TIM1_CH4"),
		STM32_FUNCTION(6, "SPI4_MOSI"),
		STM32_FUNCTION(13, "FMC_D11"),
		STM32_FUNCTION(15, "LCD_CLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(79, "PE15"),
		STM32_FUNCTION(0, "GPIOE15"),
		STM32_FUNCTION(2, "TIM1_BKIN"),
		STM32_FUNCTION(13, "FMC_D12"),
		STM32_FUNCTION(15, "LCD_R7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(80, "PF0"),
		STM32_FUNCTION(0, "GPIOF0"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(13, "FMC_A0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(81, "PF1"),
		STM32_FUNCTION(0, "GPIOF1"),
		STM32_FUNCTION(5, "I2C2_SCL"),
		STM32_FUNCTION(13, "FMC_A1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(82, "PF2"),
		STM32_FUNCTION(0, "GPIOF2"),
		STM32_FUNCTION(5, "I2C2_SMBA"),
		STM32_FUNCTION(13, "FMC_A2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(83, "PF3"),
		STM32_FUNCTION(0, "GPIOF3"),
		STM32_FUNCTION(13, "FMC_A3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(84, "PF4"),
		STM32_FUNCTION(0, "GPIOF4"),
		STM32_FUNCTION(13, "FMC_A4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(85, "PF5"),
		STM32_FUNCTION(0, "GPIOF5"),
		STM32_FUNCTION(13, "FMC_A5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(86, "PF6"),
		STM32_FUNCTION(0, "GPIOF6"),
		STM32_FUNCTION(4, "TIM10_CH1"),
		STM32_FUNCTION(6, "SPI5_NSS"),
		STM32_FUNCTION(7, "SAI1_SD_B"),
		STM32_FUNCTION(9, "UART7_RX"),
		STM32_FUNCTION(13, "FMC_NIORD"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(87, "PF7"),
		STM32_FUNCTION(0, "GPIOF7"),
		STM32_FUNCTION(4, "TIM11_CH1"),
		STM32_FUNCTION(6, "SPI5_SCK"),
		STM32_FUNCTION(7, "SAI1_MCLK_B"),
		STM32_FUNCTION(9, "UART7_TX"),
		STM32_FUNCTION(13, "FMC_NREG"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(88, "PF8"),
		STM32_FUNCTION(0, "GPIOF8"),
		STM32_FUNCTION(6, "SPI5_MISO"),
		STM32_FUNCTION(7, "SAI1_SCK_B"),
		STM32_FUNCTION(10, "TIM13_CH1"),
		STM32_FUNCTION(13, "FMC_NIOWR"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(89, "PF9"),
		STM32_FUNCTION(0, "GPIOF9"),
		STM32_FUNCTION(6, "SPI5_MOSI"),
		STM32_FUNCTION(7, "SAI1_FS_B"),
		STM32_FUNCTION(10, "TIM14_CH1"),
		STM32_FUNCTION(13, "FMC_CD"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(90, "PF10"),
		STM32_FUNCTION(0, "GPIOF10"),
		STM32_FUNCTION(13, "FMC_INTR"),
		STM32_FUNCTION(14, "DCMI_D11"),
		STM32_FUNCTION(15, "LCD_DE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(91, "PF11"),
		STM32_FUNCTION(0, "GPIOF11"),
		STM32_FUNCTION(6, "SPI5_MOSI"),
		STM32_FUNCTION(13, "FMC_SDNRAS"),
		STM32_FUNCTION(14, "DCMI_D12"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(92, "PF12"),
		STM32_FUNCTION(0, "GPIOF12"),
		STM32_FUNCTION(13, "FMC_A6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(93, "PF13"),
		STM32_FUNCTION(0, "GPIOF13"),
		STM32_FUNCTION(13, "FMC_A7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(94, "PF14"),
		STM32_FUNCTION(0, "GPIOF14"),
		STM32_FUNCTION(13, "FMC_A8"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(95, "PF15"),
		STM32_FUNCTION(0, "GPIOF15"),
		STM32_FUNCTION(13, "FMC_A9"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(96, "PG0"),
		STM32_FUNCTION(0, "GPIOG0"),
		STM32_FUNCTION(13, "FMC_A10"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(97, "PG1"),
		STM32_FUNCTION(0, "GPIOG1"),
		STM32_FUNCTION(13, "FMC_A11"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(98, "PG2"),
		STM32_FUNCTION(0, "GPIOG2"),
		STM32_FUNCTION(13, "FMC_A12"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(99, "PG3"),
		STM32_FUNCTION(0, "GPIOG3"),
		STM32_FUNCTION(13, "FMC_A13"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(100, "PG4"),
		STM32_FUNCTION(0, "GPIOG4"),
		STM32_FUNCTION(13, "FMC_A14 FMC_BA0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(101, "PG5"),
		STM32_FUNCTION(0, "GPIOG5"),
		STM32_FUNCTION(13, "FMC_A15 FMC_BA1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(102, "PG6"),
		STM32_FUNCTION(0, "GPIOG6"),
		STM32_FUNCTION(13, "FMC_INT2"),
		STM32_FUNCTION(14, "DCMI_D12"),
		STM32_FUNCTION(15, "LCD_R7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(103, "PG7"),
		STM32_FUNCTION(0, "GPIOG7"),
		STM32_FUNCTION(9, "USART6_CK"),
		STM32_FUNCTION(13, "FMC_INT3"),
		STM32_FUNCTION(14, "DCMI_D13"),
		STM32_FUNCTION(15, "LCD_CLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(104, "PG8"),
		STM32_FUNCTION(0, "GPIOG8"),
		STM32_FUNCTION(6, "SPI6_NSS"),
		STM32_FUNCTION(9, "USART6_RTS"),
		STM32_FUNCTION(12, "ETH_PPS_OUT"),
		STM32_FUNCTION(13, "FMC_SDCLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(105, "PG9"),
		STM32_FUNCTION(0, "GPIOG9"),
		STM32_FUNCTION(9, "USART6_RX"),
		STM32_FUNCTION(13, "FMC_NE2 FMC_NCE3"),
		STM32_FUNCTION(14, "DCMI_VSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(106, "PG10"),
		STM32_FUNCTION(0, "GPIOG10"),
		STM32_FUNCTION(10, "LCD_G3"),
		STM32_FUNCTION(13, "FMC_NCE4_1 FMC_NE3"),
		STM32_FUNCTION(14, "DCMI_D2"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(107, "PG11"),
		STM32_FUNCTION(0, "GPIOG11"),
		STM32_FUNCTION(12, "ETH_MII_TX_EN ETH_RMII_TX_EN"),
		STM32_FUNCTION(13, "FMC_NCE4_2"),
		STM32_FUNCTION(14, "DCMI_D3"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(108, "PG12"),
		STM32_FUNCTION(0, "GPIOG12"),
		STM32_FUNCTION(6, "SPI6_MISO"),
		STM32_FUNCTION(9, "USART6_RTS"),
		STM32_FUNCTION(10, "LCD_B4"),
		STM32_FUNCTION(13, "FMC_NE4"),
		STM32_FUNCTION(15, "LCD_B1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(109, "PG13"),
		STM32_FUNCTION(0, "GPIOG13"),
		STM32_FUNCTION(6, "SPI6_SCK"),
		STM32_FUNCTION(9, "USART6_CTS"),
		STM32_FUNCTION(12, "ETH_MII_TXD0 ETH_RMII_TXD0"),
		STM32_FUNCTION(13, "FMC_A24"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(110, "PG14"),
		STM32_FUNCTION(0, "GPIOG14"),
		STM32_FUNCTION(6, "SPI6_MOSI"),
		STM32_FUNCTION(9, "USART6_TX"),
		STM32_FUNCTION(12, "ETH_MII_TXD1 ETH_RMII_TXD1"),
		STM32_FUNCTION(13, "FMC_A25"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(111, "PG15"),
		STM32_FUNCTION(0, "GPIOG15"),
		STM32_FUNCTION(9, "USART6_CTS"),
		STM32_FUNCTION(13, "FMC_SDNCAS"),
		STM32_FUNCTION(14, "DCMI_D13"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(112, "PH0"),
		STM32_FUNCTION(0, "GPIOH0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(113, "PH1"),
		STM32_FUNCTION(0, "GPIOH1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(114, "PH2"),
		STM32_FUNCTION(0, "GPIOH2"),
		STM32_FUNCTION(12, "ETH_MII_CRS"),
		STM32_FUNCTION(13, "FMC_SDCKE0"),
		STM32_FUNCTION(15, "LCD_R0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(115, "PH3"),
		STM32_FUNCTION(0, "GPIOH3"),
		STM32_FUNCTION(12, "ETH_MII_COL"),
		STM32_FUNCTION(13, "FMC_SDNE0"),
		STM32_FUNCTION(15, "LCD_R1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(116, "PH4"),
		STM32_FUNCTION(0, "GPIOH4"),
		STM32_FUNCTION(5, "I2C2_SCL"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_NXT"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(117, "PH5"),
		STM32_FUNCTION(0, "GPIOH5"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(6, "SPI5_NSS"),
		STM32_FUNCTION(13, "FMC_SDNWE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(118, "PH6"),
		STM32_FUNCTION(0, "GPIOH6"),
		STM32_FUNCTION(5, "I2C2_SMBA"),
		STM32_FUNCTION(6, "SPI5_SCK"),
		STM32_FUNCTION(10, "TIM12_CH1"),
		STM32_FUNCTION(12, "ETH_MII_RXD2"),
		STM32_FUNCTION(13, "FMC_SDNE1"),
		STM32_FUNCTION(14, "DCMI_D8"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(119, "PH7"),
		STM32_FUNCTION(0, "GPIOH7"),
		STM32_FUNCTION(5, "I2C3_SCL"),
		STM32_FUNCTION(6, "SPI5_MISO"),
		STM32_FUNCTION(12, "ETH_MII_RXD3"),
		STM32_FUNCTION(13, "FMC_SDCKE1"),
		STM32_FUNCTION(14, "DCMI_D9"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(120, "PH8"),
		STM32_FUNCTION(0, "GPIOH8"),
		STM32_FUNCTION(5, "I2C3_SDA"),
		STM32_FUNCTION(13, "FMC_D16"),
		STM32_FUNCTION(14, "DCMI_HSYNC"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(121, "PH9"),
		STM32_FUNCTION(0, "GPIOH9"),
		STM32_FUNCTION(5, "I2C3_SMBA"),
		STM32_FUNCTION(10, "TIM12_CH2"),
		STM32_FUNCTION(13, "FMC_D17"),
		STM32_FUNCTION(14, "DCMI_D0"),
		STM32_FUNCTION(15, "LCD_R3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(122, "PH10"),
		STM32_FUNCTION(0, "GPIOH10"),
		STM32_FUNCTION(3, "TIM5_CH1"),
		STM32_FUNCTION(13, "FMC_D18"),
		STM32_FUNCTION(14, "DCMI_D1"),
		STM32_FUNCTION(15, "LCD_R4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(123, "PH11"),
		STM32_FUNCTION(0, "GPIOH11"),
		STM32_FUNCTION(3, "TIM5_CH2"),
		STM32_FUNCTION(13, "FMC_D19"),
		STM32_FUNCTION(14, "DCMI_D2"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(124, "PH12"),
		STM32_FUNCTION(0, "GPIOH12"),
		STM32_FUNCTION(3, "TIM5_CH3"),
		STM32_FUNCTION(13, "FMC_D20"),
		STM32_FUNCTION(14, "DCMI_D3"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(125, "PH13"),
		STM32_FUNCTION(0, "GPIOH13"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(10, "CAN1_TX"),
		STM32_FUNCTION(13, "FMC_D21"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(126, "PH14"),
		STM32_FUNCTION(0, "GPIOH14"),
		STM32_FUNCTION(4, "TIM8_CH2N"),
		STM32_FUNCTION(13, "FMC_D22"),
		STM32_FUNCTION(14, "DCMI_D4"),
		STM32_FUNCTION(15, "LCD_G3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(127, "PH15"),
		STM32_FUNCTION(0, "GPIOH15"),
		STM32_FUNCTION(4, "TIM8_CH3N"),
		STM32_FUNCTION(13, "FMC_D23"),
		STM32_FUNCTION(14, "DCMI_D11"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(128, "PI0"),
		STM32_FUNCTION(0, "GPIOI0"),
		STM32_FUNCTION(3, "TIM5_CH4"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(13, "FMC_D24"),
		STM32_FUNCTION(14, "DCMI_D13"),
		STM32_FUNCTION(15, "LCD_G5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(129, "PI1"),
		STM32_FUNCTION(0, "GPIOI1"),
		STM32_FUNCTION(6, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(13, "FMC_D25"),
		STM32_FUNCTION(14, "DCMI_D8"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(130, "PI2"),
		STM32_FUNCTION(0, "GPIOI2"),
		STM32_FUNCTION(4, "TIM8_CH4"),
		STM32_FUNCTION(6, "SPI2_MISO"),
		STM32_FUNCTION(7, "I2S2EXT_SD"),
		STM32_FUNCTION(13, "FMC_D26"),
		STM32_FUNCTION(14, "DCMI_D9"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(131, "PI3"),
		STM32_FUNCTION(0, "GPIOI3"),
		STM32_FUNCTION(4, "TIM8_ETR"),
		STM32_FUNCTION(6, "SPI2_MOSI I2S2_SD"),
		STM32_FUNCTION(13, "FMC_D27"),
		STM32_FUNCTION(14, "DCMI_D10"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(132, "PI4"),
		STM32_FUNCTION(0, "GPIOI4"),
		STM32_FUNCTION(4, "TIM8_BKIN"),
		STM32_FUNCTION(13, "FMC_NBL2"),
		STM32_FUNCTION(14, "DCMI_D5"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(133, "PI5"),
		STM32_FUNCTION(0, "GPIOI5"),
		STM32_FUNCTION(4, "TIM8_CH1"),
		STM32_FUNCTION(13, "FMC_NBL3"),
		STM32_FUNCTION(14, "DCMI_VSYNC"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(134, "PI6"),
		STM32_FUNCTION(0, "GPIOI6"),
		STM32_FUNCTION(4, "TIM8_CH2"),
		STM32_FUNCTION(13, "FMC_D28"),
		STM32_FUNCTION(14, "DCMI_D6"),
		STM32_FUNCTION(15, "LCD_B6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(135, "PI7"),
		STM32_FUNCTION(0, "GPIOI7"),
		STM32_FUNCTION(4, "TIM8_CH3"),
		STM32_FUNCTION(13, "FMC_D29"),
		STM32_FUNCTION(14, "DCMI_D7"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(136, "PI8"),
		STM32_FUNCTION(0, "GPIOI8"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(137, "PI9"),
		STM32_FUNCTION(0, "GPIOI9"),
		STM32_FUNCTION(10, "CAN1_RX"),
		STM32_FUNCTION(13, "FMC_D30"),
		STM32_FUNCTION(15, "LCD_VSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(138, "PI10"),
		STM32_FUNCTION(0, "GPIOI10"),
		STM32_FUNCTION(12, "ETH_MII_RX_ER"),
		STM32_FUNCTION(13, "FMC_D31"),
		STM32_FUNCTION(15, "LCD_HSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(139, "PI11"),
		STM32_FUNCTION(0, "GPIOI11"),
		STM32_FUNCTION(11, "OTG_HS_ULPI_DIR"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(140, "PI12"),
		STM32_FUNCTION(0, "GPIOI12"),
		STM32_FUNCTION(15, "LCD_HSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(141, "PI13"),
		STM32_FUNCTION(0, "GPIOI13"),
		STM32_FUNCTION(15, "LCD_VSYNC"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(142, "PI14"),
		STM32_FUNCTION(0, "GPIOI14"),
		STM32_FUNCTION(15, "LCD_CLK"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(143, "PI15"),
		STM32_FUNCTION(0, "GPIOI15"),
		STM32_FUNCTION(15, "LCD_R0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(144, "PJ0"),
		STM32_FUNCTION(0, "GPIOJ0"),
		STM32_FUNCTION(15, "LCD_R1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(145, "PJ1"),
		STM32_FUNCTION(0, "GPIOJ1"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(146, "PJ2"),
		STM32_FUNCTION(0, "GPIOJ2"),
		STM32_FUNCTION(15, "LCD_R3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(147, "PJ3"),
		STM32_FUNCTION(0, "GPIOJ3"),
		STM32_FUNCTION(15, "LCD_R4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(148, "PJ4"),
		STM32_FUNCTION(0, "GPIOJ4"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(149, "PJ5"),
		STM32_FUNCTION(0, "GPIOJ5"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(150, "PJ6"),
		STM32_FUNCTION(0, "GPIOJ6"),
		STM32_FUNCTION(15, "LCD_R7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(151, "PJ7"),
		STM32_FUNCTION(0, "GPIOJ7"),
		STM32_FUNCTION(15, "LCD_G0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(152, "PJ8"),
		STM32_FUNCTION(0, "GPIOJ8"),
		STM32_FUNCTION(15, "LCD_G1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(153, "PJ9"),
		STM32_FUNCTION(0, "GPIOJ9"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(154, "PJ10"),
		STM32_FUNCTION(0, "GPIOJ10"),
		STM32_FUNCTION(15, "LCD_G3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(155, "PJ11"),
		STM32_FUNCTION(0, "GPIOJ11"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(156, "PJ12"),
		STM32_FUNCTION(0, "GPIOJ12"),
		STM32_FUNCTION(15, "LCD_B0"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(157, "PJ13"),
		STM32_FUNCTION(0, "GPIOJ13"),
		STM32_FUNCTION(15, "LCD_B1"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(158, "PJ14"),
		STM32_FUNCTION(0, "GPIOJ14"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(159, "PJ15"),
		STM32_FUNCTION(0, "GPIOJ15"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(160, "PK0"),
		STM32_FUNCTION(0, "GPIOK0"),
		STM32_FUNCTION(15, "LCD_G5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(161, "PK1"),
		STM32_FUNCTION(0, "GPIOK1"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(162, "PK2"),
		STM32_FUNCTION(0, "GPIOK2"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(163, "PK3"),
		STM32_FUNCTION(0, "GPIOK3"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(164, "PK4"),
		STM32_FUNCTION(0, "GPIOK4"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(165, "PK5"),
		STM32_FUNCTION(0, "GPIOK5"),
		STM32_FUNCTION(15, "LCD_B6"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(166, "PK6"),
		STM32_FUNCTION(0, "GPIOK6"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(167, "PK7"),
		STM32_FUNCTION(0, "GPIOK7"),
		STM32_FUNCTION(15, "LCD_DE"),
		STM32_FUNCTION(16, "EVENTOUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
};

static struct stm32_pinctrl_match_data stm32f429_match_data = {
	.pins = stm32f429_pins,
	.npins = ARRAY_SIZE(stm32f429_pins),
};

static const struct of_device_id stm32f429_pctrl_match[] = {
	{
		.compatible = "st,stm32f429-pinctrl",
		.data = &stm32f429_match_data,
	},
	{ }
};

static struct platform_driver stm32f429_pinctrl_driver = {
	.probe = stm32_pctl_probe,
	.driver = {
		.name = "stm32f429-pinctrl",
		.of_match_table = stm32f429_pctrl_match,
	},
};

static int __init stm32f429_pinctrl_init(void)
{
	return platform_driver_register(&stm32f429_pinctrl_driver);
}
arch_initcall(stm32f429_pinctrl_init);
