/*******************************************************************************
 * Copyright (C) 2004-2008 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of Intel Corp. nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <cstdio>
#include "PTHIDisplay.h"
#include "resource.h"
#include "Utils.h"

/*
* DisplayCodeVersions print code version
* Arguments:
*	versions - reference to the CODE_VERSIONS struct
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayCodeVersions(const CODE_VERSIONS &versions)
{
	UINT32 i, j;
	UINT16 len;

	// BIOS version is free format null terminated string,
	// max length of BIOS version string is 64 byte
	DisplayMessage(BIOS_VERSION);
	fprintf(stdout,"\t\t %s\n\n", versions.BiosVersion);
	DisplayMessage(AMT_CODE_VERSION);
	for (i = 0; i < versions.VersionsCount; i++) {
		fprintf(stdout, "\t");
		len = versions.Versions[i].Description.Length;
		for (j = 0; j < len; j++) {
			fprintf(stdout, "%c", versions.Versions[i].Description.String[j]);
		}
		fprintf(stdout, ":");
		for (j = 0 ; j < (UINT32)(24 - len); j++) {
			fprintf(stdout, " ");
		}

		fprintf(stdout, "%s\n", versions.Versions[i].Version.String);
	}
	fprintf(stdout, "\n");
}

/*
* DisplayAMTMode print legacy mode
* Arguments:
*	legacy - reference to the AMT_BOOLEAN
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayAMTMode(const AMT_BOOLEAN &legacy)
{
	fprintf(stdout, "\n");
	DisplayMessage(AMT_MODE);
	fprintf(stdout, "\t\t");
	if (legacy) {
		DisplayMessage(AMT_MODE_1);
	} else {
		DisplayMessage(AMT_MODE_2);
	}
}

/*
* DisplayProvisioningState print provisioning state
* Arguments:
*	state - reference to the AMT_PROVISIONING_STATE enum
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayProvisioningState(const AMT_PROVISIONING_STATE &state)
{
	fprintf(stdout, "\n");
	DisplayMessage(PROVISIONING_STATE);
	fprintf(stdout, "\t\t");
	switch (state) {
	case PROVISIONING_STATE_PRE:
		DisplayMessage(STATE_PRE);
		break;
	case PROVISIONING_STATE_IN:
		DisplayMessage(STATE_IN);
		break;
	case PROVISIONING_STATE_POST:
		DisplayMessage(STATE_POST);
		break;
	default:
		DisplayMessage(UNKNOWN);
		break;
	}
}

/*
* DisplayRngSeedStatus print RNG seed status
* Arguments:
*	rngStatus - reference to the AMT_RNG_STATUS enum
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayRngSeedStatus(const AMT_RNG_STATUS &rngStatus)
{
	fprintf(stdout, "\n");
	DisplayMessage(WORD_RNG_SEED_STATUS);
	fprintf(stdout, "\t\t");
	switch (rngStatus) {
	case RNG_STATUS_EXIST:
		DisplayMessage(WORD_EXIST);
		break;
	case RNG_STATUS_IN_PROGRESS:
		DisplayMessage(WORD_IN_PROGRESS);
		break;
	case RNG_STATUS_NOT_EXIST:
		DisplayMessage(WORD_NOT_EXIST);
		break;
	default:
		DisplayMessage(UNKNOWN);
		break;
	}
}

/*
* DisplayZTCEnabled print if ZTC enabled
* Arguments:
*	ztcEnabled - reference to the AMT_BOOLEAN enum
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayZTCEnabled(const AMT_BOOLEAN &ztcEnabled)
{
	fprintf(stdout, "\n");
	DisplayMessage(WORD_ZTC);
	fprintf(stdout, "\t\t");
	if (ztcEnabled) {
		DisplayMessage(WORD_ENABLED);
	} else {
		DisplayMessage(WORD_DISABLED);
	}
}

/*
* DisplayProvisioningTlsMode print provisioning TLS mode
* Arguments:
*	&provisioningTlsMode - reference to the AMT_PROVISIONING_TLS_MODE enum
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayProvisioningTlsMode(const AMT_PROVISIONING_TLS_MODE &provisioningTlsMode)
{
	fprintf(stdout, "\n");
	DisplayMessage(WORD_PROVISIONING_TLS_MODE);
	fprintf(stdout, "\t\t");
	switch (provisioningTlsMode) {
	case PKI:
		DisplayMessage(WORD_PKI);
		break;
	case PSK:
		DisplayMessage(WORD_PSK);
		break;
	case NOT_READY:
		DisplayMessage(WORD_NOT_READY);
		break;
	default:
		DisplayMessage(UNKNOWN);
		break;
	}
}

/*
* DisplayHashEntry print Certificate Hash Entry
* Arguments:
*	hashEntry - reference to the CERTHASH_ENTRY struct
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayHashEntry(CERTHASH_ENTRY &hashEntry)
{
	char *printString;

	fprintf(stdout, "\n");
	DisplayMessage(HASH_ENTRY);
	DisplayMessage(FRIENDLY_NAME);
	printString = (char *)malloc((hashEntry.Name.Length + 1) * sizeof(CHAR));
	if (NULL != printString) {
		memcpy(printString, hashEntry.Name.Buffer, hashEntry.Name.Length * sizeof(CHAR));
		printString[hashEntry.Name.Length * sizeof(CHAR)] = '\0';
		fprintf(stdout, "\t\t%s", printString);
		free(printString);
	}
	fprintf(stdout, "\n");
	fprintf(stdout, "Default = ");
	fprintf(stdout, "%s\n", ((hashEntry.IsDefault) ? "true" : "false"));
	fprintf(stdout, "Active = ");
	fprintf(stdout, "%s\n", ((hashEntry.IsActive) ? "true" : "false"));
	fprintf(stdout, "Hash Algorithm = ");

	int len;
	int rows;
	switch(hashEntry.HashAlgorithm) {
	case CERT_HASH_ALGORITHM_MD5:
		fprintf(stdout, "MD5");
		len = 16;
		rows = 2;
		break;

	case CERT_HASH_ALGORITHM_SHA1:
		fprintf(stdout, "SHA1");
		len = 20;
		rows = 4;
		break;

	default:
		fprintf(stdout, "UNKNOWN");
		len = 0;
		break;
	}

	fprintf(stdout, "\n");
	//break the print into rows
	DisplayMessage(CERT_HASH);

	for (int j = 0; j < rows; j++) {
		for (int i = 0; i < len/rows; i++) {
			fprintf(stdout, " %02X", hashEntry.CertificateHash[j * (len/rows) + i]);
		}
		fprintf(stdout, "\n");
	}
}

/*
* DisplayConfigActivate print activate status
* Arguments:
*	status - amt operation status value
* Return values:
*	NONE
*/
VOID PTHIDisplay::DisplayConfigActivate(AMT_STATUS status)
{
	fprintf(stdout, "\n");
	DisplayMessage(WORD_AMT_CONFIG_ACTIVATE);
	if (AMT_STATUS_SUCCESS == status) {
		DisplayMessage(WORD_SUCCESS);
	} else {
		DisplayMessage(WORD_FAILURE);
	}
}

