/*******************************************************************************
 * Copyright (C) 2004-2008 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       Utils.cpp
//
//----------------------------------------------------------------------------
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <cstdio>
#include <cstdlib>
#include <string>
#include <iostream>

#include "Utils.h"
#include "StringTableUtils.h"
#include "StatusCodeDefinitions.h"
#include "Options.h"
#include "resource.h"

/*
* Display a error message
*/
VOID DisplayErrorMessage(UINT32 errorCode)
{
	TCHAR str[MAX_LINE_LEN];
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), ERROR_MESSAGE, str, sizeof(str)/sizeof(TCHAR));
	fprintf(stderr, "\n%s ", str);
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), errorCode, str, sizeof(str)/sizeof(TCHAR));
	fprintf(stderr, ("%s\n"), str);
}
/*
* Display a status string message
*/
VOID DisplayStatusString(UINT32 statusStringID)
{
	TCHAR str[MAX_LINE_LEN];
	StringTableUtils::LoadStatusString(StringTableUtils::GetModuleHandle(NULL), statusStringID, str, sizeof(str)/sizeof(TCHAR));
	fprintf(stdout, "\n%s\n", str);
}

/*
* Display a  message (include \n)
*/
VOID DisplayMessage(UINT32 messageId)
{
	TCHAR str[MAX_LINE_LEN];
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), messageId, str, sizeof(str)/sizeof(TCHAR));
	fprintf(stdout, "%s\n", str);
}
/*
* Display a  String (without \n)
*/
VOID DisplayString(UINT32 StringId)
{
	TCHAR str[MAX_LINE_LEN];
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), StringId, str, sizeof(str)/sizeof(TCHAR));
	fprintf(stdout, "%s", str);
}
/*
* Calls to Parse user parameters.
* Arguments:
*	param - Local agent parameters structure
* Return values:
*	AMT_STATUS_SUCCESS - on success for get amt configuration data
*	appropriate error value defined in StatusCodeDefinitions.h - on failure
*/
UINT32	Parse(int argc, char *argv[], LOCAL_AGENT_PARAMS *Params)
{
	if ((NULL == Params) || (NULL == argv)) {
		return PTSDK_STATUS_INVALID_PARAM;
	}

	Params->Verbose = false;
	Params->Activate = false;
	Params->DnsSuffix.Length = 0;
	Params->OneTimePassword.Length = 0;

	char parseKeyDiscovery[MAX_LINE_LEN];
	char parseKeyActivate[MAX_LINE_LEN];
	char parseKeyOTP[MAX_LINE_LEN];
	char parseKeyDnsSuffix[MAX_LINE_LEN];
	char parseKeyVerbose[MAX_LINE_LEN];

	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), PARSE_KEYWORD_DISCOVERY_TEST,
		(TCHAR *)parseKeyDiscovery, sizeof(parseKeyDiscovery)/sizeof(TCHAR));
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), PARSE_KEYWORD_ACTIVATE,
		(TCHAR *)parseKeyActivate, sizeof(parseKeyActivate)/sizeof(TCHAR));
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), PARSE_KEYWORD_OTP,
		(TCHAR *)parseKeyOTP, sizeof(parseKeyOTP)/sizeof(TCHAR));
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), PARSE_KEYWORD_DNS,
		(TCHAR *)parseKeyDnsSuffix, sizeof(parseKeyDnsSuffix)/sizeof(TCHAR));
	StringTableUtils::LoadString(StringTableUtils::GetModuleHandle(NULL), PARSE_KEYWORD_VERBOSE,
		(TCHAR *)parseKeyVerbose, sizeof(parseKeyVerbose)/sizeof(TCHAR));

	Options options;

	const Options::FormatNode format[] =
	    {{parseKeyDiscovery, false}, {parseKeyActivate, false},
	    {parseKeyOTP, true}, {parseKeyDnsSuffix, true}, {parseKeyVerbose, false}};

	if (!options.parse(argc, const_cast<const char **>(argv), format,
		sizeof(format)/sizeof(Options::FormatNode))) {
		DisplayErrorMessage(INVALID_PARAM_INPUT);
		fprintf(stdout,"\n");
		return PTSDK_STATUS_INVALID_PARAM;
	}

	if (options.optionExists(parseKeyOTP)) {
		const char *otp = options.getOption(parseKeyOTP);
		if (strlen(otp) > sizeof(Params->OneTimePassword.String)) {
			return PTSDK_STATUS_INVALID_PARAM;
		}
		Params->OneTimePassword.Length = (UINT16)strlen(otp);
		memcpy(Params->OneTimePassword.String, otp, Params->OneTimePassword.Length);
	}

	if (options.optionExists(parseKeyDnsSuffix)) {
		const char *dnss = options.getOption(parseKeyDnsSuffix);
		if (strlen(dnss) > sizeof(Params->DnsSuffix.String)) {
			return PTSDK_STATUS_INVALID_PARAM;
		}
		Params->DnsSuffix.Length = (UINT16)strlen(dnss);
		memcpy(Params->DnsSuffix.String, dnss, Params->DnsSuffix.Length);
	}

	if ((!options.optionExists(parseKeyDiscovery)) && (!options.optionExists(parseKeyActivate))) {
		return PTSDK_STATUS_INVALID_PARAM;
	} else if (options.optionExists(parseKeyActivate)) {
		Params->Activate = true;
	} else {
		if (options.optionExists(parseKeyOTP) || options.optionExists(parseKeyDnsSuffix)) {
			return PTSDK_STATUS_INVALID_PARAM;
		}
	}

	if (options.optionExists(parseKeyVerbose)) {
		Params->Verbose = true;
	}

	return AMT_STATUS_SUCCESS;
}

/*
* Print Usage
*/
VOID PrintHelp()
{
	DisplayMessage(USAGE);
	DisplayMessage(USAGE_LOCAL_AGENT);
	printf("\n");
	DisplayMessage(USAGE_OPTIONS);
	DisplayMessage(USAGE_OPTIONS_DISCOVERY);
	DisplayMessage(USAGE_OPTIONS_ACTIVATE);
	DisplayMessage(USAGE_OPTIONS_VERBOSE);
	DisplayMessage(USAGE_OPTIONS_DNS);
	DisplayMessage(USAGE_OPTIONS_OTP);
	DisplayMessage(USAGE_OPTIONS_OTP_SECOND);
	printf("\n");
}

