#ifndef _QWT_SAMPLING_THREAD_H_
#define _QWT_SAMPLING_THREAD_H_

#include "qwt_global.h"
#include <qthread.h>

/*!
  \brief A thread collecting samples at regular intervals.

  Contiounous signals are converted into a discrete signal by
  collecting samples at regular intervals. A discrete signal
  can be displayed by a QwtPlotSeriesItem on a QwtPlot widget.

  QwtSamplingThread starts a thread calling perodically sample(),
  to collect and store ( or emit ) a single sample.

  \sa QwtPlotCurve, QwtPlotSeriesItem
*/
class QWT_EXPORT QwtSamplingThread: public QThread
{
    Q_OBJECT

public:
    virtual ~QwtSamplingThread();

    double interval() const;
    double elapsed() const;

public Q_SLOTS:
    void setInterval( double interval );
    void stop();

protected:
    explicit QwtSamplingThread( QObject *parent = NULL );

    virtual void run();

    /*!
       Collect a sample

       \param elapsed Time since the thread was started in miliseconds
     */
    virtual void sample( double elapsed ) = 0;

private:
    class PrivateData;
    PrivateData *d_data;
};

#endif
